---
generated_at: 2026-01-20 21:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **オンラインドキュメントURL**：外部リンクの有効性未確認
  2. **コンパイル済みヘルプファイル**：内容の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/CorLib.vbp` - プロジェクトファイル（クラス一覧・参照設定）
- E-02: `README.md` - プロジェクト概要
- E-03: `Source/CorLib/README.TXT` - バージョン履歴・変更点
- E-04: `Source/CorLib/System/Exception.cls` - 例外クラス実装
- E-05: `Source/CorLib/System/CorArray.cls` - 配列操作クラス実装
- E-06: `Source/CorLib/System.Collections/ArrayList.cls` - ArrayListクラス実装
- E-07: `Source/CorLib/System.Collections/IComparer.cls` - IComparerインターフェース
- E-08: `Source/CorLib/System/Startup.bas` - 初期化モジュール
- E-09: `Source/Tests/` ディレクトリ構造 - テストファイル配置
- E-10: `Source/CorLib/` ディレクトリ構造 - ソースコード配置
- E-11: プロジェクトファイル内のClass/Module定義
- E-12: 各クラスのドキュメントコメント（`''` で始まる行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Frameworkの実装 | E-02, E-03 | ○ |
| C-02 | クラスモジュール(.cls)の基本構造 | E-04, E-06 | ○ |
| C-03 | プロジェクトファイル(.vbp)の構造 | E-01 | ○ |
| C-04 | VB6データ型一覧 | E-05, E-06 | ○ |
| C-05 | Private/Public変数宣言パターン | E-06:70-73 | ○ |
| C-06 | Select Case制御構造 | E-05:574-581 | ○ |
| C-07 | If文の省略記法（_による継続） | E-06:175-180 | ○ |
| C-08 | For...Nextループパターン | E-05:241-252 | ○ |
| C-09 | Do...Loopパターン | E-05:1023-1031 | ○ |
| C-10 | Public Function定義形式 | E-06:88-91 | ○ |
| C-11 | Private Sub定義形式 | E-06:734-748 | ○ |
| C-12 | ByRef/ByValパラメータ渡し | E-05, E-06 | ○ |
| C-13 | 参照設定の管理方法 | E-01:2-4 | ○ |
| C-14 | .NET互換クラス名対応表 | E-02, E-03, E-01 | ○ |
| C-15 | Corプレフィックス命名規則 | E-03, E-05 | ○ |
| C-16 | Implementsによるインターフェース実装 | E-06:52-57 | ○ |
| C-17 | IObject_* 形式のインターフェース実装 | E-06:901-911 | ○ |
| C-18 | 例外クラス階層 | E-04, E-01 | ○ |
| C-19 | Error.* 形式の例外スロー | E-05:563-570 | ○ |
| C-20 | Staticクラスパターン | E-01（*Static.clsファイル一覧） | ○ |
| C-21 | ファイル命名規則（*.cls, *Static.cls, I*.cls） | E-01, E-10 | ○ |
| C-22 | m プレフィックス（メンバー変数） | E-06:70-73 | ○ |
| C-23 | p プレフィックス（ポインタ変数） | E-05 | ○ |
| C-24 | Ex サフィックス（拡張メソッド） | E-05:526, E-06:174 | ○ |
| C-25 | ディレクトリ構造 | E-10 | ○ |
| C-26 | System名前空間のファイル数（95ファイル） | E-01 | ○ |
| C-27 | System.Collections名前空間のファイル数 | E-01 | ○ |
| C-28 | アーキテクチャ図（.NET互換レイヤー） | E-02, E-03 | ○ |
| C-29 | Startup.basの初期化処理 | E-08:38-46 | ○ |
| C-30 | ArrayList.Add処理フロー | E-06:88-91, 424-433 | ○ |
| C-31 | EnsureCapacity実装詳細 | E-06:734-748 | ○ |
| C-32 | BinarySearch処理フロー | E-05:491-494, 1300-1338 | ○ |
| C-33 | IComparer.Compare仕様 | E-07:49-71 | ○ |
| C-34 | mVersion変更検出パターン | E-06:73, 259, 432 | ○ |
| C-35 | コールバックパターン（AddressOf） | E-05:151-184 | ○ |
| C-36 | InsertSpace/RemoveSpace ヘルパー | E-06:750-762 | ○ |
| C-37 | Option Explicitの使用 | E-05:45, E-06:51, E-08:25 | ○ |
| C-38 | PropertyBagによるシリアライズ | E-06:822-887 | ○ |
| C-39 | テストディレクトリ構造 | E-09 | ○ |
| C-40 | 352クラスファイル数 | E-01（カウント結果） | ○ |
| C-41 | 31モジュールファイル数 | E-01（カウント結果） | ○ |
| C-42 | SafeArray構造体の使用 | E-05:52-61 | ○ |
| C-43 | Variant型の使用目的 | E-05, E-06 | ○ |
| C-44 | オンラインドキュメントURL | **根拠なし** | △ |
| C-45 | CorLib.chmヘルプファイル | E-10（ファイル存在） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-44: オンラインドキュメントURL**
  - 外部URL（http://www.kellyethridge.com/vbcorlib/doc/CorLib.html）の有効性は実行時に確認されていない
  - 候補：Webアクセスによる確認 / アーカイブ確認 / README.mdの記載を信頼

- **C-45: CorLib.chmヘルプファイル**
  - ファイルの存在は確認（`Source/CorLib/CorLib.chm`）
  - 内容の詳細（APIカバレッジ等）は未確認
  - 候補：CHMファイルの展開確認 / ドキュメント内容の検証

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 言語基礎・構文説明
  - ソースコードから直接引用しており、高い信頼性
- **0: 低リスク** - ディレクトリ構造
  - 実際のファイルシステムから取得
- **0: 低リスク** - 命名規則
  - 複数ファイルのパターンから帰納的に導出
- **1: 中リスク** - 外部リンク
  - URLの有効性が時間経過で変化する可能性
- **0: 低リスク** - アーキテクチャ説明
  - README.mdとソースコード構造から導出

## 6) レビュアーチェックリスト（最小）
- [x] コード例が実際のソースファイルから正確に引用されているか
- [x] ファイルパスと行番号が正確か
- [x] VB6の構文説明が技術的に正確か
- [x] .NET対応表が実際のクラス実装と一致しているか
- [ ] 外部URLが有効か（オフライン環境では確認不可）
- [x] ディレクトリ構造が実際のプロジェクトと一致しているか
- [x] 命名規則が複数ファイルで一貫して適用されているか
- [x] 処理フローの説明がソースコードの実装と一致しているか
