---
generated_at: 2026-01-20 15:40:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **非同期処理の制約**: VB6の非同期処理サポートの詳細が不明確
  2. **パフォーマンス特性**: 各コンポーネントのパフォーマンス情報なし
  3. **スレッドセーフティ**: スレッド安全性に関する明確な記述なし
  4. **バージョン互換性**: VB6ランタイムの最小バージョン要件が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、機能一覧
- E-02: `Source/CorLib/README.TXT` - バージョン履歴、変更履歴
- E-03: `Source/CorLib/CorLib.vbp` - VB6プロジェクト定義、クラス一覧、参照ライブラリ
- E-04: `Source/CorLib/System/Exception.cls` - 例外クラスの実装、Throw/Catchパターン
- E-05: `Source/CorLib/System.Collections/IEnumerable.cls` - インターフェース定義
- E-06: `Source/CorLib/System/Startup.bas` - 初期化処理、IDE検出
- E-07: `Source/CorLib/System/Constructors.cls` - ファクトリパターン実装
- E-08: ディレクトリ構造調査 - 名前空間対応のフォルダ構成
- E-09: `Source/Tests/` - テストクラス構成
- E-10: `Source/Fakes/` - モックオブジェクト構成
- E-11: `Source/CorLib/System.Security.Cryptography/` - 暗号化クラス群
- E-12: `Source/CorLib/System.Collections/` - コレクションクラス群
- E-13: `Source/CorLib/Microsoft.Win32/Win32Native.bas` - Win32 API定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Frameworkの多くのクラスをVB6で再実装したライブラリ | E-01, E-02 | ○ |
| C-02 | VB6と.NETアプリケーション間のデータ共有が目的 | E-01 | ○ |
| C-03 | Windows CryptoAPIとの連携 | E-11, E-13 | ○ |
| C-04 | Windows Registry APIとの連携 | E-03, E-13 | ○ |
| C-05 | VB6ランタイム (vbvm6lib.tlb) への参照 | E-03 | ○ |
| C-06 | CorType.tlb型ライブラリへの参照 | E-03 | ○ |
| C-07 | 名前空間ベースのモジュラーアーキテクチャ | E-03, E-08 | ○ |
| C-08 | Constructors.clsによるファクトリパターン | E-07 | ○ |
| C-09 | PublicFunctions.cls、StaticClasses.clsの存在 | E-03 | ○ |
| C-10 | System名前空間に基本型・例外・ユーティリティ | E-03, E-08 | ○ |
| C-11 | System.Collectionsにコレクションフレームワーク | E-03, E-12 | ○ |
| C-12 | System.IOにファイル・ストリーム操作 | E-03, E-08 | ○ |
| C-13 | System.Textにテキストエンコーディング | E-03, E-08 | ○ |
| C-14 | System.Globalizationに国際化機能 | E-03, E-08 | ○ |
| C-15 | System.Security.Cryptographyに暗号化機能 | E-03, E-11 | ○ |
| C-16 | System.Numericsに大数演算（BigInteger） | E-03, E-08 | ○ |
| C-17 | Microsoft.Win32にレジストリ操作 | E-03, E-08 | ○ |
| C-18 | 352個のクラスファイル（.cls） | E-08（ファイルカウント結果） | ○ |
| C-19 | Exception階層の継承関係 | E-04, E-03 | ○ |
| C-20 | IEnumerable, ICollection, IListインターフェース | E-05, E-12 | ○ |
| C-21 | Stream抽象クラスとFileStream, MemoryStreamの継承 | E-03 | ○ |
| C-22 | Throw/Catchパターンによる例外処理 | E-04 | ○ |
| C-23 | SimplyVBUnitによるユニットテスト | E-09 | ○ |
| C-24 | Fakesディレクトリにモックオブジェクト | E-10 | ○ |
| C-25 | MITライセンス | E-04（ソースコード内のライセンス表記） | ○ |
| C-26 | DEP対応（バージョン2.3以降） | E-02 | ○ |
| C-27 | Unicode対応（32KB超のパス） | E-02 | ○ |
| C-28 | VB_GlobalNameSpace属性によるグローバル関数アクセス | E-07 | ○ |
| C-29 | 非同期処理のサポートが限定的 | **根拠なし** | △ |
| C-30 | レイヤー間の依存関係ルール | **根拠なし**（推測） | △ |
| C-31 | インメモリキャッシュの使用（CultureTable等） | **根拠なし**（コード詳細未確認） | △ |
| C-32 | コーディング規約（命名規則等） | **根拠なし**（観察に基づく推測） | △ |

## 4) 不足情報（Unknown / Missing）
- **非同期処理の詳細（C-29）**: Stream.BeginRead等の非同期メソッドの実装詳細が未確認
  - 候補：FileStream.cls / Stream.cls / AsyncCallback.cls の詳細確認
- **依存関係ルール（C-30）**: 明示的なアーキテクチャドキュメントなし
  - 候補：既存の設計ドキュメント / 開発者ガイド
- **キャッシュ実装（C-31）**: CultureTable、EncodingTableの内部実装詳細
  - 候補：CultureTable.cls / EncodingTable.cls の詳細確認
- **コーディング規約（C-32）**: 正式なコーディング規約ドキュメントなし
  - 候補：開発者向けガイドライン / CONTRIBUTING.md

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: ディレクトリ構造、ファイル構成、クラス名に関する記述
- **0: 低リスク**: README.md、README.TXTに基づく機能概要
- **1: 中リスク**: インターフェース設計、継承関係（複数ソースからの推測）
- **1: 中リスク**: データフロー図（実装詳細の推測を含む）
- **2: 高リスク**: 非同期処理の制約に関する記述（詳細未確認）
- **2: 高リスク**: コーディング規約（公式ドキュメントなし）

## 6) レビュアーチェックリスト（最小）
- [ ] 名前空間とディレクトリ構造の対応が正確か確認
- [ ] 外部システム連携（CryptoAPI、Registry等）の記述が実際のWin32Native.basと一致するか
- [ ] 例外階層図がException.cls、SystemException.cls等の実装と整合しているか
- [ ] コレクションインターフェース（IEnumerable, ICollection, IList）の関係が正しいか
- [ ] Stream系クラスの継承関係がプロジェクトファイル（.vbp）と一致するか
- [ ] 暗号化クラスの階層（HashAlgorithm, SymmetricAlgorithm等）が実装と整合しているか
- [ ] 非同期処理に関する記述の正確性を検証（BeginRead/EndRead等の実装確認）
- [ ] DEP対応、Unicode対応のバージョン情報が正しいか（README.TXTと照合）
