# アーキテクチャ構成図

## 1. システム全体構成図

```mermaid
graph TB
    subgraph "VBCorLib Architecture"
        subgraph "Public API Layer"
            CONS[Constructors.cls<br/>ファクトリ関数]
            PUB[PublicFunctions.cls<br/>グローバル関数]
            STAT[StaticClasses.cls<br/>静的クラスアクセサ]
        end

        subgraph "Domain Layer"
            subgraph "System"
                EXC[Exception階層]
                ARR[CorArray]
                STR[CorString]
                DT[CorDateTime]
                BUF[Buffer]
                ENV[Environment]
            end

            subgraph "System.Collections"
                AL[ArrayList]
                HT[Hashtable]
                SL[SortedList]
                STK[Stack]
                QUE[Queue]
                BA[BitArray]
            end

            subgraph "System.IO"
                STRM[Stream]
                FS[FileStream]
                MS[MemoryStream]
                BR[BinaryReader/Writer]
                SR[StreamReader/Writer]
                DIR[Directory/File]
            end

            subgraph "System.Text"
                ENC[Encoding]
                UTF8[UTF8Encoding]
                UNI[UnicodeEncoding]
                SB[StringBuilder]
            end

            subgraph "System.Security.Cryptography"
                HASH[HashAlgorithm]
                SYM[SymmetricAlgorithm]
                ASYM[AsymmetricAlgorithm]
                CS[CryptoStream]
            end
        end

        subgraph "Core/Infrastructure Layer"
            W32[Win32Native.bas]
            CORM[Cor/* Modules]
            HELP[*Helper.bas Modules]
        end

        subgraph "Type Definition Layer"
            IOBJ[IObject]
            IENUM[IEnumerable]
            ICOL[ICollection]
            ILIST[IList]
            ICOMP[IComparer]
        end
    end

    subgraph "External Systems"
        CAPI[Windows CryptoAPI]
        REG[Windows Registry]
        FSYS[Windows File System]
        VB6RT[VB6 Runtime]
    end

    CONS --> EXC
    CONS --> ARR
    CONS --> AL
    CONS --> FS

    AL --> IENUM
    AL --> ICOL
    AL --> ILIST

    STRM --> IOBJ
    FS --> STRM
    MS --> STRM
    CS --> STRM

    HASH --> W32
    SYM --> W32
    FS --> W32

    W32 --> CAPI
    W32 --> REG
    W32 --> FSYS
    W32 --> VB6RT
```

## 2. 名前空間構成図

```mermaid
graph LR
    subgraph "Source/CorLib"
        COR[Cor/]
        SYS[System/]
        SYSCOL[System.Collections/]
        SYSIO[System.IO/]
        SYSTXT[System.Text/]
        SYSGLB[System.Globalization/]
        SYSSEC[System.Security.Cryptography/]
        SYSRES[System.Resources/]
        SYSNUM[System.Numerics/]
        SYSTHR[System.Threading/]
        MSWIN[Microsoft.Win32/]
    end

    COR --> |基盤機能| SYS
    SYS --> |依存| SYSCOL
    SYS --> |依存| SYSIO
    SYSIO --> |依存| SYSTXT
    SYSIO --> |依存| SYSGLB
    SYSIO --> |依存| SYSSEC
    SYSCOL --> |依存| MSWIN
```

## 3. クラス階層図 - Exception系

```mermaid
classDiagram
    class Exception {
        +Message: String
        +HResult: Long
        +InnerException: Exception
        +GetBaseException(): Exception
        +ToString(): String
    }

    class SystemException {
    }

    class ArgumentException {
        +ParamName: String
    }

    class ArgumentNullException {
    }

    class ArgumentOutOfRangeException {
        +ActualValue: Variant
    }

    class IOException {
    }

    class FileNotFoundException {
        +FileName: String
    }

    class CryptographicException {
    }

    Exception <|-- SystemException
    SystemException <|-- ArgumentException
    ArgumentException <|-- ArgumentNullException
    ArgumentException <|-- ArgumentOutOfRangeException
    SystemException <|-- IOException
    IOException <|-- FileNotFoundException
    SystemException <|-- CryptographicException
```

## 4. クラス階層図 - Collection系

```mermaid
classDiagram
    class IEnumerable {
        <<interface>>
        +GetEnumerator(): IEnumerator
        +NewEnum(): IUnknown
    }

    class ICollection {
        <<interface>>
        +Count: Long
        +CopyTo(Array, Index)
    }

    class IList {
        <<interface>>
        +Item(Index): Variant
        +Add(Value): Long
        +Remove(Value)
        +Clear()
    }

    class IDictionary {
        <<interface>>
        +Item(Key): Variant
        +Keys: ICollection
        +Values: ICollection
        +Add(Key, Value)
        +Remove(Key)
    }

    class ArrayList {
        -mItems(): Variant
        -mCount: Long
        +Capacity: Long
        +Add(Value): Long
        +Sort()
        +BinarySearch(Value): Long
    }

    class Hashtable {
        -mBuckets(): Bucket
        +Add(Key, Value)
        +ContainsKey(Key): Boolean
        +ContainsValue(Value): Boolean
    }

    class SortedList {
        -mKeys(): Variant
        -mValues(): Variant
        +GetByIndex(Index): Variant
        +IndexOfKey(Key): Long
    }

    IEnumerable <|-- ICollection
    ICollection <|-- IList
    ICollection <|-- IDictionary
    IList <|.. ArrayList
    IDictionary <|.. Hashtable
    IDictionary <|.. SortedList
```

## 5. クラス階層図 - Stream系

```mermaid
classDiagram
    class Stream {
        <<abstract>>
        +CanRead: Boolean
        +CanWrite: Boolean
        +CanSeek: Boolean
        +Length: Currency
        +Position: Currency
        +ReadByte(): Long
        +WriteByte(Value)
        +Read(Buffer, Offset, Count): Long
        +Write(Buffer, Offset, Count)
        +Seek(Offset, Origin): Currency
        +Close()
    }

    class FileStream {
        -mHandle: SafeFileHandle
        -mBuffer(): Byte
        +Name: String
        +SafeFileHandle: SafeFileHandle
    }

    class MemoryStream {
        -mBuffer(): Byte
        -mCapacity: Long
        +ToArray(): Byte()
        +GetBuffer(): Byte()
    }

    class CryptoStream {
        -mStream: Stream
        -mTransform: ICryptoTransform
        +FlushFinalBlock()
    }

    class TextReader {
        <<abstract>>
        +Read(): Long
        +ReadLine(): String
        +ReadToEnd(): String
    }

    class StreamReader {
        -mStream: Stream
        -mEncoding: Encoding
        +EndOfStream: Boolean
    }

    class TextWriter {
        <<abstract>>
        +Write(Value)
        +WriteLine(Value)
    }

    class StreamWriter {
        -mStream: Stream
        -mEncoding: Encoding
        +AutoFlush: Boolean
    }

    Stream <|-- FileStream
    Stream <|-- MemoryStream
    Stream <|-- CryptoStream
    TextReader <|-- StreamReader
    TextWriter <|-- StreamWriter
    StreamReader --> Stream
    StreamWriter --> Stream
```

## 6. クラス階層図 - 暗号化系

```mermaid
classDiagram
    class HashAlgorithm {
        <<abstract>>
        +HashSize: Long
        +Hash: Byte()
        +ComputeHash(Data): Byte()
        +TransformBlock(Input, Output): Long
        +TransformFinalBlock(Input): Byte()
    }

    class SHA1 {
        <<abstract>>
    }

    class SHA1Managed {
    }

    class SHA1CryptoServiceProvider {
    }

    class MD5 {
        <<abstract>>
    }

    class MD5CryptoServiceProvider {
    }

    class SymmetricAlgorithm {
        <<abstract>>
        +Key: Byte()
        +IV: Byte()
        +BlockSize: Long
        +KeySize: Long
        +Mode: CipherMode
        +Padding: PaddingMode
        +CreateEncryptor(): ICryptoTransform
        +CreateDecryptor(): ICryptoTransform
    }

    class DES {
        <<abstract>>
    }

    class DESCryptoServiceProvider {
    }

    class TripleDES {
        <<abstract>>
    }

    class TripleDESCryptoServiceProvider {
    }

    class Rijndael {
        <<abstract>>
    }

    class RijndaelManaged {
    }

    class AsymmetricAlgorithm {
        <<abstract>>
        +KeySize: Long
    }

    class RSA {
        <<abstract>>
    }

    class RSACryptoServiceProvider {
    }

    HashAlgorithm <|-- SHA1
    SHA1 <|-- SHA1Managed
    SHA1 <|-- SHA1CryptoServiceProvider
    HashAlgorithm <|-- MD5
    MD5 <|-- MD5CryptoServiceProvider

    SymmetricAlgorithm <|-- DES
    DES <|-- DESCryptoServiceProvider
    SymmetricAlgorithm <|-- TripleDES
    TripleDES <|-- TripleDESCryptoServiceProvider
    SymmetricAlgorithm <|-- Rijndael
    Rijndael <|-- RijndaelManaged

    AsymmetricAlgorithm <|-- RSA
    RSA <|-- RSACryptoServiceProvider
```

## 7. データフロー図 - ファイル読み込み

```mermaid
sequenceDiagram
    participant Client
    participant NewFileStream
    participant FileStream
    participant SafeFileHandle
    participant Win32Native
    participant WindowsAPI

    Client->>NewFileStream: NewFileStream(path, mode)
    NewFileStream->>FileStream: Create instance
    FileStream->>Win32Native: CreateFileW(path, ...)
    Win32Native->>WindowsAPI: CreateFileW
    WindowsAPI-->>Win32Native: Handle
    Win32Native-->>FileStream: Handle
    FileStream->>SafeFileHandle: Wrap handle
    SafeFileHandle-->>FileStream: SafeFileHandle
    FileStream-->>NewFileStream: FileStream
    NewFileStream-->>Client: FileStream

    Client->>FileStream: Read(buffer, offset, count)
    FileStream->>Win32Native: ReadFile(handle, ...)
    Win32Native->>WindowsAPI: ReadFile
    WindowsAPI-->>Win32Native: bytes read
    Win32Native-->>FileStream: bytes read
    FileStream-->>Client: bytes read

    Client->>FileStream: Close()
    FileStream->>SafeFileHandle: Dispose()
    SafeFileHandle->>Win32Native: CloseHandle
    Win32Native->>WindowsAPI: CloseHandle
```

## 8. データフロー図 - 暗号化

```mermaid
sequenceDiagram
    participant Client
    participant RijndaelManaged
    participant CryptoStream
    participant ICryptoTransform
    participant DestStream

    Client->>RijndaelManaged: Create instance
    Client->>RijndaelManaged: Set Key, IV
    Client->>RijndaelManaged: CreateEncryptor()
    RijndaelManaged-->>Client: ICryptoTransform

    Client->>CryptoStream: New CryptoStream(destStream, transform, Write)

    loop For each data chunk
        Client->>CryptoStream: Write(data, offset, count)
        CryptoStream->>ICryptoTransform: TransformBlock(input, output)
        ICryptoTransform-->>CryptoStream: transformed bytes
        CryptoStream->>DestStream: Write(encrypted data)
    end

    Client->>CryptoStream: FlushFinalBlock()
    CryptoStream->>ICryptoTransform: TransformFinalBlock(input)
    ICryptoTransform-->>CryptoStream: final block with padding
    CryptoStream->>DestStream: Write(final encrypted data)

    Client->>CryptoStream: Close()
```

## 9. コンポーネント配置図

```mermaid
graph TB
    subgraph "Development Environment"
        VB6IDE[VB6 IDE]
        SVBU[SimplyVBUnit<br/>テストフレームワーク]
    end

    subgraph "Build Outputs"
        DLL[VBCorLib3.dll<br/>コンパイル済みライブラリ]
        TLB[CorType.tlb<br/>型ライブラリ]
    end

    subgraph "Client Application"
        APP[VB6 Application]
    end

    subgraph "Windows System"
        CAPI[advapi32.dll<br/>CryptoAPI]
        K32[kernel32.dll<br/>File/Memory API]
        USER[user32.dll<br/>Console API]
    end

    VB6IDE --> DLL
    VB6IDE --> TLB
    SVBU --> DLL

    APP --> DLL
    DLL --> TLB
    DLL --> CAPI
    DLL --> K32
    DLL --> USER
```

## 10. 静的クラスパターン図

```mermaid
classDiagram
    class CorArray {
        <<GlobalMultiUse>>
        +BinarySearch(arr, value): Long
        +Copy(source, dest, length)
        +IndexOf(arr, value): Long
        +Sort(arr)
        +Reverse(arr)
    }

    class CorArrayStatic {
        <<hidden>>
        -Helper methods
    }

    class CorString {
        <<GlobalMultiUse>>
        +Compare(s1, s2): Long
        +Format(format, args): String
        +Join(separator, values): String
        +Split(s, separator): String()
    }

    class Path {
        <<GlobalMultiUse>>
        +Combine(path1, path2): String
        +GetDirectoryName(path): String
        +GetExtension(path): String
        +GetFileName(path): String
    }

    class File {
        <<GlobalMultiUse>>
        +Exists(path): Boolean
        +ReadAllBytes(path): Byte()
        +WriteAllBytes(path, bytes)
        +Delete(path)
    }

    class Directory {
        <<GlobalMultiUse>>
        +Exists(path): Boolean
        +CreateDirectory(path): DirectoryInfo
        +Delete(path)
        +GetFiles(path): String()
    }

    note for CorArray "VB_GlobalNameSpace = True\nにより直接呼び出し可能"
    note for CorArrayStatic "内部ヘルパーメソッドを\n格納"

    CorArray --> CorArrayStatic : uses
```
