# アーキテクチャ設計書

## 概要

本ドキュメントは、VBCorLibプロジェクトのアーキテクチャ設計について記述します。VBCorLibは、.NET Frameworkの多くのクラスをVisual Basic 6で再実装したクラスライブラリであり、VB6アプリケーションと.NETアプリケーション間のデータ共有を容易にすることを目的としています。

## システム全体構成

### アーキテクチャ概要図

[アーキテクチャ構成図.md](./アーキテクチャ構成図.md) を参照

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| Windows CryptoAPI | Win32 API呼び出し | 暗号化・ハッシュ計算処理 |
| Windows Registry | Win32 API呼び出し | システム設定・ユーザー設定の読み書き |
| Windows File System | Win32 API呼び出し（Unicode対応） | ファイル・ディレクトリ操作 |
| VB6ランタイム (vbvm6lib.tlb) | COMタイプライブラリ参照 | VB6仮想マシン機能へのアクセス |
| CorType.tlb | COMタイプライブラリ参照 | VBCorLib固有の型定義 |

## レイヤー構成

### アーキテクチャスタイル

**名前空間ベースのライブラリアーキテクチャ（.NET Framework互換）**

VBCorLibは、.NET Frameworkの名前空間構造を模倣したモジュラーライブラリアーキテクチャを採用しています。各名前空間がドメイン固有の機能を提供し、インターフェースを通じて疎結合を実現しています。

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| Public API Layer | 外部公開インターフェース、コンストラクタ関数 | Constructors.cls, PublicFunctions.cls, StaticClasses.cls |
| Domain Layer | ドメイン固有ロジックの実装 | System.*, System.Collections.*, System.IO.*, System.Security.Cryptography.* |
| Core/Infrastructure Layer | 基盤機能、Win32 API連携、ユーティリティ | Cor/, Microsoft.Win32/, 各種*.basモジュール |
| Type Definition Layer | 型定義、インターフェース定義 | IObject, ICloneable, IComparable, IEnumerable等のインターフェースクラス |

### レイヤー間の依存関係ルール

- **依存の方向性**: 上位レイヤーから下位レイヤーへの依存のみ許可
- **許可される参照**:
  - Public API Layer -> Domain Layer -> Core Layer
  - 全レイヤー -> Type Definition Layer
- **禁止される参照**:
  - Core Layer -> Domain Layer（逆依存）
  - Domain Layer -> Public API Layer（逆依存）
- **インターフェース駆動**: 具象クラス間の直接依存を避け、インターフェース（IEnumerable, IComparer等）を介した疎結合を推奨

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| System | 基本型、例外、ユーティリティクラス | Exception, CorArray, CorString, CorDateTime, Buffer, Environment等 |
| System.Collections | コレクションフレームワーク | ArrayList, Stack, Queue, Hashtable, SortedList, BitArray |
| System.IO | ファイル・ストリーム操作 | Stream, FileStream, MemoryStream, BinaryReader/Writer, StreamReader/Writer, Directory, File |
| System.Text | テキストエンコーディング | Encoding, UTF8Encoding, UTF7Encoding, UnicodeEncoding, StringBuilder |
| System.Globalization | 国際化・ローカライゼーション | CultureInfo, DateTimeFormatInfo, NumberFormatInfo, Calendar系クラス |
| System.Security.Cryptography | 暗号化・ハッシュ | SHA1/256/384/512, MD5, DES, TripleDES, Rijndael, RSA, DSA, HMAC系 |
| System.Resources | リソース管理 | ResourceReader, ResourceWriter, ResourceManager |
| System.Numerics | 大数演算 | BigInteger |
| System.Threading | スレッド・同期 | WaitHandle, Thread, Ticker |
| Microsoft.Win32 | Windowsレジストリ操作 | Registry, RegistryKey |

### パッケージ構造

```
Source/
├── CorLib/                          # メインライブラリ
│   ├── Cor/                         # コアユーティリティ
│   │   ├── Interaction.bas
│   │   ├── ConversionMethods.bas
│   │   └── Information.bas
│   ├── System/                      # 基本システムクラス
│   │   ├── Exception.cls
│   │   ├── CorArray.cls
│   │   ├── CorString.cls
│   │   ├── CorDateTime.cls
│   │   ├── Constructors.cls         # ファクトリ関数
│   │   ├── PublicFunctions.cls
│   │   └── ...
│   ├── System.Collections/          # コレクションフレームワーク
│   │   ├── ArrayList.cls
│   │   ├── Hashtable.cls
│   │   ├── IEnumerable.cls
│   │   └── ...
│   ├── System.IO/                   # ファイル・ストリーム
│   │   ├── Stream.cls
│   │   ├── FileStream.cls
│   │   └── ...
│   ├── System.Text/                 # テキスト処理
│   │   ├── Encoding.cls
│   │   ├── StringBuilder.cls
│   │   └── ...
│   ├── System.Globalization/        # 国際化
│   │   ├── CultureInfo.cls
│   │   └── ...
│   ├── System.Security.Cryptography/ # 暗号化
│   │   ├── HashAlgorithm.cls
│   │   ├── SymmetricAlgorithm.cls
│   │   └── ...
│   ├── System.Resources/            # リソース管理
│   │   └── ...
│   ├── System.Numerics/             # 大数演算
│   │   └── BigInteger.cls
│   ├── System.Threading/            # スレッド
│   │   └── ...
│   ├── Microsoft.Win32/             # Windowsレジストリ
│   │   ├── Registry.cls
│   │   ├── RegistryKey.cls
│   │   └── Win32Native.bas
│   ├── Microsoft.Win32.SafeHandles/ # セーフハンドル
│   │   └── ...
│   └── CorLib.vbp                   # VB6プロジェクトファイル
├── Tests/                           # ユニットテスト
│   ├── System/
│   ├── System.Collections/
│   ├── System.IO/
│   └── ...
└── Fakes/                           # テスト用モックオブジェクト
    └── ...
```

### コンポーネント依存関係

**コアコンポーネント間の依存関係**:

1. **Exception階層**: Exception <- SystemException <- 各種具体例外クラス（ArgumentException, IOException等）
2. **Collection階層**: IEnumerable <- ICollection <- IList <- ArrayList
3. **Stream階層**: Stream <- FileStream, MemoryStream, CryptoStream
4. **Encoding階層**: Encoding <- UTF8Encoding, UnicodeEncoding, ASCIIEncoding
5. **HashAlgorithm階層**: HashAlgorithm <- SHA1, SHA256, MD5等
6. **SymmetricAlgorithm階層**: SymmetricAlgorithm <- DES, TripleDES, Rijndael

## ミドルウェア構成

### データベース

本ライブラリはデータベースミドルウェアを直接使用しません。

| 種類 | ミドルウェア | バージョン | 用途 |
| --- | --- | --- | --- |
| N/A | N/A | N/A | N/A |

### キャッシュ

| ミドルウェア | バージョン | 用途 | TTL |
| --- | --- | --- | --- |
| インメモリキャッシュ | 内部実装 | CultureTable、EncodingTable等の静的データ | アプリケーションライフタイム |

### メッセージキュー

本ライブラリはメッセージキューを使用しません。

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| N/A | N/A | N/A |

### 検索エンジン

本ライブラリは検索エンジンを使用しません。

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| N/A | N/A | N/A |

### その他ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Windows CryptoAPI | OS提供 | 暗号化・復号・ハッシュ計算 |
| Windows Registry API | OS提供 | レジストリ操作 |
| Windows File API | OS提供（Unicode対応） | ファイルシステム操作（32KB超の長いパス対応） |

## データフロー

### リクエスト処理の流れ

**ファイル読み込み処理の例（FileStream使用）**:

1. クライアントが `NewFileStream` コンストラクタ関数を呼び出し
2. `FileStream` オブジェクトが初期化され、Win32 API `CreateFileW` を呼び出し
3. ファイルハンドルが `SafeFileHandle` にラップされて保持
4. `Read` メソッド呼び出し時に `ReadFile` API でデータ取得
5. バッファにデータをコピーしてクライアントに返却
6. `Close` または `Dispose` でハンドル解放

**暗号化処理の例（Rijndael使用）**:

1. `RijndaelManaged` オブジェクトを生成
2. `CreateEncryptor` で `ICryptoTransform` を取得
3. `CryptoStream` を作成し、ソースストリームをラップ
4. データを書き込むと、`TransformBlock` が呼ばれブロック単位で暗号化
5. 最終ブロックは `TransformFinalBlock` でパディング処理

### 非同期処理の流れ

VB6の制約により、非同期処理は限定的なサポートのみ:

1. `Stream.BeginRead/BeginWrite` で非同期読み書きを開始
2. `IAsyncResult` オブジェクトが返却される
3. `AsyncCallback` が設定されている場合、完了時にコールバック
4. `EndRead/EndWrite` で結果を取得

### データ永続化の流れ

**リソース書き込み処理の例**:

1. `ResourceWriter` オブジェクトを生成
2. `AddResource` でリソースを追加（メモリ上に蓄積）
3. `Generate` でバイナリ形式に変換
4. `Close` でストリームに書き込み、リソース解放

## 横断的関心事

### 認証・認可

本ライブラリ自体は認証・認可機能を提供しません。暗号化機能を通じて認証・認可を実装するアプリケーションを支援します。

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| N/A（ライブラリのため） | N/A | N/A |

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| デバッグログ | Debug.Assert, Debug.Print | VB6 IDE即時ウィンドウ |
| コンソール出力 | Console.WriteLine | コンソールウィンドウ |

### エラーハンドリング

VB6の `On Error` 構文と .NET スタイルの例外処理をブリッジする仕組みを提供:

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| 引数エラー | ArgumentException, ArgumentNullException, ArgumentOutOfRangeException | Err.Raise + 例外オブジェクト保持 |
| ファイルエラー | IOException, FileNotFoundException, DirectoryNotFoundException | Err.Raise + 詳細情報付き例外 |
| 暗号化エラー | CryptographicException | Err.Raise + 詳細情報付き例外 |
| 一般エラー | Exception, SystemException | Err.Raise + 例外オブジェクト保持 |

**例外の使用パターン**:

1. `Throw` 関数で例外オブジェクトを投げる
2. エラートラップ内で `Catch` 関数を呼び出し
3. 例外オブジェクトの型を `TypeOf` で判定
4. 適切なエラー処理を実行

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| N/A（ライブラリのため） | N/A | N/A |

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| Interface Segregation | コレクション系クラス | IEnumerable, ICollection, IList を分離定義 |
| Dependency Inversion | Stream系、暗号化系 | 抽象クラス（Stream, HashAlgorithm）を定義し、具象クラスが継承 |
| Factory Pattern | オブジェクト生成 | Constructors.cls の New* 関数群 |
| Template Method | 暗号化アルゴリズム | HashAlgorithmBase, SymmetricAlgorithmBase |
| Decorator Pattern | ストリーム処理 | CryptoStream が Stream をラップ |
| Static Class Pattern | ユーティリティ | CorArray, CorString, Path, File, Directory |

### コーディング規約

- **命名規則**:
  - クラス名: PascalCase（例: ArrayList, FileStream）
  - インターフェース名: "I" プレフィックス（例: IEnumerable, IComparer）
  - 静的クラス: *Static サフィックス（例: CorArrayStatic, EncodingStatic）
  - プライベートメンバ: "m" プレフィックス（例: mBase, mInIDE）
  - 定数: PascalCase（例: PropBase, BufferSize）

- **ファイル構成**:
  - 1クラス = 1ファイル（.cls）
  - 共通モジュール = .bas ファイル
  - 名前空間に対応したディレクトリ構造

- **エラー処理**:
  - 例外クラスを使用した構造化エラー処理
  - Throw/Catch パターンの推奨

- **ドキュメンテーション**:
  - XMLスタイルのVBDocコメント
  - DocIncludesフォルダに詳細ドキュメントを分離

## 備考

- **VB6とVB.NET間の互換性**: VBCorLibの主目的は、VB6アプリケーションが.NETアプリケーションと同等のデータ構造・アルゴリズムを使用できるようにすることです。これにより、異種プラットフォーム間でのデータ交換が容易になります。

- **Unicode対応**: Windows NT系（2000以降）では、ファイルAPI呼び出しがUnicode（Wide API）を使用し、32KB超の長いファイルパスをサポートします。

- **DEP対応**: バージョン2.3以降、Data Execution Prevention (DEP) に対応したASMコードに更新されています。

- **テストフレームワーク**: SimplyVBUnit を使用した単体テストが整備されており、各名前空間に対応したテストクラスが存在します。

- **ライセンス**: MIT License
