---
generated_at: 2026-01-20 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **クライアント環境要件（OS、メモリ等）**：一部推測に基づく
  2. **外部ドキュメントサイトの詳細情報**：外部サイト参照のため未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルート）
- E-02: `Source/CorLib/README.TXT`（バージョン履歴・機能一覧）
- E-03: `Source/CorLib/CorLib.vbp`（プロジェクト設定、依存関係）
- E-04: `Install/InstallScript.iss`（インストーラ設定）
- E-05: `TypeLibrary/README.TXT`（タイプライブラリ情報）
- E-06: `TypeLibrary/CorType.tlb`（型定義ライブラリ）
- E-07: `TypeLibrary/VBVM6Lib.tlb`（VB6 VM拡張ライブラリ）
- E-08: `_config.yml`（GitHub Pages設定）
- E-09: `.gitattributes`（Git設定）
- E-10: `Source/CorLib/CorLib.Build.vbp`（ビルド用プロジェクト設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibはVB6向け.NET互換クラスライブラリである | E-01, E-02 | ○ |
| C-02 | メインライブラリはVBCorLib3.dll（ActiveX DLL）である | E-03, E-04 | ○ |
| C-03 | タイプライブラリとしてCorType.tlb、VBVM6Lib.tlbを使用 | E-03, E-05, E-06, E-07 | ○ |
| C-04 | GitHub Pagesでドキュメントを公開（jekyll-theme-cayman使用） | E-08 | ○ |
| C-05 | OLE Automation 2.0（stdole2.tlb）に依存 | E-03 | ○ |
| C-06 | VBVM6Lib 1.1に依存 | E-03 | ○ |
| C-07 | 暗号化機能（RSA、DES、Rijndael等）を提供 | E-01, E-02 | ○ |
| C-08 | Inno Setupでインストーラを作成 | E-04 | ○ |
| C-09 | 出力ファイル名はVBCorLib-3.2.0.exe | E-04 | ○ |
| C-10 | インストール先はシステムフォルダ（regserver登録） | E-04 | ○ |
| C-11 | テンプレートファイルをVB6テンプレートフォルダに配置 | E-04 | ○ |
| C-12 | バージョン4.0が最新 | E-02 | ○ |
| C-13 | Git設定でautocrlf=falseが必須 | E-01 | ○ |
| C-14 | BigInteger、Int64などの拡張数値型をサポート | E-02 | ○ |
| C-15 | VBCultures.nlpはリソースとしてDLLに内包 | E-02 | ○ |
| C-16 | テストプロジェクトはCorLib.Tests.vbp | E-03（参照）, ファイル存在確認 | ○ |
| C-17 | 対応OSはWindows XP以降推奨 | **根拠なし**（推測） | △ |
| C-18 | 外部ドキュメントサイト（kellyethridge.com）の詳細 | **根拠なし**（外部サイト未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-17（対応OS要件）について**
  - README.TXTにWindows XPからの依存解除について言及あり（v3.2）が、明示的な対応OS一覧は記載なし
  - 候補：公式ドキュメント / 実機テスト結果 / 開発者への確認

- **C-18（外部ドキュメントサイト詳細）について**
  - README.mdに外部URLの参照があるが、サイトの詳細構成は未確認
  - 候補：外部サイトへのアクセス確認 / 開発者への確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コア機能に関する主張（C-01〜C-16）は全て根拠あり
- **1: 中リスク** - 対応OS要件（C-17）は推測に基づくため、公式情報での確認推奨
- **0: 低リスク** - 外部サイト情報（C-18）は補足情報のため影響軽微

## 6) レビュアーチェックリスト（最小）
- [ ] VBCorLib3.dllのCOM登録プロセスが正しく記載されているか確認
- [ ] インストーラの構成がInstallScript.issと一致しているか確認
- [ ] タイプライブラリの依存関係がCorLib.vbpと一致しているか確認
- [ ] 対応Windows OSバージョンの公式情報を確認（C-17の補完）
- [ ] 暗号化アルゴリズム一覧がREADME.TXTと一致しているか確認
