# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発環境"
        DEV[開発者PC]
        VB6[Visual Basic 6.0 IDE]
        GIT[Git Client]
    end

    subgraph "ソース管理・配布"
        GITHUB[GitHub Repository]
        PAGES[GitHub Pages]
        RELEASES[GitHub Releases]
    end

    subgraph "ドキュメント配布"
        WEBSITE[kellyethridge.com]
    end

    subgraph "クライアント環境（エンドユーザー）"
        CLIENT[Windows PC]
        APP[VB6アプリケーション]
        DLL[VBCorLib3.dll]
        RUNTIME[VB6 Runtime]
        CRYPTO[Windows CryptoAPI]
        COM[COM/OLE基盤]
    end

    DEV --> VB6
    DEV --> GIT
    GIT -->|push/pull| GITHUB
    GITHUB -->|Jekyll build| PAGES
    GITHUB -->|release| RELEASES

    RELEASES -->|download| CLIENT
    PAGES -->|browse| DEV
    WEBSITE -->|browse| DEV

    CLIENT --> APP
    APP --> DLL
    DLL --> RUNTIME
    DLL --> CRYPTO
    DLL --> COM
```

## コンポーネント構成図

```mermaid
graph LR
    subgraph "VBCorLib パッケージ"
        MAIN[VBCorLib3.dll<br/>メインライブラリ]
        TLB1[CorType.tlb<br/>型定義]
        TLB2[VBVM6Lib.tlb<br/>VM拡張]
        RES[CorLib.RES<br/>リソース]
        CHM[CorLib.chm<br/>ヘルプ]
    end

    subgraph "依存関係"
        STDOLE[stdole2.tlb<br/>OLE Automation]
        MSVBVM[MSVBVM60.DLL<br/>VB6 Runtime]
        WINCRYPT[CryptoAPI<br/>暗号化]
        WINAPI[Windows API]
    end

    MAIN --> TLB1
    MAIN --> TLB2
    MAIN --> RES
    MAIN -.-> CHM

    MAIN --> STDOLE
    MAIN --> MSVBVM
    MAIN --> WINCRYPT
    MAIN --> WINAPI
```

## ビルド・配布フロー

```mermaid
flowchart TD
    subgraph "ソースコード"
        SRC[Source/CorLib/*.cls,*.bas]
        VBP[CorLib.vbp<br/>プロジェクトファイル]
        ODL[CorType.odl<br/>型定義ソース]
    end

    subgraph "ビルドプロセス"
        VB6[Visual Basic 6.0]
        MKTYPLIB[MKTYPLIB.EXE]
        ISS[Inno Setup]
    end

    subgraph "成果物"
        DLL[VBCorLib3.dll]
        TLB[CorType.tlb]
        INSTALLER[VBCorLib-3.2.0.exe]
    end

    subgraph "配布"
        GITHUB[GitHub Releases]
        REG[regsvr32<br/>COM登録]
        SYSDIR[System32/SysWOW64]
    end

    SRC --> VBP
    VBP --> VB6
    ODL --> MKTYPLIB
    MKTYPLIB --> TLB
    VB6 --> DLL

    DLL --> ISS
    TLB --> ISS
    ISS --> INSTALLER

    INSTALLER --> GITHUB
    INSTALLER --> REG
    REG --> SYSDIR
```

## モジュール依存関係図

```mermaid
graph TB
    subgraph "VBCorLib モジュール構成"
        subgraph "System名前空間"
            SYS_CORE[System<br/>基本クラス]
            SYS_COLL[System.Collections<br/>コレクション]
            SYS_IO[System.IO<br/>入出力]
            SYS_TEXT[System.Text<br/>テキスト処理]
            SYS_GLOB[System.Globalization<br/>国際化]
            SYS_SEC[System.Security.Cryptography<br/>暗号化]
            SYS_NUM[System.Numerics<br/>数値演算]
            SYS_RES[System.Resources<br/>リソース管理]
            SYS_THR[System.Threading<br/>スレッド]
            SYS_DIAG[System.Diagnostics<br/>診断]
        end

        subgraph "Microsoft名前空間"
            MS_WIN32[Microsoft.Win32<br/>レジストリ]
            MS_SAFE[Microsoft.Win32.SafeHandles<br/>安全ハンドル]
        end

        subgraph "Cor名前空間"
            COR[Cor<br/>変換・情報]
        end
    end

    SYS_CORE --> SYS_COLL
    SYS_CORE --> SYS_TEXT
    SYS_CORE --> SYS_IO
    SYS_IO --> SYS_TEXT
    SYS_IO --> SYS_SEC
    SYS_TEXT --> SYS_GLOB
    SYS_SEC --> SYS_IO
    SYS_NUM --> SYS_CORE
    SYS_RES --> SYS_IO
    SYS_THR --> SYS_CORE
    MS_WIN32 --> SYS_CORE
    MS_SAFE --> MS_WIN32
    COR --> SYS_CORE
```

## インストール構成図

```mermaid
flowchart LR
    subgraph "インストーラ"
        ISS[VBCorLib-3.2.0.exe]
    end

    subgraph "インストール先"
        subgraph "システムフォルダ"
            SYS[C:\Windows\SysWOW64\]
            DLL[VBCorLib3.dll]
        end

        subgraph "アプリケーションフォルダ"
            APP[C:\Program Files\VBCorLib3\]
            README[readme.txt]
            LICENSE[LICENSE.txt]
            EXAMPLES[Examples\]
        end

        subgraph "VB6テンプレート"
            TMPL[Templates\Classes\]
            CLS[*.cls テンプレート]
        end

        subgraph "レジストリ"
            REG[HKCR\CLSID\]
            TYPELIB[HKCR\TypeLib\]
        end
    end

    ISS -->|binaries| SYS
    SYS --> DLL
    DLL -.->|regsvr32| REG
    DLL -.->|regsvr32| TYPELIB

    ISS -->|readme| APP
    APP --> README
    APP --> LICENSE

    ISS -->|examples| EXAMPLES

    ISS -->|templates| TMPL
    TMPL --> CLS
```
