# インフラ設計書

## 概要

本ドキュメントは、VBCorLib（Visual Basic 6向け.NETフレームワーク互換クラスライブラリ）の実行環境およびインフラ構成について記載したものです。VBCorLibはサーバーサイドアプリケーションではなく、クライアントサイドで動作するCOMコンポーネント（ActiveX DLL）であるため、従来のWebシステムにおけるサーバー構成とは異なる観点で記述しています。

## システム構成

### 全体構成

VBCorLibは以下の構成要素から成るクライアントサイドライブラリです。

- **メインライブラリ**: VBCorLib3.dll（ActiveX DLL/COMコンポーネント）
- **タイプライブラリ**: CorType.tlb、VBVM6Lib.tlb（開発時参照用）
- **リソースファイル**: CorLib.RES、CorLib.chm（ヘルプファイル）

クライアントPC上でVB6アプリケーションと共に動作し、.NETフレームワーク相当の機能を提供します。

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| 該当なし | - | - | - |

本プロジェクトはクライアントサイドライブラリであり、サーバー構成は存在しません。ただし、配布およびドキュメント公開用に以下の外部サービスを利用しています。

| 外部サービス | 役割 |
| --- | --- |
| GitHub | ソースコード管理、バージョン管理、イシュー管理 |
| GitHub Pages | ドキュメントホスティング（jekyll-theme-caymanテーマ使用） |
| kellyethridge.com | オンラインドキュメント公開、CHMファイル配布 |

### ネットワーク構成

本プロジェクトはクライアントサイドで完結するため、専用のネットワーク構成は必要ありません。ただし、以下のネットワーク接続が関係します。

- **開発者向け**: GitHubリポジトリへのアクセス（HTTPS/SSH）
- **エンドユーザー向け**: ドキュメントサイトへのアクセス（HTTPS）

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Visual Basic 6.0 Runtime | - | VB6アプリケーション実行基盤 |
| OLE Automation (stdole2.tlb) | 2.0 | COM/OLEインフラストラクチャ |
| VBVM6Lib | 1.1 | VB6仮想マシン拡張機能 |
| Windows CryptoAPI | - | 暗号化機能（RSA、DES、AES等） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソース管理・配布 | HTTPS/SSH（Git） |
| GitHub Pages | ドキュメント公開 | HTTPS（Jekyll） |

## スケーリング設計

本プロジェクトはクライアントサイドCOMコンポーネントであり、サーバーサイドのスケーリング設計は適用されません。

各クライアントPC上で独立して動作するため、スケーラビリティはエンドユーザーのマシンスペックに依存します。

### クライアント環境要件

- **OS**: Windows（NT系）- Windows XP以降推奨
- **ランタイム**: VB6ランタイム（MSVBVM60.DLL）
- **アーキテクチャ**: 32ビット（x86）/ WoW64
- **メモリ**: アプリケーション依存
- **ディスク**: DLL約1.6MB（CorLib.chm含む）

## 可用性設計

### DLL登録と依存関係

VBCorLib3.dllはCOMコンポーネントとしてWindowsレジストリに登録が必要です。

- **登録方法**: `regsvr32 VBCorLib3.dll` またはインストーラ使用
- **インストール先**: `{System}` フォルダ（通常 C:\Windows\SysWOW64）
- **アンインストール**: 標準のWindows「プログラムの追加と削除」から実行

### 冗長構成

クライアントサイドライブラリのため、サーバー冗長構成は適用されません。

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git（GitHub） | コミット毎 | 無期限 |
| リリースバイナリ | GitHub Releases | リリース毎 | 無期限 |
| ドキュメント | GitHub Pages | 更新毎 | 無期限 |

## 監視設計

本プロジェクトはクライアントサイドライブラリであり、サーバー監視は適用されません。

### 品質保証

- **テストフレームワーク**: VB6ネイティブテスト（Source/Tests）
- **テストプロジェクト**: CorLib.Tests.vbp
- **サンプルプロジェクト**: Examples配下の各種サンプル

## 配布インフラ

### インストーラ構成

Inno Setup（InstallScript.iss）を使用した配布パッケージを提供しています。

| 項目 | 内容 |
| --- | --- |
| インストーラ形式 | Inno Setup |
| 出力ファイル名 | VBCorLib-3.2.0.exe |
| 圧縮方式 | LZMA（ソリッド圧縮） |
| コンポーネント | binaries（必須）、examples（オプション） |

### インストール内容

1. **VBCorLib3.dll**: システムフォルダにコピー・COM登録
2. **テンプレート**: VB6テンプレートフォルダにコピー
3. **サンプル**: 任意でProgram Filesにコピー
4. **ドキュメント**: readme.txt、LICENSE.txt

## 開発環境構成

### 必須環境

| 項目 | 要件 |
| --- | --- |
| IDE | Visual Basic 6.0 |
| タイプライブラリビルド | MKTYPLIB.EXE（VB6付属） |
| インストーラビルド | Inno Setup |

### Git設定要件

Windows EOL対応のため、以下の設定が必須です。

```shell
git config --global core.autocrlf false
```

## 備考

- VBCorLibはバージョン4.0が最新であり、多数の.NET互換クラスを提供
- 暗号化機能（Rijndael、RSA、DES、TripleDES、各種ハッシュアルゴリズム）はWindows CryptoAPIを利用
- Unicode APIサポートにより、32KB以上の長いファイル名に対応
- BigInteger、Int64などの拡張数値型をサポート
- VBCultures.nlpファイルはリソースとしてDLLに内包され、配布の簡素化を実現
