---
generated_at: 2026-01-20 17:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **PBKDF2推奨反復回数**：業界標準を参照したが、コード内に明示的な推奨値なし
  2. **RSA推奨キーサイズ2048ビット**：コードではデフォルト1024ビット、推奨値は一般的なセキュリティガイドライン
  3. **高暗号化システムの定義**：Windows CryptoAPIの仕様に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/TripleDESCryptoServiceProvider.cls`
- E-04: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls`
- E-05: `Source/CorLib/System.Security.Cryptography/SHA256Managed.cls`
- E-06: `Source/CorLib/System.Security.Cryptography/HMACSHA256.cls`
- E-07: `Source/CorLib/System.Security.Cryptography/Rfc2898DeriveBytes.cls`
- E-08: `Source/CorLib/System.Security.Cryptography/RNGCryptoServiceProvider.cls`
- E-09: `Source/CorLib/System.Security.Cryptography/CryptoStream.cls`
- E-10: `Source/CorLib/System.Security/SecurityElement.cls`
- E-11: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rijndaelは128/192/256ビットキーをサポート | E-02: DEF_MINKEYSIZE=128, DEF_MAXKEYSIZE=256, DEF_KEYSKIPSIZE=64 | ○ |
| C-02 | Rijndaelは128/192/256ビットブロックサイズをサポート | E-02: DEF_MINBLOCKSIZE=128, DEF_MAXBLOCKSIZE=256 | ○ |
| C-03 | TripleDESは128/192ビットキーをサポート | E-03: LegalMinKeySize=128, LegalMaxKeySize=192 | ○ |
| C-04 | DESは64ビットキーをサポート | E-04: LegalKeySize=64 | ○ |
| C-05 | CBCがデフォルト暗号モード | E-02, E-03, E-04: Mode=CipherMode.CBC | ○ |
| C-06 | PKCS7がデフォルトパディング | E-02, E-03, E-04: Padding=PaddingMode.PKCS7 | ○ |
| C-07 | RSAはデフォルト1024ビット | E-01: mKeySize=1024 | ○ |
| C-08 | RSAは384-16384ビットをサポート | E-01: Cor.NewKeySizes(384, 16384, 8) | ○ |
| C-09 | RSAはOAEPパディングをサポート | E-01: fOAEP=True時にCRYPT_OAEPフラグ使用 | ○ |
| C-10 | RSAはSHA-256署名をサポート | E-01: CALG_SHA_256対応のSetHash関数 | ○ |
| C-11 | SHA-256は256ビットハッシュ | E-05: HashSize=256 | ○ |
| C-12 | HMAC-SHA256は256ビットハッシュ | E-06: HashSize=256 | ○ |
| C-13 | HMAC-SHA256のブロックサイズは64バイト | E-06: Cor.NewHMACBase(New SHA256Managed, 64, "SHA256") | ○ |
| C-14 | Rfc2898DeriveBytesはPBKDF2実装 | E-07: HMACSHA1ベースの鍵導出、反復処理実装 | ○ |
| C-15 | ソルトは8バイト以上が必要 | E-07: Len1D(Value) < 8 でエラー | ○ |
| C-16 | RNGはCryptoAPI経由 | E-08: CryptGenRandom関数使用 | ○ |
| C-17 | CryptoStreamは読み取り/書き込みモード | E-09: CryptoStreamMode.ReadMode, WriteMode | ○ |
| C-18 | SecurityElementは入力検証実装 | E-10: IsValidTag, IsValidText等のチェック | ○ |
| C-19 | DESは弱鍵検出機能あり | E-04: IsWeakKey, IsSemiWeakKey呼び出し | ○ |
| C-20 | TripleDESは弱鍵検出機能あり | E-03: IsWeakKey呼び出し | ○ |
| C-21 | PersistKeyInCspでキー永続化 | E-01: mPersistKeyInCspプロパティ | ○ |
| C-22 | UseMachineKeyStoreフラグ対応 | E-01: CspProviderFlags.UseMachineKeyStore | ○ |
| C-23 | UseExistingKeyフラグ対応 | E-01: mFlags And UseExistingKey | ○ |
| C-24 | UseNonExportableKeyフラグ対応 | E-01: mFlags And UseNonExportableKey | ○ |
| C-25 | Clearメソッドでキー消去 | E-02, E-03: mBase.Clear | ○ |
| C-26 | SHA-384は384ビットハッシュ | E-01: HashLen=48（48*8=384） | ○ |
| C-27 | SHA-512は512ビットハッシュ | E-01: HashLen=64（64*8=512） | ○ |
| C-28 | MD5は128ビットハッシュ | E-01: HashLen=16（16*8=128） | ○ |
| C-29 | RSAはXMLエクスポート/インポート対応 | E-01: ToXmlString, FromXmlString | ○ |
| C-30 | 高暗号化システムでRSA最大16384ビット | E-01: HasHighEncryption時 | ○ |
| C-31 | ベース暗号化システムでRSA最大512ビット | E-01: Else時NewKeySizes(384, 512, 8) | ○ |
| C-32 | Rfc2898DeriveBytesはHMACSHA1使用 | E-07: Set mHasher = Cor.NewHMACSHA1(Key) | ○ |
| C-33 | パスワードはUTF-8エンコード | E-07: Encoding.UTF8.GetBytes(Password) | ○ |
| C-34 | SHA1は160ビットハッシュ | E-01: HashLen=20（20*8=160） | ○ |
| C-35 | CFBモードはフィードバックサイズ制限あり | E-03, E-04: CFBSizeNotSupported | ○ |
| C-36 | CryptoStreamはFlushFinalBlock必要 | E-09: FlushFinalBlockメソッド | ○ |
| C-37 | MACTripleDESサポート | E-11: README.mdに記載 | ○ |
| C-38 | RIPEMD160サポート | E-11: README.mdに記載 | ○ |
| C-39 | RC2暗号化サポート | E-11: README.mdに記載 | ○ |
| C-40 | 2GB以上のファイル対応 | E-11: README.mdに記載 | ○ |
| C-41 | MITライセンス | E-01, E-02等: ソースコードヘッダー | ○ |
| C-42 | Windows CryptoAPI依存 | E-01, E-08: CryptoAPI呼び出し | ○ |
| C-43 | PBKDF2推奨反復回数10,000回以上 | **根拠なし** | △ |
| C-44 | RSA推奨キーサイズ2048ビット以上 | **根拠なし** | △ |
| C-45 | 高暗号化システムの定義基準 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **PBKDF2推奨反復回数**: コード内に推奨値の明示なし。NIST SP 800-132等の外部標準を参照。
  - 候補：NIST SP 800-132 / OWASP Guidelines / RFC 8018
- **RSA推奨キーサイズ**: コードデフォルトは1024ビット。NIST/CISベンチマーク等の推奨は2048ビット以上。
  - 候補：NIST SP 800-131A / CIS Benchmarks / ENISA Guidelines
- **高暗号化システムの定義**: Windows CryptoAPIの`HasHighEncryption`の判定基準がコード内に不明。
  - 候補：Windows SDK Documentation / Microsoft CryptoAPI Reference

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 暗号アルゴリズム仕様、キーサイズ、ブロックサイズ等の技術仕様
- **1（中リスク）**: 推奨事項、ベストプラクティス関連の記述
- **2（高リスク）**: 該当なし（セキュリティ脆弱性につながる誤記載は確認されず）

## 6) レビュアーチェックリスト（最小）
- [ ] RSAデフォルトキーサイズ1024ビットが利用側アプリケーションで適切か確認
- [ ] PBKDF2の反復回数がプロジェクト要件を満たしているか確認
- [ ] DES/MD5/SHA-1の使用が許容されるか、プロジェクトのセキュリティポリシーと照合
- [ ] 弱鍵検出機能が有効に活用されているか確認
- [ ] キー消去（Clear）が適切なタイミングで呼び出されているか確認
