# セキュリティ設計書

## 概要

本ドキュメントは、VBCorLibプロジェクトにおけるセキュリティ関連機能の設計を記載する。VBCorLibは.NET Frameworkの暗号化機能をVisual Basic 6向けに実装したライブラリであり、Windows CryptoAPIを活用した暗号化サービスを提供する。

## 認証設計

### 認証方式

VBCorLibはライブラリとして機能するため、認証機能は直接実装していない。ただし、暗号化キーの管理において以下のセキュリティ機構を提供する。

| 項目 | 説明 |
| --- | --- |
| キーコンテナ | Windows CryptoAPI経由でCSP（Cryptographic Service Provider）キーコンテナを使用 |
| マシンキーストア | `UseMachineKeyStore`フラグによりマシンレベルでのキー保存が可能 |
| キーの永続化 | `PersistKeyInCsp`プロパティでキーの永続化を制御 |

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッション有効期限 | 該当なし | ライブラリのため、セッション管理は利用側アプリケーションの責任 |
| セッション固定化対策 | 該当なし | ライブラリのため、セッション管理は利用側アプリケーションの責任 |

## 認可設計

### 権限体系

| ロール | 権限 | 説明 |
| --- | --- | --- |
| 該当なし | 該当なし | VBCorLibはライブラリであり、ロールベースのアクセス制御は実装していない |

### アクセス制御

VBCorLibはライブラリとして動作するため、アクセス制御は利用側アプリケーションの責任となる。ただし、暗号化キーへのアクセスにおいて以下の制御が可能。

- **CspProviderFlags**: キーへのアクセス制御フラグ
  - `UseMachineKeyStore`: マシンレベルのキーストアを使用
  - `UseExistingKey`: 既存のキーのみ使用（新規生成不可）
  - `UseNonExportableKey`: エクスポート不可のキーを生成
  - `UseArchivableKey`: アーカイブ可能なキーを生成

## 通信セキュリティ

| 項目 | 対策 |
| --- | --- |
| HTTPS | 該当なし（ライブラリのため通信機能なし） |
| HSTS | 該当なし（ライブラリのため通信機能なし） |

## データセキュリティ

### 暗号化

VBCorLibは以下の暗号化アルゴリズムを提供する。

#### 対称鍵暗号

| 対象 | 暗号化方式 | キーサイズ | ブロックサイズ | 備考 |
| --- | --- | --- | --- | --- |
| 保存データ | Rijndael (AES) | 128/192/256ビット | 128/192/256ビット | 推奨 |
| 保存データ | TripleDES (3DES) | 128/192ビット | 64ビット | レガシーサポート |
| 保存データ | DES | 64ビット | 64ビット | 非推奨（弱鍵検出機能あり） |
| 保存データ | RC2 | 40-128ビット | 64ビット | レガシーサポート |

#### 暗号モード

| モード | 説明 | 対応状況 |
| --- | --- | --- |
| CBC | Cipher Block Chaining（デフォルト） | 対応 |
| ECB | Electronic Codebook | 対応 |
| CFB | Cipher Feedback | 対応（フィードバックサイズ制限あり） |

#### パディングモード

| モード | 説明 | 対応状況 |
| --- | --- | --- |
| PKCS7 | PKCS#7パディング（デフォルト） | 対応 |

#### 非対称鍵暗号

| 対象 | 暗号化方式 | キーサイズ | 備考 |
| --- | --- | --- | --- |
| キー交換 | RSA | 384-16384ビット（デフォルト1024） | PKCS#1 v1.5またはOAEPパディング |
| デジタル署名 | RSA | 384-16384ビット | SHA1/SHA256/SHA384/SHA512/MD5対応 |
| デジタル署名 | DSA | 可変 | Windows CryptoAPI経由 |

### ハッシュアルゴリズム

| アルゴリズム | ハッシュサイズ | 実装 | 備考 |
| --- | --- | --- | --- |
| SHA-1 | 160ビット | Managed/CryptoAPI | レガシーサポート |
| SHA-256 | 256ビット | Managed | 推奨 |
| SHA-384 | 384ビット | Managed | 推奨 |
| SHA-512 | 512ビット | Managed | 推奨 |
| MD5 | 128ビット | CryptoAPI | 非推奨 |
| RIPEMD-160 | 160ビット | Managed | 特定用途向け |

### メッセージ認証コード（MAC）

| アルゴリズム | ベースハッシュ | ブロックサイズ | 備考 |
| --- | --- | --- | --- |
| HMAC-SHA1 | SHA-1 | 64バイト | 標準サポート |
| HMAC-SHA256 | SHA-256 | 64バイト | 推奨 |
| HMAC-SHA384 | SHA-384 | 128バイト | 高セキュリティ向け |
| HMAC-SHA512 | SHA-512 | 128バイト | 高セキュリティ向け |
| HMAC-MD5 | MD5 | 64バイト | レガシーサポート |
| HMAC-RIPEMD160 | RIPEMD-160 | 64バイト | 特定用途向け |
| MACTripleDES | TripleDES | 64バイト | レガシーサポート |

### 鍵導出関数

| 関数 | 説明 | パラメータ |
| --- | --- | --- |
| Rfc2898DeriveBytes | PBKDF2（パスワードベース鍵導出関数） | パスワード、ソルト（8バイト以上）、反復回数 |

### 乱数生成

| クラス | 説明 | 用途 |
| --- | --- | --- |
| RNGCryptoServiceProvider | Windows CryptoAPI経由の暗号学的乱数生成 | キー生成、IV生成、ソルト生成 |

### 機密情報管理

VBCorLibでは以下の機密情報管理機構を実装。

| 項目 | 管理方式 |
| --- | --- |
| 秘密鍵 | CSPキーコンテナに保存可能（`PersistKeyInCsp`） |
| 対称鍵 | メモリ上で管理、`Clear`メソッドで明示的に消去 |
| IV | メモリ上で管理、`Clear`メソッドで明示的に消去 |
| パスワード | UTF-8エンコードでHMACキーに変換後、元データは保持しない |

### 弱鍵対策

| アルゴリズム | 対策 | 実装 |
| --- | --- | --- |
| DES | 弱鍵・準弱鍵の検出 | `IsWeakKey`、`IsSemiWeakKey`メソッド |
| TripleDES | 弱鍵の検出 | `IsWeakKey`メソッド |

## 入出力対策

| 脅威 | 対策 |
| --- | --- |
| XSS | 該当なし（ライブラリのためUI機能なし） |
| SQLインジェクション | 該当なし（ライブラリのためDB機能なし） |
| CSRF | 該当なし（ライブラリのためWeb機能なし） |
| XMLインジェクション | SecurityElementクラスで入力検証（`IsValidTag`、`IsValidText`、`IsValidAttributeName`、`IsValidAttributeValue`） |
| バッファオーバーフロー | 配列境界チェック、`ValidateArray`関数による入力検証 |

## 監査ログ

| ログ種別 | 記録内容 | 保持期間 |
| --- | --- | --- |
| 該当なし | 該当なし | VBCorLibはライブラリであり、ログ機能は利用側アプリケーションの責任 |

## セキュリティ実装詳細

### CryptoStreamクラス

ストリーミング暗号化/復号を提供。

| 項目 | 説明 |
| --- | --- |
| 読み取りモード | データを読み取りながら復号 |
| 書き込みモード | データを書き込みながら暗号化 |
| 最終ブロック処理 | `FlushFinalBlock`で最終データとパディングを処理 |

### Base64変換

| クラス | 説明 |
| --- | --- |
| ToBase64Transform | バイナリからBase64への変換 |
| FromBase64Transform | Base64からバイナリへの変換 |

### XMLセキュリティ

RSAパラメータのXML形式でのインポート/エクスポートをサポート。

| メソッド | 説明 |
| --- | --- |
| ToXmlString | RSAパラメータをXML文字列にエクスポート |
| FromXmlString | XML文字列からRSAパラメータをインポート |

## セキュリティ上の推奨事項

1. **推奨アルゴリズム**
   - 対称鍵暗号: Rijndael (AES) 256ビット
   - ハッシュ: SHA-256以上
   - MAC: HMAC-SHA256以上
   - 非対称鍵: RSA 2048ビット以上

2. **非推奨アルゴリズム**
   - DES（64ビット鍵は現代の基準で脆弱）
   - MD5（衝突攻撃に対して脆弱）
   - SHA-1（署名用途では非推奨）

3. **ベストプラクティス**
   - 暗号化後は必ず`Clear`メソッドを呼び出してキーを消去
   - IVは毎回ランダムに生成（`GenerateIV`）
   - パスワードからの鍵導出には`Rfc2898DeriveBytes`を使用
   - ソルトは8バイト以上を使用
   - PBKDF2の反復回数は最低10,000回以上を推奨

## 備考

- VBCorLibはMIT Licenseの下で提供されている
- Windows CryptoAPIに依存するため、Windowsプラットフォームでのみ動作
- 高暗号化システムでは最大16384ビットのRSAキーをサポート
- ベース暗号化システムでは最大512ビットのRSAキーに制限
