---
generated_at: 2026-01-20 15:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **性能テスト目標値**：具体的な数値目標の根拠不足
  2. **カバレッジ目標の妥当性**：測定ツール未導入の判断根拠不足
  3. **CI/CD未導入の理由**：技術的制約の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Tests/CorLib.Tests.vbp` - テストプロジェクト設定ファイル
- E-02: `Source/Tests/README.TXT` - テストプロジェクト説明
- E-03: `Source/Tests/frmSimplyVBUnitRunner.frm` - テストランナーフォーム
- E-04: `Source/Tests/Helpers/AssertHelper.bas` - アサーションヘルパーモジュール
- E-05: `Source/Tests/System/CorArrayTests.cls` - テストクラス例（CorArray）
- E-06: `Source/Tests/System.Security.Cryptography/SHA1CryptoServiceProviderTests.cls` - テストクラス例（暗号化）
- E-07: `Source/Fakes/Fakes.vbp` - Fakesプロジェクト設定ファイル
- E-08: `README.md` - プロジェクト概要
- E-09: `Source/Tests/Dummy Test Files/` - テストデータファイル群
- E-10: `Source/Tests/` ディレクトリ構造 - テストクラス配置

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SimplyVBUnit 5.0をテストフレームワークとして使用 | E-01, E-02 | ○ |
| C-02 | 216個のテストクラスが存在 | E-10（find結果） | ○ |
| C-03 | テストクラス命名規約は{対象クラス名}Tests | E-05, E-06 | ○ |
| C-04 | ICategorizable/ITestCaseSourceインターフェースを実装 | E-05, E-06 | ○ |
| C-05 | Assert.That による流暢なアサーション記法を使用 | E-05, E-06 | ○ |
| C-06 | Sim.NewTestSuite()によるテストグループ化 | E-03 | ○ |
| C-07 | Fakesプロジェクトにテストダブルを配置 | E-07 | ○ |
| C-08 | FakeStream, FakeTransform等のクラスが存在 | E-07 | ○ |
| C-09 | テストデータはDummy Test Filesに配置 | E-09 | ○ |
| C-10 | テストメソッド命名は{メソッド名}_{条件}_{期待結果} | E-05, E-06 | ○ |
| C-11 | AssertHelper.basに例外検証ヘルパーを定義 | E-04 | ○ |
| C-12 | System名前空間のテストが約50クラス | E-10 | ○ |
| C-13 | System.Collectionsのテストが約25クラス | E-10 | ○ |
| C-14 | System.Security.Cryptographyのテストが約40クラス | E-10 | ○ |
| C-15 | テストランナーはfrmSimplyVBUnitRunner | E-03 | ○ |
| C-16 | F5キーで全テスト実行可能 | E-03 | ○ |
| C-17 | OutputLoggerでログ出力 | E-03 | ○ |
| C-18 | タイムゾーン依存テストにAssertPacificTimeZoneを使用 | E-04 | ○ |
| C-19 | 暗号化テストでHexToBytes関数を使用 | E-06 | ○ |
| C-20 | パラメータ化テストでTest.Useを使用 | E-05, E-06 | ○ |
| C-21 | CorLibは.NET互換のVB6ライブラリ | E-08 | ○ |
| C-22 | 2GB超ファイル処理をサポート | E-08 | ○ |
| C-23 | 行カバレッジ/分岐カバレッジの測定ツール未導入 | **根拠なし** | △ |
| C-24 | CI/CDパイプライン未導入 | E-10（設定ファイル不在） | ○ |
| C-25 | 性能テストの具体的な目標値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ測定ツール未導入の根拠**: VB6環境でのカバレッジ測定ツールの調査・検証結果が不明
  - 候補：VB6対応カバレッジツールの存在確認 / プロジェクト方針ドキュメント / 開発者へのヒアリング
- **性能テスト目標値**: 性能要件を定義したドキュメントが見当たらない
  - 候補：性能要件定義書 / ベンチマーク結果 / 非機能要件ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストフレームワーク、テストクラス構成、命名規約 - ソースコードから明確に確認可能
- **1（中リスク）**: カバレッジ目標、CI/CD連携 - 現状の制約を記載しているが、改善計画の確認が望ましい
- **2（高リスク）**: 性能テスト目標 - 具体的な数値目標がないため、品質基準が曖昧

## 6) レビュアーチェックリスト（最小）
- [ ] SimplyVBUnit 5.0のバージョンが現在も正しいか確認
- [ ] テストクラス数216の正確性を検証（テスト追加時に更新が必要）
- [ ] 性能テストの具体的な目標値を定義する必要があるか判断
- [ ] カバレッジ測定ツール導入の可否を検討
- [ ] CI/CD導入の技術的実現可能性を調査
- [ ] タイムゾーン依存テストのスキップ条件が適切か確認
- [ ] 暗号化テストベクターが最新の.NET実装と一致しているか確認
