# テスト方針書

## 概要

本ドキュメントは、VBCorLibプロジェクトにおけるテスト方針を定義する。VBCorLibは.NET Frameworkの多くのクラスをVisual Basic 6で実装したライブラリであり、コレクション、暗号化、ハッシュ、エンコーディング、ファイル操作、BigInteger等の機能を提供する。本テスト方針書は、ライブラリの品質を担保するためのテスト戦略、環境、ツール、カバレッジ目標を規定する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 各クラス・モジュールの機能が仕様通りに動作することを検証する | 開発者 |
| 結合テスト | 複数クラス間の連携（例：暗号化とストリーム、エンコーディングとファイル操作）が正しく動作することを検証する | 開発者 |
| システムテスト | ライブラリ全体として.NET互換の動作を実現していることを検証する | 開発者・QA |
| 受入テスト | エンドユーザーがライブラリを利用する際の要件を満たしていることを確認する | ユーザー・開発者 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各クラスのメソッド・プロパティが仕様通りの結果を返すことを検証する | 開発時・コミット前 |
| 性能テスト | BigInteger演算、暗号化処理、大容量ファイル操作等のパフォーマンスを計測する | リリース前 |
| セキュリティテスト | 暗号化アルゴリズム（Rijndael、RSA、TripleDES、DES等）の実装が正しいことを検証する | リリース前 |
| 境界値テスト | 配列境界、ファイルサイズ上限（2GB超）、数値オーバーフロー等のエッジケースを検証する | 開発時 |
| 例外テスト | 不正な入力に対して適切な例外がスローされることを検証する | 開発時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| 開発環境 | 単体テストの実行・デバッグ | Windows + VB6 IDE + SimplyVBUnit |
| テスト環境 | 結合テスト・システムテストの実行 | Windows + VB6ランタイム + SimplyVBUnit |
| CI環境 | 未導入（手動実行） | N/A |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| SimplyVBUnit | 単体テストフレームワーク | 5.0 |
| SimplyVBUnit.Component.ocx | テストランナーUIコンポーネント | 5.0 |
| SimplyVBUnitType.tlb | SimplyVBUnit型ライブラリ | 5.0 |
| Fakes.dll | テストダブル（Fake/Mock/Spy）ライブラリ | 1.0 |

## テストフレームワーク詳細

### SimplyVBUnit

SimplyVBUnitはVB6用の単体テストフレームワークであり、以下の機能を提供する：

- **アサーション**: `Assert.That`による流暢なアサーション記法
- **制約ベースアサーション**: `Iz.EqualTo()`, `Iz.True`, `Iz.False`等の制約
- **テストケースソース**: `ITestCaseSource`インターフェースによるパラメータ化テスト
- **カテゴリ分類**: `ICategorizable`インターフェースによるテストの分類
- **テストスイート**: `Sim.NewTestSuite()`によるテストのグループ化
- **Setup/Teardown**: 各テスト前後の初期化・クリーンアップ処理

### テストクラス構成

テストクラスは以下の規約に従う：

1. クラス名は`{対象クラス名}Tests`とする（例：`CorArrayTests`, `SHA1CryptoServiceProviderTests`）
2. `ICategorizable`インターフェースを実装し、名前空間カテゴリを設定する
3. パラメータ化テストには`ITestCaseSource`インターフェースを実装する
4. テストメソッドは`Public Sub`として定義し、パラメータなし（パラメータ化テストは例外）

### Fakes（テストダブル）ライブラリ

テストダブル用のFakesプロジェクトには以下のクラスが含まれる：

| クラス | 用途 |
| --- | --- |
| FakeStream | ストリーム操作のテスト用ダブル |
| FakeTransform | 暗号変換のテスト用ダブル |
| CryptoStreamSpy | 暗号ストリームの動作監視用スパイ |
| FakeObject | 汎用オブジェクトのテスト用ダブル |
| FakeCustomFormatter | カスタムフォーマッタのテスト用ダブル |
| MockObject | モックオブジェクト |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 測定ツール未導入のため数値目標なし |
| 分岐カバレッジ | 測定ツール未導入のため数値目標なし |
| 機能カバレッジ | 主要クラスの公開メソッド・プロパティを網羅 |

### 現在のテストカバレッジ状況

現在216個のテストクラスが存在し、以下の名前空間をカバーしている：

| 名前空間 | テストクラス数 | 主なテスト対象 |
| --- | --- | --- |
| System | 約50クラス | CorArray, Convert, DateTime, Exception, Guid, TimeSpan等 |
| System.Collections | 約25クラス | ArrayList, Hashtable, Queue, Stack, SortedList, BitArray等 |
| System.IO | 約20クラス | File, Directory, Stream, BinaryReader/Writer等 |
| System.Text | 約25クラス | Encoding (UTF8, UTF7, Unicode, ASCII等), StringBuilder等 |
| System.Security.Cryptography | 約40クラス | SHA1, SHA256, MD5, DES, TripleDES, Rijndael, RSA等 |
| System.Resources | 約25クラス | ResourceReader/Writer, ResourceManager等 |
| System.Globalization | 約10クラス | Calendar (Gregorian, Hebrew, Hijri, Japanese等), CultureInfo等 |
| System.Numerics | 約15クラス | BigInteger, NumberStyles Parsing等 |
| System.IO.MemoryMappedFiles | 3クラス | MemoryMappedFile, MemoryMappedViewAccessor等 |
| Microsoft.Win32 | 3クラス | Registry, RegistryKey, SafeHandle等 |
| System.Security | 1クラス | SecurityElement |
| System.Diagnostics | 1クラス | StopWatch |

## テストデータ

テストデータは以下の方法で準備する：

### インラインデータ

- パラメータ化テストにおいて`ITestCaseSource`の`GetTestCases`メソッド内でテストケースを定義
- 例：暗号化テストでの入力メッセージとダイジェストの期待値

### 外部ファイル

テストデータファイルは`Source/Tests/Dummy Test Files/`ディレクトリに配置：

| ファイル | 用途 |
| --- | --- |
| 100Bytes.txt | ファイルサイズテスト用 |
| 3bytes.txt | 小サイズファイルテスト用 |
| Chars0To65535InCodePage437.txt | 文字コードページテスト用 |
| Exists.txt | ファイル存在確認テスト用 |
| HebrewCalendar_*.txt | ヘブライ暦テスト用データ |
| hello.txt | 基本的なファイル読み取りテスト用 |
| mappedfile.txt | メモリマップトファイルテスト用 |

### 暗号化テストデータ

`Source/Tests/Cryptography Files/`ディレクトリに暗号化関連のテストベクターを配置。

## 不具合管理

不具合は以下の方法で管理する：

1. **発見時**: テストクラス内のコメントまたは`[TaskList]`セクションに記録
2. **追跡**: GitHub Issuesを使用（ISSUE_TEMPLATE.mdに従う）
3. **修正確認**: 該当する単体テストを追加または修正し、テストがパスすることを確認

### テストスキップ

特定条件でスキップが必要なテストには以下の機構を使用：

- `Assert.Ignore`: テストをスキップ（例：タイムゾーン固有テスト）
- `Assert.Pass`: 条件付きパス（例：`SkipUnsupportedTimeZone`フラグ）

## CI/CD連携

現在、CI/CDパイプラインは導入されていない。テストは以下の方法で実行される：

### 手動実行

1. VB6 IDEで`CorLib.Tests.vbp`を開く
2. F5キーまたは「実行」でテストランナー（frmSimplyVBUnitRunner）を起動
3. テストランナーUIでテストを実行（F5キーで全テスト実行）

### テスト実行の前提条件

- SimplyVBUnit 5.0がシステムにインストールされていること
- CorLib.vbpがビルド済みであること
- Fakes.vbpがビルド済みであること

### テスト結果の確認

- テストランナーUIで結果を視覚的に確認
- OutputLoggerクラスによるログ出力

## テスト命名規約

テストメソッドは以下の命名規約に従う：

```
{メソッド名}_{テスト条件}_{期待結果}
```

例：
- `GetLength_WithDimension_ReturnsExpected`
- `GetLength_WithInvalidDimensions_ThrowsIndexOutOfRangeException`
- `ComputeHash_WithByteArray_ReturnsExpected`
- `Constructor_WhenCalled_SetsDefaultValues`

## アサーションヘルパー

`AssertHelper.bas`モジュールには以下の例外検証用ヘルパー関数が定義されている：

| ヘルパー関数 | 検証対象 |
| --- | --- |
| AssertArgumentException | ArgumentException |
| AssertArgumentNullException | ArgumentNullException |
| AssertArgumentOutOfRangeException | ArgumentOutOfRangeException |
| AssertIndexOutOfRangeException | IndexOutOfRangeException |
| AssertInvalidOperationException | InvalidOperationException |
| AssertFormatException | FormatException |
| AssertOverflowException | OverflowException |
| AssertIOException | IOException |
| AssertFileNotFoundException | FileNotFoundException |
| AssertCryptographicException | CryptographicException |
| その他多数 | 各種例外 |

## 備考

### .NET互換性

VBCorLibは.NET Frameworkのクラスを模倣しているため、テストケースも.NETの動作に準拠することを目指す。テストベクター（特に暗号化関連）は.NETの実装と同一の結果を返すことを検証する。

### タイムゾーン依存テスト

一部のテスト（特にDateTime、TimeZone関連）はPacific Standard Timeを前提としている。他のタイムゾーンでは`AssertPacificTimeZone`ヘルパーによりテストがスキップされる場合がある。

### 大規模データ処理

VBCorLibは2GB超のファイル処理をサポートしており、関連するテストでは大容量ファイルの読み書きを検証する。

### 既知の制限事項

- VB6 IDEの制約により、CI/CDパイプラインでの自動実行は困難
- コードカバレッジ測定ツールがVB6に対応していないため、数値目標を設定していない
- 一部のテストはWindows固有の機能（Registry、Win32 API等）に依存
