# ER図

## 概要

本ドキュメントは、VBCorLibプロジェクトのER図（Entity-Relationship Diagram）を記載するものです。

**結論: VBCorLibプロジェクトにはデータベースが存在しないため、ER図は該当ありません。**

## ER図

```mermaid
erDiagram
    %% VBCorLibにはデータベーステーブルが存在しないため、
    %% ER図で表現すべきエンティティはありません。
    %%
    %% 以下は参考として、プロジェクトの主要な内部データ構造を
    %% クラス図形式で表現しています。
```

## 内部データ構造図（参考）

VBCorLibはデータベースを使用しませんが、プログラム内部で使用される主要なデータ構造の関係を参考として示します。

```mermaid
classDiagram
    class ArrayList {
        -mItems() Variant
        -mCount Long
        +Add(Value)
        +Remove(Index)
        +Item(Index) Variant
    }

    class Hashtable {
        -mBuckets() HashBucket
        -mCount Long
        +Add(Key, Value)
        +Remove(Key)
        +Item(Key) Variant
    }

    class HashBucket {
        +Key Variant
        +Value Variant
        +HashCode Long
    }

    class Stack {
        -mItems() Variant
        -mTop Long
        +Push(Value)
        +Pop() Variant
        +Peek() Variant
    }

    class Queue {
        -mItems() Variant
        -mHead Long
        -mTail Long
        +Enqueue(Value)
        +Dequeue() Variant
        +Peek() Variant
    }

    class BigNumber {
        +Digits() Long
        +Sign Long
        +Precision Long
    }

    class Delegate {
        +pVTable Long
        +pFunc Long
        +ObjectPtr Long
    }

    class SortItems {
        +Keys Variant
        +Items Variant
        +Left Long
        +Right Long
    }

    Hashtable --> HashBucket : contains
```

## コレクションクラス継承関係（参考）

```mermaid
classDiagram
    class ICollection {
        <<interface>>
        +Count() Long
        +CopyTo(Arr, Index)
    }

    class IList {
        <<interface>>
        +Add(Value)
        +Remove(Index)
        +Item(Index) Variant
    }

    class IDictionary {
        <<interface>>
        +Add(Key, Value)
        +Remove(Key)
        +Item(Key) Variant
    }

    class IEnumerable {
        <<interface>>
        +GetEnumerator() IEnumerator
    }

    class IEnumerator {
        <<interface>>
        +MoveNext() Boolean
        +Current Variant
        +Reset()
    }

    class ArrayList {
        +Capacity Long
        +Sort()
        +BinarySearch()
    }

    class Hashtable {
        +LoadFactor Single
        +Keys() ICollection
        +Values() ICollection
    }

    class Stack {
        +Clear()
        +ToArray() Variant
    }

    class Queue {
        +Clear()
        +ToArray() Variant
    }

    ICollection <|-- IList
    ICollection <|-- IDictionary
    IEnumerable <|-- ICollection
    IList <|.. ArrayList
    IDictionary <|.. Hashtable
    ICollection <|.. Stack
    ICollection <|.. Queue
```

## 備考

### 図の説明

上記のクラス図は、VBCorLibの内部データ構造を表現したものであり、リレーショナルデータベースのER図ではありません。これらの構造体やクラスは、メモリ上でのデータ操作に使用されます。

### データベース連携について

VBCorLibをデータベースアプリケーションと組み合わせて使用する場合、`ArrayList`や`Hashtable`などのコレクションクラスを使用して、データベースから取得したレコードセットを効率的に管理することができます。

例えば:
- `ArrayList`を使用してクエリ結果を順序付きリストとして保持
- `Hashtable`を使用して主キーベースの高速検索を実現
- `Queue`を使用してバッチ処理のジョブキューを管理
