# データベース設計書

## 概要

本ドキュメントは、VBCorLibプロジェクトにおけるデータベース設計について記載するものです。

**結論: VBCorLibプロジェクトにはデータベース機能が存在しません。**

VBCorLibは.NET Frameworkの多くのクラスをVisual Basic 6で実装したライブラリであり、以下のような機能を提供しています:

- コレクション型（ArrayList, Stack, Queue, Hashtable）
- 暗号化アルゴリズム（Rijndael, RSA, TripleDES, DES）
- ハッシュアルゴリズム（SHA1, SHA256, SHA384, SHA512, RIPEMD160, MD5）
- テキストエンコーディング（UTF8, UTF7, UTF16, UTF32）
- ファイル操作クラス
- BigInteger（大規模数値計算）
- コンソールアクセス機能

これらはすべてインメモリ操作またはファイルシステム操作を行うユーティリティであり、データベース接続（ADODB、DAO等）やスキーマ定義、ORM機能は含まれていません。

## プロジェクト構造分析

### 調査対象

| 調査項目 | 結果 |
| --- | --- |
| SQLファイル（*.sql） | 存在しない |
| Accessデータベース（*.mdb, *.accdb） | 存在しない |
| System.Data名前空間 | 存在しない |
| ADODB/DAO参照 | 存在しない |
| データベース接続コード | 存在しない |

### ソースコード構造

VBCorLibのソースコードは以下の名前空間（ディレクトリ）で構成されています:

| 名前空間 | 説明 |
| --- | --- |
| Cor | コアユーティリティ（型変換、情報取得） |
| Microsoft.Win32 | Windows APIラッパー |
| Microsoft.Win32.SafeHandles | 安全なハンドル管理 |
| System | 基本型、配列操作、例外処理 |
| System.Collections | コレクションクラス（ArrayList, Hashtable等） |
| System.Diagnostics | 診断機能 |
| System.Globalization | 国際化・カレンダー機能 |
| System.IO | ファイル入出力 |
| System.IO.MemoryMappedFiles | メモリマップトファイル |
| System.Numerics | 数値計算（BigInteger） |
| System.Resources | リソース管理 |
| System.Runtime.Serialization | シリアライゼーション |
| System.Security | セキュリティ基盤 |
| System.Security.Cryptography | 暗号化機能 |
| System.Text | テキスト処理・エンコーディング |
| System.Threading | スレッド関連 |

**上記の中にSystem.Dataに相当するデータベースアクセス機能は含まれていません。**

## テーブル一覧

該当なし（本プロジェクトにはデータベーステーブルが存在しません）

## 各テーブル定義

該当なし

## 内部データ構造（参考）

VBCorLibでは、メモリ上のデータ操作のために以下のようなVB6のType（構造体）が定義されています。これらはデータベーステーブルではなく、プログラム内部で使用されるメモリ構造です:

| 構造体名 | 所在 | 用途 |
| --- | --- | --- |
| EnumeratorWrapper | System.Collections/Enumeration.bas | 列挙子ラッパー |
| LocalDelegateVTable | System/Delegation.bas | デリゲート仮想テーブル |
| DelegateVTable | System/Delegation.bas | デリゲート仮想テーブル |
| LocalDelegate | System/Delegation.bas | ローカルデリゲート |
| Delegate | System/Delegation.bas | パブリックデリゲート型 |
| SortItems | System/ArrayHelpers.bas | ソート用アイテム |
| HashBucket | System.Collections/HashtableHelper.bas | ハッシュテーブルバケット |
| BITMAPINFOHEADER | System/Resources.bas | ビットマップ情報ヘッダー |
| ListRange | System/Argument.bas | リスト範囲 |
| BufferBucket | System/CharAllocation.bas | 文字バッファバケット |
| BigNumber | System.Numerics/BigNumberMath.bas | 大規模数値 |
| NullVersionable | System/Statics.bas | Nullバージョン管理 |

## 備考

### 本ドキュメントの適用範囲

本ドキュメントは、VBCorLibプロジェクトのソースコード分析に基づいて作成されています。将来的にデータベース機能が追加された場合は、本ドキュメントを更新する必要があります。

### 推奨事項

VBCorLibをデータベースアプリケーションで使用する場合は、以下の方法が考えられます:

1. **別途ADODBを使用**: VB6標準のADODBライブラリを直接使用してデータベース接続を行う
2. **DAOを使用**: Microsoft DAO（Data Access Objects）を使用してAccessデータベースに接続する
3. **カスタムラッパー作成**: VBCorLibのコレクションクラスと組み合わせてデータベースラッパーを作成する

VBCorLibの`ArrayList`や`Hashtable`などのコレクションクラスは、データベースから取得したデータを効率的に管理するために活用できます。
