---
generated_at: 2026-01-20 15:40:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `TypeLibrary/Build.bat` - タイプライブラリビルドバッチファイル
- E-02: `TypeLibrary/CorType.odl` - ODL定義ファイル（Build.batで参照）
- E-03: `TypeLibrary/CorType.tlb` - 生成されたタイプライブラリファイル
- E-04: `Install/InstallScript.iss` - Inno Setupインストールスクリプト
- E-05: `TypeLibrary/README.TXT` - タイプライブラリの説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Build.batはタイプライブラリをビルドする | E-01 | ○ |
| C-02 | Build.batはmktyplib コマンドを使用する | E-01（2行目: `mktyplib /nocpp /tlb CorType.tlb CorType.odl`） | ○ |
| C-03 | Build.batはregtlib コマンドで登録する | E-01（6行目: `regtlib CorType.tlb`） | ○ |
| C-04 | Build.batはエラー時にpauseで停止する | E-01（3-5行目: `if not errorlevel 1 goto end` / `pause`） | ○ |
| C-05 | InstallScript.issはInno Setup用スクリプトである | E-04（1行目: Inno Setup Script Wizard生成コメント） | ○ |
| C-06 | InstallScript.issはVBCorLib3.dllをregserver登録する | E-04（35行目: `Flags: regserver`） | ○ |
| C-07 | InstallScript.issはExamplesをコピーする | E-04（36行目: `Source: ..\Examples\*`） | ○ |
| C-08 | InstallScript.issはTemplateをコピーする | E-04（39行目: `Source: ..\Template\Classes\*`） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 本プロジェクトで検出されたバッチ処理は全て根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して根拠が確認できており、信頼度は高い

## 6) レビュアーチェックリスト（最小）
- [ ] Build.batの実行環境（mktyplib, regtlibコマンドの存在）を確認
- [ ] InstallScript.issのInno Setup Compilerバージョン互換性を確認
- [ ] 他にスクリプト化されていないバッチ処理がないか確認
