# バッチ設計書 1-Build.bat

## 概要

本ドキュメントは、VBCorLibプロジェクトのタイプライブラリ（CorType.tlb）をビルドおよびシステム登録するバッチファイル「Build.bat」の設計仕様を記述する。

### 本バッチの処理概要

このバッチは、VBCorLibライブラリで使用されるCOM型定義ファイル（タイプライブラリ）を生成し、Windowsシステムに登録する処理を行う。

**業務上の目的・背景**：VBCorLibは.NET Frameworkの機能をVB6環境で利用可能にするライブラリである。COMコンポーネントとして動作するため、型情報を定義したタイプライブラリ（TLB）ファイルが必要となる。このバッチは、ODL（Object Description Language）ファイルからTLBファイルを生成し、開発者やエンドユーザーがライブラリを利用できるようにシステムへ登録する役割を担う。

**バッチの実行タイミング**：タイプライブラリ定義（CorType.odl）を変更した際に手動で実行する。新しい型定義の追加、既存の構造体・列挙型・インターフェースの変更時に必要となる。

**主要な処理内容**：
1. mktyplib コマンドでODLファイル（CorType.odl）からTLBファイル（CorType.tlb）を生成
2. 生成時のエラーチェックを実施し、エラー発生時は処理を停止
3. regtlib コマンドでTLBファイルをWindowsシステムに登録

**前後の処理との関連**：本バッチは、CorType.odlファイルの編集後に実行される。生成されたTLBファイルは、VBCorLib3.dllのビルドおよびインストール時に参照される。インストールスクリプト（InstallScript.iss）による配布の前提条件となる。

**影響範囲**：Windowsシステムのタイプライブラリ登録領域に影響する。登録されたタイプライブラリはVB6 IDEやその他のCOM対応開発環境から参照可能になる。

## バッチ種別

ビルド / システム登録

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（ODLファイル変更後） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| mktyplib | Microsoft Type Library Makerがシステムにインストールされていること |
| regtlib | タイプライブラリ登録ツールが利用可能であること |
| CorType.odl | TypeLibraryディレクトリにCorType.odlファイルが存在すること |
| 管理者権限 | システム登録のため管理者権限が必要 |

### 実行可否判定

- CorType.odlファイルが存在しない場合、mktyplib がエラーを返す
- 管理者権限がない場合、regtlib がエラーを返す可能性がある

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CorType.odl | ODL（Object Description Language） | タイプライブラリの定義ファイル。構造体、列挙型、インターフェース等を定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CorType.tlb | TLB（Type Library Binary） | コンパイルされたタイプライブラリファイル |
| Windowsレジストリ | レジストリエントリ | タイプライブラリのシステム登録情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CorType.tlb |
| 出力先 | TypeLibraryディレクトリ（カレントディレクトリ） |
| ファイル形式 | バイナリ（タイプライブラリ形式） |

## 処理フロー

### 処理シーケンス

```
1. echo off
   └─ コマンドエコーを無効化し、画面出力を抑制

2. mktyplib /nocpp /tlb CorType.tlb CorType.odl
   └─ ODLファイルをコンパイルしてTLBファイルを生成
      - /nocpp: Cプリプロセッサを使用しない
      - /tlb: 出力ファイル名を指定

3. エラーレベルチェック
   └─ errorlevel が 1 以上の場合はエラー処理へ

4. pause（エラー時のみ）
   └─ エラー発生時にユーザーに確認を求めて停止

5. regtlib CorType.tlb
   └─ 生成したTLBファイルをシステムに登録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[echo off]
    B --> C[mktyplib でTLB生成]
    C --> D{errorlevel チェック}
    D -->|エラーなし| E[regtlib でシステム登録]
    D -->|エラーあり| F[pause で停止]
    E --> G[バッチ終了]
    F --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| errorlevel >= 1 | mktyplib エラー | ODLファイルの構文エラー、ファイル不在など | ODLファイルの内容を確認し、構文エラーを修正 |
| - | regtlib エラー | 権限不足、TLBファイル不正など | 管理者権限で再実行、TLBファイルの再生成 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動リトライ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラー発生時はpauseにより処理が停止する
2. コンソール出力でエラー内容を確認
3. ODLファイルの構文エラーを修正後、再度バッチを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 該当なし（OSのデフォルト） |

## 排他制御

- TLBファイルが他のプロセスで使用中の場合、上書きに失敗する可能性がある
- VB6 IDEが起動中の場合、タイプライブラリの登録更新に影響する可能性がある

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | mktyplib、regtlib の実行結果（echo offのため最小限） |
| エラー出力 | エラー発生時 | コンパイルエラー詳細、登録エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- mktyplib は古いツールであり、Visual Studio 2005以降ではMIDLコンパイラに置き換えられているが、VB6環境との互換性のために使用されている
- CorType.odl には VBCorLib で使用される構造体（WIN32_FIND_DATA等）、列挙型（BOOL、STGC等）、インターフェースが定義されている
- タイプライブラリのバージョンは4.0（helpstringに「CorLib Type Library 4.0」と記載）
- UUIDは 1705040f-4494-4ab3-8a97-a9f84820636d
