# バッチ設計書 2-InstallScript.iss

## 概要

本ドキュメントは、VBCorLibプロジェクトのインストーラーを生成するInno Setupスクリプト「InstallScript.iss」の設計仕様を記述する。

### 本バッチの処理概要

このスクリプトは、VBCorLibライブラリのWindowsインストーラーを生成するための定義ファイルである。Inno Setup Compilerによりコンパイルされ、エンドユーザー向けの配布用インストーラー（VBCorLib-3.2.0.exe）を作成する。

**業務上の目的・背景**：VBCorLibは.NET Framework相当の機能をVB6環境で利用可能にする大規模なライブラリである。多数のファイル（DLL、サンプルプロジェクト、テンプレート、ドキュメント）を含むため、手動インストールは困難である。本スクリプトは、これらのファイルを適切な場所に配置し、COMコンポーネントの登録を自動化することで、エンドユーザーが簡単にライブラリを導入できるようにする。

**バッチの実行タイミング**：新バージョンのリリース時、またはインストーラー内容の変更時に手動で実行する。Inno Setup Compilerでスクリプトをコンパイルしてインストーラーを生成する。

**主要な処理内容**：
1. VBCorLib3.dllをシステムディレクトリ（%SYSTEM%）にコピーし、regserverで登録
2. Examplesディレクトリ配下のサンプルプロジェクトをインストール先にコピー
3. readme.txtとLICENSE.txtをインストール先にコピー
4. VB6クラステンプレートをVisual Basicのテンプレートディレクトリにコピー
5. スタートメニューにアンインストール用アイコンとExamplesフォルダへのショートカットを作成

**前後の処理との関連**：Build.batによりタイプライブラリが生成・登録された後、VBCorLib3.dllがビルドされ、その後に本スクリプトでインストーラーを作成する。配布前の最終工程として位置づけられる。

**影響範囲**：生成されたインストーラーは、ユーザーのシステムディレクトリ（System32）、Program Files、VB6テンプレートディレクトリ、スタートメニューに影響を与える。COMコンポーネントの登録はWindowsレジストリに影響する。

## バッチ種別

インストール / 配布パッケージ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（Inno Setup Compilerで実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Inno Setup | Inno Setup Compilerがインストールされていること |
| VBCorLib3.dll | Binaries/Compiled/VBCorLib3.dllが存在すること |
| Examplesディレクトリ | サンプルプロジェクトが存在すること |
| Templateディレクトリ | クラステンプレートが存在すること |
| readme.txt | Source/CorLib/readme.txtが存在すること |
| LICENSE.txt | Install/LICENSE.txtが存在すること |

### 実行可否判定

- 参照ファイルが存在しない場合、Inno Setup Compilerがエラーを返す
- Inno Setup Compilerがインストールされていない場合、スクリプトを実行できない

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | スクリプト自体がパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| VBCorLib3.dll | DLL | VBCorLibメインライブラリバイナリ |
| Examples/* | VBP/FRM/BAS等 | サンプルプロジェクトファイル群 |
| readme.txt | テキスト | バージョン履歴・変更履歴 |
| LICENSE.txt | テキスト | MITライセンス文書 |
| Template/Classes/* | CLS | VB6クラステンプレート（EnumeratorTemplate, ExceptionTemplate, IObjectTemplate） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| VBCorLib-3.2.0.exe | 実行ファイル | 生成されるインストーラー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | VBCorLib-3.2.0.exe |
| 出力先 | Installディレクトリ（OutputDir=.） |
| 圧縮形式 | LZMA（SolidCompression） |

## 処理フロー

### 処理シーケンス

```
1. インストーラー起動
   └─ ユーザーにウェルカム画面を表示

2. インストール先選択
   └─ デフォルト: {pf}\VBCorLib3（Program Files\VBCorLib3）

3. テンプレートディレクトリ選択（カスタムページ）
   └─ VB6のテンプレートディレクトリを自動検出
      - レジストリ HKCU\Software\Microsoft\Visual Basic\6.0\TemplatesDirectory を確認
      - 存在しない場合は HKLM\Software\WOW6432Node\Microsoft\VisualStudio\6.0\Setup から取得

4. コンポーネント選択
   └─ binaries: バイナリファイルとテンプレート
   └─ examples: サンプルプロジェクト

5. ファイルコピー・登録
   └─ VBCorLib3.dll → {sys} (regserver)
   └─ Examples/* → {app}\Examples
   └─ readme.txt → {app}（isreadme）
   └─ LICENSE.txt → {app}
   └─ Template/Classes/* → {VB6テンプレート}\Classes\

6. スタートメニュー作成
   └─ アンインストールショートカット
   └─ Examplesフォルダショートカット

7. インストール完了
   └─ readme.txtを表示（isreadme フラグ）
```

### フローチャート

```mermaid
flowchart TD
    A[Inno Setup Compiler実行] --> B[スクリプト解析]
    B --> C[ファイル存在チェック]
    C --> D{必要ファイル存在?}
    D -->|Yes| E[インストーラー生成]
    D -->|No| F[コンパイルエラー]
    E --> G[VBCorLib-3.2.0.exe出力]
    F --> H[終了]
    G --> I[インストーラー実行時]
    I --> J[インストール先選択]
    J --> K[テンプレートDir選択]
    K --> L[コンポーネント選択]
    L --> M[ファイルコピー・DLL登録]
    M --> N[ショートカット作成]
    N --> O[readme表示]
    O --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | 参照ファイルが存在しない | 必要ファイルを準備後、再コンパイル |
| - | 構文エラー | スクリプト構文が不正 | スクリプトを修正 |
| - | DLL登録失敗 | regserver登録時のエラー | 管理者権限で再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動リトライ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. コンパイルエラー時はInno Setup IDEでエラー内容を確認
2. 参照ファイルのパスを確認し、必要に応じて修正
3. インストール実行時のエラーはログファイルを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（Inno Setupのアンインストール機能で復元可能） |
| コミットタイミング | 該当なし |
| ロールバック条件 | インストール中断時はInno Setupがクリーンアップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1インストーラー |
| 目標処理時間 | コンパイル：数秒〜数十秒、インストール：数十秒 |
| メモリ使用量上限 | 該当なし（OSのデフォルト） |

## 排他制御

- 同一ファイルへの複数同時コンパイルは不可
- インストール実行時、対象DLLが使用中の場合は登録失敗の可能性あり
- VB6 IDEが起動中の場合、DLL登録に影響する可能性あり

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コンパイルログ | コンパイル中 | ファイル処理状況、エラー情報 |
| インストールログ | インストール中 | ファイルコピー状況、登録状況（/LOG オプション使用時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

### セットアップ情報

| 項目 | 値 |
|-----|-----|
| AppId | {CBB90C23-2F68-4770-8469-85F0B78FFF25} |
| AppName | VBCorLib 3.2.0 |
| AppPublisher | Kelly Ethridge |
| AppURL | https://github.com/kellyethridge/VBCorLib |
| DefaultDirName | {pf}\VBCorLib3 |
| DefaultGroupName | VBCorLib |
| 圧縮方式 | LZMA (SolidCompression) |
| 言語 | English |

### インストールコンポーネント

| コンポーネント | 説明 | フルインストール時 |
|--------------|------|-----------------|
| binaries | バイナリファイルとテンプレート | 含む |
| examples | サンプルプロジェクト | 含む |

### テンプレートディレクトリ検出ロジック

1. レジストリ `HKCU\Software\Microsoft\Visual Basic\6.0\TemplatesDirectory` を確認
2. 存在しない場合、`HKLM\Software\WOW6432Node\Microsoft\VisualStudio\6.0\Setup\Microsoft Visual Basic\ProductDir` から取得し、`\Templates\` を付加

### 含まれるクラステンプレート

- EnumeratorTemplate.cls（4,157バイト）
- ExceptionTemplate.cls（9,438バイト）
- IObjectTemplate.cls（2,362バイト）
