---
generated_at: 2026-01-20 15:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-Build.bat バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **管理者権限の必要性**：regtlibの動作要件は推測に基づく
  2. **処理時間「数秒以内」**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `TypeLibrary/Build.bat` - バッチファイル本体（6行）
- E-02: `TypeLibrary/CorType.odl` - ODL定義ファイル
- E-03: `TypeLibrary/CorType.tlb` - 生成済みTLBファイル（存在確認）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチはmktyplib コマンドでTLBを生成する | E-01（2行目） | ○ |
| C-02 | /nocppオプションでCプリプロセッサを使用しない | E-01（2行目） | ○ |
| C-03 | /tlbオプションで出力ファイル名を指定 | E-01（2行目） | ○ |
| C-04 | errorlevelでエラーチェックを行う | E-01（3行目） | ○ |
| C-05 | エラー時はpauseで停止する | E-01（4行目） | ○ |
| C-06 | regtlibでシステム登録を行う | E-01（6行目） | ○ |
| C-07 | 入力ファイルはCorType.odl | E-01, E-02 | ○ |
| C-08 | 出力ファイルはCorType.tlb | E-01, E-03 | ○ |
| C-09 | タイプライブラリのバージョンは4.0 | E-02（5行目: version(4.0)） | ○ |
| C-10 | UUIDは1705040f-4494-4ab3-8a97-a9f84820636d | E-02（3行目） | ○ |
| C-11 | helpstringは「VB.EXT: CorLib Type Library 4.0」 | E-02（2行目） | ○ |
| C-12 | ODLには構造体WIN32_FIND_DATAが定義されている | E-02（58行目以降） | ○ |
| C-13 | ODLには列挙型BOOL、STGCが定義されている | E-02（26-38行目） | ○ |
| C-14 | echo offでエコーを無効化 | E-01（1行目） | ○ |
| C-15 | 手動実行のバッチである | E-04（備考欄） | ○ |
| C-16 | TypeLibraryディレクトリに配置される | E-04（備考欄） | ○ |
| C-17 | 管理者権限がシステム登録に必要 | **根拠なし** | △ |
| C-18 | 処理時間は数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **管理者権限の必要性**：regtlibコマンドの動作要件に関する公式ドキュメントが参照されていない
  - 候補：Microsoft公式ドキュメント / Windows SDK仕様書 / 実行テスト結果
- **処理時間の推定**：実測データがない
  - 候補：実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バッチコードの構造・処理内容（ソースコードから直接確認可能）
- 0: 低リスク - ODLファイルの構成・内容（ファイルから直接確認可能）
- 1: 中リスク - 前提条件（mktyplib、regtlibの可用性）は環境依存
- 1: 中リスク - 管理者権限要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] Build.batの6行が設計書の処理フローと一致しているか確認
- [ ] CorType.odlのバージョン・UUID情報が正確か確認
- [ ] 管理者権限の必要性について環境で検証
- [ ] mktyplib、regtlibの可用性について開発環境で確認
