---
generated_at: 2026-01-20 15:50:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：2-InstallScript.iss バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **VBCorLib3.dllの存在場所**：Binaries/Compiledディレクトリが存在しない
  2. **処理時間の推定**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Install/InstallScript.iss` - インストールスクリプト本体（78行）
- E-02: `Install/LICENSE.txt` - MITライセンス文書
- E-03: `Source/CorLib/readme.txt` - バージョン履歴
- E-04: `Examples/` - サンプルプロジェクトディレクトリ（6サブディレクトリ確認）
- E-05: `Template/Classes/` - クラステンプレート（3ファイル確認）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AppIdは{CBB90C23-2F68-4770-8469-85F0B78FFF25} | E-01（8行目） | ○ |
| C-02 | AppNameはVBCorLib 3.2.0 | E-01（9行目） | ○ |
| C-03 | AppPublisherはKelly Ethridge | E-01（12行目） | ○ |
| C-04 | AppURLはhttps://github.com/kellyethridge/VBCorLib | E-01（13-15行目） | ○ |
| C-05 | DefaultDirNameは{pf}\VBCorLib3 | E-01（15行目） | ○ |
| C-06 | 圧縮方式はLZMA（SolidCompression） | E-01（20-21行目） | ○ |
| C-07 | 言語はEnglish | E-01（24行目） | ○ |
| C-08 | コンポーネントはbinariesとexamples | E-01（30-32行目） | ○ |
| C-09 | VBCorLib3.dllをregserverで登録 | E-01（35行目: Flags: regserver） | ○ |
| C-10 | VBCorLib3.dllは{sys}にコピー | E-01（35行目: DestDir: {sys}） | ○ |
| C-11 | Examplesは{app}\Examplesにコピー | E-01（36行目） | ○ |
| C-12 | readme.txtはisreadmeフラグ付き | E-01（37行目: Flags: isreadme） | ○ |
| C-13 | LICENSE.txtをコピー | E-01（38行目） | ○ |
| C-14 | テンプレートをVB6テンプレートディレクトリにコピー | E-01（39行目） | ○ |
| C-15 | アンインストールショートカットを作成 | E-01（42行目） | ○ |
| C-16 | Examplesショートカットを作成 | E-01（43行目） | ○ |
| C-17 | レジストリからテンプレートディレクトリを取得（HKCU） | E-01（53行目） | ○ |
| C-18 | フォールバックとしてHKLMからProductDirを取得 | E-01（57行目） | ○ |
| C-19 | 出力ファイル名はVBCorLib-3.2.0 | E-01（19行目: OutputBaseFilename） | ○ |
| C-20 | 出力先はカレントディレクトリ | E-01（18行目: OutputDir=.） | ○ |
| C-21 | MITライセンスで配布 | E-02（全文） | ○ |
| C-22 | 含まれるテンプレートは3ファイル | E-05（EnumeratorTemplate, ExceptionTemplate, IObjectTemplate確認） | ○ |
| C-23 | サンプルプロジェクトは複数カテゴリ存在 | E-04（Console Example, Cryptography, IO Examples等確認） | ○ |
| C-24 | VBCorLib3.dllはBinaries/Compiledに存在 | **根拠なし（ディレクトリ不在）** | △ |
| C-25 | コンパイル・インストール時間は数秒〜数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **VBCorLib3.dllの存在場所**：スクリプトでは `Binaries/Compiled/VBCorLib3.dll` を参照しているが、現在のリポジトリには当該ディレクトリが存在しない
  - 候補：ビルド手順書 / ビルド済みアーティファクト / CI/CDパイプライン設定
- **処理時間の推定**：実測データがない
  - 候補：実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプト構成・各セクションの内容（ソースコードから直接確認可能）
- 0: 低リスク - AppId、バージョン情報（スクリプトから直接確認可能）
- 0: 低リスク - テンプレートディレクトリ検出ロジック（Pascalコードから確認可能）
- 2: 高リスク - VBCorLib3.dllの参照パス（ディレクトリが存在しないため、ビルド手順の確認必要）

## 6) レビュアーチェックリスト（最小）
- [ ] InstallScript.issの78行が設計書の内容と一致しているか確認
- [ ] AppId、バージョン情報が最新であるか確認
- [ ] VBCorLib3.dllのビルド手順・配置先を確認
- [ ] テンプレートディレクトリ検出ロジック（GetTemplatesFolder関数）の動作を確認
- [ ] サンプルプロジェクトの.vbw, .pdb, .config除外設定が適切か確認
