---
generated_at: 2026-01-20 20:30:00
metrics:
  claims_total: 154
  claims_with_evidence: 154
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Cor.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：154 / 154、根拠なし：0
- 優先レビュー（高）
  1. **UT-COR-153, UT-COR-154**：StrongPtr関数はメモリ操作を伴う危険な操作のため、テスト実行時に注意が必要
  2. **UT-COR-013, UT-COR-036**：InvalidCastExceptionのスロー条件の網羅性確認
  3. **UT-COR-113**：ArgumentOutOfRangeエラーの発生条件の網羅性確認
  4. **UT-COR-147, UT-COR-148**：GetValidSAPtrの例外処理テスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Cor/Conversion.cls`
- E-02: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Cor/ConversionMethods.bas`
- E-03: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Cor/Interaction.bas`
- E-04: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Cor/Information.bas`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-COR-001〜003) | Conversion.CDateTime メソッドのテストケース | E-01 (行49-51) | ○ |
| C-02 (UT-COR-004〜016) | Conversion.CInt64 メソッドのテストケース（正常系・異常系・境界値） | E-01 (行61-63), E-02 (行44-61) | ○ |
| C-03 (UT-COR-017〜021) | Conversion.CBigInt メソッドのテストケース | E-01 (行89-91), E-02 (行63-78) | ○ |
| C-04 (UT-COR-022〜023) | Conversion.CUnk メソッドのテストケース | E-01 (行98-100), E-02 (行80-82) | ○ |
| C-05 (UT-COR-024〜025) | Conversion.CObj メソッドのテストケース | E-01 (行107-109) | ○ |
| C-06 (UT-COR-026〜027) | ConversionMethods.CLngOrDefault メソッドのテストケース | E-02 (行28-34) | ○ |
| C-07 (UT-COR-028〜029) | ConversionMethods.CVarOrDefault メソッドのテストケース | E-02 (行36-42) | ○ |
| C-08 (UT-COR-030〜036) | ConversionMethods.CInt64 メソッドのテストケース | E-02 (行44-61) | ○ |
| C-09 (UT-COR-037〜041) | ConversionMethods.CBigInt/CUnk メソッドのテストケース | E-02 (行63-82) | ○ |
| C-10 (UT-COR-042〜072) | ConversionMethods.Widenシリーズ メソッドのテストケース | E-02 (行89-211) | ○ |
| C-11 (UT-COR-073〜085) | ConversionMethods.Narrowシリーズ メソッドのテストケース | E-02 (行214-251) | ○ |
| C-12 (UT-COR-086〜088) | Interaction.IfObject メソッドのテストケース | E-03 (行27-33) | ○ |
| C-13 (UT-COR-089〜091) | Interaction.IfString メソッドのテストケース | E-03 (行35-41) | ○ |
| C-14 (UT-COR-092〜093) | Interaction.IIfLong メソッドのテストケース | E-03 (行43-49) | ○ |
| C-15 (UT-COR-094〜102) | Interaction.Swapシリーズ メソッドのテストケース（境界値含む） | E-03 (行51-73) | ○ |
| C-16 (UT-COR-103) | Information.FuncAddr メソッドのテストケース | E-04 (行36-38) | ○ |
| C-17 (UT-COR-104〜113) | Information.SizeOf メソッドのテストケース | E-04 (行40-63) | ○ |
| C-18 (UT-COR-114〜116) | Information.IsInt64 メソッドのテストケース | E-04 (行68-75) | ○ |
| C-19 (UT-COR-117〜118) | Information.IsInt64Array メソッドのテストケース | E-04 (行77-82) | ○ |
| C-20 (UT-COR-119) | Information.GetGuid メソッドのテストケース | E-04 (行84-89) | ○ |
| C-21 (UT-COR-120〜122) | Information.IsPicture メソッドのテストケース | E-04 (行91-99) | ○ |
| C-22 (UT-COR-123〜124) | Information.IsPictureResourceGroup メソッドのテストケース | E-04 (行101-109) | ○ |
| C-23 (UT-COR-125〜129) | Information.IsInteger メソッドのテストケース | E-04 (行111-116) | ○ |
| C-24 (UT-COR-130〜134) | Information.IsEnumerable メソッドのテストケース | E-04 (行118-130) | ○ |
| C-25 (UT-COR-135〜137) | Information.CorVarType メソッドのテストケース | E-04 (行136-138) | ○ |
| C-26 (UT-COR-138) | Information.DataPtr メソッドのテストケース | E-04 (行144-146) | ○ |
| C-27 (UT-COR-139〜140) | Information.GetRecordInfo メソッドのテストケース | E-04 (行151-159) | ○ |
| C-28 (UT-COR-141) | Information.ArrDataPtr メソッドのテストケース | E-04 (行164-166) | ○ |
| C-29 (UT-COR-142〜144) | Information.ElementPtr メソッドのテストケース | E-04 (行174-184) | ○ |
| C-30 (UT-COR-145) | Information.SAPtrV メソッドのテストケース | E-04 (行191-193) | ○ |
| C-31 (UT-COR-146〜148) | Information.GetValidSAPtr メソッドのテストケース | E-04 (行195-203) | ○ |
| C-32 (UT-COR-149〜151) | Information.Len1D メソッドのテストケース | E-04 (行208-210) | ○ |
| C-33 (UT-COR-152) | Information.WeakPtr メソッドのテストケース | E-04 (行213-215) | ○ |
| C-34 (UT-COR-153〜154) | Information.StrongPtr メソッドのテストケース | E-04 (行218-223) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 補足事項：
  - VB6固有の型（Currency、Decimal等）のテストには実行環境の準備が必要
  - メモリ操作関数（StrongPtr、WeakPtr、DataPtr、ElementPtr等）のテストは実行時の安全性に注意
  - Int64、BigInteger等のVBCorLib固有型のテストには依存ライブラリが必要

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケース - 型変換やユーティリティ関数のテスト（UT-COR-024〜072、UT-COR-077〜085、UT-COR-094〜099等）
- **1（中リスク）**:
  - UT-COR-074, UT-COR-076, UT-COR-081（オーバーフローテスト）- 実行時エラーの発生を確認するテスト
  - UT-COR-100〜102（SwapCurrency, SwapVariant）- 金額やオブジェクト参照の交換
- **2（高リスク）**:
  - UT-COR-153, UT-COR-154（StrongPtrテスト）- 無効なポインタ操作によるクラッシュの可能性
  - UT-COR-147, UT-COR-148（GetValidSAPtrテスト）- 配列バリデーションの例外テスト

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースがソースコードの該当メソッドと対応していることを確認
- [ ] 境界値テスト（Long最大値/最小値、Byte最大値/最小値、空配列等）が網羅されていることを確認
- [ ] 異常系テスト（不正な型、Null値、未初期化配列、Nothing等）が網羅されていることを確認
- [ ] VB6実行環境でのテスト実施可否を確認
- [ ] メモリ操作関数（StrongPtr, WeakPtr, DataPtr, ElementPtr, ArrDataPtr, SAPtrV）のテストにおける安全対策を確認
- [ ] Int64、BigInteger等のVBCorLib固有型のテストに必要な依存関係を確認
- [ ] Widen/Narrow系変換メソッドの全パターンがカバーされていることを確認
- [ ] Swap系メソッドの境界値テストが含まれていることを確認
