---
generated_at: 2026-01-20 21:00:00
metrics:
  claims_total: 84
  claims_with_evidence: 84
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Fakes.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードに該当するクラス・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：Fakesモジュール内の全クラス・全メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：84 / 84、根拠なし：0
- 優先レビュー（高）
  1. **FakeTransformのブロックサイズ検証**：EnforceBlockSizeMultipleの動作確認が重要
  2. **Int32の二重初期化防止**：Debug.Assertの挙動はデバッグモード依存
  3. **FakeSafeHandleのリソース解放**：mBaseイベントハンドラの動作確認

## 2) 参照した情報（Evidence一覧）
> Fakesモジュール内の全ソースファイルを解析

- E-01: `Source/Fakes/Count.cls` - カウンタークラス
- E-02: `Source/Fakes/Int32.cls` - 整数値ラッパークラス（IObject, IComparable実装）
- E-03: `Source/Fakes/Int32Formattable.cls` - フォーマット可能な整数値ラッパー
- E-04: `Source/Fakes/MockFormattable.cls` - IFormattableモック
- E-05: `Source/Fakes/MockObject.cls` - IObjectモック
- E-06: `Source/Fakes/FakeObject.cls` - IObjectのデフォルト実装委譲
- E-07: `Source/Fakes/FakeFormatProvider.cls` - IFormatProviderフェイク
- E-08: `Source/Fakes/FakeCustomFormatter.cls` - ICustomFormatterフェイク
- E-09: `Source/Fakes/FakeStream.cls` - Streamフェイク
- E-10: `Source/Fakes/FakeTransform.cls` - ICryptoTransformフェイク
- E-11: `Source/Fakes/CryptoStreamSpy.cls` - CryptoStreamスパイ
- E-12: `Source/Fakes/FakeAsyncCallback.cls` - AsyncCallbackフェイク
- E-13: `Source/Fakes/FakeSafeHandle.cls` - SafeHandleフェイク
- E-14: `Source/Fakes/NullEncoderFallback.cls` - EncoderFallbackスタブ
- E-15: `Source/Fakes/NullEncoderFallbackBuffer.cls` - EncoderFallbackBufferスタブ
- E-16: `Source/Fakes/FakePictureResourceInfo.cls` - PictureResourceInfoフェイク
- E-17: `Source/Fakes/FakeTypes.cls` - テスト用構造体定義
- E-18: `Source/Fakes/FakeStructures.cls` - テスト用構造体定義
- E-19: `Source/Fakes/TerminateEventCount.cls` - 終了イベントカウンター
- E-20: `Source/Fakes/Fakes.vbp` - プロジェクトファイル（クラス一覧）

## 3) Claims と根拠の対応（レビューの主戦場）

### Count クラス（UT-FAK-001〜004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IncrementメソッドでmValueが1増加する | E-01: 18-20行目 `mValue = mValue + 1` | ○ |
| C-02 | 複数回呼び出しで累積する | E-01: Incrementメソッドの実装 | ○ |
| C-03 | Valueプロパティで現在値取得可能 | E-01: 22-25行目 | ○ |
| C-04 | Long型の境界値テスト | E-01: mValue As Long宣言 | ○ |

### Int32 クラス（UT-FAK-005〜017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | Initで値が初期化される | E-02: 25-29行目 | ○ |
| C-06 | 二重初期化時にDebug.Assertが発火 | E-02: 26行目 `Debug.Assert Not mInited` | ○ |
| C-07 | Valueプロパティで値取得 | E-02: 21-23行目 | ○ |
| C-08 | IObject_Equalsで同値判定 | E-02: 31-38行目 | ○ |
| C-09 | IObject_Equalsで異値判定 | E-02: 35行目 `Me.Value = Other.Value` | ○ |
| C-10 | 非Int32オブジェクトでエラーハンドリング | E-02: 32行目 `On Error GoTo Catch` | ○ |
| C-11 | IObject_GetHashCodeで値を返却 | E-02: 40-42行目 | ○ |
| C-12 | IObject_ToStringで文字列変換 | E-02: 44-46行目 | ○ |
| C-13 | IComparable_CompareToで小さい値比較 | E-02: 64-65行目 | ○ |
| C-14 | IComparable_CompareToで大きい値比較 | E-02: 66-67行目 | ○ |
| C-15 | IComparable_CompareToで同値比較 | E-02: 64-68行目（else節で0） | ○ |
| C-16 | Nothing比較で1を返却 | E-02: 53-55行目 | ○ |
| C-17 | Long値との比較 | E-02: 60-61行目 `OtherValue = Value` | ○ |

### Int32Formattable クラス（UT-FAK-018〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | IComparable_CompareToでオブジェクト比較 | E-03: 26-38行目 | ○ |
| C-19 | IComparable_CompareToでLong値比較 | E-03: 33行目 | ○ |
| C-20 | IFormattable_ToStringでフォーマット適用 | E-03: 40-42行目 `VBA.Format$` | ○ |
| C-21 | 空フォーマットでエラーなし | E-03: Val(Format)が0を返す | ○ |

### MockFormattable クラス（UT-FAK-022〜023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | Resultが返却される | E-04: 24行目 | ○ |
| C-23 | Format/Providerが記録される | E-04: 22-23行目 | ○ |

### MockObject クラス（UT-FAK-024〜027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Equalsで値が記録される | E-05: 24-32行目 | ○ |
| C-25 | 非オブジェクト値も記録 | E-05: 28行目 `Me.Equals = Value` | ○ |
| C-26 | GetHashCodeResultが返却される | E-05: 35-38行目 | ○ |
| C-27 | ToStringResultが返却される | E-05: 40-42行目 | ○ |

### FakeObject クラス（UT-FAK-028〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | MyBase.Equalsに委譲 | E-06: 17-19行目 | ○ |
| C-29 | MyBase.GetHashCodeに委譲 | E-06: 21-23行目 | ○ |
| C-30 | MyBase.ToStringに委譲 | E-06: 25-27行目 | ○ |

### FakeFormatProvider クラス（UT-FAK-031〜032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | GetFormatResultが返却される | E-07: 21-24行目 | ○ |
| C-32 | FormatTypeが記録される | E-07: 22行目 | ○ |

### FakeCustomFormatter クラス（UT-FAK-033〜037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | FormatResultが返却され引数記録 | E-08: 26-34行目 | ○ |
| C-34 | ReturnNull=Trueで空文字列 | E-08: 30-31行目 | ○ |
| C-35 | ICustomFormatterで自身を返却 | E-08: 39-40行目 | ○ |
| C-36 | Disable=Trueでnothing | E-08: 39行目 `Not Me.Disable` | ○ |
| C-37 | 別FormatTypeでNothing | E-08: 39行目 `LCase$(FormatType) = "icustomformatter"` | ○ |

### FakeStream クラス（UT-FAK-038〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | 初期状態で全CanプロパティがTrue | E-09: 24-28行目 Class_Initialize | ○ |
| C-39 | CanReadプロパティ反映 | E-09: 38-40行目 | ○ |
| C-40 | CanWriteプロパティ反映 | E-09: 50-52行目 | ○ |
| C-41 | CanSeekプロパティ反映 | E-09: 42-44行目 | ○ |
| C-42 | CloseStreamでIsClosed=True | E-09: 54-56行目 | ○ |
| C-43 | FlushでFlushCalled=True | E-09: 74-76行目 | ○ |

### FakeTransform クラス（UT-FAK-044〜052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | 初期状態でEnabled=True、BlockSize=8 | E-10: 35-39行目 Class_Initialize | ○ |
| C-45 | Initでパラメータ設定 | E-10: 27-33行目 | ○ |
| C-46 | TransformBlockでデータコピー | E-10: 57-70行目 | ○ |
| C-47 | Enabled=Falseでコピーなし | E-10: 66行目 `If Enabled And InputCount > 0` | ○ |
| C-48 | EnforceBlockSizeMultipleでエラー | E-10: 60-64行目 | ○ |
| C-49 | InputCount=0で何も処理しない | E-10: 66行目の条件 | ○ |
| C-50 | TransformFinalBlockで変換 | E-10: 72-83行目 | ○ |
| C-51 | Enabled=Falseで空配列 | E-10: 80-81行目 | ○ |
| C-52 | InputCount=0で空配列 | E-10: 75行目の条件 | ○ |

### CryptoStreamSpy クラス（UT-FAK-053〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | CanReadでReadModeチェック | E-11: 30-32行目 | ○ |
| C-54 | CanReadでWriteModeはFalse | E-11: 31行目 `Mode = ReadMode` | ○ |
| C-55 | CanWriteでWriteModeチェック | E-11: 42-44行目 | ○ |
| C-56 | CanWriteでReadModeはFalse | E-11: 43行目 `Mode = WriteMode` | ○ |
| C-57 | FlushFinalBlockでカウント増加 | E-11: 70-72行目 | ○ |
| C-58 | Streamインターフェース経由CanRead | E-11: 142-144行目 | ○ |
| C-59 | Streamインターフェース経由CanWrite | E-11: 154-156行目 | ○ |

### FakeAsyncCallback クラス（UT-FAK-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Executeで状態記録 | E-12: 20-23行目 | ○ |

### FakeSafeHandle クラス（UT-FAK-061〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | Initでハンドル初期化 | E-13: 23-25行目 | ○ |
| C-62 | DangerousGetHandleで値取得 | E-13: 31-33行目 | ○ |
| C-63 | IsClosed初期状態 | E-13: 35-37行目 | ○ |
| C-64 | CloseHandle後のIsClosed | E-13: 27-29行目 | ○ |
| C-65 | CloseHandleでイベント発火 | E-13: 47-49行目 mBase_ReleaseHandle | ○ |
| C-66 | Class_TerminateでCloseHandle | E-13: 43-45行目 | ○ |
| C-67 | IsInvalidの動作 | E-13: 39-41行目 | ○ |

### NullEncoderFallback/Buffer クラス（UT-FAK-068〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | CreateFallbackBufferでインスタンス返却 | E-14: 20-22行目 | ○ |
| C-69 | FallbackでFalse返却（スタブ） | E-15: 24-26行目（空実装） | ○ |
| C-70 | GetNextCharで0返却 | E-15: 32-34行目（空実装） | ○ |
| C-71 | MovePreviousでFalse返却 | E-15: 36-38行目（空実装） | ○ |
| C-72 | Remainingで0返却 | E-15: 40-42行目（空実装） | ○ |

### FakePictureResourceInfo クラス（UT-FAK-073〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | BitCount取得 | E-16: 26-28行目 | ○ |
| C-74 | Colors取得 | E-16: 30-32行目 | ○ |
| C-75 | Height取得 | E-16: 42-44行目 | ○ |
| C-76 | Width取得 | E-16: 66-68行目 | ○ |
| C-77 | Planes取得 | E-16: 46-48行目 | ○ |
| C-78 | ResourceId取得 | E-16: 50-52行目 | ○ |
| C-79 | ResourceType取得 | E-16: 54-56行目 | ○ |
| C-80 | Size取得 | E-16: 58-60行目 | ○ |

### FakeTypes クラス（UT-FAK-081〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | NewLargeUdtで構造体生成 | E-17: 23-27行目 | ○ |
| C-82 | オプション引数省略可能 | E-17: 23行目 Optional引数 | ○ |

### TerminateEventCount クラス（UT-FAK-083〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Class_Terminateでカウント増加 | E-19: 18-20行目 | ○ |
| C-84 | Countプロパティで確認可能 | E-19: 16行目 Public Count As New Count | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- FakeStructuresクラスは構造体定義のみで、テスト対象メソッドがないためテストケース対象外としました

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて作成されています
- 注意点：
  - Debug.Assertはデバッグモードでのみ動作するため、リリースビルドでは二重初期化チェックが無効になります（UT-FAK-006）
  - NullEncoderFallback/Bufferは未実装メソッドが多く、実際のテストでは期待動作の確認が限定的です

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスのテスト優先度（高/中/低）が適切か確認
- [ ] FakeTransformのEnforceBlockSizeMultiple動作のテスト観点が十分か確認
- [ ] FakeSafeHandleのリソース解放タイミングが正しくテストされているか確認
- [ ] スタブ実装（NullEncoderFallback系）のテストケースが必要最小限か確認
- [ ] Int32の境界値テスト（Long.MinValue、Long.MaxValue）の追加を検討
