---
generated_at: 2026-01-20 20:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：Microsoft.Win32.SafeHandles 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-SFH-022, 037, 049**：Windows API呼び出しの実際の動作確認が必要
  2. **UT-SFH-027, 028, 053, 054**：IObject実装の詳細な戻り値確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` - SafeHandle基底クラスの実装
- E-02: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeFileHandle.cls` - SafeFileHandleクラスの実装
- E-03: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeFindHandle.cls` - SafeFindHandleクラスの実装
- E-04: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeMemoryMappedFileHandle.cls` - SafeMemoryMappedFileHandleクラスの実装
- E-05: `Source/Tests/Microsoft.Win32/SafeHandleTests.cls` - 既存の単体テスト
- E-06: `Source/Fakes/FakeSafeHandle.cls` - テスト用フェイクオブジェクト

## 3) Claims と根拠の対応（レビューの主戦場）

### SafeHandle クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DangerousGetHandle - 有効なハンドル値が返却される | E-01 (L59-62), E-05 (L29) | ○ |
| C-02 | DangerousGetHandle - 0のハンドル値が返却される | E-01 (L59-62) | ○ |
| C-03 | DangerousGetHandle - INVALID_HANDLE値が返却される | E-01 (L59-62) | ○ |
| C-04 | IsClosed - 初期状態でFalse | E-01 (L67-69), E-05 (L30) | ○ |
| C-05 | IsClosed - CloseHandle後にTrue | E-05 (L49) | ○ |
| C-06 | IsInvalid - 有効なハンドルでFalse | E-01 (L77-79), E-05 (L31) | ○ |
| C-07 | IsInvalid - INVALID_HANDLEでTrue | E-01 (L78) | ○ |
| C-08 | IsInvalid - ZeroIsInvalid=TrueかつHandle=0でTrue | E-01 (L78), E-05 (L37-39) | ○ |
| C-09 | IsInvalid - ZeroIsInvalid=FalseかつHandle=0でFalse | E-01 (L78) | ○ |
| C-10 | CloseHandle - ReleaseHandleイベントが発生する | E-01 (L88-94), E-05 (L42-50) | ○ |
| C-11 | CloseHandle - OwnsHandle=Falseの場合イベント発生しない | E-01 (L89), E-05 (L52-60) | ○ |
| C-12 | CloseHandle - 二重クローズ時に1回のみ発生 | E-01 (L89) | ○ |
| C-13 | CloseHandle - クローズ後にINVALID_HANDLEになる | E-01 (L91) | ○ |
| C-14 | Init - 初期化パラメータが正しく設定される | E-01 (L100-104) | ○ |
| C-15 | Init - ZeroIsInvalidパラメータが正しく設定される | E-01 (L103) | ○ |
| C-16 | Class_Terminate - ReleaseHandleが呼ばれる | E-05 (L62-72), E-06 (L43-45) | ○ |

### SafeFileHandle クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | DangerousGetHandle - 有効なファイルハンドル値が返却される | E-02 (L61-64) | ○ |
| C-18 | IsClosed - 初期状態でFalse | E-02 (L74-76) | ○ |
| C-19 | IsClosed - CloseHandle後にTrue | E-02 (L66-68) | ○ |
| C-20 | IsInvalid - 有効なハンドルでFalse | E-02 (L53-55) | ○ |
| C-21 | IsInvalid - INVALID_HANDLEでTrue | E-02 (L53-55) | ○ |
| C-22 | CloseHandle - CorType.CloseHandleが呼び出される | E-02 (L122-124) | ○ |
| C-23 | CloseHandle - OwnsHandle=Falseの場合解放されない | E-02 (L110-112) | ○ |
| C-24 | Init - 初期化パラメータが正しく設定される | E-02 (L110-112) | ○ |
| C-25 | Equals - 同一インスタンスでTrue | E-02 (L84-86) | ○ |
| C-26 | Equals - 異なるインスタンスでFalse | E-02 (L84-86) | ○ |
| C-27 | GetHashCode - ハッシュコードが返却される | E-02 (L93-95) | ○ |
| C-28 | ToString - 文字列表現が返却される | E-02 (L102-104) | ○ |
| C-29 | Class_Terminate - CloseHandleが呼ばれる | E-02 (L114-116) | ○ |
| C-30 | SafeHandle_DangerousGetHandle - インターフェース経由で取得可能 | E-02 (L130-132) | ○ |
| C-31 | SafeHandle_CloseHandle - インターフェース経由でクローズ可能 | E-02 (L126-128) | ○ |

### SafeFindHandle クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | DangerousGetHandle - 有効な検索ハンドル値が返却される | E-03 (L49-52) | ○ |
| C-33 | IsClosed - 初期状態でFalse | E-03 (L58-60) | ○ |
| C-34 | IsClosed - CloseHandle後にTrue | E-03 (L54-56) | ○ |
| C-35 | IsInvalid - 有効なハンドルでFalse | E-03 (L45-47) | ○ |
| C-36 | IsInvalid - INVALID_HANDLEでTrue | E-03 (L45-47) | ○ |
| C-37 | CloseHandle - FindCloseが呼び出される | E-03 (L78-80) | ○ |
| C-38 | CloseHandle - OwnsHandle=Falseの場合解放されない | E-03 (L66-68) | ○ |
| C-39 | Init - 初期化パラメータが正しく設定される | E-03 (L66-68) | ○ |
| C-40 | Class_Terminate - CloseHandleが呼ばれる | E-03 (L70-72) | ○ |
| C-41 | SafeHandle_DangerousGetHandle - インターフェース経由で取得可能 | E-03 (L86-88) | ○ |
| C-42 | SafeHandle_CloseHandle - インターフェース経由でクローズ可能 | E-03 (L82-84) | ○ |

### SafeMemoryMappedFileHandle クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | DangerousGetHandle - 有効なハンドル値が返却される | E-04 (L61-63) | ○ |
| C-44 | IsClosed - 初期状態でFalse | E-04 (L75-77) | ○ |
| C-45 | IsClosed - CloseHandle後にTrue | E-04 (L67-69) | ○ |
| C-46 | IsInvalid - 有効なハンドルでFalse | E-04 (L53-55) | ○ |
| C-47 | IsInvalid - Handle=0でTrue（ZeroIsInvalid=True固定） | E-04 (L115) | ○ |
| C-48 | IsInvalid - INVALID_HANDLEでTrue | E-04 (L53-55) | ○ |
| C-49 | CloseHandle - CorType.CloseHandleが呼び出される | E-04 (L142-144) | ○ |
| C-50 | Init - 初期化パラメータが正しく設定される | E-04 (L114-116) | ○ |
| C-51 | Equals - 同一インスタンスでTrue | E-04 (L86-88) | ○ |
| C-52 | Equals - 異なるインスタンスでFalse | E-04 (L86-88) | ○ |
| C-53 | GetHashCode - ハッシュコードが返却される | E-04 (L96-98) | ○ |
| C-54 | ToString - 文字列表現が返却される | E-04 (L106-108) | ○ |
| C-55 | Class_Terminate - CloseHandleが呼ばれる | E-04 (L118-120) | ○ |
| C-56 | SafeHandle_DangerousGetHandle - インターフェース経由で取得可能 | E-04 (L150-152) | ○ |
| C-57 | SafeHandle_CloseHandle - インターフェース経由でクローズ可能 | E-04 (L146-148) | ○ |

### 追加テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | CloseHandle - 既にクローズ済みでもエラーにならない | E-01 (L89) | ○ |
| C-59 | SafeFileHandle.IsInvalid - Handle=0でFalse | **根拠なし** | △ |
| C-60 | SafeFindHandle.IsInvalid - Handle=0でFalse | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SafeFileHandleおよびSafeFindHandleのHandle=0時の動作について、明示的なテストコードがない
  - 候補：SafeHandleTests.clsにテスト追加 / 実機テストで確認 / コードレビューで確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどのテストケースはソースコードから直接導出
- 1: 中リスク - Windows API（CloseHandle, FindClose）の実際の動作は実機テストが必要
- 0: 低リスク - IObject実装は標準的なパターンに従っている

## 6) レビュアーチェックリスト（最小）
- [ ] SafeHandleの基底クラスとしての動作が正しくテストされているか確認
- [ ] ZeroIsInvalidフラグの挙動が各派生クラスで適切にテストされているか確認
- [ ] ReleaseHandleイベントの発生タイミングと回数が正しいか確認
- [ ] Windows API呼び出し（CloseHandle, FindClose）のモック方法を検討
- [ ] Class_Terminateによる自動リソース解放のテスト方法を確認
- [ ] SafeHandle_* インターフェース実装のテストが網羅的か確認
