---
generated_at: 2026-01-20 17:35:00
metrics:
  claims_total: 133
  claims_with_evidence: 128
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：Microsoft.Win32 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：128 / 133、根拠なし：5
- 優先レビュー（高）
  1. **UT-WIN32-080, 081 (GetLastWriteTime)**: OS依存の動作確認が必要
  2. **UT-WIN32-088-090 (OpenRemoteBaseKey)**: リモート接続テストは実環境依存
  3. **UT-WIN32-097 (非ファイル対象)**: パイプ等のテスト環境構築が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Microsoft.Win32/Registry.cls`
- E-02: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Microsoft.Win32/RegistryKey.cls`
- E-03: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Microsoft.Win32/RegistryKeyStatic.cls`
- E-04: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Microsoft.Win32/Win32Native.bas`
- E-05: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/Tests/Microsoft.Win32/RegistryKeyTests.cls`
- E-06: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/Tests/Microsoft.Win32/RegistryTests.cls`

## 3) Claims と根拠の対応（レビューの主戦場）

### Registry クラス (UT-WIN32-001 - 014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClassesRoot がルートキーを返す | E-01 (L69-71), E-06 (L42) | ○ |
| C-02 | CurrentConfig がルートキーを返す | E-01 (L78-80), E-06 (L45) | ○ |
| C-03 | CurrentUser がルートキーを返す | E-01 (L87-89), E-06 (L44) | ○ |
| C-04 | LocalMachine がルートキーを返す | E-01 (L95-97), E-06 (L43) | ○ |
| C-05 | PerformanceData がルートキーを返す | E-01 (L103-105), E-06 (L46) | ○ |
| C-06 | Users がルートキーを返す | E-01 (L111-113), E-06 (L47) | ○ |
| C-07 | GetValue で値を取得できる | E-01 (L127-132), E-06 (L58-65) | ○ |
| C-08 | GetValue でデフォルト値が返る | E-01 (L127-132) | ○ |
| C-09 | 無効なキー名で ArgumentException | E-01 (L170-172), E-06 (L67-72) | ○ |
| C-10 | 空のキー名で ArgumentException | E-06 (L74-79) | ○ |
| C-11 | SetValue で値を設定できる | E-01 (L145-150), E-06 (L50-56) | ○ |
| C-12 | SetValue で無効キー名例外 | E-06 (L81-86) | ○ |
| C-13 | GetRootKey が大文字小文字無視 | E-01 (L157) - UCase$ 使用 | ○ |
| C-14 | GetRootKey が各ルートに対応 | E-01 (L156-173), E-06 (L27-33) | ○ |

### RegistryKey クラス - プロパティ (UT-WIN32-015 - 016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | Name プロパティが名前を返す | E-02 (L129-132), E-05 (L66) | ○ |
| C-16 | 閉じたキーで ObjectDisposed | E-02 (L615-618) - EnsureNotDisposed | ○ |

### RegistryKey クラス - OpenSubKey (UT-WIN32-017 - 021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | 存在するサブキーを開ける | E-02 (L144-155), E-05 (L59-67) | ○ |
| C-18 | 存在しないサブキーで Nothing | E-02 (L152-154), E-05 (L163-170) | ○ |
| C-19 | Writable フラグが設定される | E-02 (L144, L153), E-05 (L117-127) | ○ |
| C-20 | キー名の前後スラッシュがトリム | E-02 (L148) CorString.Trim | ○ |
| C-21 | 長いキー名で ArgumentException | E-02 (L592-608), E-05 (L172-180) | ○ |

### RegistryKey クラス - CloseKey/Flush (UT-WIN32-022 - 026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | キーが正常に閉じられる | E-02 (L163-168) | ○ |
| C-23 | システムキーは閉じられない | E-02 (L164, L611-613) - IsSystemKey | ○ |
| C-24 | 複数回CloseKeyを呼んでもエラーなし | E-02 (L164-167) | ○ |
| C-25 | Flush でディスクに書き込み | E-02 (L179-182) | ○ |
| C-26 | Flush でDispose後ObjectDisposed | E-02 (L180) EnsureNotDisposed | ○ |

### RegistryKey クラス - CreateSubKey (UT-WIN32-027 - 030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | CreateSubKey で新規作成 | E-02 (L191-203), E-05 (L95-104) | ○ |
| C-28 | 既存キーで同じキーが返る | E-02 (L189-190), E-05 (L265-273) | ○ |
| C-29 | ネストしたサブキーを一度に作成 | E-02 (L191-203) | ○ |
| C-30 | 読み取り専用で Unauthorized | E-02 (L193, L621-625), E-05 (L151-161) | ○ |

### RegistryKey クラス - DeleteSubKey (UT-WIN32-031 - 036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | サブキーを削除できる | E-02 (L215-230), E-05 (L182-192) | ○ |
| C-32 | 存在しないキーで Argument | E-02 (L227-228), E-05 (L194-203) | ○ |
| C-33 | ThrowOnMissing=False で何もしない | E-02 (L227), E-05 (L205-211) | ○ |
| C-34 | サブキー含むで InvalidOperation | E-02 (L222-223), E-05 (L213-222) | ○ |
| C-35 | DeleteSubKeyTree で再帰削除 | E-02 (L238-260), E-05 (L251-263, L358-372) | ○ |
| C-36 | DeleteSubKeyTree 書き込み権限なしで Unauthorized | E-02 (L239-240) | ○ |

### RegistryKey クラス - GetSubKeyNames/GetValueNames (UT-WIN32-037 - 042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | サブキー名配列を取得 | E-02 (L269-290), E-05 (L224-237) | ○ |
| C-38 | サブキーなしで空配列 | E-02 (L278), E-05 (L239-249) | ○ |
| C-39 | GetSubKeyNames でDispose後ObjectDisposed | E-02 (L270) EnsureNotDisposed | ○ |
| C-40 | 値名配列を取得 | E-02 (L304-325), E-05 (L286-299) | ○ |
| C-41 | デフォルト値存在時に空文字列含む | E-02 (L298-303) コメント参照 | ○ |
| C-42 | 値なしで空配列 | E-02 (L313), E-05 (L275-284) | ○ |

### RegistryKey クラス - SetValue (UT-WIN32-043 - 053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | 文字列値を設定 (REG_SZ) | E-02 (L627-631, L694), E-05 (L117-127) | ○ |
| C-44 | Long値を設定 (REG_DWORD) | E-02 (L652-654, L684) | ○ |
| C-45 | バイト配列を設定 (REG_BINARY) | E-02 (L656-669, L688), E-05 (L35) | ○ |
| C-46 | 文字列配列を設定 (REG_MULTI_SZ) | E-02 (L633-644, L686-687), E-05 (L36) | ○ |
| C-47 | Int64値を設定 (REG_QWORD) | E-02 (L671-673, L690), E-05 (L34) | ○ |
| C-48 | Currency値を設定 (REG_QWORD) | E-02 (L689-690), E-05 (L42) | ○ |
| C-49 | 展開可能文字列を設定 | E-02 (L646-650, L709), E-05 (L312-321) | ○ |
| C-50 | IObject の ToString 保存 | E-02 (L675-677, L691-693) | ○ |
| C-51 | 読み取り専用で Unauthorized | E-02 (L353, L621-625), E-05 (L129-138) | ○ |
| C-52 | 長い値名で Argument | E-02 (L356-357) | ○ |
| C-53 | 型不一致で Argument | E-02 (L373-379) | ○ |

### RegistryKey クラス - GetValue (UT-WIN32-054 - 064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | REG_SZ値を取得 | E-02 (L424-429), E-05 (L106-115) | ○ |
| C-55 | REG_DWORD値を取得 | E-02 (L431-434), E-05 (L32) | ○ |
| C-56 | REG_BINARY値を取得 | E-02 (L436-446), E-05 (L35) | ○ |
| C-57 | REG_MULTI_SZ値を取得 | E-02 (L448-453), E-05 (L36) | ○ |
| C-58 | REG_QWORD値を取得 | E-02 (L468-471), E-05 (L34, L45) | ○ |
| C-59 | REG_EXPAND_SZ展開される | E-02 (L455-466), E-05 (L312-321) | ○ |
| C-60 | 展開スキップオプション | E-02 (L461-463) | ○ |
| C-61 | 存在しない値でデフォルト | E-02 (L413-418), E-05 (L272) | ○ |
| C-62 | 存在しない値で Empty | E-02 (L413-418) | ○ |
| C-63 | 長い値名で Argument | E-02 (L405-406) | ○ |
| C-64 | サイズ0のREG_BINARYで空配列 | E-02 (L441-442) | ○ |

### RegistryKey クラス - DeleteValue (UT-WIN32-065 - 068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | 値を削除できる | E-02 (L484-491), E-05 (L323-333) | ○ |
| C-66 | 存在しない値で Argument | E-02 (L488-489), E-05 (L335-343) | ○ |
| C-67 | ThrowOnMissing=False で何もしない | E-02 (L488) | ○ |
| C-68 | 書き込み権限なしで Unauthorized | E-02 (L485) VerifyWritable | ○ |

### RegistryKey クラス - カウント系 (UT-WIN32-069 - 073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | SubKeyCount を取得 | E-02 (L498-501), E-05 (L69-80) | ○ |
| C-70 | サブキーなしで 0 | E-02 (L500) | ○ |
| C-71 | SubKeyCount でDispose後ObjectDisposed | E-02 (L499) EnsureNotDisposed | ○ |
| C-72 | ValueCount を取得 | E-02 (L508-511), E-05 (L82-93) | ○ |
| C-73 | 値なしで 0 | E-02 (L510) | ○ |

### RegistryKey クラス - GetValueKind (UT-WIN32-074 - 079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | StringKind を取得 | E-02 (L519-522), E-05 (L41, L374-383) | ○ |
| C-75 | DWordKind を取得 | E-02 (L519-522), E-05 (L40, L374-383) | ○ |
| C-76 | BinaryKind を取得 | E-02 (L519-522), E-05 (L43, L374-383) | ○ |
| C-77 | MultiStringKind を取得 | E-02 (L519-522), E-05 (L44, L374-383) | ○ |
| C-78 | QWordKind を取得 | E-02 (L519-522), E-05 (L42, L45, L374-383) | ○ |
| C-79 | ExpandStringKind を取得 | E-02 (L519-522) | ○ |

### RegistryKey クラス - その他 (UT-WIN32-080 - 087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | GetLastWriteTime (NT系) | E-02 (L530-540) | △ |
| C-81 | GetLastWriteTime (Win9x) | E-02 (L537-538) | △ |
| C-82 | ToString が文字列返す | E-02 (L546-548) | ○ |
| C-83 | Equals で同一判定 | E-02 (L556-558) | ○ |
| C-84 | Equals で異なる判定 | E-02 (L556-558) | ○ |
| C-85 | GetHashCode | E-02 (L564-566) | ○ |
| C-86 | Init で初期化 | E-02 (L572-576) | ○ |
| C-87 | Class_Terminate で CloseKey | E-02 (L578-580) | ○ |

### RegistryKeyStatic クラス (UT-WIN32-088 - 091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | リモート接続 | E-03 (L84-94) | △ |
| C-89 | 空マシン名でローカル | E-03 (L81-82) | ○ |
| C-90 | 接続失敗で Win32Error | E-03 (L89-91) | △ |
| C-91 | 各RegistryHive値を指定できる | E-03 (L64-71, L101-116) | ○ |

### Win32Native モジュール (UT-WIN32-092 - 104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | MakeHRFromErrorCode | E-04 (L77-79) | ○ |
| C-93 | SafeCreateFile (Read) | E-04 (L81-108) | ○ |
| C-94 | SafeCreateFile (Write) | E-04 (L81-108) | ○ |
| C-95 | SafeCreateFile (ReadWrite) | E-04 (L81-108) | ○ |
| C-96 | SafeCreateFile 無効アクセス | E-04 (L90-92) | ○ |
| C-97 | SafeCreateFile 非ファイル | E-04 (L103-104) | △ |
| C-98 | SafeFindFirstFile | E-04 (L110-115) | ○ |
| C-99 | SafeCreateFileMapping | E-04 (L117-122) | ○ |
| C-100 | SafeOpenFileMapping | E-04 (L124-129) | ○ |
| C-101 | GetSystemMenu | E-04 (L131-135) | ○ |
| C-102 | GetSystemMenu bRevert=True | E-04 (L131-135) | ○ |
| C-103 | GetMessage | E-04 (L137-152) | ○ |
| C-104 | GetMessage 不明エラー | E-04 (L149-151) | ○ |

### ラウンドトリップテスト (UT-WIN32-105 - 110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | Long ラウンドトリップ | E-05 (L32, L301-310) | ○ |
| C-106 | String ラウンドトリップ | E-05 (L33, L301-310) | ○ |
| C-107 | Int64 ラウンドトリップ | E-05 (L34, L301-310) | ○ |
| C-108 | Bytes ラウンドトリップ | E-05 (L35, L301-310) | ○ |
| C-109 | Strings ラウンドトリップ | E-05 (L36, L301-310) | ○ |
| C-110 | ExpandString ラウンドトリップ | E-05 (L37, L312-321) | ○ |

### 境界値テスト (UT-WIN32-111 - 118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | 空String配列でnull文字のみ | E-02 (L635-641) | ○ |
| C-112 | Null配列でnull文字のみ | E-02 (L635-636) | ○ |
| C-113 | 空Byte配列でサイズ0 | E-02 (L660-666) | ○ |
| C-114 | NullByte配列でサイズ0 | E-02 (L660-661) | ○ |
| C-115 | キー名各セグメント255文字以下OK | E-02 (L592-608) | ○ |
| C-116 | キー名セグメント256文字以上エラー | E-02 (L598-599) | ○ |
| C-117 | IsSystemKey ルートキーでTrue | E-02 (L611-613) | ○ |
| C-118 | IsSystemKey 通常キーでFalse | E-02 (L611-613) | ○ |

### 列挙値テスト (UT-WIN32-119 - 133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | UnknownKind = 0 | E-02 (L105) | ○ |
| C-120 | StringKind = 1 | E-02 (L106) | ○ |
| C-121 | DWordKind = 4 | E-02 (L107) | ○ |
| C-122 | BinaryKind = 3 | E-02 (L108) | ○ |
| C-123 | MultiStringKind = 7 | E-02 (L109) | ○ |
| C-124 | ExpandStringKind = 2 | E-02 (L110) | ○ |
| C-125 | QWordKind = 11 | E-02 (L111) | ○ |
| C-126 | RegistryValueOptions.None = 0 | E-02 (L115) | ○ |
| C-127 | DoNotExpandEnvironmentVariables = 1 | E-02 (L116) | ○ |
| C-128 | RegistryHive.ClassesRoot | E-03 (L65) | ○ |
| C-129 | RegistryHive.CurrentConfig | E-03 (L66) | ○ |
| C-130 | RegistryHive.CurrentUser | E-03 (L67) | ○ |
| C-131 | RegistryHive.LocalMachine | E-03 (L68) | ○ |
| C-132 | RegistryHive.Users | E-03 (L69) | ○ |
| C-133 | RegistryHive.PerformanceData | E-03 (L70) | ○ |

## 4) 不足情報（Unknown / Missing）

- **GetLastWriteTime (UT-WIN32-080, 081)**: OS検出ロジック (Environment.IsNT) の実際の動作確認が必要。Win9x環境でのテストは現実的に困難。
  - 候補: モック化 / 条件分岐のユニットテスト / 統合テストでスキップ

- **OpenRemoteBaseKey (UT-WIN32-088, 090)**: リモートレジストリ接続は実環境依存。ネットワーク構成やアクセス権限が必要。
  - 候補: モックレジストリ / 統合テストとして分離 / CI環境でスキップ

- **SafeCreateFile 非ファイル対象 (UT-WIN32-097)**: パイプやデバイスなど非ファイル対象のテスト環境構築が必要。
  - 候補: 名前付きパイプの作成 / デバイスファイルの利用

## 5) リスクフラグ（レビュー観点）

| レベル | 項目 | 理由 |
|--------|------|------|
| 1 | GetLastWriteTime (UT-WIN32-080, 081) | OS依存の分岐があり、全パスのテストが困難 |
| 1 | OpenRemoteBaseKey (UT-WIN32-088, 090) | ネットワーク環境依存 |
| 1 | SafeCreateFile 非ファイル (UT-WIN32-097) | 特殊なファイルタイプのテスト環境が必要 |
| 0 | その他全項目 | ソースコードと既存テストから十分な根拠あり |

## 6) レビュアーチェックリスト（最小）

- [ ] 既存テストファイル (RegistryKeyTests.cls, RegistryTests.cls) のテストケースが網羅されているか
- [ ] Registry クラスの6つのルートキープロパティが全てテストされているか
- [ ] RegistryKey クラスの主要メソッド (OpenSubKey, CreateSubKey, DeleteSubKey, SetValue, GetValue, DeleteValue) が正常系/異常系でテストされているか
- [ ] RegistryValueKind の全ての型 (String, DWord, Binary, MultiString, ExpandString, QWord) に対するテストがあるか
- [ ] 境界値テスト (空配列、長すぎる名前など) が含まれているか
- [ ] 権限チェック (読み取り専用キーへの書き込み) のテストがあるか
- [ ] Win32Native モジュールのヘルパー関数がテストされているか
- [ ] ラウンドトリップテスト (SetValue後にGetValueで同じ値が取得できる) が各データ型に対してあるか
- [ ] 列挙値 (RegistryValueKind, RegistryValueOptions, RegistryHive) の値が正しいか確認されているか
