---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 210
  claims_with_evidence: 208
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：System.Collections 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたSystem.Collections単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：208 / 210、根拠なし：2
- 優先レビュー（高）
  1. **Hashtable.Clean メソッド**：.NET標準APIとは異なるVBCorLib固有機能の可能性
  2. **CaseInsensitiveComparer カルチャ依存の動作**：カルチャ依存の比較動作についてより詳細な検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Collections/ArrayList.cls` - ArrayListクラスのソースコード
- E-02: `Source/CorLib/System.Collections/Hashtable.cls` - Hashtableクラスのソースコード
- E-03: `Source/CorLib/System.Collections/SortedList.cls` - SortedListクラスのソースコード
- E-04: `Source/CorLib/System.Collections/Queue.cls` - Queueクラスのソースコード
- E-05: `Source/CorLib/System.Collections/Stack.cls` - Stackクラスのソースコード
- E-06: `Source/CorLib/System.Collections/BitArray.cls` - BitArrayクラスのソースコード
- E-07: `Source/CorLib/System.Collections/Comparer.cls` - Comparerクラスのソースコード
- E-08: `Source/CorLib/System.Collections/CaseInsensitiveComparer.cls` - CaseInsensitiveComparerクラスのソースコード
- E-09: `Source/CorLib/System.Collections/DictionaryEntry.cls` - DictionaryEntryクラスのソースコード
- E-10: `Source/CorLib/System.Collections/FixedSizeArrayList.cls` - FixedSizeArrayListクラスのソースコード
- E-11: `Source/CorLib/System.Collections/ReadOnlyArrayList.cls` - ReadOnlyArrayListクラスのソースコード
- E-12: `Source/CorLib/System.Collections/EqualityComparer.cls` - EqualityComparerクラスのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）

### ArrayList関連テストケース（C-001〜C-060）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ArrayList.Addで要素が追加される | E-01: Add関数の実装（EnsureCapacity、VariantCopyInd）を確認 | ○ |
| C-002 | ArrayList.Addでオブジェクト型が追加できる | E-01: VariantCopyIndがVariant型を処理 | ○ |
| C-003 | ArrayList.AddでNull値が追加できる | E-01: Variant型としてNull値を許容 | ○ |
| C-004 | ArrayList.AddでEmpty値が追加できる | E-01: Variant型としてEmpty値を許容 | ○ |
| C-005 | ArrayList.Addで容量が自動拡張される | E-01: EnsureCapacity関数でCapacity倍増ロジック確認 | ○ |
| C-006〜C-008 | ArrayList.AddRangeで複数要素追加 | E-01: WriteRange関数で配列/ICollection/VBA.Collectionを処理 | ○ |
| C-009 | ArrayList.AddRangeでNull配列例外 | E-01: WriteArray内でCorArray.IsNull判定 | ○ |
| C-010〜C-014 | ArrayList.BinarySearch関連 | E-01: BinarySearch、BinarySearchEx実装を確認 | ○ |
| C-015〜C-017 | ArrayList.Capacityプロパティ | E-01: Capacityのget/let実装、ValidateNewCapacity確認 | ○ |
| C-018〜C-019 | ArrayList.Clearメソッド | E-01: Clear実装でCount=0、配列再初期化を確認 | ○ |
| C-020〜C-021 | ArrayList.Cloneメソッド | E-01: Clone実装でInitClone呼び出し確認 | ○ |
| C-022〜C-024 | ArrayList.Containsメソッド | E-01: Contains内でObject.Equals使用を確認 | ○ |
| C-025〜C-027 | ArrayList.CopyTo/CopyToExメソッド | E-01: CopyTo、CopyToEx実装でCorArray.CopyEx使用を確認 | ○ |
| C-028 | ArrayList.Countプロパティ | E-01: Count取得実装を確認 | ○ |
| C-029〜C-030 | ArrayList.GetEnumeratorメソッド | E-01: GetEnumerator実装でArrayListEnumerator生成を確認 | ○ |
| C-031〜C-032 | ArrayList.GetRangeメソッド | E-01: GetRange実装でRangedArrayList生成を確認 | ○ |
| C-033〜C-035 | ArrayList.IndexOfメソッド | E-01: IndexOf実装でCorArray.IndexOf使用を確認 | ○ |
| C-036〜C-039 | ArrayList.Insert/InsertRangeメソッド | E-01: Insert、InsertRange実装を確認 | ○ |
| C-040〜C-041 | ArrayList.IsFixedSize/IsReadOnly | E-01: プロパティがFalseを返すことを確認 | ○ |
| C-042〜C-045 | ArrayList.Itemインデクサ | E-01: Item get/let/set実装、範囲チェックを確認 | ○ |
| C-046〜C-047 | ArrayList.LastIndexOfメソッド | E-01: LastIndexOf実装でCorArray.LastIndexOf使用を確認 | ○ |
| C-048〜C-052 | ArrayList.Remove/RemoveAt/RemoveRange | E-01: 削除系メソッドの実装を確認 | ○ |
| C-053〜C-054 | ArrayList.Reverseメソッド | E-01: Reverse実装を確認 | ○ |
| C-055 | ArrayList.SetRangeメソッド | E-01: SetRange実装を確認 | ○ |
| C-056〜C-057 | ArrayList.Sortメソッド | E-01: Sort実装でCorArray.SortKey使用を確認 | ○ |
| C-058〜C-059 | ArrayList.ToArrayメソッド | E-01: ToArray実装で型変換を確認 | ○ |
| C-060 | ArrayList.TrimToSizeメソッド | E-01: TrimToSize実装でCapacity=Count設定を確認 | ○ |

### Hashtable関連テストケース（C-061〜C-083）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-061 | Hashtable.Addでキーと値が追加される | E-02: Add関数の実装を確認 | ○ |
| C-062 | Hashtable.Addで重複キー例外 | E-02: InsertItem内で重複チェック実装を確認 | ○ |
| C-063 | Hashtable.Clearで全要素クリア | E-02: Clear実装を確認 | ○ |
| C-064 | Hashtable.Cleanで削除済みバケット整理 | E-02: Cleanメソッドが存在（VBCorLib固有機能） | △ |
| C-065 | Hashtable.Cloneでシャローコピー | E-02: Clone実装を確認 | ○ |
| C-066〜C-070 | Hashtable.Contains/ContainsKey/ContainsValue | E-02: 各メソッドの実装を確認 | ○ |
| C-071 | Hashtable.CopyToでDictionaryEntry配列コピー | E-02: CopyTo実装を確認 | ○ |
| C-072 | Hashtable.Countプロパティ | E-02: Count取得実装を確認 | ○ |
| C-073 | Hashtable.GetEnumeratorでIDictionaryEnumerator取得 | E-02: GetEnumerator実装を確認 | ○ |
| C-074〜C-075 | Hashtable.IsFixedSize/IsReadOnly | E-02: プロパティがFalseを返すことを確認 | ○ |
| C-076〜C-079 | Hashtable.Itemインデクサ | E-02: Item get/let/set実装を確認 | ○ |
| C-080 | Hashtable.Keysプロパティ | E-02: Keys取得実装を確認 | ○ |
| C-081〜C-082 | Hashtable.Removeメソッド | E-02: Remove実装を確認 | ○ |
| C-083 | Hashtable.Valuesプロパティ | E-02: Values取得実装を確認 | ○ |

### SortedList関連テストケース（C-084〜C-111）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-084〜C-086 | SortedList.Addメソッド | E-03: Add実装、ソート維持ロジックを確認 | ○ |
| C-087〜C-088 | SortedList.Capacityプロパティ | E-03: Capacity get/let実装を確認 | ○ |
| C-089 | SortedList.Clearメソッド | E-03: Clear実装を確認 | ○ |
| C-090 | SortedList.Cloneメソッド | E-03: Clone実装を確認 | ○ |
| C-091〜C-093 | SortedList.Contains/ContainsKey/ContainsValue | E-03: 各メソッドの実装を確認 | ○ |
| C-094 | SortedList.CopyToメソッド | E-03: CopyTo実装を確認 | ○ |
| C-095 | SortedList.Countプロパティ | E-03: Count取得実装を確認 | ○ |
| C-096〜C-098 | SortedList.GetByIndex/GetKeyメソッド | E-03: インデックスアクセス実装を確認 | ○ |
| C-099〜C-100 | SortedList.GetKeyList/GetValueListメソッド | E-03: リスト取得実装を確認 | ○ |
| C-101〜C-103 | SortedList.IndexOfKey/IndexOfValueメソッド | E-03: 検索実装を確認 | ○ |
| C-104〜C-105 | SortedList.Itemインデクサ | E-03: Item get/let/set実装を確認 | ○ |
| C-106 | SortedList.Keysプロパティ | E-03: Keys取得実装を確認 | ○ |
| C-107〜C-108 | SortedList.Remove/RemoveAtメソッド | E-03: 削除実装を確認 | ○ |
| C-109 | SortedList.SetByIndexメソッド | E-03: SetByIndex実装を確認 | ○ |
| C-110 | SortedList.TrimToSizeメソッド | E-03: TrimToSize実装を確認 | ○ |
| C-111 | SortedList.Valuesプロパティ | E-03: Values取得実装を確認 | ○ |

### Queue関連テストケース（C-112〜C-127）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | Queue.Clearで全要素クリア | E-04: Clear実装（mCount=0、mHead=0、mTail=0）を確認 | ○ |
| C-113 | Queue.Cloneでシャローコピー | E-04: Clone実装でInitClone呼び出しを確認 | ○ |
| C-114〜C-115 | Queue.Containsメソッド | E-04: Contains実装でObject.Equals使用を確認 | ○ |
| C-116 | Queue.CopyToで配列コピー | E-04: CopyTo実装を確認（循環バッファ対応） | ○ |
| C-117 | Queue.Countプロパティ | E-04: mCount返却を確認 | ○ |
| C-118〜C-119 | Queue.Dequeueメソッド | E-04: Dequeue実装（mCount=0時のInvalidOperationException）を確認 | ○ |
| C-120〜C-121 | Queue.Enqueueメソッド | E-04: Enqueue実装（EnsureCapacity呼び出し）を確認 | ○ |
| C-122 | Queue.GetEnumeratorメソッド | E-04: GetEnumerator実装でQueueEnumerator生成を確認 | ○ |
| C-123〜C-124 | Queue.Peekメソッド | E-04: Peek実装（mCount=0時のInvalidOperationException）を確認 | ○ |
| C-125 | Queue.ToArrayメソッド | E-04: ToArray実装を確認 | ○ |
| C-126〜C-127 | Queue.TrimToSizeメソッド | E-04: TrimToSize実装（空時のDefaultCapacity設定）を確認 | ○ |

### Stack関連テストケース（C-128〜C-141）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | Stack.Clearで全要素クリア | E-05: Clear実装（ReDim、mCount=0）を確認 | ○ |
| C-129 | Stack.Cloneでシャローコピー | E-05: Clone実装でInitClone呼び出しを確認 | ○ |
| C-130〜C-131 | Stack.Containsメソッド | E-05: Contains実装でCorArray.IndexOf使用を確認 | ○ |
| C-132 | Stack.CopyToで配列コピー | E-05: CopyTo実装（Reverse呼び出し）を確認 | ○ |
| C-133 | Stack.Countプロパティ | E-05: mCount返却を確認 | ○ |
| C-134 | Stack.GetEnumeratorメソッド | E-05: GetEnumerator実装でStackEnumerator生成を確認 | ○ |
| C-135〜C-136 | Stack.Peekメソッド | E-05: Peek実装（mCount=0時のInvalidOperationException）を確認 | ○ |
| C-137〜C-138 | Stack.Popメソッド | E-05: Pop実装（mCount=0時のInvalidOperationException）を確認 | ○ |
| C-139〜C-140 | Stack.Pushメソッド | E-05: Push実装（EnsureCapacity呼び出し）を確認 | ○ |
| C-141 | Stack.ToArrayメソッド | E-05: ToArray実装（逆順配列）を確認 | ○ |

### BitArray関連テストケース（C-142〜C-165）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142〜C-144 | BitArray.AndBitsメソッド | E-06: AndBits実装（長さチェック、Null チェック）を確認 | ○ |
| C-145 | BitArray.Cloneメソッド | E-06: Clone実装でInitClone呼び出しを確認 | ○ |
| C-146〜C-148 | BitArray.CopyToメソッド | E-06: CopyTo実装（Long/Byte/Boolean配列対応）を確認 | ○ |
| C-149 | BitArray.Countプロパティ | E-06: mLength返却を確認 | ○ |
| C-150 | BitArray.GetEnumeratorメソッド | E-06: GetEnumerator実装でBitArrayEnumerator生成を確認 | ○ |
| C-151 | BitArray.IsReadOnlyプロパティ | E-06: Falseを返すことを確認 | ○ |
| C-152〜C-154 | BitArray.Itemインデクサ | E-06: Item get/let実装、範囲チェックを確認 | ○ |
| C-155〜C-158 | BitArray.Lengthプロパティ | E-06: Length get/let実装、負値チェックを確認 | ○ |
| C-159 | BitArray.NotBitsメソッド | E-06: NotBits実装でNot演算を確認 | ○ |
| C-160〜C-161 | BitArray.OrBitsメソッド | E-06: OrBits実装（長さチェック）を確認 | ○ |
| C-162〜C-163 | BitArray.SetAllメソッド | E-06: SetAll実装を確認 | ○ |
| C-164〜C-165 | BitArray.XorBitsメソッド | E-06: XorBits実装（長さチェック）を確認 | ○ |

### Comparer関連テストケース（C-166〜C-174）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-166〜C-172 | Comparer.Compareメソッド | E-07: Compare実装（数値/文字列/Null/Empty/IComparable）を確認 | ○ |
| C-173 | CaseInsensitiveComparer.Compareで大文字小文字無視 | E-08: Compare実装でIgnoreCase使用を確認 | ○ |
| C-174 | CaseInsensitiveComparer.Compareで文字列以外はデフォルト | E-08: mDefault.Compare呼び出しを確認 | △ |

### DictionaryEntry関連テストケース（C-175〜C-181）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-175〜C-178 | DictionaryEntry.Key/Valueプロパティ | E-09: Key/Value get/let/set実装を確認 | ○ |
| C-179〜C-180 | DictionaryEntry.Equalsメソッド | E-09: Equals実装でObject.Equals使用を確認 | ○ |
| C-181 | DictionaryEntry.GetHashCodeメソッド | E-09: GetHashCode実装でXor演算を確認 | ○ |

### FixedSizeArrayList関連テストケース（C-182〜C-191）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-182〜C-187 | FixedSizeArrayList変更操作でNotSupportedException | E-10: Add/Clear/Insert/Remove/RemoveAt/TrimToSizeでThrow確認 | ○ |
| C-188〜C-189 | FixedSizeArrayList.Item取得/設定 | E-10: Item get/let/set実装（mList委譲）を確認 | ○ |
| C-190〜C-191 | FixedSizeArrayList.IsFixedSize/IsReadOnly | E-10: IsFixedSize=True、IsReadOnly=Falseを確認 | ○ |

### ReadOnlyArrayList関連テストケース（C-192〜C-201）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-192〜C-198 | ReadOnlyArrayList変更操作でNotSupportedException | E-11: Add/Clear/Insert/Remove/Item Set/Reverse/SortでThrowNotSupported確認 | ○ |
| C-199 | ReadOnlyArrayList.Item取得 | E-11: Item get実装（mList委譲）を確認 | ○ |
| C-200〜C-201 | ReadOnlyArrayList.IsFixedSize/IsReadOnly | E-11: IsFixedSize=True、IsReadOnly=Trueを確認 | ○ |

### EqualityComparer関連テストケース（C-202〜C-204）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-202〜C-203 | EqualityComparer.Equalsメソッド | E-12: IEqualityComparer_Equals実装でObject.Equals使用を確認 | ○ |
| C-204 | EqualityComparer.GetHashCodeメソッド | E-12: IEqualityComparer_GetHashCode実装でObject.GetHashCode使用を確認 | ○ |

### バージョン管理関連テストケース（C-205〜C-210）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-205 | ArrayList.Version更新 | E-01: mVersion増分箇所を確認 | ○ |
| C-206 | Hashtable.Version更新 | E-02: mVersion増分箇所を確認 | ○ |
| C-207 | Queue.Version更新 | E-04: mVersion増分箇所を確認 | ○ |
| C-208 | Stack.Version更新 | E-05: mVersion増分箇所を確認 | ○ |
| C-209 | BitArray.Version更新 | E-06: mVersion増分箇所を確認 | ○ |
| C-210 | SortedList.Version更新 | E-03: mVersion増分箇所を確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Hashtable.Cleanメソッド（C-064）**：.NET Framework標準のHashtableにはCleanメソッドが存在しない。VBCorLib固有の最適化機能と思われるが、詳細な仕様書がない
  - 候補：実装コードのコメント / テストケース / 開発者ドキュメント
- **CaseInsensitiveComparer カルチャ依存の動作（C-174）**：異なるカルチャでの比較動作の詳細な仕様が不明
  - 候補：CultureInfo関連のテストケース / ロケール仕様書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 標準的なコレクション操作（Add, Remove, Contains等）のテストケース
- **1: 中リスク** - 境界値・異常系のテストケース（空コレクション操作、範囲外アクセス等）
- **2: 高リスク** - VBCorLib固有機能（Hashtable.Clean）、カルチャ依存機能（Comparer）

## 6) レビュアーチェックリスト（最小）
- [ ] 各コレクションクラスの基本操作（Add, Remove, Clear, Contains）のテストケースが網羅されているか
- [ ] 境界値テスト（空コレクション、最大容量、負のインデックス）が含まれているか
- [ ] 異常系テスト（例外発生条件）が適切にカバーされているか
- [ ] IEnumerable/ICollection/IList等のインターフェース実装が検証されているか
- [ ] FixedSizeArrayList/ReadOnlyArrayListの制約が正しくテストされているか
- [ ] Hashtable.Cleanメソッドの仕様を確認し、テストケースの妥当性を検証する
- [ ] カルチャ依存の比較動作についてテストケースの追加が必要か検討する
