---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：System.Diagnostics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **UT-DIA-037**：QPCサポートなし環境のテストは実機検証が困難
  2. **UT-DIA-040**：精度検証は環境依存性が高い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Diagnostics/StopWatch.cls` - StopWatchクラス実装
- E-02: `Source/CorLib/System.Diagnostics/StopWatchStatic.cls` - StopWatchStaticクラス実装
- E-03: `Source/Tests/System.Diagnostics/StopWatchTests.cls` - 既存テストコード
- E-04: VB6/VBA言語仕様 - Currency型、Variant型の仕様
- E-05: Windows API仕様 - QueryPerformanceCounter、QueryPerformanceFrequency、timeGetTime

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StartCount - StopWatch開始機能 | E-01 (70-75行目), E-03 (41-47行目) | ○ |
| C-02 | StartCount - 重複開始防止 | E-01 (71行目 If Not mIsRunning) | ○ |
| C-03 | StopCount - StopWatch停止機能 | E-01 (88-93行目) | ○ |
| C-04 | StopCount - 停止状態の保持 | E-01 (89行目 If mIsRunning) | ○ |
| C-05 | StopCount - 経過時間累積 | E-01 (90行目) | ○ |
| C-06 | IsRunning - 停止状態でFalse | E-03 (32-38行目) | ○ |
| C-07 | IsRunning - 実行中でTrue | E-03 (41-47行目) | ○ |
| C-08 | Reset - 経過時間ゼロ化 | E-01 (106-108行目), E-03 (67-74行目) | ○ |
| C-09 | Reset - 停止状態化 | E-01 (108行目), E-03 (73行目) | ○ |
| C-10 | Restart - リセット後開始 | E-01 (114-117行目) | ○ |
| C-11 | Elapsed - TimeSpan返却 | E-01 (130-132行目), E-03 (57-65行目) | ○ |
| C-12 | Elapsed - 実行中の時間取得 | E-01 (204-206行目) | ○ |
| C-13 | Elapsed - 停止後の時間保持 | E-01 (202行目) | ○ |
| C-14 | ElapsedMilliseconds - ミリ秒変換 | E-01 (145-147行目) | ○ |
| C-15 | ElapsedMilliseconds - 初期値0 | E-01 (47-49行目初期値) | ○ |
| C-16 | ElapsedTicks - Tick単位返却 | E-01 (160-162行目) | ○ |
| C-17 | ElapsedTicks - 単位換算整合性 | E-01 (161行目 * 10000&) | ○ |
| C-18 | ToString - 文字列表現 | E-01 (169-171行目) | ○ |
| C-19 | Equals - 同一インスタンス比較 | E-01 (181-183行目) | ○ |
| C-20 | Equals - 異インスタンス比較 | E-01 (181-183行目) | ○ |
| C-21 | GetHashCode - ハッシュコード | E-01 (192-194行目) | ○ |
| C-22 | Class_Initialize - 初期化 | E-01 (219-224行目) | ○ |
| C-23 | IObject_Equals - インターフェース | E-01 (230-232行目) | ○ |
| C-24 | IObject_GetHashCode - インターフェース | E-01 (234-236行目) | ○ |
| C-25 | IObject_ToString - インターフェース | E-01 (238-240行目) | ○ |
| C-26 | IsHighResolution - Boolean返却 | E-02 (56-58行目), E-03 (24-26行目) | ○ |
| C-27 | IsHighResolution - QPC環境でTrue | E-02 (108行目), E-03 (25行目) | ○ |
| C-28 | Frequency - 周波数返却 | E-02 (65-67行目), E-03 (28-30行目) | ○ |
| C-29 | Frequency - 非ゼロ値 | E-03 (29行目) | ○ |
| C-30 | GetTimeStamp - タイムスタンプ | E-02 (77-79行目) | ○ |
| C-31 | GetTimeStamp - 単調増加 | E-02 (95-101行目) | ○ |
| C-32 | StartNew - インスタンス生成 | E-02 (86-89行目), E-03 (49-55行目) | ○ |
| C-33 | StartNew - 実行中状態 | E-02 (88行目), E-03 (54行目) | ○ |
| C-34 | InternalGetTimeStamp - 高解像度 | E-02 (96-97行目) | ○ |
| C-35 | InternalGetTimeStamp - 低解像度 | E-02 (98-99行目) | ○ |
| C-36 | Class_Initialize - QPF成功 | E-02 (107-109行目) | ○ |
| C-37 | Class_Initialize - QPF失敗 | E-02 (108行目) | △ |
| C-38 | 累積計測 - Start-Stop繰り返し | E-01 (90行目の加算ロジック) | ○ |
| C-39 | 累積計測 - 重複開始の安全性 | E-01 (71行目の条件分岐) | ○ |
| C-40 | 精度検証 - 100ms待機 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-37 (QPF失敗時の動作)**：現代のWindowsシステムでは、QueryPerformanceFrequencyが失敗するケースは非常に稀であり、実際にテストすることが困難
  - 候補：仮想環境での検証 / モック化 / 条件付きスキップ
- **C-40 (精度検証)**：実行環境のCPU負荷、タスクスケジューラの影響により、正確な時間待機が保証されない
  - 候補：許容範囲を広げる / 統計的検証 / 複数回実行の平均

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - StopWatch基本機能（Start/Stop/Reset/Restart）
- **0: 低リスク** - プロパティ取得（IsRunning、Elapsed系）
- **0: 低リスク** - IObjectインターフェース実装
- **1: 中リスク** - 時間単位変換（ミリ秒、Tick）の精度
- **1: 中リスク** - 高解像度/低解像度タイマーの切り替え
- **2: 高リスク** - 環境依存テスト（QPCサポートなし環境）

## 6) レビュアーチェックリスト（最小）
- [ ] StopWatch.cls の各メソッドシグネチャとテストケースの対応確認
- [ ] StopWatchStatic.cls の各メソッドシグネチャとテストケースの対応確認
- [ ] 既存テスト（StopWatchTests.cls）との重複・整合性確認
- [ ] 境界値テストの妥当性確認（初期値0、累積計測など）
- [ ] IObjectインターフェース実装のテスト必要性判断
- [ ] 環境依存テスト（C-37, C-40）の実装方針決定
