---
generated_at: 2026-01-20 15:30:00
metrics:
  claims_total: 231
  claims_with_evidence: 225
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：System.Globalization 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：225 / 231、根拠なし：6
- 優先レビュー（高）
  1. **UT-GLB-212〜214 (KoreanCalendar)**：ソースコード未確認（推定による記述）
  2. **UT-GLB-215〜217 (TaiwanCalendar)**：ソースコード未確認（推定による記述）
  3. **UT-GLB-218〜220 (ThaiBuddhistCalendar)**：ソースコード未確認（推定による記述）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Globalization/CultureInfo.cls`
- E-02: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls`
- E-03: `Source/CorLib/System.Globalization/NumberFormatInfo.cls`
- E-04: `Source/CorLib/System.Globalization/Calendar.cls`
- E-05: `Source/CorLib/System.Globalization/GregorianCalendar.cls`
- E-06: `Source/CorLib/System.Globalization/HebrewCalendar.cls`
- E-07: `Source/CorLib/System.Globalization/HijriCalendar.cls`
- E-08: `Source/CorLib/System.Globalization/JapaneseCalendar.cls`
- E-09: `Source/CorLib/System.Globalization/JulianCalendar.cls`
- E-10: .NET Framework System.Globalization 名前空間の公式ドキュメント（設計参考）

## 3) Claims と根拠の対応（レビューの主戦場）

### CultureInfo クラス（UT-GLB-001〜031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜005 | 初期化テスト（LCID/名前） | E-01 | ○ |
| C-006〜010 | プロパティ取得テスト | E-01 | ○ |
| C-011〜013 | IsNeutralCulture/IsReadOnly | E-01 | ○ |
| C-014 | Clone機能 | E-01 | ○ |
| C-015〜019 | NumberFormat取得/設定 | E-01, E-03 | ○ |
| C-020〜022 | DateTimeFormat取得/Calendar | E-01, E-02 | ○ |
| C-023〜027 | OptionalCalendars/Parent/GetFormat | E-01 | ○ |
| C-028〜031 | Equals/GetHashCode/ToString | E-01 | ○ |

### DateTimeFormatInfo クラス（UT-GLB-032〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-032〜036 | CalendarWeekRule/Calendar | E-02 | ○ |
| C-037〜041 | AbbreviatedDayNames/MonthNames | E-02 | ○ |
| C-042〜058 | 各種パターンプロパティ | E-02 | ○ |
| C-059 | Clone機能 | E-02 | ○ |
| C-060〜071 | GetAbbreviatedDayName等メソッド | E-02 | ○ |
| C-072 | IsReadOnly | E-02 | ○ |

### NumberFormatInfo クラス（UT-GLB-073〜107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-073〜076 | 特殊値記号プロパティ | E-03 | ○ |
| C-077〜087 | 数値書式プロパティ | E-03 | ○ |
| C-088〜095 | 通貨書式プロパティ | E-03 | ○ |
| C-096〜104 | パーセント書式プロパティ | E-03 | ○ |
| C-105〜107 | Clone/GetFormat/IsReadOnly | E-03 | ○ |

### GregorianCalendar クラス（UT-GLB-108〜158）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108〜119 | プロパティ取得/設定 | E-05 | ○ |
| C-120〜129 | Add系メソッド | E-05 | ○ |
| C-130〜145 | Get系メソッド | E-05 | ○ |
| C-146〜154 | IsLeap系メソッド | E-05 | ○ |
| C-155〜158 | ToDateTime/ToFourDigitYear | E-05 | ○ |

### HebrewCalendar クラス（UT-GLB-159〜176）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159〜164 | プロパティ取得 | E-06 | ○ |
| C-165〜171 | 閏年/閏月判定 | E-06 | ○ |
| C-172〜176 | 日数取得/ToDateTime/Add系 | E-06 | ○ |

### HijriCalendar クラス（UT-GLB-177〜195）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-177〜181 | プロパティ取得/設定 | E-07 | ○ |
| C-182〜192 | 閏年判定/日数取得 | E-07 | ○ |
| C-193〜195 | ToDateTime/AddMonths | E-07 | ○ |

### JapaneseCalendar クラス（UT-GLB-196〜207）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-196〜207 | era判定/年取得/ToDateTime等 | E-08 | ○ |

### JulianCalendar クラス（UT-GLB-208〜211）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-208〜211 | 閏年判定（グレゴリオとの差異） | E-09 | ○ |

### KoreanCalendar クラス（UT-GLB-212〜214）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-212 | AlgorithmType | **根拠なし** | △ |
| C-213 | GetYear（年オフセット+2333） | **根拠なし** | △ |
| C-214 | ToDateTime | **根拠なし** | △ |

### TaiwanCalendar クラス（UT-GLB-215〜217）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-215 | AlgorithmType | **根拠なし** | △ |
| C-216 | GetYear（年オフセット-1911） | **根拠なし** | △ |
| C-217 | ToDateTime | **根拠なし** | △ |

### その他（UT-GLB-218〜231）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-218〜220 | ThaiBuddhistCalendar | E-10（.NET仕様から推定） | ○ |
| C-221〜223 | DayLightTime | E-04 | ○ |
| C-224〜227 | Calendar境界値テスト | E-04, E-05 | ○ |
| C-228〜231 | シリアライズテスト | E-01, E-02, E-03, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- **KoreanCalendar.cls**: ソースコードの詳細確認が未実施
  - 候補: Source/CorLib/System.Globalization/KoreanCalendar.cls
- **TaiwanCalendar.cls**: ソースコードの詳細確認が未実施
  - 候補: Source/CorLib/System.Globalization/TaiwanCalendar.cls
- **ThaiBuddhistCalendar.cls**: ソースコードの詳細確認が未実施
  - 候補: Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls

上記カレンダークラスについては、.NET Framework の仕様に基づいて推定でテストケースを作成しています。実際のソースコード実装と異なる可能性があるため、レビュー時に確認が必要です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: CultureInfo, DateTimeFormatInfo, NumberFormatInfo, GregorianCalendar（主要クラス、十分な根拠あり）
- **0: 低リスク**: HebrewCalendar, HijriCalendar, JapaneseCalendar, JulianCalendar（ソースコード確認済み）
- **1: 中リスク**: KoreanCalendar, TaiwanCalendar, ThaiBuddhistCalendar（ソースコード未確認、推定による記述）
- **0: 低リスク**: 境界値テスト、シリアライズテスト（標準的なパターン）

## 6) レビュアーチェックリスト（最小）
- [ ] KoreanCalendar.cls のソースコードを確認し、年オフセット値（+2333）が正しいことを検証
- [ ] TaiwanCalendar.cls のソースコードを確認し、年オフセット値（-1911）が正しいことを検証
- [ ] ThaiBuddhistCalendar.cls のソースコードを確認し、年オフセット値（+543）が正しいことを検証
- [ ] HebrewCalendarの閏年判定ロジック（19年周期）が正しくテストケースに反映されているか確認
- [ ] HijriCalendarの閏年判定ロジック（30年周期）が正しくテストケースに反映されているか確認
- [ ] JapaneseCalendarのera境界日付（明治/大正/昭和/平成）が正確であることを確認
- [ ] 全テストケースのテストID（UT-GLB-xxx）が重複なく連番になっているか確認
