---
generated_at: 2026-01-20 20:30:00
metrics:
  claims_total: 191
  claims_with_evidence: 191
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.IO.MemoryMappedFiles 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコード等の根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：対象モジュールのクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：191 / 191、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードまたは既存テストコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedFile.cls` - MemoryMappedFileクラス本体（L1-256）
- E-02: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedFileStatic.cls` - 静的メソッド群（L1-463）
- E-03: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedViewAccessor.cls` - ランダムアクセスビュー（L1-992）
- E-04: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedViewStream.cls` - シーケンシャルアクセスストリーム（L1-865）
- E-05: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeMemoryMappedFileHandle.cls` - セーフハンドルラッパー（L1-161）
- E-06: `Source/Tests/System.IO.MemoryMappedFiles/MemoryMappedFileTests.cls` - 既存テストコード（L1-501）
- E-07: `Source/Tests/System.IO.MemoryMappedFiles/MemoryMappedViewAccessorTests.cls` - 既存テストコード（L1-524）
- E-08: `Source/Tests/System.IO.MemoryMappedFiles/MemoryMappedViewStreamTests.cls` - 既存テストコード（L1-164）

## 3) Claims と根拠の対応（レビューの主戦場）

### MemoryMappedFileStatic クラス（UT-MMF-001 〜 UT-MMF-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateFromFile - 正常作成 | E-02 (L101-144), E-06 (L80-86) | ○ |
| C-02 | CreateFromFile - ファイルサイズ拡張 | E-02 (L126-134), E-06 (L147-154) | ○ |
| C-03 | CreateFromFile - vbNullStringで無名マッピング | E-02 (L106) | ○ |
| C-04 | CreateFromFile - 空MapNameでArgumentException | E-02 (L106-107), E-06 (L80-86) | ○ |
| C-05 | CreateFromFile - 負Capacityで例外 | E-02 (L108-109), E-06 (L88-94) | ○ |
| C-06 | CreateFromFile - 無効Access値(下限)で例外 | E-02 (L110-111), E-06 (L96-102) | ○ |
| C-07 | CreateFromFile - 無効Access値(上限)で例外 | E-02 (L110-111), E-06 (L96-102) | ○ |
| C-08 | CreateFromFile - FileMode.Appendで例外 | E-02 (L112-113), E-06 (L104-109) | ○ |
| C-09 | CreateFromFile - WriteOnlyで例外 | E-02 (L114-115), E-06 (L112-118) | ○ |
| C-10 | CreateFromFile - 空ファイルで例外 | E-02 (L121-124), E-06 (L120-127) | ○ |
| C-11 | CreateFromFile - Capacity<FileSizeで例外 | E-02 (L128-130), E-06 (L129-136) | ○ |
| C-12 | CreateFromFile - ReadOnlyでCapacity>FileSizeで例外 | E-02 (L131-133), E-06 (L138-145) | ○ |
| C-13 | CreateFromFileStream - 正常作成 | E-02 (L193-225), E-06 (L416-427) | ○ |
| C-14 | CreateFromFileStream - LeaveOpen=True | E-02 (L224) | ○ |
| C-15 | CreateFromFileStream - LeaveOpen=False | E-02 (L224), E-01 (L234-238) | ○ |
| C-16 | CreateFromFileStream - Nothing FileStreamで例外 | E-02 (L196-197), E-06 (L186-192) | ○ |
| C-17 | CreateFromFileStream - 空MapNameで例外 | E-02 (L198-199), E-06 (L194-200) | ○ |
| C-18 | CreateFromFileStream - 負Capacityで例外 | E-02 (L200-201), E-06 (L202-208) | ○ |
| C-19 | CreateFromFileStream - 無効Access値で例外 | E-02 (L202-203), E-06 (L210-216) | ○ |
| C-20 | CreateFromFileStream - WriteOnlyで例外 | E-02 (L209-210), E-06 (L229-235) | ○ |
| C-21 | CreateFromFileStream - 空ストリームで例外 | E-02 (L207-208), E-06 (L218-227) | ○ |
| C-22 | CreateFromFileStream - ReadOnlyでCapacity>Lengthで例外 | E-02 (L220-221), E-06 (L237-245) | ○ |
| C-23 | CreateFromFileStream - Capacity<Lengthで例外 | E-02 (L218-219), E-06 (L247-255) | ○ |
| C-24 | CreateNew - 正常作成 | E-02 (L257-274), E-06 (L297-304) | ○ |
| C-25 | CreateNew - ハンドル有効性 | E-06 (L297-304) | ○ |
| C-26 | CreateNew - vbNullStringで無名マッピング | E-02 (L260) | ○ |
| C-27 | CreateNew - 空MapNameで例外 | E-02 (L260-261), E-06 (L257-263) | ○ |
| C-28 | CreateNew - Capacity=0で例外 | E-02 (L265-266), E-06 (L265-271) | ○ |
| C-29 | CreateNew - 負Capacityで例外 | E-02 (L265-266), E-06 (L273-279) | ○ |
| C-30 | CreateNew - 無効Access値で例外 | E-02 (L267-268), E-06 (L281-287) | ○ |
| C-31 | CreateNew - WriteOnlyで例外 | E-02 (L269-270), E-06 (L289-295) | ○ |
| C-32 | OpenExisting - 正常オープン | E-02 (L301-313), E-06 (L339-348) | ○ |
| C-33 | OpenExisting - vbNullStringで例外 | E-02 (L304-305), E-06 (L306-311) | ○ |
| C-34 | OpenExisting - 空MapNameで例外 | E-02 (L306-307), E-06 (L314-320) | ○ |
| C-35 | OpenExisting - 無効権限(&H10)で例外 | E-02 (L308-309), E-06 (L322-328) | ○ |
| C-36 | OpenExisting - 無効権限(&H100000)で例外 | E-02 (L308-309), E-06 (L322-328) | ○ |
| C-37 | OpenExisting - 存在しない名前で例外 | E-02 (L396-401), E-06 (L331-337) | ○ |
| C-38 | CreateOrOpen - 新規作成 | E-02 (L345-367), E-06 (L390-396) | ○ |
| C-39 | CreateOrOpen - 既存オープン | E-02 (L360-366), E-06 (L398-414) | ○ |
| C-40 | CreateOrOpen - 共有メモリ書き込み/読み取り | E-06 (L398-414) | ○ |
| C-41 | CreateOrOpen - vbNullStringで例外 | E-02 (L348-349), E-06 (L350-356) | ○ |
| C-42 | CreateOrOpen - 空MapNameで例外 | E-02 (L350-351), E-06 (L358-364) | ○ |
| C-43 | CreateOrOpen - Capacity=0で例外 | E-02 (L355-356), E-06 (L366-372) | ○ |
| C-44 | CreateOrOpen - 負Capacityで例外 | E-02 (L355-356), E-06 (L374-380) | ○ |
| C-45 | CreateOrOpen - 無効Access値で例外 | E-02 (L357-358), E-06 (L382-388) | ○ |

### MemoryMappedFile クラス（UT-MMF-046 〜 UT-MMF-065）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | SafeMemoryMappedFileHandle取得 | E-01 (L115-117) | ○ |
| C-47 | CreateViewAccessor - 正常作成 | E-01 (L144-154), E-06 (L176-184) | ○ |
| C-48 | CreateViewAccessor - オフセット指定 | E-01 (L152-153), E-06 (L429-437) | ○ |
| C-49 | CreateViewAccessor - FileStreamベース | E-06 (L416-427) | ○ |
| C-50 | CreateViewAccessor - 負Offsetで例外 | E-01 (L145-146), E-06 (L156-164) | ○ |
| C-51 | CreateViewAccessor - 負Sizeで例外 | E-01 (L147-148), E-06 (L166-174) | ○ |
| C-52 | CreateViewStream - 正常作成 | E-01 (L182-192), E-06 (L439-447) | ○ |
| C-53-58 | CreateViewStream - 各Access別CanRead/CanWrite | E-01, E-06 (L469-478) | ○ |
| C-59 | CreateViewStream - 負Offsetで例外 | E-01 (L183-184), E-06 (L439-447) | ○ |
| C-60 | CreateViewStream - 負Sizeで例外 | E-01 (L185-186), E-06 (L449-457) | ○ |
| C-61 | CreateViewStream - 無効Access値で例外 | E-01 (L187-188), E-06 (L459-467) | ○ |
| C-62-65 | IObject実装（ToString, Equals, GetHashCode） | E-01 (L199-221) | ○ |

### MemoryMappedViewAccessor クラス（UT-MVA-001 〜 UT-MVA-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66-69 | CanWrite/CanRead プロパティ | E-03 (L60-70), E-03 (L887-912) | ○ |
| C-70 | Capacity プロパティ | E-03 (L76-78) | ○ |
| C-71 | PointerOffset プロパティ | E-03 (L84-86) | ○ |
| C-72-77 | ReadByte - 正常読み取り/オフセット付き | E-03 (L109-115), E-07 (L131-155) | ○ |
| C-78-80 | ReadByte - 例外ケース | E-03 (L915-928), E-07 (L118-129) | ○ |
| C-81-83 | ReadBoolean - 正常読み取り | E-03 (L138-143), E-07 (L157-168) | ○ |
| C-84 | ReadChar - 正常読み取り | E-03 (L168-173), E-07 (L170-181) | ○ |
| C-85 | ReadInt16 - 正常読み取り | E-03 (L196-202), E-07 (L183-194) | ○ |
| C-86 | ReadInt32 - 正常読み取り | E-03 (L225-231), E-07 (L196-207) | ○ |
| C-87-88 | ReadInt64 - 正常読み取り/FileStreamベース | E-03 (L254-260), E-07 (L276-303) | ○ |
| C-89 | ReadCurrency - 正常読み取り | E-03 (L319-325), E-07 (L222-233) | ○ |
| C-90 | ReadDate - 正常読み取り | E-03 (L288-293), E-07 (L209-220) | ○ |
| C-91 | ReadDouble - 正常読み取り | E-03 (L348-354), E-07 (L235-247) | ○ |
| C-92 | ReadSingle - 正常読み取り | E-03 (L377-383), E-07 (L249-261) | ○ |
| C-93 | ReadDecimal - 正常読み取り | E-03 (L406-412), E-07 (L263-274) | ○ |
| C-94-95 | Read - 構造体読み取り | E-03 (L440-468), E-07 (L305-333) | ○ |
| C-96-101 | Read - プリミティブ型読み取り | E-03 (L444-462), E-07 (L335-345) | ○ |
| C-102-108 | Read - 無効構造体例外 | E-03 (L466), E-07 (L347-358) | ○ |
| C-109-113 | ReadArray - 各型配列読み取り | E-03 (L505-538), E-07 (L388-413) | ○ |
| C-114 | ReadArray - 利用可能分のみ読み取り | E-03 (L535), E-07 (L415-429) | ○ |
| C-115-116 | ReadArray - 例外ケース | E-07 (L360-386) | ○ |
| C-117-126 | WriteValue - 各型書き込み | E-03 (L605-643), E-07 (L431-445) | ○ |
| C-127 | WriteValue - 書き込み不可例外 | E-03 (L606-607) | ○ |
| C-128-137 | WriteArray - 各型配列書き込み | E-03 (L690-726), E-07 (L473-487) | ○ |
| C-138-139 | WriteArray - 例外ケース | E-03 (L696-699), E-07 (L447-471) | ○ |
| C-140 | Flush | E-03 (L772-776) | ○ |
| C-141-143 | IObject実装 | E-03 (L784-804) | ○ |

### MemoryMappedViewStream クラス（UT-MVS-001 〜 UT-MVS-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144-147 | CanRead/CanWrite プロパティ | E-04 (L59-70), E-04 (L710-735) | ○ |
| C-148-149 | CanSeek - オープン時True/クローズ時False | E-04 (L77-78), E-08 (L121-133) | ○ |
| C-150 | CanTimeout - 常にFalse | E-04 (L86-87) | ○ |
| C-151 | Capacity プロパティ | E-04 (L94-96) | ○ |
| C-152 | Length プロパティ | E-04 (L102-104), E-08 (L34-45) | ○ |
| C-153-154 | Position プロパティ | E-04 (L120-143) | ○ |
| C-155-157 | ReadByte - 正常読み取り/例外 | E-04 (L421-426), E-08 (L47-72) | ○ |
| C-158-160 | ReadBlock - 正常読み取り/例外 | E-04 (L396-401), E-08 (L90-101) | ○ |
| C-161-162 | WriteByte - 正常書き込み/例外 | E-04 (L556-561), E-08 (L74-88) | ○ |
| C-163-164 | WriteBlock - 正常書き込み/例外 | E-04 (L522-527), E-08 (L103-119) | ○ |
| C-165 | SeekPosition | E-04 (L453-455) | ○ |
| C-166 | SetLength - NotSupportedException | E-04 (L472-474) | ○ |
| C-167 | Flush | E-04 (L356-358) | ○ |
| C-168 | CloseStream | E-04 (L147-153), E-08 (L121-133) | ○ |
| C-169-174 | BeginRead/BeginWrite/EndRead/EndWrite | E-04 (L253-352) | ○ |
| C-175-178 | ReadTimeout/WriteTimeout - 例外 | E-04 (L169-225) | ○ |
| C-179 | CopyTo | E-04 (L593-595) | ○ |
| C-180-182 | IObject実装 | E-04 (L604-626) | ○ |

### SafeMemoryMappedFileHandle クラス（UT-SFH-001 〜 UT-SFH-009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-183-184 | IsInvalid プロパティ | E-05 (L53-55) | ○ |
| C-185 | DangerousGetHandle | E-05 (L61-63) | ○ |
| C-186 | CloseHandle | E-05 (L67-69) | ○ |
| C-187-188 | IsClosed プロパティ | E-05 (L75-77) | ○ |
| C-189-191 | IObject実装 | E-05 (L86-108) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースにソースコードまたは既存テストコードの根拠が存在

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースが実装コードおよび既存テストコードと整合性あり
- 既存のテストコード（MemoryMappedFileTests.cls, MemoryMappedViewAccessorTests.cls, MemoryMappedViewStreamTests.cls）で多くのケースが実証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-MMF-001〜045、UT-MVA-007〜061、UT-MVS-012〜021）の期待結果が正確か確認
- [ ] 境界値テスト（UT-MVA-049、UT-MVA-014、UT-MVA-079）のカバレッジが十分か確認
- [ ] IPC（プロセス間通信）関連テスト（UT-MMF-039, UT-MMF-040）の実行環境依存性を考慮
- [ ] 非同期処理テスト（UT-MVS-026〜031）の実装詳細を確認
- [ ] Enum値の境界値（MemoryMappedFileAccess、MemoryMappedFileRights）のテストが網羅的か確認
- [ ] LeaveOpenパラメータの動作確認テスト（UT-MMF-014, UT-MMF-015）の検証
