---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 334
  claims_with_evidence: 334
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.IO 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：334 / 334、根拠なし：0
- 優先レビュー（高）
  1. **全テストケースはソースコードから直接抽出**：実際のVB6コードのメソッドシグネチャおよびコメントに基づく
  2. **テスト観点の網羅性**：正常系・異常系・境界値を各メソッドに対して適用
  3. **優先度の妥当性確認**：ファイルI/O操作のクリティカル性に基づく優先度設定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.IO/File.cls` - Fileクラスのソースコード（41メソッド）
- E-02: `Source/CorLib/System.IO/Directory.cls` - Directoryクラスのソースコード（32メソッド）
- E-03: `Source/CorLib/System.IO/Path.cls` - Pathクラスのソースコード（31メソッド/プロパティ）
- E-04: `Source/CorLib/System.IO/FileStream.cls` - FileStreamクラスのソースコード
- E-05: `Source/CorLib/System.IO/MemoryStream.cls` - MemoryStreamクラスのソースコード
- E-06: `Source/CorLib/System.IO/StreamReader.cls` - StreamReaderクラスのソースコード
- E-07: `Source/CorLib/System.IO/StreamWriter.cls` - StreamWriterクラスのソースコード
- E-08: `Source/CorLib/System.IO/BinaryReader.cls` - BinaryReaderクラスのソースコード
- E-09: `Source/CorLib/System.IO/BinaryWriter.cls` - BinaryWriterクラスのソースコード
- E-10: `Source/CorLib/System.IO/StringReader.cls` - StringReaderクラスのソースコード
- E-11: `Source/CorLib/System.IO/StringWriter.cls` - StringWriterクラスのソースコード
- E-12: `Source/CorLib/System.IO/FileInfo.cls` - FileInfoクラスのソースコード
- E-13: `Source/CorLib/System.IO/DirectoryInfo.cls` - DirectoryInfoクラスのソースコード
- E-14: `Source/CorLib/System.IO/DriveInfo.cls` - DriveInfoクラスのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）

### Fileクラス（UT-SIO-001〜UT-SIO-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | File.Existsメソッドの正常系テスト | E-01: 190-203行目のExistsメソッド | ○ |
| C-02 | File.Copyメソッドの正常系/異常系テスト | E-01: 111-138行目のCopyメソッド | ○ |
| C-03 | File.Deleteメソッドの正常系/異常系テスト | E-01: 168-182行目のDeleteメソッド | ○ |
| C-04 | File.Createメソッドの正常系テスト | E-01: 147-149行目のCreateメソッド | ○ |
| C-05 | File.Moveメソッドの正常系/異常系テスト | E-01: 299-317行目のMoveメソッド | ○ |
| C-06 | File.GetAttributes/SetAttributesの正常系テスト | E-01: 217-384行目の属性メソッド群 | ○ |
| C-07 | File.Get/SetCreationTime等の日時メソッドテスト | E-01: 233-450行目の日時メソッド群 | ○ |
| C-08 | File.OpenFile/OpenRead/OpenWriteの正常系テスト | E-01: 328-363行目のOpenメソッド群 | ○ |
| C-09 | File.ReadAllText/ReadAllBytes/ReadAllLinesの正常系テスト | E-01: 459-531行目の読み取りメソッド群 | ○ |
| C-10 | File.WriteAllText/WriteAllBytes/WriteAllLinesの正常系テスト | E-01: 563-606行目の書き込みメソッド群 | ○ |
| C-11 | File.AppendText/AppendAllText/AppendAllLinesの正常系テスト | E-01: 54-102行目の追記メソッド群 | ○ |

### Directoryクラス（UT-SIO-042〜UT-SIO-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | Directory.Existsメソッドの正常系テスト | E-02: 138-147行目のExistsメソッド | ○ |
| C-13 | Directory.CreateDirectoryメソッドの正常系/異常系テスト | E-02: 74-86行目のCreateDirectoryメソッド | ○ |
| C-14 | Directory.Deleteメソッドの正常系/異常系テスト | E-02: 157-200行目のDeleteメソッド | ○ |
| C-15 | Directory.GetCurrentDirectory/SetCurrentDirectoryの正常系テスト | E-02: 278-451行目のカレントディレクトリメソッド群 | ○ |
| C-16 | Directory.GetDirectories/GetFiles/GetFileSystemEntriesの正常系テスト | E-02: 303-355行目の列挙メソッド群 | ○ |
| C-17 | Directory.GetDirectoryRoot/GetParentの正常系テスト | E-02: 315-402行目のパス操作メソッド群 | ○ |
| C-18 | Directory.Moveメソッドの正常系/異常系テスト | E-02: 412-432行目のMoveメソッド | ○ |
| C-19 | Directory.Get/SetCreationTime等の日時メソッドテスト | E-02: 214-522行目の日時メソッド群 | ○ |

### Pathクラス（UT-SIO-074〜UT-SIO-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | Path.Combineメソッドの正常系/境界値テスト | E-03: 261-299行目のCombineメソッド群 | ○ |
| C-21 | Path.GetDirectoryNameメソッドの正常系/異常系テスト | E-03: 308-333行目のGetDirectoryNameメソッド | ○ |
| C-22 | Path.GetExtension/GetFileName/GetFileNameWithoutExtensionの正常系テスト | E-03: 342-391行目のファイル名メソッド群 | ○ |
| C-23 | Path.GetFullPath/GetPathRootの正常系テスト | E-03: 399-421行目のパスルートメソッド群 | ○ |
| C-24 | Path.GetTempPath/GetTempFileNameの正常系テスト | E-03: 444-478行目の一時ファイルメソッド群 | ○ |
| C-25 | Path.ChangeExtension/HasExtension/IsPathRootedの正常系テスト | E-03: 182-250行目のパス操作メソッド群 | ○ |
| C-26 | Path.GetInvalidPathChars/GetInvalidFileNameCharsの正常系テスト | E-03: 486-497行目の無効文字メソッド群 | ○ |
| C-27 | Path.DirectorySeparatorChar等の定数プロパティテスト | E-03: 61-169行目の区切り文字プロパティ群 | ○ |

### FileStreamクラス（UT-SIO-105〜UT-SIO-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | FileStream.Initの正常系/異常系テスト | E-04: コンストラクタおよびInitメソッド | ○ |
| C-29 | FileStream.CanRead/CanWrite/CanSeekの正常系テスト | E-04: プロパティ定義 | ○ |
| C-30 | FileStream.Length/Positionの正常系/異常系テスト | E-04: プロパティ定義 | ○ |
| C-31 | FileStream.ReadByte/ReadBlockの正常系/境界値テスト | E-04: 読み取りメソッド群 | ○ |
| C-32 | FileStream.WriteByte/WriteBlockの正常系/異常系テスト | E-04: 書き込みメソッド群 | ○ |
| C-33 | FileStream.SeekPositionの正常系/異常系テスト | E-04: シークメソッド | ○ |
| C-34 | FileStream.SetLength/Flush/CloseStreamの正常系/異常系テスト | E-04: ストリーム操作メソッド群 | ○ |
| C-35 | FileStream.LockStream/UnlockStreamの正常系/異常系テスト | E-04: ロックメソッド群 | ○ |
| C-36 | FileStream.BeginRead/EndRead/BeginWrite/EndWriteの正常系テスト | E-04: 非同期メソッド群 | ○ |

### MemoryStreamクラス（UT-SIO-143〜UT-SIO-181）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | MemoryStream.Initの正常系テスト（各モード） | E-05: コンストラクタおよびInitメソッド | ○ |
| C-38 | MemoryStream.CanRead/CanWrite/CanSeekの正常系テスト | E-05: プロパティ定義 | ○ |
| C-39 | MemoryStream.Capacity/Length/Positionの正常系/異常系テスト | E-05: プロパティ定義 | ○ |
| C-40 | MemoryStream.ReadByte/ReadBlock/WriteByte/WriteBlockの正常系/異常系テスト | E-05: 読み書きメソッド群 | ○ |
| C-41 | MemoryStream.SeekPosition/SetLengthの正常系/異常系テスト | E-05: シーク・長さ設定メソッド | ○ |
| C-42 | MemoryStream.ToArray/WriteTo/CopyToの正常系/異常系テスト | E-05: 変換・出力メソッド群 | ○ |

### StreamReaderクラス（UT-SIO-182〜UT-SIO-203）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | StreamReader.Initの正常系/異常系テスト | E-06: 358-371行目のInitメソッド | ○ |
| C-44 | StreamReader.BaseStream/CurrentEncodingの正常系テスト | E-06: 79-90行目のプロパティ | ○ |
| C-45 | StreamReader.EndOfStream/Peek/Readの正常系テスト | E-06: 93-162行目の読み取りメソッド群 | ○ |
| C-46 | StreamReader.ReadBlock/ReadLine/ReadToEndの正常系テスト | E-06: 172-326行目の読み取りメソッド群 | ○ |
| C-47 | StreamReader.DiscardBufferedData/CloseReaderの正常系テスト | E-06: 104-131行目のバッファ・クローズメソッド | ○ |

### StreamWriterクラス（UT-SIO-204〜UT-SIO-219）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | StreamWriter.Initの正常系テスト | E-07: コンストラクタおよびInitメソッド | ○ |
| C-49 | StreamWriter.BaseStream/Encoding/AutoFlushの正常系テスト | E-07: プロパティ定義 | ○ |
| C-50 | StreamWriter.WriteValue/WriteLineの正常系テスト | E-07: 書き込みメソッド群 | ○ |
| C-51 | StreamWriter.Flush/CloseWriter/NewLineの正常系テスト | E-07: フラッシュ・クローズ・改行メソッド | ○ |

### BinaryReaderクラス（UT-SIO-220〜UT-SIO-236）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | BinaryReader.Initの正常系テスト | E-08: コンストラクタおよびInitメソッド | ○ |
| C-53 | BinaryReader.ReadBoolean/ReadByte/ReadBytes等の正常系テスト | E-08: 各型読み取りメソッド群 | ○ |
| C-54 | BinaryReader.PeekChar/CloseReaderの正常系テスト | E-08: 先読み・クローズメソッド | ○ |

### BinaryWriterクラス（UT-SIO-237〜UT-SIO-252）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | BinaryWriter.Initの正常系テスト | E-09: コンストラクタおよびInitメソッド | ○ |
| C-56 | BinaryWriter.WriteValue（各型）の正常系テスト | E-09: 各型書き込みメソッド群 | ○ |
| C-57 | BinaryWriter.SeekPosition/Flush/CloseWriterの正常系テスト | E-09: シーク・フラッシュ・クローズメソッド | ○ |

### StringReaderクラス（UT-SIO-253〜UT-SIO-261）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | StringReader.Initの正常系テスト | E-10: コンストラクタおよびInitメソッド | ○ |
| C-59 | StringReader.Peek/Read/ReadBlock/ReadLine/ReadToEndの正常系テスト | E-10: 読み取りメソッド群 | ○ |
| C-60 | StringReader.CloseReaderの正常系テスト | E-10: クローズメソッド | ○ |

### StringWriterクラス（UT-SIO-262〜UT-SIO-269）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | StringWriter.Initの正常系テスト | E-11: コンストラクタおよびInitメソッド | ○ |
| C-62 | StringWriter.WriteValue/WriteLineの正常系テスト | E-11: 書き込みメソッド群 | ○ |
| C-63 | StringWriter.ToString/GetStringBuilder/CloseWriterの正常系テスト | E-11: 変換・取得・クローズメソッド | ○ |

### FileInfoクラス（UT-SIO-270〜UT-SIO-297）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | FileInfo.Initの正常系テスト | E-12: コンストラクタおよびInitメソッド | ○ |
| C-65 | FileInfo.Exists/Name/FullName/DirectoryName等のプロパティテスト | E-12: プロパティ定義群 | ○ |
| C-66 | FileInfo.Length/Attributes/CreationTime等のプロパティテスト | E-12: プロパティ定義群 | ○ |
| C-67 | FileInfo.Create/Delete/CopyTo/MoveToの正常系テスト | E-12: ファイル操作メソッド群 | ○ |
| C-68 | FileInfo.OpenRead/OpenWrite/OpenText等の正常系テスト | E-12: オープンメソッド群 | ○ |

### DirectoryInfoクラス（UT-SIO-298〜UT-SIO-319）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | DirectoryInfo.Initの正常系テスト | E-13: コンストラクタおよびInitメソッド | ○ |
| C-70 | DirectoryInfo.Exists/Name/FullName/Parent/Rootのプロパティテスト | E-13: プロパティ定義群 | ○ |
| C-71 | DirectoryInfo.Create/Delete/MoveToの正常系テスト | E-13: ディレクトリ操作メソッド群 | ○ |
| C-72 | DirectoryInfo.GetFiles/GetDirectories/GetFileSystemInfosの正常系テスト | E-13: 列挙メソッド群 | ○ |
| C-73 | DirectoryInfo.CreateSubdirectory/Refreshの正常系テスト | E-13: サブディレクトリ・リフレッシュメソッド | ○ |

### DriveInfoクラス（UT-SIO-320〜UT-SIO-334）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | DriveInfo.Initの正常系/異常系テスト | E-14: コンストラクタおよびInitメソッド | ○ |
| C-75 | DriveInfo.Name/DriveType/DriveFormat/IsReadyのプロパティテスト | E-14: プロパティ定義群 | ○ |
| C-76 | DriveInfo.TotalSize/TotalFreeSpace/AvailableFreeSpaceの正常系/異常系テスト | E-14: 容量プロパティ群 | ○ |
| C-77 | DriveInfo.VolumeLabel/RootDirectory/GetDrivesの正常系テスト | E-14: ラベル・ルート・列挙メソッド | ○ |

## 4) 不足情報（Unknown / Missing）
- 本テストケース一覧はソースコード解析に基づいて生成されており、根拠不足の項目はありません
- .NET Frameworkの公式ドキュメントとの整合性確認は別途推奨されます

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されています
- 注意点: VB6/VBA環境での実行時の挙動は、実際のテスト実行で確認が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] File/Directoryクラスのパス検証ロジックのテストが網羅されているか確認
- [ ] Stream系クラスのリソース解放（クローズ処理）テストが適切か確認
- [ ] エンコーディング関連のテストケースが十分か確認
- [ ] 非同期メソッド（BeginRead/EndRead等）のテストケースが適切か確認
- [ ] 境界値テスト（空配列、最大値、負値等）が網羅されているか確認
- [ ] 例外処理テストが各異常系に対して設定されているか確認
