---
generated_at: 2026-01-20 20:45:00
metrics:
  claims_total: 194
  claims_with_evidence: 194
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Numerics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべきクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：194 / 194、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコードによる根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Numerics/BigInteger.cls` - BigIntegerクラスのソースコード
- E-02: `Source/CorLib/System.Numerics/BigIntegerStatic.cls` - BigIntegerStaticクラスのソースコード
- E-03: `Source/CorLib/System.Numerics/BigNumberMath.bas` - BigNumberMath数学モジュール
- E-04: `Source/CorLib/System.Numerics/Mathematics.bas` - Mathematics汎用数学モジュール
- E-05: `Source/Tests/System.Numerics/BigIntegerTests.cls` - 既存のBigIntegerテストコード
- E-06: `Source/Tests/System.Numerics/BIntNumberStylesAllowHexSpecifierTests.cls` - 16進パーステスト
- E-07: `Source/Tests/System.Numerics/BIntParseNumberStylesComboTests.cls` - 複合NumberStylesパーステスト
- E-08: `Source/Tests/System.Numerics/BIntNumberStylesAllowExponentTests.cls` - 指数パーステスト

## 3) Claims と根拠の対応（レビューの主戦場）

### BigInteger クラス - プロパティ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Sign プロパティで符号が取得できる | E-01 (L67-69), E-05 | ○ |
| C-002 | IsZero プロパティでゼロ判定ができる | E-01 (L75-77), E-05 | ○ |
| C-003 | IsOne プロパティで1判定ができる | E-01 (L83-87), E-05 | ○ |
| C-004 | IsEven プロパティで偶数判定ができる | E-01 (L97-103), E-05 | ○ |
| C-005 | Precision プロパティでバイト精度が取得できる | E-01 (L113-130), E-05 | ○ |

### BigInteger クラス - 変換メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-006 | ToByteArray でバイト配列に変換できる | E-01 (L137-185), E-05 | ○ |
| C-007 | ToString で文字列に変換できる | E-01 (L206-208), E-05 | ○ |
| C-008 | 16進フォーマットで文字列変換できる | E-01 (L193-204), E-05 | ○ |

### BigInteger クラス - 比較メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-009 | CompareTo で比較できる | E-01 (L231-238), E-05 | ○ |
| C-010 | Equals で等価判定できる | E-01 (L248-256), E-05 | ○ |
| C-011 | GetHashCode でハッシュ値を取得できる | E-01 (L267-287), E-05 | ○ |

### BigInteger クラス - 算術演算メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-012 | Negate で符号反転できる | E-01 (L298-305), E-05 | ○ |
| C-013 | Absolute で絶対値を取得できる | E-01 (L313-319), E-05 | ○ |
| C-014 | Add で加算できる | E-01 (L337-347), E-05 | ○ |
| C-015 | Subtract で減算できる | E-01 (L370-380), E-05 | ○ |
| C-016 | Multiply で乗算できる | E-01 (L403-419), E-05 | ○ |
| C-017 | Divide で除算できる | E-01 (L442-457), E-05 | ○ |
| C-018 | DivRem で商と余りを取得できる | E-01 (L485-503), E-05 | ○ |
| C-019 | Modulus で剰余を取得できる | E-01 (L526-533), E-05 | ○ |
| C-020 | GreatestCommonDivisor で最大公約数を計算できる | E-01 (L545-547), E-05 | ○ |

### BigInteger クラス - ビット操作メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-021 | TestBit でビットをテストできる | E-01 (L557-570), E-05 | ○ |
| C-022 | SetBit でビットをセットできる | E-01 (L580-610), E-05 | ○ |
| C-023 | ClearBit でビットをクリアできる | E-01 (L618-649), E-05 | ○ |
| C-024 | FlipBit でビットを反転できる | E-01 (L686-692), E-05 | ○ |
| C-025 | BitwiseAnd でAND演算できる | E-01 (L699-707), E-05 | ○ |
| C-026 | BitwiseOr でOR演算できる | E-01 (L719-729), E-05 | ○ |
| C-027 | BitwiseXor でXOR演算できる | E-01 (L741-751), E-05 | ○ |
| C-028 | BitwiseNot でNOT演算できる | E-01 (L763-772), E-05 | ○ |
| C-029 | BitwiseAndNot でANDNOT演算できる | E-01 (L779-782), E-05 | ○ |

### BigInteger クラス - 高度な算術メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-030 | Pow でべき乗計算できる | E-01 (L789-791), E-05 | ○ |
| C-031 | ShiftRight で右シフトできる | E-01 (L799-822), E-05 | ○ |
| C-032 | ShiftLeft で左シフトできる | E-01 (L830-843), E-05 | ○ |
| C-033 | SquareRoot で平方根を計算できる | E-01 (L849-851), E-05 | ○ |
| C-034 | Min で最小値を取得できる | E-01 (L860-862), E-05 | ○ |
| C-035 | Max で最大値を取得できる | E-01 (L871-873), E-05 | ○ |
| C-036 | Factorial で階乗を計算できる | E-01 (L879-881), E-05 | ○ |

### BigInteger クラス - 初期化メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-037 | Long値から初期化できる | E-01 (L893-920), E-05 | ○ |
| C-038 | Double値から初期化できる | E-01 (L1145-1173), E-05 | ○ |
| C-039 | Currency値から初期化できる | E-01 (L1175-1181), E-05 | ○ |
| C-040 | Decimal値から初期化できる | E-01 (L1198-1214), E-05 | ○ |
| C-041 | バイト配列から初期化できる | E-01 (L1074-1143), E-05 | ○ |
| C-042 | Int64から初期化できる | E-01 (L1030-1072), E-05 | ○ |

### BigIntegerStatic クラス - 定数プロパティ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-043 | Zero でゼロインスタンスを取得できる | E-02 (L64-66), E-05 | ○ |
| C-044 | One で1インスタンスを取得できる | E-02 (L73-75), E-05 | ○ |
| C-045 | MinusOne で-1インスタンスを取得できる | E-02 (L82-84), E-05 | ○ |
| C-046 | Ten で10インスタンスを取得できる | E-02 (L91-93), E-05 | ○ |

### BigIntegerStatic クラス - パースメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-047 | TryParse で文字列をパースできる | E-02 (L157-159), E-05-08 | ○ |
| C-048 | TryParseEx でスタイル指定パースできる | E-02 (L172-190), E-05-08 | ○ |
| C-049 | Parse で文字列をパースできる | E-02 (L221-225), E-05 | ○ |

### BigIntegerStatic クラス - 静的算術メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-050 | Compare で比較できる | E-02 (L130-133), E-05 | ○ |
| C-051 | Equals で等価判定できる | E-02 (L142-145), E-05 | ○ |
| C-052 | Negate で符号反転できる | E-02 (L262-265), E-05 | ○ |
| C-053 | Absolute で絶対値を取得できる | E-02 (L275-278), E-05 | ○ |
| C-054 | Add で加算できる | E-02 (L292-295), E-05 | ○ |
| C-055 | Subtract で減算できる | E-02 (L309-312), E-05 | ○ |
| C-056 | Multiply で乗算できる | E-02 (L326-329), E-05 | ○ |
| C-057 | Divide で除算できる | E-02 (L346-349), E-05 | ○ |
| C-058 | DivRem で商と余りを取得できる | E-02 (L368-371), E-05 | ○ |
| C-059 | Modulus で剰余を取得できる | E-02 (L386-389), E-05 | ○ |
| C-060 | GreatestCommonDivisor でGCDを計算できる | E-02 (L398-417), E-05 | ○ |
| C-061 | Pow でべき乗計算できる | E-02 (L541-555), E-05 | ○ |
| C-062 | ModPow でべき乗剰余を計算できる | E-02 (L590-593), E-05 | ○ |
| C-063 | Min で最小値を取得できる | E-02 (L602-608), E-05 | ○ |
| C-064 | Max で最大値を取得できる | E-02 (L617-623), E-05 | ○ |
| C-065 | SquareRoot で平方根を計算できる | E-02 (L694-718), E-05 | ○ |
| C-066 | Factorial で階乗を計算できる | E-02 (L725-741), E-05 | ○ |

### BigIntegerStatic クラス - ビット操作メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-067 | TestBit でビットをテストできる | E-02 (L429-432), E-05 | ○ |
| C-068 | SetBit でビットをセットできる | E-02 (L443-446), E-05 | ○ |
| C-069 | ClearBit でビットをクリアできる | E-02 (L455-458), E-05 | ○ |
| C-070 | FlipBit でビットを反転できる | E-02 (L470-473), E-05 | ○ |
| C-071 | BitwiseAnd でAND演算できる | E-02 (L482-485), E-05 | ○ |
| C-072 | BitwiseOr でOR演算できる | E-02 (L494-497), E-05 | ○ |
| C-073 | BitwiseXor でXOR演算できる | E-02 (L506-509), E-05 | ○ |
| C-074 | BitwiseNot でNOT演算できる | E-02 (L517-520), E-05 | ○ |
| C-075 | BitwiseAndNot でANDNOT演算できる | E-02 (L529-532), E-05 | ○ |
| C-076 | ShiftLeft で左シフトできる | E-02 (L671-674), E-05 | ○ |
| C-077 | ShiftRight で右シフトできる | E-02 (L684-687), E-05 | ○ |

### BigIntegerStatic クラス - 乱数メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-078 | Randomize で乱数シードを設定できる | E-02 (L631-633), E-05 | ○ |
| C-079 | SeedRnd でRnd関数のシードを設定できる | E-02 (L641-643), E-05 | ○ |
| C-080 | Rnd でランダムBigIntegerを生成できる | E-02 (L651-661), E-05 | ○ |

### BigNumberMath モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-081 | Equals でBigNumber等価判定できる | E-03 (L45-60) | ○ |
| C-082 | Compare でBigNumber比較できる | E-03 (L62-84) | ○ |
| C-083 | Negate でBigNumber符号反転できる | E-03 (L86-92) | ○ |
| C-084 | Add でBigNumber加算できる | E-03 (L131-179) | ○ |
| C-085 | Subtract でBigNumber減算できる | E-03 (L187-235) | ○ |
| C-086 | Multiply でBigNumber乗算できる | E-03 (L242-257) | ○ |
| C-087 | Divide でBigNumber除算できる | E-03 (L327-330) | ○ |
| C-088 | DivRem でBigNumber除算剰余できる | E-03 (L332-334) | ○ |
| C-089 | Remainder でBigNumber剰余できる | E-03 (L336-345) | ○ |
| C-090 | BitwiseAnd でBigNumber AND演算できる | E-03 (L600-606) | ○ |
| C-091 | BitwiseOr でBigNumber OR演算できる | E-03 (L637-643) | ○ |
| C-092 | BitwiseXor でBigNumber XOR演算できる | E-03 (L666-672) | ○ |
| C-093 | BitwiseNot でBigNumber NOT演算できる | E-03 (L699-717) | ○ |
| C-094 | Rnd でBigNumber乱数生成できる | E-03 (L719-739) | ○ |
| C-095 | Normalize でBigNumber正規化できる | E-03 (L741-798) | ○ |
| C-096 | SingleInPlaceDivideBy10 で10除算できる | E-03 (L805-837) | ○ |
| C-097 | SingleInPlaceMultiply で単一値乗算できる | E-03 (L854-867/L1040-1054) | ○ |
| C-098 | SingleInPlaceAdd で単一値加算できる | E-03 (L874-887/L1056-1072) | ○ |
| C-099 | ApplyTwosComplement で2の補数変換できる | E-03 (L1006-1017/L1027-1038) | ○ |

### Mathematics モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | ShiftRightInt32 で32ビット右シフトできる | E-04 (L38-83) | ○ |
| C-101 | ShiftLeftInt32 で32ビット左シフトできる | E-04 (L100-292) | ○ |
| C-102 | ShiftRightInt64 で64ビット右シフトできる | E-04 (L85-98) | ○ |
| C-103 | RRotate で右ローテートできる | E-04 (L294-296) | ○ |
| C-104 | LRotate で左ローテートできる | E-04 (L298-300) | ○ |
| C-105 | Modulus でCurrency型剰余を計算できる | E-04 (L309-311) | ○ |
| C-106 | SwapEndian でエンディアン変換できる | E-04 (L313-319) | ○ |
| C-107 | InitMathematics で初期化できる | E-04 (L33-36) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースにソースコードによる根拠が存在

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**：全テストケースがソースコードから直接導出されており、既存テストコードとも整合性がある

## 6) レビュアーチェックリスト（最小）
- [x] 全クラス（BigInteger, BigIntegerStatic）のpublicメソッドがカバーされているか
- [x] 全モジュール（BigNumberMath, Mathematics）の主要関数がカバーされているか
- [x] 正常系・異常系・境界値のテスト観点が網羅されているか
- [x] 既存テストコード（BigIntegerTests.cls）と整合性があるか
- [x] 例外処理（DivideByZeroException, ArgumentOutOfRangeException等）のテストケースが含まれているか
- [x] 2の補数表現に関連するテストケースが含まれているか
- [x] 大きな数値（任意精度）に関するテストケースが含まれているか
