---
generated_at: 2026-01-20 20:30:00
metrics:
  claims_total: 54
  claims_with_evidence: 54
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Runtime.Serialization 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象クラスのすべてのpublicメソッド・プロパティをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：54 / 54、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Runtime.Serialization/SerializationException.cls` - SerializationExceptionクラス本体
- E-02: `Source/CorLib/System/ExceptionBase.cls` - 例外基底ヘルパークラス
- E-03: `Source/CorLib/System/Constructors.cls` (行250-252) - NewSerializationExceptionファクトリ関数
- E-04: `Source/CorLib/System/Resources.bas` (行64) - Arg_SerializationException定数定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Publicプロパティ・メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Data Property GetはIDictionaryを返す | E-01 (行59-61), E-02 (行83-89) | ○ |
| C-02 | Dataに値を追加・取得できる | E-02 (行83-89) | ○ |
| C-03 | HelpLink Property Getは初期値が空文字 | E-01 (行70-72), E-02 (行260-262) | ○ |
| C-04 | HelpLink Property Letで値を設定できる | E-01 (行81-83), E-02 (行271-273) | ○ |
| C-05 | HelpLinkに空文字を設定できる | E-01 (行81-83) | ○ |
| C-06 | HResultはCOR_E_SERIALIZATIONを返す | E-01 (行93-95) | ○ |
| C-07 | ErrorNumberはvbNotSerializableを返す | E-01 (行102-104) | ○ |
| C-08 | Source Property Getは初期値が空文字 | E-01 (行114-116), E-02 (行237-239) | ○ |
| C-09 | Source Property Letで値を設定できる | E-01 (行126-128), E-02 (行249-251) | ○ |
| C-10 | Messageはデフォルトメッセージを返す | E-01 (行140-142), E-04 | ○ |
| C-11 | Messageはカスタムメッセージを返す | E-01 (行140-142), E-03 | ○ |
| C-12 | 空メッセージ時はデフォルトにフォールバック | E-01 (行140-142) | ○ |
| C-13 | InnerException初期値はNothing | E-01 (行152-154), E-02 (行212-214) | ○ |
| C-14 | InnerExceptionを設定・取得できる | E-01 (行152-154), E-03 (行252) | ○ |
| C-15 | GetBaseExceptionはInnerExceptionなしで自身を返す | E-01 (行169-171), E-02 (行289-295) | ○ |
| C-16 | GetBaseExceptionは例外チェーンを走査する | E-02 (行289-295) | ○ |
| C-17 | GetBaseExceptionは深い例外チェーンを走査する | E-02 (行293) 再帰呼び出し | ○ |
| C-18 | ToStringは型名とメッセージを含む | E-01 (行181-183), E-02 (行311-325) | ○ |
| C-19 | ToStringはInnerExceptionの情報も含む | E-02 (行322-324) | ○ |
| C-20 | Equalsは同一インスタンスでTrueを返す | E-01 (行191-193) | ○ |
| C-21 | Equalsは異なるインスタンスでFalseを返す | E-01 (行191-193) | ○ |
| C-22 | EqualsはNothingとの比較でFalseを返す | E-01 (行191-193) | ○ |
| C-23 | Equalsは異なる型との比較でFalseを返す | E-01 (行191-193) | ○ |
| C-24 | GetHashCodeはLong値を返す | E-01 (行203-205) | ○ |
| C-25 | GetHashCodeは一貫した値を返す | E-01 (行203-205) | ○ |

### 初期化・コンストラクタ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | InitでMessage/InnerExceptionが設定される | E-01 (行215-218), E-03 (行250-252) | ○ |
| C-27 | vbNullStringメッセージでも初期化可能 | E-01 (行215-218), E-02 (行186-202) | ○ |
| C-28 | Class_InitPropertiesでExceptionBaseが初期化される | E-01 (行211-213) | ○ |

### シリアライゼーション

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Class_ReadPropertiesでPropertyBagから復元できる | E-01 (行224-226) | ○ |
| C-30 | Class_WritePropertiesでPropertyBagに保存できる | E-01 (行228-230) | ○ |
| C-31 | シリアライゼーションのラウンドトリップが機能する | E-01 (行224-230), E-02 (行371-400) | ○ |

### IObjectインターフェース実装

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | IObject_Equalsが実装されている | E-01 (行236-238) | ○ |
| C-33 | IObject_GetHashCodeが実装されている | E-01 (行240-242) | ○ |
| C-34 | IObject_ToStringが実装されている | E-01 (行244-246) | ○ |

### Exceptionインターフェース実装

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Exception_Dataが実装されている | E-01 (行252-254) | ○ |
| C-36 | Exception_ErrorNumberが実装されている | E-01 (行260-262) | ○ |
| C-37 | Exception_GetBaseExceptionが実装されている | E-01 (行264-266) | ○ |
| C-38 | Exception_HelpLink Get/Letが実装されている | E-01 (行272-278) | ○ |
| C-39 | Exception_HResultが実装されている | E-01 (行280-282) | ○ |
| C-40 | Exception_InnerExceptionが実装されている | E-01 (行284-286) | ○ |
| C-41 | Exception_Messageが実装されている | E-01 (行288-290) | ○ |
| C-42 | Exception_Source Get/Letが実装されている | E-01 (行292-298) | ○ |
| C-43 | Exception_ToStringが実装されている | E-01 (行300-302) | ○ |

### SystemExceptionインターフェース実装

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | SystemException_Dataが実装されている | E-01 (行308-310) | ○ |
| C-45 | SystemException_ErrorNumberが実装されている | E-01 (行316-318) | ○ |
| C-46 | SystemException_GetBaseExceptionが実装されている | E-01 (行320-322) | ○ |
| C-47 | SystemException_HelpLink Get/Letが実装されている | E-01 (行328-334) | ○ |
| C-48 | SystemException_HResultが実装されている | E-01 (行336-338) | ○ |
| C-49 | SystemException_InnerExceptionが実装されている | E-01 (行340-342) | ○ |
| C-50 | SystemException_Messageが実装されている | E-01 (行344-346) | ○ |
| C-51 | SystemException_Source Get/Letが実装されている | E-01 (行348-354) | ○ |
| C-52 | SystemException_ToStringが実装されている | E-01 (行356-358) | ○ |

### 全体・統合テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | PropertyBag読み込みエラー時の挙動を確認 | E-01 (行224-226) | ○ |
| C-54 | Throwで例外として使用できる | E-01 (行43-45) Implements Exception | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースに対応するソースコードの根拠が存在します

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: SerializationExceptionクラスは標準的な例外クラスパターンに従っており、ExceptionBaseへの委譲により実装が安定しています
- 注意点: HResultとErrorNumberは定数値（COR_E_SERIALIZATION, vbNotSerializable）を返すため、これらの定数値が正しく定義されていることを確認する必要があります

## 6) レビュアーチェックリスト（最小）
- [ ] COR_E_SERIALIZATION定数の値が正しいか確認
- [ ] vbNotSerializable定数の値が正しいか確認
- [ ] Arg_SerializationException (リソースID 225) のデフォルトメッセージ内容を確認
- [ ] PropertyBagへのシリアライゼーションが実際に動作するか確認（VB6ランタイム依存）
- [ ] ExceptionBaseクラスとの連携が正しく動作するか確認
- [ ] IObject, Exception, SystemExceptionインターフェースの各メソッドがPublicメソッドに正しく委譲されているか確認
