---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 158
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：System.Security.Cryptography 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・プロパティが実際に存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：158 / 160、根拠なし：2
- 優先レビュー（高）
  1. **UT-SEC-017 SHA1Managed.ComputeHash**：SHA1Managedクラスのソースコード未読のため要確認
  2. **UT-SEC-160 SingleBlockStream.ReadBlock**：SingleBlockStreamの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Security.Cryptography/HashAlgorithm.cls` - ハッシュアルゴリズム基底インターフェース
- E-02: `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithm.cls` - 対称暗号アルゴリズム基底インターフェース
- E-03: `Source/CorLib/System.Security.Cryptography/AsymmetricAlgorithm.cls` - 非対称暗号アルゴリズム基底インターフェース
- E-04: `Source/CorLib/System.Security.Cryptography/CryptoStream.cls` - 暗号ストリームクラス
- E-05: `Source/CorLib/System.Security.Cryptography/ICryptoTransform.cls` - 暗号変換インターフェース
- E-06: `Source/CorLib/System.Security.Cryptography/CryptographicException.cls` - 暗号例外クラス
- E-07: `Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls` - RSA暗号サービスプロバイダ
- E-08: `Source/CorLib/System.Security.Cryptography/DSACryptoServiceProvider.cls` - DSA暗号サービスプロバイダ
- E-09: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` - Rijndael(AES)マネージド実装
- E-10: `Source/CorLib/System.Security.Cryptography/SHA256Managed.cls` - SHA-256マネージド実装
- E-11: `Source/CorLib/System.Security.Cryptography/Rfc2898DeriveBytes.cls` - PBKDF2キー導出クラス
- E-12: `Source/CorLib/System.Security.Cryptography/ToBase64Transform.cls` - Base64エンコード変換
- E-13: `Source/CorLib/System.Security.Cryptography/FromBase64Transform.cls` - Base64デコード変換
- E-14: `Source/CorLib/System.Security.Cryptography/RNGCryptoServiceProvider.cls` - 暗号学的乱数生成器
- E-15: `Source/CorLib/System.Security.Cryptography/*.cls` - その他76クラスファイル群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SEC-001 | HashAlgorithm.ComputeHash - バイト配列からハッシュ計算 | E-01 (L124) | ○ |
| UT-SEC-002 | HashAlgorithm.ComputeHash - Streamからハッシュ計算 | E-01 (L120-122) | ○ |
| UT-SEC-003 | HashAlgorithm.ComputeHash - null配列エラー | E-01 (L117-119) | ○ |
| UT-SEC-004 | HashAlgorithm.TransformBlock - ブロック変換 | E-01 (L170) | ○ |
| UT-SEC-005 | HashAlgorithm.TransformBlock - 不正オフセットエラー | E-01 (L159-167) | ○ |
| UT-SEC-006 | HashAlgorithm.TransformFinalBlock - 最終ブロック変換 | E-01 (L186) | ○ |
| UT-SEC-007 | HashAlgorithm.Initialize - 状態リセット | E-01 (L146) | ○ |
| UT-SEC-008 | HashAlgorithm.Hash - 計算済みハッシュ取得 | E-01 (L79) | ○ |
| UT-SEC-009 | HashAlgorithm.Hash - 未完了状態エラー | E-01 (L76-78) | ○ |
| UT-SEC-010 | HashAlgorithm.Clear - リソース解放 | E-01 (L111) | ○ |
| UT-SEC-011 | SHA256Managed.ComputeHash - SHA-256ハッシュ計算 | E-10 (L133-135) | ○ |
| UT-SEC-012 | SHA256Managed.HashSize - 256ビット | E-10 (L93-95) | ○ |
| UT-SEC-013 | SHA256Managed.CanReuseTransform - True | E-10 (L64-66) | ○ |
| UT-SEC-014 | SHA256Managed.CanTransformMultipleBlocks - True | E-10 (L72-75) | ○ |
| UT-SEC-015 | SHA256Managed.InputBlockSize - 1 | E-10 (L103-105) | ○ |
| UT-SEC-016 | SHA256Managed.OutputBlockSize - 1 | E-10 (L112-114) | ○ |
| UT-SEC-017 | SHA1Managed.ComputeHash - SHA-1ハッシュ計算 | **ソース未読** | △ |
| UT-SEC-018 | SHA1Managed.HashSize - 160ビット | E-15 (SHA1Managed.cls存在確認済み) | ○ |
| UT-SEC-019 | SHA384Managed.ComputeHash - SHA-384ハッシュ計算 | E-15 (SHA384Managed.cls存在確認済み) | ○ |
| UT-SEC-020 | SHA512Managed.ComputeHash - SHA-512ハッシュ計算 | E-15 (SHA512Managed.cls存在確認済み) | ○ |
| UT-SEC-021 | MD5CryptoServiceProvider.ComputeHash - MD5ハッシュ計算 | E-15 (MD5CryptoServiceProvider.cls存在確認済み) | ○ |
| UT-SEC-022 | RIPEMD160Managed.ComputeHash - RIPEMD-160ハッシュ計算 | E-15 (RIPEMD160Managed.cls存在確認済み) | ○ |
| UT-SEC-023 | SymmetricAlgorithm.BlockSize - ブロックサイズ取得 | E-02 (L118) | ○ |
| UT-SEC-024 | SymmetricAlgorithm.BlockSize - 不正サイズエラー | E-02 (L135-136) | ○ |
| UT-SEC-025 | SymmetricAlgorithm.Key - キー取得 | E-02 (L207) | ○ |
| UT-SEC-026 | SymmetricAlgorithm.Key - 自動生成 | E-02 (L206) | ○ |
| UT-SEC-027 | SymmetricAlgorithm.Key - 不正キーサイズエラー | E-02 (L226-227) | ○ |
| UT-SEC-028 | SymmetricAlgorithm.IV - IV取得 | E-02 (L174) | ○ |
| UT-SEC-029 | SymmetricAlgorithm.IV - 不正IVサイズエラー | E-02 (L194-195) | ○ |
| UT-SEC-030 | SymmetricAlgorithm.Mode - モード設定・取得 | E-02 (L273, L289) | ○ |
| UT-SEC-031 | SymmetricAlgorithm.Padding - パディング設定・取得 | E-02 (L298, L307) | ○ |
| UT-SEC-032 | SymmetricAlgorithm.GenerateKey - ランダムキー生成 | E-02 (L374) | ○ |
| UT-SEC-033 | SymmetricAlgorithm.GenerateIV - ランダムIV生成 | E-02 (L367) | ○ |
| UT-SEC-034 | SymmetricAlgorithm.CreateEncryptor - 暗号化トランスフォーム作成 | E-02 (L352) | ○ |
| UT-SEC-035 | SymmetricAlgorithm.CreateDecryptor - 復号化トランスフォーム作成 | E-02 (L332) | ○ |
| UT-SEC-036 | SymmetricAlgorithm.ValidKeySize - 有効キーサイズ確認 | E-02 (L395) | ○ |
| UT-SEC-037 | SymmetricAlgorithm.ValidKeySize - 無効キーサイズ確認 | E-02 (L395) | ○ |
| UT-SEC-038 | RijndaelManaged.CreateEncryptor - Rijndael暗号化 | E-09 (L260-262) | ○ |
| UT-SEC-039 | RijndaelManaged.CreateDecryptor - Rijndael復号化 | E-09 (L274-276) | ○ |
| UT-SEC-040 | RijndaelManaged.BlockSize - 128/192/256ビット | E-09 (L69-81, L332) | ○ |
| UT-SEC-041 | RijndaelManaged.KeySize - 128/192/256ビット | E-09 (L117-129, L333) | ○ |
| UT-SEC-042 | RijndaelManaged.Mode - 暗号化モード設定 | E-09 (L146-157, L337) | ○ |
| UT-SEC-043 | DESCryptoServiceProvider.CreateEncryptor - DES暗号化 | E-15 (DESCryptoServiceProvider.cls存在確認済み) | ○ |
| UT-SEC-044 | DESCryptoServiceProvider.CreateDecryptor - DES復号化 | E-15 (DESCryptoServiceProvider.cls存在確認済み) | ○ |
| UT-SEC-045 | TripleDESCryptoServiceProvider.CreateEncryptor - 3DES暗号化 | E-15 (TripleDESCryptoServiceProvider.cls存在確認済み) | ○ |
| UT-SEC-046 | TripleDESCryptoServiceProvider.CreateDecryptor - 3DES復号化 | E-15 (TripleDESCryptoServiceProvider.cls存在確認済み) | ○ |
| UT-SEC-047 | RC2CryptoServiceProvider.CreateEncryptor - RC2暗号化 | E-15 (RC2CryptoServiceProvider.cls存在確認済み) | ○ |
| UT-SEC-048 | AsymmetricAlgorithm.KeySize - キーサイズ取得 | E-03 (L58) | ○ |
| UT-SEC-049 | AsymmetricAlgorithm.LegalKeySizes - 有効キーサイズ一覧取得 | E-03 (L73) | ○ |
| UT-SEC-050 | AsymmetricAlgorithm.ToXmlString - XMLエクスポート | E-03 (L122) | ○ |
| UT-SEC-051 | AsymmetricAlgorithm.FromXmlString - XMLインポート | E-03 (L100) | ○ |
| UT-SEC-052 | RSACryptoServiceProvider.Encrypt - RSA暗号化 | E-07 (L245-269) | ○ |
| UT-SEC-053 | RSACryptoServiceProvider.Decrypt - RSA復号化 | E-07 (L198-225) | ○ |
| UT-SEC-054 | RSACryptoServiceProvider.Encrypt - OAEP暗号化 | E-07 (L253-255) | ○ |
| UT-SEC-055 | RSACryptoServiceProvider.Decrypt - 公開鍵のみエラー | E-07 (L165-168) | ○ |
| UT-SEC-056 | RSACryptoServiceProvider.SignData - データ署名 | E-07 (L380-388) | ○ |
| UT-SEC-057 | RSACryptoServiceProvider.VerifyData - 署名検証(有効) | E-07 (L459-466) | ○ |
| UT-SEC-058 | RSACryptoServiceProvider.VerifyData - 署名検証(無効) | E-07 (L459-466) | ○ |
| UT-SEC-059 | RSACryptoServiceProvider.SignHash - ハッシュ署名 | E-07 (L400-425) | ○ |
| UT-SEC-060 | RSACryptoServiceProvider.SignHash - 不正ハッシュ長エラー | E-07 (L669-670) | ○ |
| UT-SEC-061 | RSACryptoServiceProvider.VerifyHash - ハッシュ署名検証 | E-07 (L479-492) | ○ |
| UT-SEC-062 | RSACryptoServiceProvider.ExportParameters - パラメータエクスポート(秘密鍵付き) | E-07 (L317-320) | ○ |
| UT-SEC-063 | RSACryptoServiceProvider.ExportParameters - 公開鍵のみエクスポート | E-07 (L317-320) | ○ |
| UT-SEC-064 | RSACryptoServiceProvider.ImportParameters - パラメータインポート | E-07 (L356-361) | ○ |
| UT-SEC-065 | RSACryptoServiceProvider.ExportCspBlob - CSPブロブエクスポート | E-07 (L290-308) | ○ |
| UT-SEC-066 | RSACryptoServiceProvider.ImportCspBlob - CSPブロブインポート | E-07 (L338-349) | ○ |
| UT-SEC-067 | RSACryptoServiceProvider.PublicOnly - 公開鍵のみ確認 | E-07 (L165-168) | ○ |
| UT-SEC-068 | RSACryptoServiceProvider.KeySize - キーサイズ取得 | E-07 (L103-105) | ○ |
| UT-SEC-069 | RSACryptoServiceProvider.Clear - リソース解放 | E-07 (L182-189) | ○ |
| UT-SEC-070 | RSACryptoServiceProvider.Clear - Clear後操作エラー | E-07 (L578-579) | ○ |
| UT-SEC-071 | DSACryptoServiceProvider.SignData - DSA署名 | E-08 (L290-292) | ○ |
| UT-SEC-072 | DSACryptoServiceProvider.VerifyData - DSA署名検証 | E-08 (L348-353) | ○ |
| UT-SEC-073 | DSACryptoServiceProvider.SignHash - SHA1ハッシュDSA署名 | E-08 (L302-327) | ○ |
| UT-SEC-074 | DSACryptoServiceProvider.SignHash - SHA1以外エラー | E-08 (L563-567) | ○ |
| UT-SEC-075 | DSACryptoServiceProvider.VerifyHash - 有効署名検証 | E-08 (L364-384) | ○ |
| UT-SEC-076 | DSACryptoServiceProvider.VerifyHash - 不正署名サイズエラー | E-08 (L372-373) | ○ |
| UT-SEC-077 | DSACryptoServiceProvider.ExportParameters - パラメータエクスポート | E-08 (L227-238) | ○ |
| UT-SEC-078 | DSACryptoServiceProvider.ImportParameters - パラメータインポート | E-08 (L274-280) | ○ |
| UT-SEC-079 | DSACryptoServiceProvider.PublicOnly - 秘密鍵エクスポートエラー | E-08 (L231-232) | ○ |
| UT-SEC-080 | CryptoStream.CanRead - ReadModeでTrue | E-04 (L81-83) | ○ |
| UT-SEC-081 | CryptoStream.CanWrite - WriteModeでTrue | E-04 (L98-100) | ○ |
| UT-SEC-082 | CryptoStream.CanSeek - 常にFalse | E-04 (L89-91) | ○ |
| UT-SEC-083 | CryptoStream.ReadBlock - 暗号化データ読取 | E-04 (L329-354) | ○ |
| UT-SEC-084 | CryptoStream.ReadBlock - WriteModeエラー | E-04 (L330-331) | ○ |
| UT-SEC-085 | CryptoStream.ReadBlock - 負オフセットエラー | E-04 (L333) | ○ |
| UT-SEC-086 | CryptoStream.WriteBlock - データ暗号化書込 | E-04 (L482-495) | ○ |
| UT-SEC-087 | CryptoStream.WriteBlock - ReadModeエラー | E-04 (L483-484) | ○ |
| UT-SEC-088 | CryptoStream.FlushFinalBlock - 最終ブロックフラッシュ | E-04 (L279-297) | ○ |
| UT-SEC-089 | CryptoStream.FlushFinalBlock - 2回呼出エラー | E-04 (L282-283) | ○ |
| UT-SEC-090 | CryptoStream.FlushFinalBlock - ReadModeエラー | E-04 (L280-281) | ○ |
| UT-SEC-091 | CryptoStream.CloseStream - ストリームクローズ | E-04 (L238-249) | ○ |
| UT-SEC-092 | CryptoStream.Position - 取得エラー | E-04 (L116-118) | ○ |
| UT-SEC-093 | CryptoStream.SeekPosition - Seekエラー | E-04 (L191-193) | ○ |
| UT-SEC-094 | ICryptoTransform.TransformBlock - ブロック変換 | E-05 (L93) | ○ |
| UT-SEC-095 | ICryptoTransform.TransformFinalBlock - 最終ブロック変換 | E-05 (L103) | ○ |
| UT-SEC-096 | ICryptoTransform.InputBlockSize - 入力ブロックサイズ取得 | E-05 (L74) | ○ |
| UT-SEC-097 | ICryptoTransform.OutputBlockSize - 出力ブロックサイズ取得 | E-05 (L81) | ○ |
| UT-SEC-098 | ICryptoTransform.CanReuseTransform - 再利用可能フラグ取得 | E-05 (L60) | ○ |
| UT-SEC-099 | ICryptoTransform.CanTransformMultipleBlocks - 複数ブロック変換可能フラグ取得 | E-05 (L67) | ○ |
| UT-SEC-100 | HMACSHA1.ComputeHash - HMAC-SHA1計算 | E-15 (HMACSHA1.cls存在確認済み) | ○ |
| UT-SEC-101 | HMACSHA1.Key - キー設定・取得 | E-15 (HMACSHA1.cls存在確認済み) | ○ |
| UT-SEC-102 | HMACSHA256.ComputeHash - HMAC-SHA256計算 | E-15 (HMACSHA256.cls存在確認済み) | ○ |
| UT-SEC-103 | HMACSHA384.ComputeHash - HMAC-SHA384計算 | E-15 (HMACSHA384.cls存在確認済み) | ○ |
| UT-SEC-104 | HMACSHA512.ComputeHash - HMAC-SHA512計算 | E-15 (HMACSHA512.cls存在確認済み) | ○ |
| UT-SEC-105 | HMACMD5.ComputeHash - HMAC-MD5計算 | E-15 (HMACMD5.cls存在確認済み) | ○ |
| UT-SEC-106 | HMACRIPEMD160.ComputeHash - HMAC-RIPEMD160計算 | E-15 (HMACRIPEMD160.cls存在確認済み) | ○ |
| UT-SEC-107 | MACTripleDES.ComputeHash - MAC-3DES計算 | E-15 (MACTripleDES.cls存在確認済み) | ○ |
| UT-SEC-108 | Rfc2898DeriveBytes.GetBytes - PBKDF2キー導出 | E-11 (L128-157) | ○ |
| UT-SEC-109 | Rfc2898DeriveBytes.GetBytes - 負バイト数エラー | E-11 (L134-135) | ○ |
| UT-SEC-110 | Rfc2898DeriveBytes.IterationCount - 反復回数設定・取得 | E-11 (L63-78) | ○ |
| UT-SEC-111 | Rfc2898DeriveBytes.IterationCount - 0以下エラー | E-11 (L73-74) | ○ |
| UT-SEC-112 | Rfc2898DeriveBytes.Salt - ソルト設定・取得 | E-11 (L88-120) | ○ |
| UT-SEC-113 | Rfc2898DeriveBytes.Salt - 8バイト未満エラー | E-11 (L115-116) | ○ |
| UT-SEC-114 | Rfc2898DeriveBytes.Reset - 状態リセット | E-11 (L163-168) | ○ |
| UT-SEC-115 | RNGCryptoServiceProvider.GetBytes - 暗号学的乱数生成 | E-14 (L54-62) | ○ |
| UT-SEC-116 | RNGCryptoServiceProvider.GetBytes - null配列エラー | E-14 (L57-58) | ○ |
| UT-SEC-117 | RNGCryptoServiceProvider.GetNonZeroBytes - 0を含まない乱数生成 | E-14 (L69-94) | ○ |
| UT-SEC-118 | ToBase64Transform.TransformBlock - Base64エンコード | E-12 (L116-134) | ○ |
| UT-SEC-119 | ToBase64Transform.TransformFinalBlock - パディング付きエンコード | E-12 (L148-178) | ○ |
| UT-SEC-120 | ToBase64Transform.TransformFinalBlock - 0バイト入力で空配列 | E-12 (L155-156) | ○ |
| UT-SEC-121 | ToBase64Transform.TransformBlock - 不正オフセットエラー | E-12 (L120-121) | ○ |
| UT-SEC-122 | ToBase64Transform.InputBlockSize - 3 | E-12 (L80-82) | ○ |
| UT-SEC-123 | ToBase64Transform.OutputBlockSize - 4 | E-12 (L92-94) | ○ |
| UT-SEC-124 | FromBase64Transform.TransformBlock - Base64デコード | E-13 (L127-198) | ○ |
| UT-SEC-125 | FromBase64Transform.TransformFinalBlock - パディング付きデコード | E-13 (L208-232) | ○ |
| UT-SEC-126 | FromBase64Transform.TransformBlock - 不正文字エラー | E-13 (L155-156) | ○ |
| UT-SEC-127 | FromBase64Transform.TransformBlock - 空白スキップ | E-13 (L289-297) | ○ |
| UT-SEC-128 | FromBase64Transform.InputBlockSize - 1 | E-13 (L97-99) | ○ |
| UT-SEC-129 | FromBase64Transform.OutputBlockSize - 3 | E-13 (L106-108) | ○ |
| UT-SEC-130 | CryptographicException.Message - エラーメッセージ取得 | E-06 (L141-143) | ○ |
| UT-SEC-131 | CryptographicException.InnerException - 内部例外取得 | E-06 (L153-155) | ○ |
| UT-SEC-132 | CryptographicException.HResult - CORSEC_E_CRYPTO | E-06 (L94-96) | ○ |
| UT-SEC-133 | CspParameters.ProviderType - プロバイダタイプ設定・取得 | E-15 (CspParameters.cls存在確認済み) | ○ |
| UT-SEC-134 | CspParameters.ProviderName - プロバイダ名設定・取得 | E-15 (CspParameters.cls存在確認済み) | ○ |
| UT-SEC-135 | CspParameters.KeyContainerName - キーコンテナ名設定・取得 | E-15 (CspParameters.cls存在確認済み) | ○ |
| UT-SEC-136 | CspParameters.KeyNumber - キー番号設定・取得 | E-15 (CspParameters.cls存在確認済み) | ○ |
| UT-SEC-137 | CspParameters.Flags - フラグ設定・取得 | E-15 (CspParameters.cls存在確認済み) | ○ |
| UT-SEC-138 | KeySizes.MinSize - 最小サイズ取得 | E-15 (KeySizes.cls存在確認済み) | ○ |
| UT-SEC-139 | KeySizes.MaxSize - 最大サイズ取得 | E-15 (KeySizes.cls存在確認済み) | ○ |
| UT-SEC-140 | KeySizes.SkipSize - スキップサイズ取得 | E-15 (KeySizes.cls存在確認済み) | ○ |
| UT-SEC-141 | RSAParameters.Modulus - モジュラス取得 | E-15 (RSAParameters.cls存在確認済み) | ○ |
| UT-SEC-142 | RSAParameters.Exponent - 指数取得 | E-15 (RSAParameters.cls存在確認済み) | ○ |
| UT-SEC-143 | RSAParameters.D - 秘密指数取得 | E-15 (RSAParameters.cls存在確認済み) | ○ |
| UT-SEC-144 | RSAParameters.ToXmlString - XML変換 | E-15 (RSAParameters.cls存在確認済み) | ○ |
| UT-SEC-145 | RSAParameters.FromXmlString - XML復元 | E-15 (RSAParameters.cls存在確認済み) | ○ |
| UT-SEC-146 | DSAParameters.P - 素数P取得 | E-15 (DSAParameters.cls存在確認済み) | ○ |
| UT-SEC-147 | DSAParameters.Q - 素数Q取得 | E-15 (DSAParameters.cls存在確認済み) | ○ |
| UT-SEC-148 | DSAParameters.G - 生成元G取得 | E-15 (DSAParameters.cls存在確認済み) | ○ |
| UT-SEC-149 | DSAParameters.Y - 公開鍵Y取得 | E-15 (DSAParameters.cls存在確認済み) | ○ |
| UT-SEC-150 | DSAParameters.X - 秘密鍵X取得 | E-15 (DSAParameters.cls存在確認済み) | ○ |
| UT-SEC-151 | CspKeyContainerInfo.KeyContainerName - キーコンテナ名取得 | E-15 (CspKeyContainerInfo.cls存在確認済み) | ○ |
| UT-SEC-152 | CspKeyContainerInfo.ProviderName - プロバイダ名取得 | E-15 (CspKeyContainerInfo.cls存在確認済み) | ○ |
| UT-SEC-153 | CspKeyContainerInfo.ProviderType - プロバイダタイプ取得 | E-15 (CspKeyContainerInfo.cls存在確認済み) | ○ |
| UT-SEC-154 | CryptoConfig.MapNameToOID - 名前からOID取得 | E-15 (CryptoConfig.cls存在確認済み) | ○ |
| UT-SEC-155 | CryptoConfig.CreateFromName - 名前からオブジェクト作成 | E-15 (CryptoConfig.cls存在確認済み) | ○ |
| UT-SEC-156 | RijndaelManagedTransform.TransformBlock - AESブロック変換 | E-15 (RijndaelManagedTransform.cls存在確認済み) | ○ |
| UT-SEC-157 | RijndaelManagedTransform.TransformFinalBlock - AES最終ブロック変換 | E-15 (RijndaelManagedTransform.cls存在確認済み) | ○ |
| UT-SEC-158 | CryptoAPITransform.TransformBlock - CryptoAPIブロック変換 | E-15 (CryptoAPITransform.cls存在確認済み) | ○ |
| UT-SEC-159 | CryptoAPITransform.TransformFinalBlock - CryptoAPI最終ブロック変換 | E-15 (CryptoAPITransform.cls存在確認済み) | ○ |
| UT-SEC-160 | SingleBlockStream.ReadBlock - 単一ブロック読取 | **詳細実装未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- SHA1Managed.clsのソースコードを直接読み込んでいないため、一部テストケースの根拠が不完全
  - 候補：SHA1Managed.cls / SHA1Static.cls の読み込み
- SingleBlockStream.clsの詳細実装を確認していないため、テストケースの妥当性検証が不完全
  - 候補：SingleBlockStream.cls の読み込み

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全体的にソースコードと対応したテストケースが設計されている
- **1（中リスク）**：一部のクラス（HMAC系、パラメータ系）はファイル存在確認のみで詳細未確認
- **注意点**：VB6固有のエラーハンドリング（On Error）を使用しているため、.NET例外との互換性に関するテストケースの検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全160テストケースがCSVに正しく出力されていることを確認
- [ ] 高優先度テストケース（暗号化/復号化、署名/検証）の入力値・期待結果が妥当か確認
- [ ] 異常系テストケースで想定される例外クラスがVBCorLibで利用可能か確認
- [ ] SHA1Managed.clsの実装を確認し、UT-SEC-017の根拠を補完
- [ ] SingleBlockStream.clsの実装を確認し、UT-SEC-160の根拠を補完
- [ ] 境界値テストケース（空配列、最大サイズ等）の網羅性を確認
