---
generated_at: 2026-01-20 21:30:00
metrics:
  claims_total: 116
  claims_with_evidence: 116
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Security 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：クラスのメソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：116 / 116、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Security/SecurityElement.cls`
- E-02: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Security/SecurityElementStatic.cls`
- E-03: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Security/XmlSyntaxException.cls`
- E-04: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/Tests/System.Security/SecurityElementTests.cls`

## 3) Claims と根拠の対応（レビューの主戦場）

### SecurityElementクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SEC-001: Tag Property Get テスト | E-01 (L147-149), E-04 (L143) | ○ |
| C-02 | UT-SEC-002: Tag Property Let 正常系 | E-01 (L157-162), E-04 (L136-145) | ○ |
| C-03 | UT-SEC-003: Tag Property Let 異常系（<） | E-01 (L158-159), E-04 (L147-155, L260-267) | ○ |
| C-04 | UT-SEC-004: Tag Property Let 異常系（>） | E-01 (L158-159), E-04 (L73-75) | ○ |
| C-05 | UT-SEC-005: Tag Property Let 異常系（スペース） | E-01 (L158-159), E-02 (L106-108) | ○ |
| C-06 | UT-SEC-006: Text Property Get 正常系 | E-01 (L169-171), E-04 (L164-165) | ○ |
| C-07 | UT-SEC-007: Text Property Get エスケープ処理 | E-01 (L170, L521-532) | ○ |
| C-08 | UT-SEC-008: Text Property Let 正常系 | E-01 (L179-184), E-04 (L164-165) | ○ |
| C-09 | UT-SEC-009: Text Property Let 異常系（<） | E-01 (L180-181), E-04 (L269-276) | ○ |
| C-10 | UT-SEC-010: Text Property Let 異常系（>） | E-01 (L180-181), E-04 (L36-42) | ○ |
| C-11 | UT-SEC-011: Attributes Property Get Nothing | E-01 (L65-74), E-04 (L141, L186-192) | ○ |
| C-12 | UT-SEC-012: Attributes Property Get 有効値 | E-01 (L65-74), E-04 (L202-214) | ○ |
| C-13 | UT-SEC-013: Attributes Property Set Nothing | E-01 (L82-103), E-04 (L186-192) | ○ |
| C-14 | UT-SEC-014: Attributes Property Set 空Hashtable | E-01 (L85-86), E-04 (L194-200) | ○ |
| C-15 | UT-SEC-015: Attributes Property Set 有効値 | E-01 (L82-103), E-04 (L202-214) | ○ |
| C-16 | UT-SEC-016: Attributes Property Set 無効キー | E-01 (L92-93), E-04 (L216-225) | ○ |
| C-17 | UT-SEC-017: Attributes Property Set 無効値 | E-01 (L94-95), E-04 (L227-236) | ○ |
| C-18 | UT-SEC-018: Children Property Get Nothing | E-01 (L118-120), E-04 (L343-350) | ○ |
| C-19 | UT-SEC-019: Children Property Get 有効値 | E-01 (L118-120), E-04 (L352-362) | ○ |
| C-20 | UT-SEC-020: Children Property Set 正常系 | E-01 (L127-140), E-04 (L352-362) | ○ |
| C-21 | UT-SEC-021: Children Property Set Null子要素 | E-01 (L130-136), E-04 (L364-373) | ○ |
| C-22 | UT-SEC-022: AddAttribute 正常系 | E-01 (L192-211), E-04 (L278-284) | ○ |
| C-23 | UT-SEC-023: AddAttribute 無効名 | E-01 (L197-198), E-04 (L286-293) | ○ |
| C-24 | UT-SEC-024: AddAttribute 無効値 | E-01 (L199-200), E-04 (L295-302) | ○ |
| C-25 | UT-SEC-025: AddAttribute 重複名 | E-01 (L202-207), E-04 (L304-312) | ○ |
| C-26 | UT-SEC-026: AddChild 正常系 | E-01 (L218-227), E-04 (L384-391) | ○ |
| C-27 | UT-SEC-027: AddChild Nothing | E-01 (L219-220), E-04 (L375-382) | ○ |
| C-28 | UT-SEC-028: GetAttribute 正常系 | E-01 (L236-252), E-04 (L323-331) | ○ |
| C-29 | UT-SEC-029: GetAttribute 存在しない属性 | E-01 (L237-251), E-04 (L314-321) | ○ |
| C-30 | UT-SEC-030: GetAttribute エスケープ処理 | E-01 (L244-247), E-04 (L333-341) | ○ |
| C-31 | UT-SEC-031: Copy 浅いコピー | E-01 (L259-262), E-04 (L563-575) | ○ |
| C-32 | UT-SEC-032: Copy 属性・子要素含む | E-01 (L259-262, L508-515), E-04 (L577-594) | ○ |
| C-33 | UT-SEC-033: SearchForChildByTag 発見 | E-01 (L272-284), E-04 (L656-664) | ○ |
| C-34 | UT-SEC-034: SearchForChildByTag 子なし | E-01 (L273-275), E-04 (L637-644) | ○ |
| C-35 | UT-SEC-035: SearchForChildByTag 不一致 | E-01 (L277-283), E-04 (L646-654) | ○ |
| C-36 | UT-SEC-036: SearchForTextOfTag 自身一致 | E-01 (L295-298), E-04 (L605-613) | ○ |
| C-37 | UT-SEC-037: SearchForTextOfTag 子一致 | E-01 (L300-305), E-04 (L615-623) | ○ |
| C-38 | UT-SEC-038: SearchForTextOfTag 孫一致 | E-01 (L308-327), E-04 (L625-635) | ○ |
| C-39 | UT-SEC-039: SearchForTextOfTag 子なし | E-01 (L300-301), E-04 (L596-603) | ○ |
| C-40 | UT-SEC-040: Equal 同一内容 | E-01 (L336-349), E-04 (L393-403) | ○ |
| C-41 | UT-SEC-041: Equal 異なるタグ | E-01 (L339-340), E-04 (L84-87) | ○ |
| C-42 | UT-SEC-042: Equal 異なるテキスト | E-01 (L341-342), E-04 (L84-87) | ○ |
| C-43 | UT-SEC-043: Equal 異なる属性数 | E-01 (L351-372), E-04 (L405-425) | ○ |
| C-44 | UT-SEC-044: Equal 同一属性 | E-01 (L351-372), E-04 (L440-450) | ○ |
| C-45 | UT-SEC-045: Equal 異なる属性名 | E-01 (L363-366), E-04 (L452-462) | ○ |
| C-46 | UT-SEC-046: Equal 異なる属性値 | E-01 (L363-366), E-04 (L464-474) | ○ |
| C-47 | UT-SEC-047: Equal 属性順序異なる | E-01 (L363-366), E-04 (L476-488) | ○ |
| C-48 | UT-SEC-048: Equal 異なる子数 | E-01 (L374-397), E-04 (L490-523) | ○ |
| C-49 | UT-SEC-049: Equal 同一子要素 | E-01 (L374-397), E-04 (L525-535) | ○ |
| C-50 | UT-SEC-050: Equal 異なる子要素 | E-01 (L374-397), E-04 (L537-547) | ○ |
| C-51 | UT-SEC-051: Equal Nothing比較 | E-01 (L337-338) | ○ |
| C-52 | UT-SEC-052: ToString タグのみ | E-01 (L430-456), E-04 (L685-693) | ○ |
| C-53 | UT-SEC-053: ToString タグとテキスト | E-01 (L430-456), E-04 (L695-703) | ○ |
| C-54 | UT-SEC-054: ToString 属性含む | E-01 (L458-475), E-04 (L705-715) | ○ |
| C-55 | UT-SEC-055: ToString 子要素含む | E-01 (L477-482), E-04 (L717-728) | ○ |
| C-56 | UT-SEC-056: Init 正常系 | E-01 (L498-506), E-04 (L157-166) | ○ |
| C-57 | UT-SEC-057: Init 無効タグ | E-01 (L499-500), E-04 (L168-176) | ○ |
| C-58 | UT-SEC-058: Init 無効テキスト | E-01 (L501-502), E-04 (L178-184) | ○ |
| C-59 | UT-SEC-059: Equals 同一インスタンス | E-01 (L407-409) | ○ |
| C-60 | UT-SEC-060: GetHashCode | E-01 (L419-421) | ○ |

### SecurityElementStaticクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | UT-SEC-061: Escape & | E-02 (L68-97), E-04 (L66, L128-134) | ○ |
| C-62 | UT-SEC-062: Escape < | E-02 (L82-83), E-04 (L62, L128-134) | ○ |
| C-63 | UT-SEC-063: Escape > | E-02 (L84-85), E-04 (L63, L128-134) | ○ |
| C-64 | UT-SEC-064: Escape " | E-02 (L86-87), E-04 (L64, L128-134) | ○ |
| C-65 | UT-SEC-065: Escape ' | E-02 (L88-89), E-04 (L65, L128-134) | ○ |
| C-66 | UT-SEC-066: Escape 不要文字列 | E-02 (L90-91), E-04 (L67, L128-134) | ○ |
| C-67 | UT-SEC-067: IsValidTag 有効名 | E-02 (L106-108), E-04 (L29, L96-102) | ○ |
| C-68 | UT-SEC-068: IsValidTag < | E-02 (L106-108), E-04 (L30, L96-102) | ○ |
| C-69 | UT-SEC-069: IsValidTag > | E-02 (L106-108), E-04 (L31, L96-102) | ○ |
| C-70 | UT-SEC-070: IsValidTag スペース | E-02 (L106-108), E-04 (L32, L96-102) | ○ |
| C-71 | UT-SEC-071: IsValidTag 空文字 | E-02 (L106-108), E-04 (L33, L96-102) | ○ |
| C-72 | UT-SEC-072: IsValidTag vbNullString | E-02 (L106-108), E-04 (L34, L96-102) | ○ |
| C-73 | UT-SEC-073: IsValidText 有効値 | E-02 (L117-119), E-04 (L39, L104-110) | ○ |
| C-74 | UT-SEC-074: IsValidText < | E-02 (L117-119), E-04 (L37, L104-110) | ○ |
| C-75 | UT-SEC-075: IsValidText > | E-02 (L117-119), E-04 (L38, L104-110) | ○ |
| C-76 | UT-SEC-076: IsValidText スペース | E-02 (L117-119), E-04 (L40, L104-110) | ○ |
| C-77 | UT-SEC-077: IsValidText 空文字 | E-02 (L117-119), E-04 (L41, L104-110) | ○ |
| C-78 | UT-SEC-078: IsValidText vbNullString | E-02 (L117-119), E-04 (L42, L104-110) | ○ |
| C-79 | UT-SEC-079: IsValidAttributeName 有効名 | E-02 (L128-130), E-04 (L45, L112-118) | ○ |
| C-80 | UT-SEC-080: IsValidAttributeName < | E-02 (L128-130), E-04 (L46, L112-118) | ○ |
| C-81 | UT-SEC-081: IsValidAttributeName > | E-02 (L128-130), E-04 (L47, L112-118) | ○ |
| C-82 | UT-SEC-082: IsValidAttributeName スペース | E-02 (L128-130), E-04 (L48, L112-118) | ○ |
| C-83 | UT-SEC-083: IsValidAttributeName 空文字 | E-02 (L128-130), E-04 (L49, L112-118) | ○ |
| C-84 | UT-SEC-084: IsValidAttributeName vbNullString | E-02 (L128-130), E-04 (L50, L112-118) | ○ |
| C-85 | UT-SEC-085: IsValidAttributeValue 有効値 | E-02 (L139-141), E-04 (L56, L120-126) | ○ |
| C-86 | UT-SEC-086: IsValidAttributeValue < | E-02 (L139-141), E-04 (L53, L120-126) | ○ |
| C-87 | UT-SEC-087: IsValidAttributeValue > | E-02 (L139-141), E-04 (L54, L120-126) | ○ |
| C-88 | UT-SEC-088: IsValidAttributeValue " | E-02 (L139-141), E-04 (L55, L120-126) | ○ |
| C-89 | UT-SEC-089: IsValidAttributeValue スペース | E-02 (L139-141), E-04 (L57, L120-126) | ○ |
| C-90 | UT-SEC-090: IsValidAttributeValue 空文字 | E-02 (L139-141), E-04 (L58, L120-126) | ○ |
| C-91 | UT-SEC-091: IsValidAttributeValue vbNullString | E-02 (L139-141), E-04 (L59, L120-126) | ○ |
| C-92 | UT-SEC-092: FromString 有効XML | E-02 (L149-158), E-04 (L767-789) | ○ |
| C-93 | UT-SEC-093: FromString 属性付きXML | E-02 (L332-358), E-04 (L770-776) | ○ |
| C-94 | UT-SEC-094: FromString 子要素付きXML | E-02 (L283-299), E-04 (L770-789) | ○ |
| C-95 | UT-SEC-095: FromString エスケープXML | E-02 (L301-330), E-04 (L800-820) | ○ |
| C-96 | UT-SEC-096: FromString 空文字 | E-02 (L150-151), E-04 (L90, L759-765) | ○ |
| C-97 | UT-SEC-097: FromString タグなし | E-02 (L175-176), E-04 (L91, L759-765) | ○ |
| C-98 | UT-SEC-098: FromString シングルクォート | E-02 (L375-417), E-04 (L791-798) | ○ |

### XmlSyntaxExceptionクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | UT-SEC-099: Message Property Get | E-03 (L140-142) | ○ |
| C-100 | UT-SEC-100: HResult Property Get | E-03 (L93-95) | ○ |
| C-101 | UT-SEC-101: ErrorNumber Property Get | E-03 (L102-104) | ○ |
| C-102 | UT-SEC-102: Source Property Get/Let | E-03 (L114-128) | ○ |
| C-103 | UT-SEC-103: HelpLink Property Get/Let | E-03 (L70-83) | ○ |
| C-104 | UT-SEC-104: Data Property Get | E-03 (L59-61) | ○ |
| C-105 | UT-SEC-105: InnerException Property Get | E-03 (L152-154) | ○ |
| C-106 | UT-SEC-106: GetBaseException | E-03 (L169-171) | ○ |
| C-107 | UT-SEC-107: ToString | E-03 (L181-183) | ○ |
| C-108 | UT-SEC-108: Init 行番号とメッセージ | E-03 (L215-227) | ○ |
| C-109 | UT-SEC-109: Init 行番号のみ | E-03 (L217-219) | ○ |
| C-110 | UT-SEC-110: Init メッセージのみ | E-03 (L221-223) | ○ |
| C-111 | UT-SEC-111: Equals | E-03 (L191-193) | ○ |
| C-112 | UT-SEC-112: GetHashCode | E-03 (L203-205) | ○ |
| C-113 | UT-SEC-113: SecurityElement シリアライズ読込 | E-01 (L538-545), E-04 (L666-683) | ○ |
| C-114 | UT-SEC-114: SecurityElement シリアライズ書込 | E-01 (L547-554), E-04 (L666-683) | ○ |
| C-115 | UT-SEC-115: XmlSyntaxException シリアライズ読込 | E-03 (L233-235) | ○ |
| C-116 | UT-SEC-116: XmlSyntaxException シリアライズ書込 | E-03 (L237-239) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースがソースコードまたは既存テストコードに基づいて生成されています）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードと既存テストコードの両方から根拠を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] SecurityElementクラスの全パブリックメソッド・プロパティがカバーされているか確認
- [ ] SecurityElementStaticクラスの全パブリックメソッドがカバーされているか確認
- [ ] XmlSyntaxExceptionクラスの例外機能がカバーされているか確認
- [ ] バリデーションロジックの境界値テストが適切か確認
- [ ] エスケープ/アンエスケープ処理のテストが網羅的か確認
- [ ] XMLパース関連の異常系テストが十分か確認
