---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 122
  claims_with_evidence: 118
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：System.Text 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：118 / 122、根拠なし：4
- 優先レビュー（高）
  1. **UT-TXT-109〜112**: Encoder/Decoderの状態維持テスト - 実装詳細の確認が必要
  2. **UT-TXT-113〜118**: EncodingStatic関連テスト - Staticクラスの実装確認が必要
  3. **UT-TXT-064**: ThrowOnInvalidBytes動作 - 例外フォールバックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Text/StringBuilder.cls` - StringBuilderクラス実装
- E-02: `Source/CorLib/System.Text/Encoding.cls` - Encodingインターフェース定義
- E-03: `Source/CorLib/System.Text/UTF8Encoding.cls` - UTF-8エンコーディング実装
- E-04: `Source/CorLib/System.Text/ASCIIEncoding.cls` - ASCIIエンコーディング実装
- E-05: `Source/CorLib/System.Text/UnicodeEncoding.cls` - UTF-16エンコーディング実装
- E-06: `Source/CorLib/System.Text/EncoderFallback.cls` - EncoderFallbackインターフェース
- E-07: `Source/CorLib/System.Text/DecoderFallback.cls` - DecoderFallbackインターフェース
- E-08: `Source/CorLib/System.Text/EncoderReplacementFallback.cls` - 置換フォールバック実装
- E-09: `Source/CorLib/System.Text/DecoderReplacementFallback.cls` - 置換フォールバック実装
- E-10: `Source/CorLib/System.Text/EncodingStatic.cls` - Encoding静的メソッド
- E-11: `Source/CorLib/System.Text/EncodingInfo.cls` - エンコーディング情報クラス
- E-12: `Source/CorLib/System.Text/Encoder.cls` - Encoderインターフェース
- E-13: `Source/CorLib/System.Text/Decoder.cls` - Decoderインターフェース
- E-14: `Source/CorLib/System.Text/UTF8Encoder.cls` - UTF-8 Encoder実装
- E-15: `Source/CorLib/System.Text/UTF8Decoder.cls` - UTF-8 Decoder実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-44 | StringBuilder各メソッドのテストケース | E-01 | ○ |
| C-45〜C-54 | Encoding基本機能テストケース | E-02 | ○ |
| C-55〜C-73 | UTF8Encoding固有機能テストケース | E-03 | ○ |
| C-74〜C-83 | ASCIIEncoding固有機能テストケース | E-04 | ○ |
| C-84〜C-95 | UnicodeEncoding固有機能テストケース | E-05 | ○ |
| C-96〜C-99 | EncoderFallback/DecoderFallback基本テスト | E-06, E-07 | ○ |
| C-100〜C-104 | EncoderReplacementFallbackテストケース | E-08 | ○ |
| C-105〜C-108 | DecoderReplacementFallbackテストケース | E-09 | ○ |
| C-109〜C-110 | Encoder状態維持テストケース | E-12, E-14 | △ |
| C-111〜C-112 | Decoder状態維持テストケース | E-13, E-15 | △ |
| C-113〜C-118 | EncodingStaticテストケース | E-10 | △ |
| C-119〜C-122 | EncodingInfoテストケース | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Encoder/Decoderの状態維持テスト（C-109〜C-112）**: 状態維持の具体的な実装詳細（PrevChar, LastByteなど）の確認が必要
  - 候補：UTF8Encoder.cls / UTF8Decoder.cls / UnicodeEncoder.cls / UnicodeDecoder.cls の詳細分析
- **EncodingStatic（C-113〜C-118）**: EncodingStatic.cls の実装を詳細に確認していないため、プロパティの正確な動作を確認する必要がある
  - 候補：EncodingStatic.cls / EncodingTable.cls の詳細分析

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - StringBuilder関連（UT-TXT-001〜044）: ソースコードから直接確認可能
- **0: 低リスク** - Encoding基本機能（UT-TXT-045〜054）: インターフェース定義から明確
- **0: 低リスク** - 各Encoding固有機能（UT-TXT-055〜095）: 実装コードから直接確認可能
- **1: 中リスク** - Fallback関連（UT-TXT-096〜108）: フォールバック動作の詳細確認推奨
- **1: 中リスク** - Encoder/Decoder状態維持（UT-TXT-109〜112）: 状態管理の複雑さから追加検証推奨
- **0: 低リスク** - EncodingStatic/EncodingInfo（UT-TXT-113〜122）: 標準的なファクトリパターン

## 6) レビュアーチェックリスト（最小）
- [ ] StringBuilderの境界値テスト（Capacity, Length）が網羅されているか確認
- [ ] UTF-8の各バイトシーケンス（1〜4バイト）のテストが適切か確認
- [ ] サロゲートペア処理のテストが正常系/異常系ともに含まれているか確認
- [ ] Fallbackの例外モードと置換モードの両方がテストされているか確認
- [ ] BigEndian/LittleEndianの両方のテストが含まれているか確認
- [ ] Encoder/Decoderの状態維持テストが実際の分割呼び出しシナリオを反映しているか確認
- [ ] 実際のVBCorLibテストコード（Source/Tests/System.Text/）との整合性を確認
