---
generated_at: 2026-01-20 20:30:00
metrics:
  claims_total: 205
  claims_with_evidence: 197
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：System単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：197 / 205、根拠なし：8
- 優先レビュー（高）
  1. **UT-SYS-012 CorDateTime.AddMonths**：閏年処理の詳細な実装確認が必要
  2. **UT-SYS-013 CorDateTime.AddYears**：閏年処理の詳細な実装確認が必要
  3. **UT-SYS-069 Environment.SetEnvironmentVariable**：レジストリ操作の詳細確認が必要
  4. **UT-SYS-099 Environment.Is64BitOperatingSystem**：Win32API呼び出しの検証が必要
  5. **UT-SYS-027 Guid.NewGuid**：GUID生成アルゴリズムの詳細確認が必要
  6. **UT-SYS-188〜205 Console系**：コンソールハンドル取得の実行環境依存性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/CorArray.cls` - 配列操作クラス（Find, Exists, BinarySearch, Sort等のメソッド確認）
- E-02: `Source/CorLib/System/CorDateTime.cls` - 日時操作クラス（Add系メソッド、プロパティ確認）
- E-03: `Source/CorLib/System/TimeSpan.cls` - 時間間隔クラス（Total系プロパティ、Duration、Negate確認）
- E-04: `Source/CorLib/System/Guid.cls` - GUIDクラス（ToByteArray、ToString各フォーマット確認）
- E-05: `Source/CorLib/System/Version.cls` - バージョンクラス（CompareTo、比較演算子実装確認）
- E-06: `Source/CorLib/System/Buffer.cls` - バッファ操作クラス（BlockCopy、GetByte、SetByte確認）
- E-07: `Source/CorLib/System/Random.cls` - 乱数生成クラス（NextLong、NextRange、NextBytes、NextDouble確認）
- E-08: `Source/CorLib/System/BitConverter.cls` - ビット変換クラス
- E-09: `Source/CorLib/System/Environment.cls` - 環境情報クラス
- E-10: `Source/CorLib/System/Exception.cls` - 例外基底インターフェース
- E-11: `Source/CorLib/System/Convert.cls` - 型変換クラス
- E-12: `Source/CorLib/System/Char.cls` - 文字操作クラス
- E-13: `Source/CorLib/System/ArgumentException.cls` - 引数例外クラス（Message、ParamName、InnerException確認）
- E-14: `Source/CorLib/System/ExceptionBase.cls` - 例外基底ヘルパークラス（Data、SetValue、GetValue確認）
- E-15: `Source/CorLib/System/Console.cls` - コンソールクラス（WriteLine、Read、SetCursorPosition、色設定等確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CorArray.Copyメソッドが配列コピーを行う | E-01 | ○ |
| C-02 | CorArray.Copyで未初期化配列時にArgumentNullExceptionをスロー | E-01 | ○ |
| C-03 | CorArray.Lengthメソッドが配列長を返す | E-01 | ○ |
| C-04 | CorArray.Reverseメソッドが配列を逆順にする | E-01 | ○ |
| C-05 | CorArray.IndexOfメソッドが要素インデックスを返す | E-01 | ○ |
| C-06 | CorDateTime.Nowプロパティが現在日時を返す | E-02 | ○ |
| C-07 | CorDateTime.AddDaysメソッドが日数加算を行う | E-02 | ○ |
| C-08 | CorDateTime.AddMonthsメソッドが月加算を行う（閏年考慮） | E-02 | △ |
| C-09 | CorDateTime.AddYearsメソッドが年加算を行う（閏年考慮） | E-02 | △ |
| C-10 | CorDateTime.Subtractメソッドが日時差分を返す | E-02 | ○ |
| C-11 | CorDateTime.Year/Month/Dayプロパティが日付要素を返す | E-02 | ○ |
| C-12 | CorDateTime.CompareToメソッドが比較結果を返す | E-02 | ○ |
| C-13 | CorDateTime.Equalsメソッドが等価比較を行う | E-02 | ○ |
| C-14 | TimeSpan.TotalDays/Hours/Minutes/Secondsプロパティが総単位を返す | E-03 | ○ |
| C-15 | TimeSpan.Add/Subtractメソッドが加減算を行う | E-03 | ○ |
| C-16 | TimeSpan.Negateメソッドが符号反転を行う | E-03 | ○ |
| C-17 | Guid.NewGuidメソッドが新しいGUIDを生成する | E-04 | ○ |
| C-18 | Guid.ToStringメソッドがGUID文字列を返す（D/B/N/P/X形式） | E-04 | ○ |
| C-19 | Guid.Parseメソッドが文字列からGUIDを生成する | E-04 | ○ |
| C-20 | Guid.Parseで不正文字列時にFormatExceptionをスロー | E-04 | ○ |
| C-21 | Version.Major/Minor/Build/Revisionプロパティがバージョン要素を返す | E-05 | ○ |
| C-22 | Version.CompareToメソッドがバージョン比較を行う | E-05 | ○ |
| C-23 | Version.ToStringメソッドがバージョン文字列を返す | E-05 | ○ |
| C-24 | Version.Cloneメソッドがクローンを作成する | E-05 | ○ |
| C-25 | Version.Initで負の値時にArgumentOutOfRangeExceptionをスロー | E-05 | ○ |
| C-26 | Buffer.BlockCopyメソッドがバイト配列コピーを行う | E-06 | ○ |
| C-27 | Buffer.ByteLengthメソッドが配列バイト長を返す | E-06 | ○ |
| C-28 | Buffer.GetByte/SetByteメソッドがバイト操作を行う | E-06 | ○ |
| C-29 | Random.NextLongメソッドが範囲内乱数を返す | E-07 | ○ |
| C-30 | Random.NextRangeメソッドが指定範囲乱数を返す | E-07 | ○ |
| C-31 | Random.NextBytesメソッドが配列を乱数で埋める | E-07 | ○ |
| C-32 | Random.NextDoubleメソッドが0-1の乱数を返す | E-07 | ○ |
| C-33 | BitConverter.GetBytesメソッドが値をバイト配列に変換する | E-08 | ○ |
| C-34 | BitConverter.ToInt32/ToDouble/ToBooleanメソッドがバイト配列から値に変換する | E-08 | ○ |
| C-35 | BitConverter.ToStringメソッドが16進数文字列を返す | E-08 | ○ |
| C-36 | BitConverter.DoubleToInt64Bits/Int64BitsToDoubleメソッドがビット変換を行う | E-08 | ○ |
| C-37 | Environment.MachineName/UserNameプロパティがシステム情報を返す | E-09 | ○ |
| C-38 | Environment.GetEnvironmentVariableメソッドが環境変数値を返す | E-09 | ○ |
| C-39 | Environment.SetEnvironmentVariableメソッドが環境変数を設定する | E-09 | △ |
| C-40 | Environment.ExpandEnvironmentVariablesメソッドが環境変数を展開する | E-09 | ○ |
| C-41 | Environment.GetFolderPathメソッドが特殊フォルダパスを返す | E-09 | ○ |
| C-42 | Environment.Is64BitOperatingSystemプロパティが64ビット判定を返す | E-09 | △ |
| C-43 | Exception.Messageプロパティがエラーメッセージを返す | E-10 | ○ |
| C-44 | Exception.InnerExceptionプロパティが内部例外を返す | E-10 | ○ |
| C-45 | Exception.GetBaseExceptionメソッドが基底例外を返す | E-10 | ○ |
| C-46 | Convert.ToBase64Stringメソッドがバイト配列をBase64文字列に変換する | E-11 | ○ |
| C-47 | Convert.FromBase64Stringメソッドが文字列をバイト配列に変換する | E-11 | ○ |
| C-48 | Convert.ToDateTimeメソッドがCorDateTimeに変換する | E-11 | ○ |
| C-49 | Char.IsWhiteSpaceメソッドが空白判定を行う | E-12 | ○ |
| C-50 | Char.Compare/Equalsメソッドが文字比較を行う | E-12 | ○ |
| C-51 | Char.IsHighSurrogate/IsLowSurrogateメソッドがサロゲート判定を行う | E-12 | ○ |
| C-52 | Char.MinValue/MaxValueプロパティが文字範囲定数を返す | E-12 | ○ |
| C-53 | CorArray.Exists/Find/FindIndex/FindAllメソッドがコールバック検索を行う | E-01 | ○ |
| C-54 | CorArray.TrueForAllメソッドが全要素判定を行う | E-01 | ○ |
| C-55 | CorArray.BinarySearchメソッドが二分探索を行う | E-01 | ○ |
| C-56 | CorArray.Sort/SortEx/SortKeyメソッドがソートを行う | E-01 | ○ |
| C-57 | CorArray.Clear/CreateInstance/IsNull/IsNullOrEmptyメソッドが配列操作を行う | E-01 | ○ |
| C-58 | CorDateTime.Hour/Minute/Second/Millisecondプロパティが時刻要素を返す | E-02 | ○ |
| C-59 | CorDateTime.DayOfWeek/DayOfYearプロパティが曜日・通算日を返す | E-02 | ○ |
| C-60 | CorDateTime.Add/AddHours/AddMinutes/AddSeconds/AddMillisecondsメソッドが時刻加算を行う | E-02 | ○ |
| C-61 | CorDateTime.ToOADate/ToFileTime/ToLocalTime/ToUniversalTimeメソッドが変換を行う | E-02 | ○ |
| C-62 | CorDateTime.DateOnly/TimeOfDayプロパティが日付・時刻部分を抽出する | E-02 | ○ |
| C-63 | TimeSpan.Days/Hours/Minutes/Seconds/Millisecondsプロパティが各部分を返す | E-03 | ○ |
| C-64 | TimeSpan.Duration/CompareTo/Equalsメソッドが絶対値・比較を行う | E-03 | ○ |
| C-65 | Guid.ToByteArrayメソッドがバイト配列を返す | E-04 | ○ |
| C-66 | Guid.Init（バイト配列）メソッドがバイト配列からGUIDを初期化する | E-04 | ○ |
| C-67 | Version.LessThanOrEqualTo/GreaterThanOrEqualTo/NotEqualToメソッドが比較を行う | E-05 | ○ |
| C-68 | ArgumentException.Message/ParamName/InnerExceptionプロパティが例外情報を返す | E-13 | ○ |
| C-69 | ArgumentException.GetBaseException/ToStringメソッドが例外処理を行う | E-13 | ○ |
| C-70 | ExceptionBase.Data/SetValue/GetValueメソッドが追加データを管理する | E-14 | ○ |
| C-71 | Console.WriteLine/WriteValueメソッドが出力を行う | E-15 | ○ |
| C-72 | Console.Read/ReadLine/ReadKeyメソッドが入力を読み取る | E-15 | ○ |
| C-73 | Console.Clear/SetCursorPositionメソッドが画面操作を行う | E-15 | ○ |
| C-74 | Console.ForegroundColor/BackgroundColorプロパティが色設定を行う | E-15 | ○ |
| C-75 | Console.Title/SetWindowSize/SetBufferSizeメソッドがウィンドウ設定を行う | E-15 | △ |
| C-76 | Console.Beepメソッドがビープ音を再生する | E-15 | ○ |
| C-77 | Console.KeyAvailable/ResetColorメソッドがキー判定・色リセットを行う | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- **閏年処理の詳細実装**：CorDateTime.AddMonths/AddYearsの閏年処理ロジックの詳細な実装確認が必要
  - 候補：CorDateTime.cls内部実装 / .NET Framework仕様書 / テスト実行による検証
- **レジストリ操作の詳細**：Environment.SetEnvironmentVariableのレジストリ操作時の権限確認が必要
  - 候補：Win32Native.bas / Windows Registry API仕様
- **Is64BitOperatingSystem実装**：IsWow64Process APIの呼び出し結果の解釈確認が必要
  - 候補：kernel32.dll仕様 / MSDN API Reference
- **コンソールハンドル取得**：Console.SetWindowSize/SetBufferSizeのコンソール非存在時の動作確認が必要
  - 候補：Console.cls内部実装 / Win32 Console API仕様

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接確認可能（CorArray、TimeSpan、Version、Buffer、Random等）
- **1: 中リスク** - 日時計算（閏年処理）はエッジケースでの動作検証が必要（CorDateTime.AddMonths/AddYears）
- **1: 中リスク** - 環境依存のテスト（Environment系）は実行環境による差異に注意
- **1: 中リスク** - コンソール操作（Console系）はコンソールウィンドウの有無により動作が異なる可能性
- **0: 低リスク** - 基本的な型変換・比較機能はソースコードで明確に確認可能
- **0: 低リスク** - 例外クラス（ArgumentException、ExceptionBase）の動作はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CorDateTime.AddMonths/AddYearsの閏年処理が.NET Frameworkと同等か確認
- [ ] Environment.SetEnvironmentVariableのレジストリ操作権限を確認
- [ ] Is64BitOperatingSystemが32ビットプロセス上で正しく動作するか確認
- [ ] Guid.NewGuidが十分なエントロピーを持つか確認
- [ ] Buffer.BlockCopyのオーバーラップコピー動作を確認
- [ ] Random乱数生成の分布が均一かサンプリング確認
- [ ] Convert.FromBase64Stringの無効文字処理が仕様通りか確認
- [ ] CorArray.BinarySearchの戻り値（ビット反転した挿入位置）が正しいか確認
- [ ] Console系メソッドがコンソールウィンドウ非存在時に適切なエラーを返すか確認
- [ ] Version.ToStringのFieldCount引数の境界値処理を確認
- [ ] ArgumentException.Messageにパラメータ名が適切に付加されるか確認
