---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 1
  claims_with_evidence: 1
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：1 / 1、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/` - VBCorLibメインソースコード（System.IO, System.Collections, System.Text, System.Security.Cryptography, System.Globalization, System.Resources等）
- E-02: `Source/CorLib/CorLib.vbp` - VB6プロジェクトファイル
- E-03: `Source/CorLib/System.IO/*.cls` - ファイル入出力関連クラス
- E-04: `Source/CorLib/System.Resources/*.cls` - リソース管理クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本プロジェクトには帳票出力機能（Crystal Reports, DataReport, PDF出力, Excel出力等）が存在しない | E-01, E-02, E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 本プロジェクトはVBCorLibという.NET FrameworkのCorLib相当の機能をVB6で実装したユーティリティライブラリであり、帳票機能は設計上含まれていない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票機能が存在しないことはソースコード調査により確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] VBCorLibの目的（.NET CorLibのVB6移植）を理解し、帳票機能が範囲外であることを確認
- [ ] プロジェクト内に帳票関連キーワード（Crystal, Report, Print, PDF, Excel）が機能として存在しないことを確認

---

## 補足：VBCorLibの概要

本プロジェクト（VBCorLib）は、.NET FrameworkのSystem名前空間配下のクラスをVisual Basic 6.0に移植したオープンソースライブラリです。

### 提供機能
- **System**: 基本型、例外、日時処理、GUID等
- **System.IO**: ファイル・ストリーム操作
- **System.Collections**: ArrayList, Hashtable, Queue, Stack等
- **System.Text**: 文字列操作、エンコーディング
- **System.Security.Cryptography**: 暗号化アルゴリズム
- **System.Globalization**: カルチャー、カレンダー
- **System.Resources**: リソースファイル管理
- **System.Numerics**: BigInteger等

### 帳票機能について
帳票出力（Crystal Reports, ActiveReports, DataReport, PDF/Excel生成等）は本ライブラリの目的・範囲外であり、実装されていません。
