---
generated_at: 2026-01-20 17:15:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべての業務要件にソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要説明
- E-02: `Source/CorLib/README.TXT` - バージョン履歴と機能一覧
- E-03: `Source/CorLib/System.Collections/*.cls` - コレクションクラス群（40ファイル）
- E-04: `Source/CorLib/System.Security.Cryptography/*.cls` - 暗号化クラス群（76ファイル）
- E-05: `Source/CorLib/System.Text/*.cls` - テキストエンコーディングクラス群（43ファイル）
- E-06: `Source/CorLib/System.IO/*.cls` - ファイル/ストリームクラス群（35ファイル）
- E-07: `Source/CorLib/System/*.cls` - 基本システムクラス群（95ファイル）
- E-08: `Source/CorLib/System.Globalization/*.cls` - グローバリゼーションクラス群（28ファイル）
- E-09: `Source/CorLib/System.Numerics/*.cls` - 数値計算クラス群（2ファイル）
- E-10: `Source/CorLib/System.Resources/*.cls` - リソース管理クラス群（31ファイル）
- E-11: `Source/CorLib/Microsoft.Win32/*.cls` - レジストリ操作クラス群（3ファイル）
- E-12: `Source/CorLib/System.Threading/*.cls` - スレッド関連クラス群（4ファイル）
- E-13: `Source/CorLib/System.IO.MemoryMappedFiles/*.cls` - メモリマップトファイルクラス群
- E-14: `Source/CorLib/System.Security/*.cls` - セキュリティ基盤クラス群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 動的リスト管理機能（ArrayList） | E-03: ArrayList.cls | ○ |
| C-02 | スタックデータ構造機能 | E-03: Stack.cls | ○ |
| C-03 | キューデータ構造機能 | E-03: Queue.cls | ○ |
| C-04 | ハッシュテーブル管理機能 | E-03: Hashtable.cls | ○ |
| C-05 | ソート済みリスト管理機能 | E-03: SortedList.cls | ○ |
| C-06 | ビット配列操作機能 | E-03: BitArray.cls | ○ |
| C-07 | 対称鍵暗号化機能（AES/Rijndael） | E-04: Rijndael.cls, RijndaelManaged.cls | ○ |
| C-08 | 対称鍵暗号化機能（DES） | E-04: DES.cls, DESCryptoServiceProvider.cls | ○ |
| C-09 | 対称鍵暗号化機能（TripleDES） | E-04: TripleDES*.cls | ○ |
| C-10 | 対称鍵暗号化機能（RC2） | E-04: RC2*.cls | ○ |
| C-11 | 非対称鍵暗号化機能（RSA） | E-04: RSA.cls, RSACryptoServiceProvider.cls | ○ |
| C-12 | デジタル署名機能（DSA） | E-04: DSA*.cls | ○ |
| C-13 | SHA-1ハッシュ計算機能 | E-04: SHA1.cls, SHA1Managed.cls | ○ |
| C-14 | SHA-256ハッシュ計算機能 | E-04: SHA256.cls, SHA256Managed.cls | ○ |
| C-15 | SHA-384ハッシュ計算機能 | E-04: SHA384.cls, SHA384Managed.cls | ○ |
| C-16 | SHA-512ハッシュ計算機能 | E-04: SHA512.cls, SHA512Managed.cls | ○ |
| C-17 | MD5ハッシュ計算機能 | E-04: MD5*.cls | ○ |
| C-18 | RIPEMD-160ハッシュ計算機能 | E-04: RIPEMD160.cls, RIPEMD160Managed.cls | ○ |
| C-19 | HMAC認証コード生成機能 | E-04: HMAC*.cls | ○ |
| C-20 | パスワード派生鍵生成機能 | E-04: Rfc2898DeriveBytes.cls | ○ |
| C-21 | UTF-8エンコーディング機能 | E-05: UTF8Encoding.cls | ○ |
| C-22 | UTF-7エンコーディング機能 | E-05: UTF7Encoding.cls | ○ |
| C-23 | UTF-16エンコーディング機能 | E-05: UnicodeEncoding.cls | ○ |
| C-24 | UTF-32エンコーディング機能 | E-05: UTF32Encoding.cls | ○ |
| C-25 | ASCIIエンコーディング機能 | E-05: ASCIIEncoding.cls | ○ |
| C-26 | コードページエンコーディング機能 | E-05: SBCSCodePageEncoding.cls, DBCSCodePageEncoding.cls | ○ |
| C-27 | 文字列ビルダー機能 | E-05: StringBuilder.cls | ○ |
| C-28 | 文字列比較機能 | E-07: StringComparer*.cls | ○ |
| C-29 | 文字列ユーティリティ機能 | E-07: CorString.cls | ○ |
| C-30 | ファイル読み書き機能 | E-06: File.cls, FileInfo.cls, FileStream.cls | ○ |
| C-31 | ディレクトリ操作機能 | E-06: Directory.cls, DirectoryInfo.cls | ○ |
| C-32 | パス操作機能 | E-06: Path.cls, PathHelper.cls | ○ |
| C-33 | ドライブ情報取得機能 | E-06: DriveInfo.cls | ○ |
| C-34 | メモリストリーム機能 | E-06: MemoryStream.cls | ○ |
| C-35 | ファイルストリーム機能 | E-06: FileStream.cls | ○ |
| C-36 | バイナリリーダー/ライター機能 | E-06: BinaryReader.cls, BinaryWriter.cls | ○ |
| C-37 | テキストリーダー/ライター機能 | E-06: StreamReader.cls, StreamWriter.cls, StringReader.cls, StringWriter.cls | ○ |
| C-38 | 暗号ストリーム機能 | E-04: CryptoStream.cls | ○ |
| C-39 | メモリマップトファイル機能 | E-13: MemoryMappedFile*.cls | ○ |
| C-40 | 日付時刻管理機能 | E-07: CorDateTime.cls | ○ |
| C-41 | 時間間隔管理機能 | E-07: TimeSpan.cls | ○ |
| C-42 | タイムゾーン管理機能 | E-07: TimeZone.cls | ○ |
| C-43 | カルチャ情報管理機能 | E-08: CultureInfo.cls | ○ |
| C-44 | 数値書式情報機能 | E-08: NumberFormatInfo.cls | ○ |
| C-45 | 日時書式情報機能 | E-08: DateTimeFormatInfo.cls | ○ |
| C-46 | グレゴリオ暦機能 | E-08: GregorianCalendar.cls | ○ |
| C-47 | ユリウス暦機能 | E-08: JulianCalendar.cls | ○ |
| C-48 | 和暦機能 | E-08: JapaneseCalendar.cls | ○ |
| C-49 | ヘブライ暦機能 | E-08: HebrewCalendar.cls | ○ |
| C-50 | イスラム暦機能 | E-08: HijriCalendar.cls | ○ |
| C-51 | 韓国暦機能 | E-08: KoreanCalendar.cls | ○ |
| C-52 | 台湾暦機能 | E-08: TaiwanCalendar.cls | ○ |
| C-53 | タイ仏暦機能 | E-08: ThaiBuddhistCalendar.cls | ○ |
| C-54 | 大整数演算機能 | E-09: BigInteger.cls | ○ |
| C-55 | 64ビット整数機能 | E-07: Int64*.cls | ○ |
| C-56 | 乱数生成機能 | E-07: Random.cls, E-04: RNGCryptoServiceProvider.cls | ○ |
| C-57 | 数学関数機能 | E-07: CorMath（モジュール） | ○ |
| C-58 | 配列ユーティリティ機能 | E-07: CorArray.cls | ○ |
| C-59 | バイト配列変換機能 | E-07: BitConverter（モジュール） | ○ |
| C-60 | リソース読み込み機能 | E-10: ResourceReader.cls, WinResourceReader.cls | ○ |
| C-61 | リソース書き込み機能 | E-10: ResourceWriter.cls | ○ |
| C-62 | リソースマネージャー機能 | E-10: ResourceManager.cls, ResourceSet.cls | ○ |
| C-63 | 画像リソースエンコード・デコード機能 | E-10: IconResource*.cls, CursorResource*.cls, BitmapResource*.cls | ○ |
| C-64 | レジストリ操作機能 | E-11: Registry.cls, RegistryKey.cls | ○ |
| C-65 | コンソール入出力機能 | E-07: Console.cls, ConsoleStream.cls | ○ |
| C-66 | 例外階層管理機能 | E-07: Exception.cls, ExceptionBase.cls | ○ |
| C-67 | 引数例外機能 | E-07: ArgumentException.cls, ArgumentNullException.cls, ArgumentOutOfRangeException.cls | ○ |
| C-68 | IO例外機能 | E-06: IOException.cls, FileNotFoundException.cls, DirectoryNotFoundException.cls | ○ |
| C-69 | 書式例外機能 | E-07: FormatException.cls | ○ |
| C-70 | 操作例外機能 | E-07: InvalidOperationException.cls, InvalidCastException.cls, ObjectDisposedException.cls | ○ |
| C-71 | オブジェクト基底インターフェース機能 | E-07: IObject.cls | ○ |
| C-72 | 比較可能インターフェース機能 | E-07: IComparable.cls, E-03: IComparer.cls | ○ |
| C-73 | 複製可能インターフェース機能 | E-07: ICloneable.cls | ○ |
| C-74 | 書式設定可能インターフェース機能 | E-07: IFormattable.cls, IFormatProvider.cls | ○ |
| C-75 | GUID生成・操作機能 | E-07: Guid.cls, GuidStatic.cls, GuidParser.cls | ○ |
| C-76 | バージョン管理機能 | E-07: Version.cls | ○ |
| C-77 | 環境情報取得機能 | E-07: Environment（モジュール）, OperatingSystem.cls | ○ |
| C-78 | スレッド制御機能 | E-12: Thread.cls, WaitHandle.cls | ○ |
| C-79 | 時間計測機能 | E-12: Ticker.cls | ○ |
| C-80 | Base64変換機能 | E-07: Convert, E-04: FromBase64Transform.cls, ToBase64Transform.cls | ○ |
| C-81 | データ型変換機能 | E-07: Convert（モジュール） | ○ |
| C-82 | INIファイル操作機能 | E-06: IniFile.cls, IniResourceWriter.cls | ○ |
| C-83 | セキュリティ要素機能 | E-14: SecurityElement.cls | ○ |
| C-84 | 暗号化構成機能 | E-04: CryptoConfig.cls | ○ |
| C-85 | CSP鍵コンテナ管理機能 | E-04: CspKeyContainerInfo.cls | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての業務要件に対してソースコード根拠が存在するため、不足情報はありません。
- 注意点：本プロジェクトはVB6ライブラリであるため、業務アプリケーションとしての業務要件ではなく、ライブラリとしての技術要件・機能要件を抽出しています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての要件にソースコード根拠あり
- 確認推奨事項：
  - カレンダー機能（C-46〜C-53）：各カレンダーの実装精度と適用範囲の確認
  - 暗号化機能（C-07〜C-20）：セキュリティ要件との整合性確認
  - スレッド機能（C-78）：VB6環境でのスレッド制限の理解

## 6) レビュアーチェックリスト（最小）
- [ ] README.mdの機能説明と業務要件一覧の対応を確認
- [ ] 各名前空間のクラス数と業務要件の網羅性を確認
- [ ] 優先度（高/中/低）の妥当性を確認
- [ ] .NET Framework互換性の観点から機能仕様を確認
- [ ] テストコード（Source/Tests/）との対応を確認
