---
generated_at: 2026-01-20 12:00:00
metrics:
  claims_total: 110
  claims_with_evidence: 108
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：108 / 110、根拠なし：2
- 優先レビュー（高）
  1. **Thread機能の詳細**：VB6でのスレッド操作の制限により実装詳細が不明確
  2. **WaitHandle機能の詳細**：同期機能の完全な実装範囲が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要説明（コレクション、暗号化、ハッシュ、エンコーディング、BigInteger、コンソール等の機能記載）
- E-02: `Source/CorLib/System/CorArray.cls` - 配列操作クラスの実装
- E-03: `Source/CorLib/System/CorString.cls` - 文字列操作クラスの実装
- E-04: `Source/CorLib/System.Collections/ArrayList.cls` - 動的リストの実装
- E-05: `Source/CorLib/System.IO/FileStream.cls` - ファイルストリームの実装
- E-06: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` - Rijndael暗号の実装
- E-07: `Source/CorLib/System.Text/UTF8Encoding.cls` - UTF8エンコーディングの実装
- E-08: `Source/CorLib/System.Numerics/BigInteger.cls` - 大整数演算の実装
- E-09: `Source/CorLib/System.Globalization/CultureInfo.cls` - カルチャ情報の実装
- E-10: `Source/CorLib/System/Console.cls` - コンソール機能の実装
- E-11: `Source/CorLib/System.Resources/ResourceManager.cls` - リソース管理の実装
- E-12: `Source/CorLib/Microsoft.Win32/RegistryKey.cls` - レジストリ操作の実装
- E-13: `Source/CorLib/System.Threading/Thread.cls` - スレッド操作クラス
- E-14: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedFile.cls` - メモリマップトファイル
- E-15: ディレクトリ構造 `Source/CorLib/` - 名前空間ごとのクラスファイル一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CorArray - 配列操作メソッドの提供 | E-02 | ○ |
| C-02 | CorString - 文字列操作関数の提供 | E-03 | ○ |
| C-03 | CorDateTime - 日付時刻の表現 | E-15 | ○ |
| C-04 | TimeSpan - 時間間隔の表現 | E-15 | ○ |
| C-05 | TimeZone - タイムゾーン情報 | E-15 | ○ |
| C-06 | Guid - GUID操作 | E-15 | ○ |
| C-07 | Version - バージョン番号管理 | E-15 | ○ |
| C-08 | Environment - システム環境情報 | E-15 | ○ |
| C-09 | OperatingSystem - OS情報 | E-15 | ○ |
| C-10 | Console - コンソール入出力 | E-10 | ○ |
| C-11 | Random - 乱数生成 | E-15 | ○ |
| C-12 | BitConverter - データ型変換 | E-15 | ○ |
| C-13 | Convert - 型変換・Base64 | E-01, E-15 | ○ |
| C-14 | CorMath - 数学関数 | E-15 | ○ |
| C-15 | Buffer - バイト操作 | E-15 | ○ |
| C-16 | Char - 文字操作 | E-15 | ○ |
| C-17 | StringBuilder - 文字列構築 | E-15 | ○ |
| C-18 | ArrayList - 動的リスト | E-01, E-04 | ○ |
| C-19 | Stack - LIFOコレクション | E-01, E-15 | ○ |
| C-20 | Queue - FIFOコレクション | E-01, E-15 | ○ |
| C-21 | Hashtable - ハッシュテーブル | E-01, E-15 | ○ |
| C-22 | SortedList - ソート済みリスト | E-15 | ○ |
| C-23 | BitArray - ビット配列 | E-15 | ○ |
| C-24 | Comparer - 比較機能 | E-15 | ○ |
| C-25 | EqualityComparer - 等価比較 | E-15 | ○ |
| C-26 | FileStream - ファイルストリーム | E-05 | ○ |
| C-27 | MemoryStream - メモリストリーム | E-15 | ○ |
| C-28 | StreamReader - テキスト読込 | E-15 | ○ |
| C-29 | StreamWriter - テキスト書込 | E-15 | ○ |
| C-30 | BinaryReader - バイナリ読込 | E-15 | ○ |
| C-31 | BinaryWriter - バイナリ書込 | E-15 | ○ |
| C-32 | StringReader - 文字列読込 | E-15 | ○ |
| C-33 | StringWriter - 文字列書込 | E-15 | ○ |
| C-34 | File - ファイル操作 | E-15 | ○ |
| C-35 | Directory - ディレクトリ操作 | E-15 | ○ |
| C-36 | FileInfo - ファイル情報 | E-15 | ○ |
| C-37 | DirectoryInfo - ディレクトリ情報 | E-15 | ○ |
| C-38 | DriveInfo - ドライブ情報 | E-15 | ○ |
| C-39 | Path - パス操作 | E-15 | ○ |
| C-40 | IniFile - INIファイル操作 | E-15 | ○ |
| C-41 | IniResourceWriter - INIリソース書込 | E-15 | ○ |
| C-42 | Encoding - エンコーディング基底 | E-01, E-15 | ○ |
| C-43 | UTF8Encoding - UTF8 | E-07 | ○ |
| C-44 | UTF7Encoding - UTF7 | E-01, E-15 | ○ |
| C-45 | UTF32Encoding - UTF32 | E-01, E-15 | ○ |
| C-46 | UnicodeEncoding - UTF16 | E-01, E-15 | ○ |
| C-47 | ASCIIEncoding - ASCII | E-15 | ○ |
| C-48 | StringBuilder - 文字列ビルダー | E-15 | ○ |
| C-49 | RijndaelManaged - Rijndael暗号 | E-01, E-06 | ○ |
| C-50 | DESCryptoServiceProvider - DES | E-01, E-15 | ○ |
| C-51 | TripleDESCryptoServiceProvider - 3DES | E-01, E-15 | ○ |
| C-52 | RC2CryptoServiceProvider - RC2 | E-15 | ○ |
| C-53 | RSACryptoServiceProvider - RSA | E-01, E-15 | ○ |
| C-54 | DSACryptoServiceProvider - DSA | E-15 | ○ |
| C-55 | SHA1Managed - SHA1ハッシュ | E-01, E-15 | ○ |
| C-56 | SHA256Managed - SHA256ハッシュ | E-01, E-15 | ○ |
| C-57 | SHA384Managed - SHA384ハッシュ | E-01, E-15 | ○ |
| C-58 | SHA512Managed - SHA512ハッシュ | E-01, E-15 | ○ |
| C-59 | MD5CryptoServiceProvider - MD5 | E-01, E-15 | ○ |
| C-60 | RIPEMD160Managed - RIPEMD160 | E-01, E-15 | ○ |
| C-61 | HMACSHA1 - HMAC認証 | E-01, E-15 | ○ |
| C-62 | HMACSHA256 - HMAC認証 | E-15 | ○ |
| C-63 | HMACSHA384 - HMAC認証 | E-15 | ○ |
| C-64 | HMACSHA512 - HMAC認証 | E-15 | ○ |
| C-65 | HMACMD5 - HMAC認証 | E-15 | ○ |
| C-66 | HMACRIPEMD160 - HMAC認証 | E-15 | ○ |
| C-67 | MACTripleDES - MAC | E-15 | ○ |
| C-68 | RNGCryptoServiceProvider - 暗号乱数 | E-15 | ○ |
| C-69 | Rfc2898DeriveBytes - 鍵導出 | E-15 | ○ |
| C-70 | CryptoStream - 暗号ストリーム | E-15 | ○ |
| C-71 | ToBase64Transform - Base64変換 | E-15 | ○ |
| C-72 | FromBase64Transform - Base64変換 | E-15 | ○ |
| C-73 | CultureInfo - カルチャ情報 | E-09 | ○ |
| C-74 | DateTimeFormatInfo - 日付書式 | E-15 | ○ |
| C-75 | NumberFormatInfo - 数値書式 | E-15 | ○ |
| C-76 | GregorianCalendar - グレゴリオ暦 | E-15 | ○ |
| C-77 | JulianCalendar - ユリウス暦 | E-15 | ○ |
| C-78 | JapaneseCalendar - 和暦 | E-15 | ○ |
| C-79 | HebrewCalendar - ヘブライ暦 | E-15 | ○ |
| C-80 | HijriCalendar - イスラム暦 | E-15 | ○ |
| C-81 | KoreanCalendar - 韓国暦 | E-15 | ○ |
| C-82 | TaiwanCalendar - 台湾暦 | E-15 | ○ |
| C-83 | ThaiBuddhistCalendar - タイ仏暦 | E-15 | ○ |
| C-84 | BigInteger - 大整数演算 | E-01, E-08 | ○ |
| C-85 | ResourceManager - リソース管理 | E-11 | ○ |
| C-86 | ResourceReader - リソース読込 | E-15 | ○ |
| C-87 | ResourceWriter - リソース書込 | E-15 | ○ |
| C-88 | ResourceSet - リソースセット | E-15 | ○ |
| C-89 | WinResourceReader - Win32リソース | E-15 | ○ |
| C-90 | Registry - レジストリアクセス | E-15 | ○ |
| C-91 | RegistryKey - レジストリキー操作 | E-12 | ○ |
| C-92 | Thread - スレッド操作 | E-13 | △ |
| C-93 | Ticker - タイマー機能 | E-15 | ○ |
| C-94 | WaitHandle - 同期待機 | E-15 | △ |
| C-95 | MemoryMappedFile - メモリマップ | E-14 | ○ |
| C-96 | MemoryMappedViewAccessor | E-15 | ○ |
| C-97 | MemoryMappedViewStream | E-15 | ○ |
| C-98 | Exception - 例外基底 | E-15 | ○ |
| C-99 | ArgumentException - 引数例外 | E-15 | ○ |
| C-100 | ArgumentNullException | E-15 | ○ |
| C-101 | ArgumentOutOfRangeException | E-15 | ○ |
| C-102 | InvalidOperationException | E-15 | ○ |
| C-103 | FormatException | E-15 | ○ |
| C-104 | OverflowException | E-15 | ○ |
| C-105 | NotSupportedException | E-15 | ○ |
| C-106 | IOException | E-15 | ○ |
| C-107 | FileNotFoundException | E-15 | ○ |
| C-108 | DirectoryNotFoundException | E-15 | ○ |
| C-109 | PathTooLongException | E-15 | ○ |
| C-110 | CryptographicException | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Thread機能の詳細実装**：VB6の制限によりマルチスレッドの完全な実装が困難なため、実際の機能範囲が不明確
  - 候補：ソースコード詳細解析 / 公式ドキュメント / テストコード
- **WaitHandle機能の詳細実装**：同期プリミティブの完全な実装範囲が不明確
  - 候補：ソースコード詳細解析 / テストコード

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：ほとんどの機能はソースコードファイルの存在により確認可能
- 1（中リスク）：Thread/WaitHandle関連機能はVB6の制限により実装範囲が限定的である可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 各カテゴリの機能数が妥当か確認
- [ ] System.Security.Cryptography配下の暗号化機能がREADMEの記載と一致するか確認
- [ ] 各機能の説明と備考が実際のクラスのコメントと整合するか確認
- [ ] Thread/WaitHandle機能の実際の動作範囲を確認
- [ ] 2GB超ファイルのサポート（READMEに記載）がFileStream機能として実装されているか確認
