# 機能設計書 1-CorArray

## 概要

本ドキュメントは、VBCorLibライブラリにおける配列操作機能（CorArray）の設計を記述する。CorArrayクラスは、VB6/VBAの配列に対して.NET Frameworkの`System.Array`クラスに相当する高度な操作機能を提供する静的クラスである。

### 本機能の処理概要

CorArrayクラスは、配列の作成、操作、検索、ソートのための包括的なメソッド群を提供する。

**業務上の目的・背景**：VB6/VBAの標準的な配列操作は機能が限られており、複雑な配列処理を行う際にはカスタムコードが必要となる。CorArrayは.NET Frameworkのような高度な配列操作機能をVB6/VBA環境で利用可能にし、開発効率と品質の向上を目的としている。これにより、配列のソート、検索、コピー、フィルタリングなどの一般的な操作を標準化されたAPIで実行できる。

**機能の利用シーン**：データ処理において配列を扱う全ての場面で利用される。具体的には、データベースから取得したレコードセットの配列変換後の処理、CSVファイルから読み込んだデータの配列操作、ユーザー入力データの一括検証・ソート、レポート生成時のデータ整形などの場面で活用される。

**主要な処理内容**：
1. 配列要素の検索（IndexOf、LastIndexOf、Find、FindIndex、BinarySearch）
2. 配列のソート（Sort、SortEx、SortKey、SortKeyEx - クイックソートアルゴリズム）
3. 配列のコピー（Copy、CopyEx - 型変換を含む）
4. 配列の反転（Reverse）
5. 配列のクリア（Clear）
6. 配列の生成（CreateInstance）
7. 配列情報の取得（Length、GetLength、Rank、IsNull、IsNullOrEmpty）
8. コールバック関数を使用した高度な検索・操作（Exists、FindAll、FindLast、FindLastIndex、TrueForAll、ForEach）

**関連システム・外部連携**：外部システムとの連携はない。VB6ランタイムのSafeArray構造体を直接操作し、低レベルなメモリ操作を行うことで高速な処理を実現している。Windows APIの`CopyMemory`、`SafeArrayCreate`、`SafeArrayCopyData`等を使用。

**権限による制御**：権限による制御は行わない。全てのメソッドは同一の動作を行う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラスである |

## 機能種別

計算処理 / データ操作ユーティリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Arr | Variant(Array) | Yes | 操作対象の配列 | 配列型でなければエラー |
| Value | Variant | No | 検索・比較対象の値 | メソッドにより異なる |
| Index | Long | No | 開始インデックス | 配列の境界内であること |
| Length/Count | Long | No | 処理する要素数 | 0以上であること |
| Comparer | IComparer/Long | No | 比較オブジェクトまたはコールバックアドレス | IComparerインターフェースまたはAddressOf |
| AddressOfPredicate | Long | No | 条件判定のコールバック関数アドレス | 有効な関数アドレス |

### 入力データソース

呼び出し元からパラメータとして渡される配列データ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 検索結果インデックス | Long | 検索メソッドの戻り値。見つからない場合はLBound-1 |
| 検索結果要素 | Variant | Find/FindLastの戻り値。見つからない場合はデフォルト値 |
| 配列長 | Long | Length/GetLengthの戻り値 |
| 次元数 | Long | Rankの戻り値 |
| 真偽値 | Boolean | IsNull/IsNullOrEmpty/Exists/TrueForAllの戻り値 |
| フィルタ結果配列 | Variant(Array) | FindAllの戻り値 |
| 生成配列 | Variant(Array) | CreateInstanceの戻り値 |

### 出力先

呼び出し元への戻り値、または参照渡しパラメータへの代入

## 処理フロー

### 処理シーケンス

```
1. パラメータ検証
   └─ 配列型チェック、境界チェック、Null/初期化チェック
2. SafeArray構造体の取得
   └─ SAPtrV関数でSafeArrayポインタを取得
3. 各種操作の実行
   └─ メソッドに応じた処理（検索、ソート、コピー等）
4. 結果の返却
   └─ 戻り値または参照パラメータへの設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{配列パラメータの検証}
    B -->|無効| C[例外をスロー]
    B -->|有効| D[SafeArrayポインタ取得]
    D --> E{処理種別}
    E -->|検索| F[インデックス検索処理]
    E -->|ソート| G[クイックソート実行]
    E -->|コピー| H[要素コピー処理]
    E -->|その他| I[対応処理実行]
    F --> J[結果返却]
    G --> J
    H --> J
    I --> J
    J --> K[終了]
    C --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 配列境界の尊重 | LBound/UBoundを尊重し、0ベースを強制しない | 全てのメソッド |
| BR-02 | 検索失敗時の戻り値 | 検索に失敗した場合、LBound-1を返す | IndexOf、LastIndexOf、FindIndex、FindLastIndex |
| BR-03 | ソートの安定性 | クイックソートを使用（不安定ソート） | Sort系メソッド |
| BR-04 | 型変換の実行 | Copyメソッドで異なる型の配列間コピー時に自動型変換 | Copy、CopyEx |

### 計算ロジック

**BinarySearch戻り値の計算**
- 値が見つかった場合: そのインデックスを返す
- 値が見つからない場合: `(Not (挿入位置 - LBound)) + LBound` を返す

**配列長の計算（多次元配列）**
- 各次元の要素数を乗算して総要素数を算出

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本機能はデータベース操作を行わない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentNullException | 引数エラー | 配列がNullまたは未初期化 | 初期化された配列を渡す |
| ArgumentException | 引数エラー | 配列型以外が渡された | 配列型の変数を渡す |
| ArgumentOutOfRangeException | 範囲エラー | インデックスまたはLengthが範囲外 | 有効な範囲を指定 |
| RankException | 次元エラー | コピー元と先の次元数が異なる | 同じ次元数の配列を使用 |
| ArrayTypeMismatchException | 型不一致 | 互換性のない型間でのコピー | 互換性のある型を使用 |
| InvalidCastException | キャストエラー | 型変換に失敗 | 変換可能な値を使用 |
| InvalidOperationException | 操作エラー | 比較処理でエラー発生 | Comparerの実装を確認 |

### リトライ仕様

リトライは行わない。エラー発生時は即座に例外をスロー。

## トランザクション仕様

本機能はトランザクション管理を行わない。配列操作はメモリ上で直接実行される。

## パフォーマンス要件

- ソート処理: クイックソートアルゴリズム使用（平均O(n log n)）
- 二分探索: O(log n)
- 線形検索: O(n)
- メモリ操作の最適化: CopyMemoryによる高速コピー
- 要素サイズに応じたスワップ関数の選択（1, 2, 4, 8, 16バイト）

## セキュリティ考慮事項

- 低レベルメモリ操作を行うため、不正なポインタ操作によるメモリ破損の可能性
- コールバック関数アドレスの検証は行わない（呼び出し元の責任）

## 備考

- VB6のSafeArray構造体を直接操作することで高速な処理を実現
- GUIDを使用してオブジェクト配列とUDT配列を正しく処理
- IRecordInfoインターフェースを使用してUDTのコピーを実現

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SafeArray関連の構造体とヘルパー型を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 52-61行目: GuidSafeArray1d、ArrayInfo構造体の定義を確認 |

**読解のコツ**: VB6のType文で定義されるUDT（ユーザー定義型）がSafeArray構造体のラッパーとして機能している点に注目。

#### Step 2: エントリーポイントを理解する

各パブリックメソッドがエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 86-88行目: Exists - FindIndexを使用した存在確認 |
| 2-2 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 112-121行目: Find - FindIndexとVariantCopyIndの組み合わせ |
| 2-3 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 491-494行目: BinarySearch - 二分探索の外部インターフェース |

**主要処理フロー**:
1. **86行目**: Existsメソッド - FindIndexの戻り値とLBoundを比較して存在判定
2. **151-184行目**: FindIndex - コールバック関数を使用した要素検索
3. **491-494行目**: BinarySearch - InternalBinarySearchへの委譲

#### Step 3: ソート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 1114-1119行目: Sort - SortKeyExへの委譲 |
| 3-2 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 1213-1294行目: SortKeyEx - メインソート処理 |

**主要処理フロー**:
- **1242-1280行目**: Comparerの型に応じたソート戦略の選択
- **1262行目**: QuickSortGeneralの呼び出し

#### Step 4: コピー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 641-648行目: Copy - CopyExへの委譲 |
| 4-2 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 707-778行目: CopyEx - 型判定と処理分岐 |
| 4-3 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 1412-1422行目: CopyValueTypes - 値型の高速コピー |
| 4-4 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 1426-1475行目: CopyReferenceTypes - 参照型のコピー |

**主要処理フロー**:
- **743-778行目**: 同一型か異なる型かで処理を分岐
- **1556-1634行目**: GetAssigningFunction - 型変換関数の取得

#### Step 5: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 1344-1359行目: LengthCore - 配列長の計算 |
| 5-2 | CorArray.cls | `Source/CorLib/System/CorArray.cls` | 1643-1647行目: GetArrayInfo - SafeArray情報の取得 |

### プログラム呼び出し階層図

```
CorArray (Public Methods)
    │
    ├─ Exists
    │      └─ FindIndex
    │             ├─ ValidateArray
    │             ├─ GetArrayInfo
    │             └─ NewDelegate (Predicate)
    │
    ├─ Find / FindLast
    │      ├─ FindIndex / FindLastIndex
    │      ├─ VariantCopyInd
    │      └─ AssignDefaultElementValue
    │
    ├─ FindAll
    │      ├─ ValidateArray
    │      ├─ GetArrayInfo
    │      ├─ FindAllMatches
    │      └─ SetFindAllResult / SetFindAllObjectResult / SetFindAllUdtResult
    │
    ├─ BinarySearch / BinarySearchEx
    │      └─ InternalBinarySearch
    │             ├─ TrySZBinarySearch
    │             └─ Comparer.Compare
    │
    ├─ Sort / SortEx / SortKey
    │      └─ SortKeyEx
    │             ├─ ValidateArrayRange
    │             ├─ SetSortKeys / SetSortItems
    │             ├─ SortStringsWithComparer
    │             ├─ TrySZSort
    │             ├─ QuickSortGeneral
    │             └─ CallbackSorter.Sort
    │
    ├─ Copy
    │      └─ CopyEx
    │             ├─ CopyReferenceTypes
    │             ├─ CopyValueTypes
    │             ├─ CopyObjectTypesCast
    │             └─ CopyWithCast
    │
    ├─ Clear
    │      └─ SafeArrayDestroyData
    │
    ├─ Reverse
    │      ├─ GetArrayInfo
    │      ├─ NewDelegate (Swapper)
    │      └─ CopyMemory (for large elements)
    │
    └─ CreateInstance
           └─ SafeArrayCreate
```

### データフロー図

```
[入力]                    [処理]                              [出力]

配列(Variant) ───────▶ ValidateArray ─────────────────────▶ エラーまたは続行
                              │
                              ▼
                       GetArrayInfo
                              │
                              ├─ SAPtr (SafeArrayポインタ)
                              ├─ DataPtr (データ領域ポインタ)
                              └─ ElementSize (要素サイズ)
                              │
                              ▼
                       [各種操作]
                              │
検索値 ─────────────▶ IndexOf/BinarySearch ──────────────▶ インデックス(Long)
コールバック ────────▶ Find/FindAll ────────────────────▶ 要素/配列
Comparer ───────────▶ Sort ──────────────────────────────▶ ソート済み配列(参照更新)
ソース配列 ──────────▶ Copy ─────────────────────────────▶ コピー先配列(参照更新)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CorArray.cls | `Source/CorLib/System/CorArray.cls` | ソース | 配列操作のメインクラス |
| modArrayHelpers.bas | `Source/CorLib/System/modArrayHelpers.bas` | ソース | 配列操作のヘルパー関数 |
| modSorting.bas | `Source/CorLib/System/modSorting.bas` | ソース | ソート関連のヘルパー関数 |
| CallbackSorter.cls | `Source/CorLib/System/CallbackSorter.cls` | ソース | コールバックを使用したソート |
| IComparer.cls | `Source/CorLib/System.Collections/IComparer.cls` | ソース | 比較インターフェース |
| Comparer.cls | `Source/CorLib/System.Collections/Comparer.cls` | ソース | デフォルト比較実装 |
