# 機能設計書 10-Console

## 概要

本ドキュメントは、VBCorLibライブラリにおけるコンソール入出力機能（Console）の設計を記述する。Consoleクラスは、.NET Frameworkの`System.Console`クラスに相当するコンソールウィンドウへの入出力機能を提供するクラスである。

### 本機能の処理概要

Consoleクラスは、コンソールウィンドウへのテキスト出力、キーボードからの入力取得、画面表示の制御（色設定、カーソル操作、ウィンドウサイズ変更等）を行う機能を提供する。

**業務上の目的・背景**：VB6アプリケーションはGUIベースが基本であるが、コマンドラインツールやバッチ処理アプリケーションではコンソール入出力が必要となる。Consoleクラスは.NETスタイルのコンソール操作APIを提供し、テキストベースのアプリケーション開発を支援する。

**機能の利用シーン**：コンソールベースのアプリケーション開発で利用される。具体的には、コマンドラインツールの作成、バッチ処理の進捗表示、デバッグ出力、ユーザーとの対話的な入力処理、ログ出力などの場面で活用される。

**主要な処理内容**：
1. テキスト出力（Write、WriteLine）
2. 入力取得（Read、ReadLine、ReadKey）
3. 画面制御（色設定、カーソル操作、画面クリア）
4. ウィンドウ/バッファサイズ管理
5. 入出力ストリームのリダイレクト（SetIn、SetOut、SetError）
6. ブレークイベント検出

**関連システム・外部連携**：Windows Console APIを使用。kernel32.dllのAllocConsole、FreeConsole、GetStdHandle、ReadConsoleInput、WriteConsoleOutput等を利用。TextWriter/TextReaderインターフェースを介した入出力ストリーム操作。

**権限による制御**：権限による制御は行わない。ただし、VB6アプリケーションをコンソールウィンドウで実行するにはEXEのサブシステムをコンソールに変更する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はコンソールウィンドウを使用するユーティリティクラスである |

## 機能種別

入出力処理 / コンソール制御ユーティリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Values | Variant() | No | 出力する値（WriteLine/WriteValue） | なし |
| Intercept | Boolean | No | キー入力を画面に表示するか（ReadKey） | デフォルトFalse |
| Frequency | Long | No | ビープ音の周波数（Hz） | 37-32767 |
| Duration | Long | No | ビープ音の持続時間（ms） | 1以上 |
| Width/Height | Long | Yes | ウィンドウ/バッファのサイズ | 正数、範囲内 |
| Left/Top | Long | Yes | カーソル/ウィンドウ位置 | 範囲内 |
| NewOut/NewIn/NewError | TextWriter/TextReader | Yes | リダイレクト先ストリーム | Nothing不可 |

### 入力データソース

キーボードからの入力（標準入力）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 読み取り文字 | Long | Readの戻り値（-1で終端） |
| 読み取り行 | String | ReadLineの戻り値 |
| キー情報 | ConsoleKeyInfo | ReadKeyの戻り値 |
| ブレーク状態 | Boolean | Breakプロパティ |
| ブレーク種別 | ConsoleBreakType | BreakTypeプロパティ |
| バッファサイズ | Long | BufferWidth/BufferHeightプロパティ |
| ウィンドウサイズ | Long | WindowWidth/WindowHeightプロパティ |
| カーソル位置 | Long | CursorLeft/CursorTopプロパティ |
| 色設定 | ConsoleColor | ForegroundColor/BackgroundColorプロパティ |
| タイトル | String | Titleプロパティ |
| エンコーディング | Encoding | InputEncoding/OutputEncodingプロパティ |
| キー状態 | Boolean | CapsLock/NumLock/KeyAvailableプロパティ |

### 出力先

コンソールウィンドウ（標準出力/標準エラー出力）

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|出力| C[TextWriter経由で出力]
    B -->|入力| D[TextReader経由で入力]
    B -->|ReadKey| E[ReadConsoleInput呼び出し]
    B -->|画面制御| F[Console API呼び出し]
    C --> G[コンソールへ表示]
    D --> H[キーボードから取得]
    E --> I[ConsoleKeyInfo生成]
    F --> J[画面状態更新]
    G --> K[終了]
    H --> K
    I --> K
    J --> K
```

### 初期化フロー

```mermaid
flowchart TD
    A[Class_Initialize] --> B[AllocConsole呼び出し]
    B --> C[Sleep 10ms]
    C --> D{デバッガ内?}
    D -->|Yes| E[閉じるボタン無効化]
    D -->|No| F[ControlBreakHandler登録]
    E --> F
    F --> G[標準ハンドル取得]
    G --> H[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | コンソール所有権 | AllocConsoleで自身がコンソールを作成した場合、終了時にFreeConsole | Class_Terminate |
| BR-02 | ストリームリダイレクト | SetOut/SetIn/SetErrorでストリームを変更可能 | 全入出力 |
| BR-03 | デバッガ保護 | IDE内実行時は閉じるボタンを無効化 | デバッグ時のみ |
| BR-04 | ブレークイベント | Ctrl+C/Ctrl+Break等のイベントをBreakプロパティで検出 | 実行中 |

### ConsoleColor列挙型

| 値 | 名前 | 説明 |
|----|------|------|
| -1 | CurrentColor | 現在の色を使用 |
| 0 | Black | 黒 |
| 1 | DarkBlue | 濃い青 |
| 2 | DarkGreen | 濃い緑 |
| 3 | DarkCyan | 濃いシアン |
| 4 | DarkRed | 濃い赤 |
| 5 | DarkMagenta | 濃いマゼンタ |
| 6 | DarkYellow | 濃い黄 |
| 7 | Gray | 灰色 |
| 8 | DarkGray | 濃い灰色 |
| 9 | Blue | 青 |
| 10 | Green | 緑 |
| 11 | Cyan | シアン |
| 12 | Red | 赤 |
| 13 | Magenta | マゼンタ |
| 14 | Yellow | 黄 |
| 15 | White | 白 |

### ConsoleBreakType列挙型

| 値 | 名前 | 説明 |
|----|------|------|
| 0 | ControlC | Ctrl+Cが押された |
| 1 | ControlBreak | Ctrl+Breakが押された |
| 2 | CloseWindow | ウィンドウが閉じられた |
| 5 | LogOffUser | ユーザーがログオフ |
| 6 | ShutDownSystem | システムがシャットダウン |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentOutOfRangeException | 範囲外 | Frequency範囲外（37-32767以外） | 有効範囲内の値を使用 |
| ArgumentOutOfRangeException | 範囲外 | Duration < 1 | 正数を使用 |
| ArgumentOutOfRangeException | 範囲外 | ConsoleColor範囲外（0-15以外） | 有効な色値を使用 |
| ArgumentOutOfRangeException | 範囲外 | CursorSize範囲外（1-100以外） | 有効範囲内の値を使用 |
| ArgumentOutOfRangeException | 範囲外 | バッファ/ウィンドウサイズ範囲外 | 適切なサイズを使用 |
| ArgumentOutOfRangeException | 範囲外 | タイトル長超過（24500文字以上） | 短いタイトルを使用 |
| ArgumentNullException | Null引数 | SetOut/SetIn/SetErrorにNothing | 有効なストリームを渡す |
| InvalidOperationException | 操作エラー | ファイルからのReadKey | コンソール入力を使用 |
| Win32Error | システムエラー | Windows API失敗時 | エラーコード確認 |

## 備考

- VB6アプリケーションをコンソールで使用するには`link /edit /subsystem:console`でEXEを変換
- IDE内での閉じるボタン操作はIDEクラッシュを引き起こすため、自動的に無効化される
- ReadKeyではAlt/Shift/Control/Caps-Lock/Scroll-Lock/Num-Lockキーは単独では返されない
- 入出力エンコーディングはNTプラットフォームでのみ変更可能
- ResetColorで前景色はGray、背景色はBlackにリセットされる
- AutoFlushがTrueに設定されているため、出力は即座に表示される

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Console.cls | `Source/CorLib/System/Console.cls` | 68-96行目: Windows API宣言 |
| 1-2 | Console.cls | `Source/CorLib/System/Console.cls` | 109-152行目: 内部構造体定義 |
| 1-3 | Console.cls | `Source/CorLib/System/Console.cls` | 163-169行目: ConsoleBreakType列挙型 |
| 1-4 | Console.cls | `Source/CorLib/System/Console.cls` | 193-211行目: ConsoleColor列挙型 |
| 1-5 | Console.cls | `Source/CorLib/System/Console.cls` | 213-223行目: 内部変数 |
| 1-6 | Console.cls | `Source/CorLib/System/Console.cls` | 266-311行目: Error/Out/In_プロパティ |
| 1-7 | Console.cls | `Source/CorLib/System/Console.cls` | 322-337行目: Read/ReadLineメソッド |
| 1-8 | Console.cls | `Source/CorLib/System/Console.cls` | 353-385行目: ReadKeyメソッド |
| 1-9 | Console.cls | `Source/CorLib/System/Console.cls` | 392-423行目: SetOut/SetIn/SetErrorメソッド |
| 1-10 | Console.cls | `Source/CorLib/System/Console.cls` | 431-453行目: OpenStandardOutput/Input/Error |
| 1-11 | Console.cls | `Source/CorLib/System/Console.cls` | 465-483行目: WriteLine/WriteValue |
| 1-12 | Console.cls | `Source/CorLib/System/Console.cls` | 491-502行目: Beepメソッド |
| 1-13 | Console.cls | `Source/CorLib/System/Console.cls` | 516-575行目: SetWindowSizeメソッド |
| 1-14 | Console.cls | `Source/CorLib/System/Console.cls` | 636-665行目: Buffer Width/Height |
| 1-15 | Console.cls | `Source/CorLib/System/Console.cls` | 678-749行目: Window Left/Top/Width/Height |
| 1-16 | Console.cls | `Source/CorLib/System/Console.cls` | 775-813行目: Titleプロパティ |
| 1-17 | Console.cls | `Source/CorLib/System/Console.cls` | 823-866行目: BackgroundColor/ForegroundColor |
| 1-18 | Console.cls | `Source/CorLib/System/Console.cls` | 875-926行目: Cursor位置/サイズ/表示 |
| 1-19 | Console.cls | `Source/CorLib/System/Console.cls` | 989-1002行目: Clearメソッド |
| 1-20 | Console.cls | `Source/CorLib/System/Console.cls` | 1017-1066行目: MoveBufferAreaメソッド |
| 1-21 | Console.cls | `Source/CorLib/System/Console.cls` | 1114-1117行目: ResetColorメソッド |
| 1-22 | Console.cls | `Source/CorLib/System/Console.cls` | 1124-1175行目: Input/OutputEncodingプロパティ |
| 1-23 | Console.cls | `Source/CorLib/System/Console.cls` | 1185-1232行目: CapsLock/NumLock/KeyAvailable |
| 1-24 | Console.cls | `Source/CorLib/System/Console.cls` | 1313-1328行目: Initメソッド（初期化処理） |
| 1-25 | Console.cls | `Source/CorLib/System/Console.cls` | 1438-1448行目: コンストラクタ/デストラクタ |

### プログラム呼び出し階層図

```
Console (エントリーポイント)
├── Class_Initialize
│   └── Init
│       ├── AllocConsole (kernel32.dll)
│       ├── DisableCloseButton
│       │   ├── GetCurrentProcessId
│       │   ├── FindWindow (user32.dll)
│       │   ├── GetSystemMenu
│       │   └── RemoveMenu
│       ├── SetConsoleCtrlHandler (kernel32.dll)
│       └── GetStdHandle (kernel32.dll) x 3
├── Out (プロパティ)
│   └── Cor.NewStreamWriter
│       └── OpenStandardOutput
│           └── GetConsoleStream
├── In_ (プロパティ)
│   └── Cor.NewStreamReader
│       └── OpenStandardInput
│           └── GetConsoleStream
├── Error (プロパティ)
│   └── Cor.NewStreamWriter
│       └── OpenStandardError
│           └── GetConsoleStream
├── WriteLine/WriteValue
│   └── WriteLineCore/WriteCore
│       └── Out.WriteValue
├── Read/ReadLine
│   └── In_.Read/ReadLine
├── ReadKey
│   ├── ReadKeyCore
│   │   └── Cor.NewConsoleKeyInfo
│   └── ReadConsoleInput (kernel32.dll)
├── Beep
│   └── BeepAPI (kernel32.dll)
├── SetWindowSize/SetBufferSize
│   ├── GetBufferInfo
│   │   └── GetConsoleScreenBufferInfo (kernel32.dll)
│   ├── SetConsoleScreenBufferSize (kernel32.dll)
│   └── SetConsoleWindowInfo (kernel32.dll)
├── Clear
│   ├── GetBufferInfo
│   ├── FillConsoleOutputCharacter (kernel32.dll)
│   ├── FillConsoleOutputAttribute (kernel32.dll)
│   └── SetConsoleCursorPosition (kernel32.dll)
└── Class_Terminate
    ├── SetConsoleCtrlHandler (kernel32.dll)
    └── FreeConsole (kernel32.dll)
```

### データフロー図

```
[キーボード] ---> [ReadConsoleInput] ---> [ReadKey/Read/ReadLine]
                                              |
                                              v
                                    [ConsoleKeyInfo / String]
                                              |
                                              v
                                        [呼び出し元]

[呼び出し元] ---> [WriteLine/WriteValue] ---> [TextWriter.WriteValue]
                                                    |
                                                    v
                                            [ConsoleStream]
                                                    |
                                                    v
                                            [コンソール画面]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Console.cls | `Source/CorLib/System/Console.cls` | ソース | コンソールI/Oのメインクラス |
| ConsoleStream.cls | `Source/CorLib/System/ConsoleStream.cls` | ソース | コンソール用ストリーム |
| ConsoleKeyInfo.cls | `Source/CorLib/System/ConsoleKeyInfo.cls` | ソース | キー入力情報クラス |
| ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | ソース | ブレークイベントコールバック |
| TextWriter.cls | `Source/CorLib/System.IO/TextWriter.cls` | ソース | テキスト出力インターフェース |
| TextReader.cls | `Source/CorLib/System.IO/TextReader.cls` | ソース | テキスト入力インターフェース |
| StreamWriter.cls | `Source/CorLib/System.IO/StreamWriter.cls` | ソース | ストリーム書き込みクラス |
| StreamReader.cls | `Source/CorLib/System.IO/StreamReader.cls` | ソース | ストリーム読み込みクラス |
| Encoding.cls | `Source/CorLib/System.Text/Encoding.cls` | ソース | エンコーディング処理 |
