# 機能設計書 100-ArgumentNullException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるArgumentNullException機能の設計を記述するものである。ArgumentNullExceptionは、Null参照がメソッドの有効な引数として受け入れられない場合にスローされる例外クラスである。

### 本機能の処理概要

ArgumentNullExceptionクラスは、ArgumentExceptionの派生クラスとして、特にNull（Nothing）参照や未初期化配列が渡された場合のエラーを表現する。ArgumentExceptionと同様にParamNameを保持し、どの引数がNullであったかを明確にする。

**業務上の目的・背景**：メソッドの入力検証において、Null参照が渡された場合を明確に区別する。ArgumentExceptionよりも具体的な例外であり、Null参照エラーの特定と対処を容易にする。

**機能の利用シーン**：必須オブジェクト参照がNothingの場合、必須配列が未初期化の場合、必須コレクションがNothingの場合に使用される。

**主要な処理内容**：
1. エラー情報の保持（Message/ParamName）
2. Exceptionからの継承機能
3. ArgumentExceptionインターフェースの実装
4. SystemExceptionインターフェースの実装
5. E_POINTERのHResultを返却

**関連システム・外部連携**：特になし

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし（内部クラス） |

## 機能種別

エラー処理 / 例外クラス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ParamName | String | No | 問題のあった引数名 | - |
| Message | String | No | エラーメッセージ | - |
| InnerException | Exception | No | 原因となった内部例外 | - |

### 入力データソース

- アプリケーションコードからの直接生成
- VBCorLib内部での例外生成

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | String | エラーメッセージ + "Parameter name: " + ParamName |
| ParamName | String | 問題のあった引数名 |
| HResult | Long | E_POINTER（&H5B） |
| ErrorNumber | Long | vbObjectNotSet |

### 出力先

- 呼び出し元への戻り値

## 処理フロー

### 処理シーケンス

```
1. ArgumentNullException生成
   └─ NewArgumentNullExceptionでインスタンス生成
   └─ ExceptionBaseに委譲して初期化
   └─ ParamName、Message、InnerExceptionを設定

2. Messageプロパティアクセス
   └─ GetExceptionMessage（ArgumentNull_Genericリソース使用）
   └─ ParamNameがあれば追加表示

3. 他のプロパティはExceptionと同様にExceptionBaseに委譲
```

### フローチャート

```mermaid
flowchart TD
    A[NewArgumentNullException] --> B[ExceptionBase生成]
    B --> C[ParamName設定]
    C --> D[Message設定]
    D --> E[InnerException設定]
    E --> F[ArgumentNullException返却]
    F --> G{Messageアクセス?}
    G -->|Yes| H[GetExceptionMessage]
    H --> I{ParamName存在?}
    I -->|Yes| J[Message + ParamName追加]
    I -->|No| K[Message返却]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-01 | HResult | HResultはE_POINTER（&H5B） | HResultアクセス時 |
| BR-100-02 | ErrorNumber | ErrorNumberはvbObjectNotSet | ErrorNumberアクセス時 |
| BR-100-03 | Message形式 | ParamNameがある場合、Messageの末尾に"Parameter name: {ParamName}"を追加 | Messageアクセス時 |
| BR-100-04 | デフォルトMessage | Messageが空の場合、ArgumentNull_Genericリソースを使用 | Messageアクセス時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

ArgumentNullExceptionクラス自体は例外を発生させない（例外情報を保持するのみ）。

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 例外オブジェクトの生成は軽量

## セキュリティ考慮事項

- エラーメッセージに引数の値など機密情報を含めないこと

## 備考

- .NET FrameworkのSystem.ArgumentNullExceptionクラスに対応
- ArgumentExceptionの派生クラスとして動作
- Implements Exception, SystemException, ArgumentExceptionでインターフェースを実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

ArgumentNullExceptionのクラス宣言とインターフェース実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | Implements IObject, Exception, SystemException, ArgumentException（57-60行目） |

**読解のコツ**: ArgumentNullExceptionはArgumentExceptionのインターフェースも実装しており、ArgumentExceptionとして扱うことが可能。

#### Step 2: ArgumentExceptionとの違いを理解する

HResultとErrorNumberがArgumentExceptionと異なることを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | HResult（119-121行目）でE_POINTERを返却 |
| 2-2 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | ErrorNumber（128-130行目）でvbObjectNotSetを返却 |

**主要処理フロー**:
- **119-121行目**: HResult Get - E_POINTER（&H5B）を返却（ArgumentExceptionは&H5）
- **128-130行目**: ErrorNumber Get - vbObjectNotSetを返却

#### Step 3: 初期化処理を理解する

Initメソッドでの引数設定順序を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | Init（247-251行目）でParamName、Message、InnerException設定 |

**主要処理フロー**:
- **247-251行目**: Init - ParamNameを先に設定し、次にMessage、最後にInnerExceptionを設定
- ArgumentExceptionと異なり、ParamNameが第1引数

#### Step 4: Messageの拡張を理解する

ArgumentExceptionと同様のMessage拡張を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | Message（166-174行目）でArgumentNull_Genericリソースを使用 |

**主要処理フロー**:
- **167行目**: GetExceptionMessage(mBase, ArgumentNull_Generic)で基本メッセージ取得
- **169-173行目**: ParamNameがあれば、vbCrLf + "Parameter name: " + ParamNameを追加

#### Step 5: ArgumentExceptionインターフェース実装を理解する

ArgumentExceptionとしても使用できることを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | ArgumentException_*（268-323行目）でインターフェース実装 |

### プログラム呼び出し階層図

```
NewArgumentNullException
    │
    └─ ArgumentNullException.Init
           │
           ├─ mBase.SetValue PropParamName, ParamName
           │
           ├─ mBase.Message = Message
           │
           └─ mBase.InnerException = InnerException

ArgumentNullException.Message
    │
    ├─ GetExceptionMessage(mBase, ArgumentNull_Generic)
    │
    └─ ParamName追加（存在時）
           └─ vbCrLf & "Parameter name: " & ParamName

ArgumentNullException.HResult
    │
    └─ E_POINTER（&H5B）

ArgumentNullException.ErrorNumber
    │
    └─ vbObjectNotSet
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ParamName ───────────────▶ ArgumentNullException.Init ──▶ mBase設定
Message ─────────────────┘      │
InnerException ──────────────────┘

（なし） ─────────────────▶ ArgumentNullException.Message ▶ 拡張メッセージ
                                │
                                ▼
                         GetExceptionMessage
                         (ArgumentNull_Generic)
                                │
                                ▼
                         ParamName追加判定
                                │
                                ▼
                         最終メッセージ生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | ソース | Null引数例外クラス |
| ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | ソース | 親インターフェース |
| Exception.cls | `Source/CorLib/System/Exception.cls` | ソース | 基底クラス |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 実装ヘルパー |
