# 機能設計書 101-ArgumentOutOfRangeException

## 概要

本ドキュメントは、VBCorLibライブラリにおける`ArgumentOutOfRangeException`クラスの機能設計を定義する。このクラスは、メソッドに渡された引数の値が許容範囲外である場合にスローされる例外を表現する。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーション開発において、メソッドに渡される引数が有効な範囲内であることを保証することは、システムの信頼性と安定性を維持するために不可欠である。ArgumentOutOfRangeExceptionは、配列インデックス、数値パラメータ、文字列長などが許容範囲を超えた場合に、明確なエラー情報を提供し、デバッグ作業を効率化する。

**機能の利用シーン**：
- 配列やコレクションのインデックスが範囲外の場合
- 数値パラメータが最小値未満または最大値超過の場合
- 文字列操作で指定された開始位置や長さが不正な場合
- 列挙型の値が定義された範囲外の場合

**主要な処理内容**：
1. 例外インスタンスの生成と初期化（パラメータ名、メッセージ、実際の値、内部例外を設定）
2. 呼び出し方法（GenericInvocation、ArrayInvocation、PropertyInvocation）に応じたVBエラー番号の設定
3. 例外情報のプロパティ提供（Message、ParamName、ActualValue、HResult、ErrorNumber等）
4. 例外チェーンの追跡（GetBaseException）とシリアライズ対応

**関連システム・外部連携**：VBCorLibの例外階層において、ArgumentException、SystemException、Exceptionインターフェースを実装し、.NET Frameworkの例外モデルとの互換性を提供する。

**権限による制御**：本クラスは権限制御なく、すべてのコードから利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | テスト実行画面でのユニットテスト結果確認のみ |

## 機能種別

例外処理 / エラーハンドリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ParamName | String | No | 例外の原因となったパラメータ名 | なし |
| Message | String | No | エラーメッセージ | なし（空の場合はデフォルトメッセージ使用） |
| ActualValue | Variant | No | 実際に渡された値 | なし |
| InnerException | Exception | No | 内部例外 | なし |
| Method | InvocationMethod | No | 呼び出し方法（GenericInvocation、ArrayInvocation、PropertyInvocation） | 列挙型範囲内 |

### 入力データソース

コンストラクタ`Cor.NewArgumentOutOfRangeException`関数経由でのパラメータ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | String | パラメータ名と実際の値を含む完全なエラーメッセージ |
| ParamName | String | 例外の原因となったパラメータ名 |
| ActualValue | Variant | 範囲外となった実際の値 |
| HResult | Long | COR_E_ARGUMENTOUTOFRANGE定数値 |
| ErrorNumber | Long | VBエラー番号（5:vbInvalidProcedureCall、9:vbSubscriptOutOfRange、380:vbInvalidPropertyValue） |
| Source | String | 例外発生元の情報 |
| Data | IDictionary | ユーザー定義の追加情報 |
| InnerException | Exception | 内部例外オブジェクト |

### 出力先

例外オブジェクトとしてスロー、またはCatchブロックで捕捉

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し（NewArgumentOutOfRangeException）
   └─ 新しいArgumentOutOfRangeExceptionインスタンスを生成
2. Initメソッド実行
   └─ ParamName、Message、ActualValue、InnerException、Methodを設定
3. エラー番号決定
   └─ Methodパラメータに基づきVBエラー番号を選択
4. 例外スロー（Throw）
   └─ 例外がエラーハンドラに伝播
5. 例外捕捉（CatchArgumentOutOfRange）
   └─ 例外タイプを判定し、例外オブジェクトを取得
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[NewArgumentOutOfRangeException呼び出し]
    B --> C[Initメソッド実行]
    C --> D{Methodパラメータ確認}
    D -->|GenericInvocation| E[ErrorNumber = vbInvalidProcedureCall]
    D -->|ArrayInvocation| F[ErrorNumber = vbSubscriptOutOfRange]
    D -->|PropertyInvocation| G[ErrorNumber = vbInvalidPropertyValue]
    D -->|範囲外| H[ArgumentOutOfRangeExceptionをスロー]
    E --> I[例外オブジェクト完成]
    F --> I
    G --> I
    I --> J[Throw実行]
    J --> K[終了]
    H --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-101 | デフォルトメッセージ | Messageが未指定の場合、"Specified argument was out of the range of valid values."を使用 | Message引数がvbNullStringの場合 |
| BR-102 | パラメータ名追記 | ParamNameが指定された場合、メッセージに"Parameter name: {ParamName}"を追記 | ParamNameが空でない場合 |
| BR-103 | 実際値追記 | ActualValueが指定された場合、メッセージに"Actual value was {Value}."を追記 | ActualValueがMissing以外の場合 |
| BR-104 | エラー番号マッピング | 呼び出し方法に応じてVBエラー番号を決定 | 常時 |

### 計算ロジック

エラー番号決定ロジック：
- GenericInvocation → vbInvalidProcedureCall (5)
- ArrayInvocation → vbSubscriptOutOfRange (9)
- PropertyInvocation → vbInvalidPropertyValue (380)
- 上記以外 → ArgumentOutOfRangeExceptionをスロー

## データベース操作仕様

該当なし（本クラスはデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| COR_E_ARGUMENTOUTOFRANGE | ArgumentOutOfRangeException | Method引数が列挙型範囲外 | Method引数に有効な値を指定 |

### リトライ仕様

リトライ不要（例外クラスであり、再試行の概念なし）

## トランザクション仕様

該当なし

## パフォーマンス要件

例外生成は即座に完了すること（ミリ秒単位）

## セキュリティ考慮事項

- ActualValueに機密情報を含めないこと推奨
- スタックトレースに機密情報が含まれる可能性に注意

## 備考

- .NET FrameworkのSystem.ArgumentOutOfRangeExceptionクラスとの互換性を意図した設計
- Persistable属性によりシリアライズ可能
- ArgumentExceptionを継承（VBのImplementsによる実装）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外クラスの継承階層とインターフェース実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | 例外の共通機能を提供するヘルパークラス。Message、HResult、InnerException等の管理方法を理解 |
| 1-2 | Exception.cls | `Source/CorLib/System/Exception.cls` | 基底例外インターフェースの定義 |

**読解のコツ**: VB6のクラスはImplementsキーワードで多重継承を模倣している。各インターフェース実装部分は別々のセクションに分かれている。

#### Step 2: エントリーポイントを理解する

例外オブジェクトの生成起点となるコンストラクタ関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewArgumentOutOfRangeException関数（176-178行目）が例外生成の起点 |

**主要処理フロー**:
1. **176行目**: 関数定義。Optional引数でParamName、Message、ActualValue、InnerException、Methodを受け取る
2. **177行目**: New ArgumentOutOfRangeExceptionでインスタンス生成
3. **178行目**: Initメソッドを呼び出し、各プロパティを初期化

#### Step 3: 例外クラスの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ArgumentOutOfRangeException.cls | `Source/CorLib/System/ArgumentOutOfRangeException.cls` | 主要な例外クラス実装 |

**主要処理フロー**:
- **54-58行目**: Implements宣言。IObject、Exception、SystemException、ArgumentExceptionを実装
- **60-64行目**: InvocationMethod列挙型の定義（GenericInvocation、ArrayInvocation、PropertyInvocation）
- **70行目**: mBase As ExceptionBase - 共通機能をExceptionBaseに委譲
- **87-89行目**: ActualValueプロパティ。mBase.GetValueで値を取得
- **99-101行目**: ParamNameプロパティ
- **133-135行目**: HResultプロパティ。COR_E_ARGUMENTOUTOFRANGE定数を返却
- **142-144行目**: ErrorNumberプロパティ。mBase.ErrorNumberを返却
- **180-194行目**: Messageプロパティ。ParamNameとActualValueを含む完全メッセージを構築
- **263-274行目**: Initメソッド。各プロパティを設定し、GetErrorNumber関数でエラー番号を決定
- **276-287行目**: GetErrorNumber関数。Methodに基づきVBエラー番号を返却

#### Step 4: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ArgumentOutOfRangeExceptionTests.cls | `Source/Tests/System/ArgumentOutOfRangeExceptionTests.cls` | 各機能の期待動作を確認 |

**主要処理フロー**:
- **24-31行目**: デフォルトコンストラクタでのMessageテスト
- **51-60行目**: メッセージ設定テスト
- **62-70行目**: ParamNameがメッセージに追記されることを確認
- **72-80行目**: ActualValueがメッセージに追記されることを確認
- **115-129行目**: シリアライズテスト

### プログラム呼び出し階層図

```
Cor.NewArgumentOutOfRangeException (Constructors.cls)
    │
    ├─ New ArgumentOutOfRangeException
    │      └─ Class_InitProperties
    │             └─ Cor.NewExceptionBase (ExceptionBase生成)
    │
    └─ ArgumentOutOfRangeException.Init
           ├─ mBase.SetValue(PropParamName, ParamName)
           ├─ mBase.SetValue(PropActualValue, ActualValue)
           ├─ mBase.Message = Message
           ├─ GetErrorNumber(Method)
           │      └─ VBエラー番号決定
           └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ParamName ─────────┐
                   │
Message ───────────┼──▶ ArgumentOutOfRangeException.Init ──▶ 例外オブジェクト
                   │           │                                    │
ActualValue ───────┤           ├─ ExceptionBase.SetValue            ├─ Message
                   │           ├─ GetErrorNumber                    ├─ ParamName
InnerException ────┤           └─ mBase設定                         ├─ ActualValue
                   │                                                ├─ HResult
Method ────────────┘                                                ├─ ErrorNumber
                                                                    └─ InnerException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArgumentOutOfRangeException.cls | `Source/CorLib/System/ArgumentOutOfRangeException.cls` | ソース | 主要な例外クラス実装 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外共通機能のヘルパークラス |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | コンストラクタ関数群 |
| ArgumentOutOfRangeExceptionTests.cls | `Source/Tests/System/ArgumentOutOfRangeExceptionTests.cls` | テスト | ユニットテスト |
| ExceptionMethods.cls | `Source/CorLib/System/ExceptionMethods.cls` | ソース | 例外捕捉ヘルパー関数 |
