# 機能設計書 104-OverflowException

## 概要

本ドキュメントは、VBCorLibライブラリにおける`OverflowException`クラスの機能設計を定義する。このクラスは、数学演算によって結果が対象データ型の有効範囲を超えた場合にスローされる例外を表現する。

### 本機能の処理概要

**業務上の目的・背景**：数値計算を行うアプリケーションにおいて、計算結果が変数の格納可能な範囲を超える場合がある。OverflowExceptionは、そのような算術オーバーフローを明示的に通知し、データの破損や予期しない動作を防止する。これにより、計算処理の信頼性を確保し、適切なエラーハンドリングを可能にする。

**機能の利用シーン**：
- 整数演算で結果がInteger/Longの範囲を超える場合
- 型変換で対象型の範囲を超える値を変換しようとした場合
- BigInteger演算でメモリ制限を超える場合
- 日付計算で有効範囲を超える場合

**主要な処理内容**：
1. 例外インスタンスの生成と初期化（メッセージ、内部例外を設定）
2. 例外情報のプロパティ提供（Message、HResult、ErrorNumber等）
3. 例外チェーンの追跡（GetBaseException）とシリアライズ対応
4. IObject、Exception、SystemException、ArithmeticExceptionインターフェースの実装

**関連システム・外部連携**：VBCorLibの例外階層において、ArithmeticException、SystemException、Exceptionインターフェースを実装し、.NET Frameworkの例外モデルとの互換性を提供する。

**権限による制御**：本クラスは権限制御なく、すべてのコードから利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面との直接的な関連なし |

## 機能種別

例外処理 / エラーハンドリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Message | String | Yes | エラーメッセージ | なし（空の場合はデフォルトメッセージ使用） |
| InnerException | Exception | No | 内部例外 | なし |

### 入力データソース

コンストラクタ`Cor.NewOverflowException`関数経由でのパラメータ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | String | エラーメッセージ |
| HResult | Long | COR_E_OVERFLOW定数値 |
| ErrorNumber | Long | vbOverflow (6) |
| Source | String | 例外発生元の情報 |
| Data | IDictionary | ユーザー定義の追加情報 |
| InnerException | Exception | 内部例外オブジェクト |

### 出力先

例外オブジェクトとしてスロー、またはCatchブロックで捕捉

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し（NewOverflowException）
   └─ 新しいOverflowExceptionインスタンスを生成
2. Initメソッド実行
   └─ Message、InnerExceptionを設定
3. 例外スロー（Throw）
   └─ 例外がエラーハンドラに伝播
4. 例外捕捉（Catch）
   └─ 例外タイプを判定し、例外オブジェクトを取得
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[NewOverflowException呼び出し]
    B --> C[新しいインスタンス生成]
    C --> D[Initメソッド実行]
    D --> E[Message設定]
    E --> F[InnerException設定]
    F --> G[例外オブジェクト完成]
    G --> H[Throw実行]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-104-1 | デフォルトメッセージ | Messageが未指定の場合、Arg_OverflowExceptionリソースからデフォルトメッセージを取得 | Message引数がvbNullStringの場合 |
| BR-104-2 | 固定ErrorNumber | ErrorNumberは常にvbOverflow (6)を返却 | 常時 |
| BR-104-3 | 固定HResult | HResultは常にCOR_E_OVERFLOWを返却 | 常時 |
| BR-104-4 | ArithmeticException実装 | ArithmeticExceptionインターフェースを実装し、算術例外として分類 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（本クラスはデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 本クラス自体が例外クラスであり、内部でエラーは発生しない | - |

### リトライ仕様

リトライ不要（例外クラスであり、再試行の概念なし）

## トランザクション仕様

該当なし

## パフォーマンス要件

例外生成は即座に完了すること（ミリ秒単位）

## セキュリティ考慮事項

- 計算に使用された値がエラーメッセージに含まれる場合、機密情報の漏洩に注意

## 備考

- .NET FrameworkのSystem.OverflowExceptionクラスとの互換性を意図した設計
- Persistable属性によりシリアライズ可能
- VB6標準のErr.Number = 6 (Overflow)と同等のエラーを表現

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外クラスの継承階層とインターフェース実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | 例外の共通機能を提供するヘルパークラス |

**読解のコツ**: OverflowExceptionは他の例外クラスと異なり、ArithmeticExceptionインターフェースも実装している。これは数学的なエラーの分類に使用される。

#### Step 2: エントリーポイントを理解する

例外オブジェクトの生成起点となるコンストラクタ関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewOverflowException関数（801-803行目）が例外生成の起点 |

**主要処理フロー**:
1. **801行目**: 関数定義。Message（必須）、InnerException（任意）を受け取る
2. **802行目**: New OverflowExceptionでインスタンス生成
3. **803行目**: Initメソッドを呼び出し、各プロパティを初期化

#### Step 3: 例外クラスの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OverflowException.cls | `Source/CorLib/System/OverflowException.cls` | 主要な例外クラス実装 |

**主要処理フロー**:
- **46-50行目**: Implements宣言。IObject、Exception、SystemException、ArithmeticExceptionを実装
- **54行目**: mBase As ExceptionBase - 共通機能をExceptionBaseに委譲
- **98-100行目**: HResultプロパティ。COR_E_OVERFLOW定数を返却
- **107-109行目**: ErrorNumberプロパティ。vbOverflow (6)を返却
- **145-147行目**: Messageプロパティ。GetExceptionMessage関数でメッセージを取得
- **220-223行目**: Initメソッド。Message、InnerExceptionを設定
- **366-419行目**: ArithmeticExceptionインターフェース実装部分

### プログラム呼び出し階層図

```
Cor.NewOverflowException (Constructors.cls)
    │
    ├─ New OverflowException
    │      └─ Class_InitProperties
    │             └─ Cor.NewExceptionBase (ExceptionBase生成)
    │
    └─ OverflowException.Init
           ├─ mBase.Message = Message
           └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Message ───────────┐
                   │
                   ├──▶ OverflowException.Init ────────▶ 例外オブジェクト
                   │           │                                │
InnerException ────┘           ├─ mBase.Message設定             ├─ Message
                               └─ mBase.InnerException設定      ├─ HResult
                                                                ├─ ErrorNumber (6)
                                                                └─ InnerException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OverflowException.cls | `Source/CorLib/System/OverflowException.cls` | ソース | 主要な例外クラス実装 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外共通機能のヘルパークラス |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | コンストラクタ関数群 |
| ExceptionMethods.cls | `Source/CorLib/System/ExceptionMethods.cls` | ソース | 例外捕捉ヘルパー関数 |
