# 機能設計書 105-NotSupportedException

## 概要

本ドキュメントは、VBCorLibライブラリにおける`NotSupportedException`クラスの機能設計を定義する。このクラスは、呼び出されたメソッドがサポートされていない場合にスローされる例外を表現する。

### 本機能の処理概要

**業務上の目的・背景**：オブジェクト指向プログラミングでは、インターフェースや基底クラスで定義されたメソッドが、特定の実装クラスではサポートされない場合がある。NotSupportedExceptionは、そのような状況を明示的に通知し、開発者に対して代替手段の検討を促す。例えば、読み取り専用コレクションでの追加操作や、特定のプラットフォームで利用できない機能を呼び出した場合に使用される。

**機能の利用シーン**：
- 読み取り専用コレクションへの追加・削除・変更操作
- 固定サイズ配列のリサイズ操作
- 現在のオブジェクト状態でサポートされない操作
- プラットフォーム固有の機能が利用できない場合
- 派生クラスで実装されていない基底クラスメソッドの呼び出し

**主要な処理内容**：
1. 例外インスタンスの生成と初期化（メッセージ、内部例外を設定）
2. 例外情報のプロパティ提供（Message、HResult、ErrorNumber等）
3. 例外チェーンの追跡（GetBaseException）とシリアライズ対応
4. IObject、Exception、SystemExceptionインターフェースの実装

**関連システム・外部連携**：VBCorLibの例外階層において、SystemException、Exceptionインターフェースを実装し、.NET Frameworkの例外モデルとの互換性を提供する。

**権限による制御**：本クラスは権限制御なく、すべてのコードから利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面との直接的な関連なし |

## 機能種別

例外処理 / エラーハンドリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Message | String | Yes | エラーメッセージ | なし（空の場合はデフォルトメッセージ使用） |
| InnerException | Exception | No | 内部例外 | なし |

### 入力データソース

コンストラクタ`Cor.NewNotSupportedException`関数経由でのパラメータ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | String | エラーメッセージ |
| HResult | Long | COR_E_NOTSUPPORTED定数値 |
| ErrorNumber | Long | vbInvalidProcedureCall (5) |
| Source | String | 例外発生元の情報 |
| Data | IDictionary | ユーザー定義の追加情報 |
| InnerException | Exception | 内部例外オブジェクト |

### 出力先

例外オブジェクトとしてスロー、またはCatchブロックで捕捉

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し（NewNotSupportedException）
   └─ 新しいNotSupportedExceptionインスタンスを生成
2. Initメソッド実行
   └─ Message、InnerExceptionを設定
3. 例外スロー（Throw）
   └─ 例外がエラーハンドラに伝播
4. 例外捕捉（Catch）
   └─ 例外タイプを判定し、例外オブジェクトを取得
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[NewNotSupportedException呼び出し]
    B --> C[新しいインスタンス生成]
    C --> D[Initメソッド実行]
    D --> E[Message設定]
    E --> F[InnerException設定]
    F --> G[例外オブジェクト完成]
    G --> H[Throw実行]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-105-1 | デフォルトメッセージ | Messageが未指定の場合、Arg_NotSupportedExceptionリソースからデフォルトメッセージを取得 | Message引数がvbNullStringの場合 |
| BR-105-2 | 固定ErrorNumber | ErrorNumberは常にvbInvalidProcedureCall (5)を返却 | 常時 |
| BR-105-3 | 固定HResult | HResultは常にCOR_E_NOTSUPPORTEDを返却 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（本クラスはデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 本クラス自体が例外クラスであり、内部でエラーは発生しない | - |

### リトライ仕様

リトライ不要（例外クラスであり、再試行の概念なし）

## トランザクション仕様

該当なし

## パフォーマンス要件

例外生成は即座に完了すること（ミリ秒単位）

## セキュリティ考慮事項

- Messageに機密情報を含めないこと推奨

## 備考

- .NET FrameworkのSystem.NotSupportedExceptionクラスとの互換性を意図した設計
- Persistable属性によりシリアライズ可能
- InvalidOperationExceptionとの違い：一時的な状態による不可の場合はInvalidOperationException、恒久的に不可の場合はNotSupportedException
- 読み取り専用コレクション（FixedSizeArrayList等）で多用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外クラスの継承階層とインターフェース実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | 例外の共通機能を提供するヘルパークラス |

**読解のコツ**: NotSupportedExceptionは読み取り専用コレクションなどで頻繁に使用される。使用箇所を確認することで、この例外の意図がより明確になる。

#### Step 2: エントリーポイントを理解する

例外オブジェクトの生成起点となるコンストラクタ関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewNotSupportedException関数（115-117行目）が例外生成の起点 |

**主要処理フロー**:
1. **115行目**: 関数定義。Message（必須）、InnerException（任意）を受け取る
2. **116行目**: New NotSupportedExceptionでインスタンス生成
3. **117行目**: Initメソッドを呼び出し、各プロパティを初期化

#### Step 3: 例外クラスの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NotSupportedException.cls | `Source/CorLib/System/NotSupportedException.cls` | 主要な例外クラス実装 |

**主要処理フロー**:
- **50-53行目**: Implements宣言。IObject、Exception、SystemExceptionを実装
- **57行目**: mBase As ExceptionBase - 共通機能をExceptionBaseに委譲
- **101-103行目**: HResultプロパティ。COR_E_NOTSUPPORTED定数を返却
- **110-112行目**: ErrorNumberプロパティ。vbInvalidProcedureCall (5)を返却
- **148-150行目**: Messageプロパティ。GetExceptionMessage関数でメッセージを取得
- **223-226行目**: Initメソッド。Message、InnerExceptionを設定

### プログラム呼び出し階層図

```
Cor.NewNotSupportedException (Constructors.cls)
    │
    ├─ New NotSupportedException
    │      └─ Class_InitProperties
    │             └─ Cor.NewExceptionBase (ExceptionBase生成)
    │
    └─ NotSupportedException.Init
           ├─ mBase.Message = Message
           └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Message ───────────┐
                   │
                   ├──▶ NotSupportedException.Init ────▶ 例外オブジェクト
                   │           │                                │
InnerException ────┘           ├─ mBase.Message設定             ├─ Message
                               └─ mBase.InnerException設定      ├─ HResult
                                                                ├─ ErrorNumber
                                                                └─ InnerException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotSupportedException.cls | `Source/CorLib/System/NotSupportedException.cls` | ソース | 主要な例外クラス実装 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外共通機能のヘルパークラス |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | コンストラクタ関数群 |
| FixedSizeArrayList.cls | `Source/CorLib/System.Collections/FixedSizeArrayList.cls` | ソース | 使用例（読み取り専用コレクション） |
