# 機能設計書 108-DirectoryNotFoundException

## 概要

本ドキュメントは、VBCorLibライブラリにおける`DirectoryNotFoundException`クラスの機能設計を定義する。このクラスは、指定されたディレクトリが見つからない場合にスローされる例外を表現する。

### 本機能の処理概要

**業務上の目的・背景**：ファイルシステム操作を行うアプリケーションにおいて、ディレクトリの存在確認は重要な処理である。DirectoryNotFoundExceptionは、指定されたディレクトリ（フォルダ）が存在しない場合に発生し、ファイルパスの問題を明確に通知する。これにより、FileNotFoundExceptionとの区別が可能となり、適切なエラーハンドリングを実現する。

**機能の利用シーン**：
- ディレクトリを開こうとしたが存在しない場合
- ファイル作成時に親ディレクトリが存在しない場合
- ディレクトリ一覧取得時に対象ディレクトリが存在しない場合
- パス指定でディレクトリ部分が無効な場合

**主要な処理内容**：
1. 例外インスタンスの生成と初期化（メッセージ、内部例外を設定）
2. 例外情報のプロパティ提供（Message、HResult、ErrorNumber等）
3. 例外チェーンの追跡（GetBaseException）とシリアライズ対応
4. IObject、Exception、SystemException、IOExceptionインターフェースの実装

**関連システム・外部連携**：VBCorLibの例外階層において、IOException、SystemException、Exceptionインターフェースを実装し、.NET Frameworkの例外モデルとの互換性を提供する。

**権限による制御**：本クラスは権限制御なく、すべてのコードから利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面との直接的な関連なし |

## 機能種別

例外処理 / エラーハンドリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Message | String | Yes | エラーメッセージ | なし（空の場合はデフォルトメッセージ使用） |
| InnerException | Exception | No | 内部例外 | なし |

### 入力データソース

コンストラクタ`Cor.NewDirectoryNotFoundException`関数経由でのパラメータ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | String | エラーメッセージ |
| HResult | Long | COR_E_DIRECTORYNOTFOUND定数値 |
| ErrorNumber | Long | vbPathNotFound (76) |
| Source | String | 例外発生元の情報 |
| Data | IDictionary | ユーザー定義の追加情報 |
| InnerException | Exception | 内部例外オブジェクト |

### 出力先

例外オブジェクトとしてスロー、またはCatchブロックで捕捉

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し（NewDirectoryNotFoundException）
   └─ 新しいDirectoryNotFoundExceptionインスタンスを生成
2. Initメソッド実行
   └─ Message、InnerExceptionを設定
3. 例外スロー（Throw）
   └─ 例外がエラーハンドラに伝播
4. 例外捕捉（Catch）
   └─ 例外タイプを判定し、例外オブジェクトを取得
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[NewDirectoryNotFoundException呼び出し]
    B --> C[新しいインスタンス生成]
    C --> D[Initメソッド実行]
    D --> E[Message設定]
    E --> F[InnerException設定]
    F --> G[例外オブジェクト完成]
    G --> H[Throw実行]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-108-1 | デフォルトメッセージ | Messageが未指定の場合、Arg_DirectoryNotFoundExceptionリソースからデフォルトメッセージを取得 | Message引数がvbNullStringの場合 |
| BR-108-2 | 固定ErrorNumber | ErrorNumberは常にvbPathNotFound (76)を返却 | 常時 |
| BR-108-3 | 固定HResult | HResultは常にCOR_E_DIRECTORYNOTFOUNDを返却 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（本クラスはデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 本クラス自体が例外クラスであり、内部でエラーは発生しない | - |

### リトライ仕様

リトライ不要（例外クラスであり、再試行の概念なし）

## トランザクション仕様

該当なし

## パフォーマンス要件

例外生成は即座に完了すること（ミリ秒単位）

## セキュリティ考慮事項

- Messageにディレクトリパスが含まれる場合、機密情報（ユーザー名を含むパス等）の漏洩に注意

## 備考

- .NET FrameworkのSystem.IO.DirectoryNotFoundExceptionクラスとの互換性を意図した設計
- Persistable属性によりシリアライズ可能
- IOExceptionを継承（Implements）
- FileNotFoundExceptionとの違い：ファイルが見つからない場合はFileNotFoundException、ディレクトリが見つからない場合はDirectoryNotFoundException

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外クラスの継承階層とインターフェース実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | 例外の共通機能を提供するヘルパークラス |
| 1-2 | IOException.cls | `Source/CorLib/System.IO/IOException.cls` | 基底となるI/O例外クラス |

**読解のコツ**: DirectoryNotFoundExceptionはFileNotFoundExceptionと異なり、追加のプロパティ（ディレクトリ名）を持たない。シンプルな例外クラスである。

#### Step 2: エントリーポイントを理解する

例外オブジェクトの生成起点となるコンストラクタ関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewDirectoryNotFoundException関数（661-663行目）が例外生成の起点 |

**主要処理フロー**:
1. **661行目**: 関数定義。Message（必須）、InnerException（任意）を受け取る
2. **662行目**: New DirectoryNotFoundExceptionでインスタンス生成
3. **663行目**: Initメソッドを呼び出し、各プロパティを初期化

#### Step 3: 例外クラスの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DirectoryNotFoundException.cls | `Source/CorLib/System.IO/DirectoryNotFoundException.cls` | 主要な例外クラス実装 |

**主要処理フロー**:
- **41-45行目**: Implements宣言。IObject、Exception、SystemException、IOExceptionを実装
- **49行目**: mBase As ExceptionBase - 共通機能をExceptionBaseに委譲
- **93-95行目**: HResultプロパティ。COR_E_DIRECTORYNOTFOUND定数を返却
- **102-104行目**: ErrorNumberプロパティ。vbPathNotFound (76)を返却
- **140-142行目**: Messageプロパティ。GetExceptionMessage関数でメッセージを取得
- **215-218行目**: Initメソッド。Message、InnerExceptionを設定

### プログラム呼び出し階層図

```
Cor.NewDirectoryNotFoundException (Constructors.cls)
    │
    ├─ New DirectoryNotFoundException
    │      └─ Class_InitProperties
    │             └─ Cor.NewExceptionBase (ExceptionBase生成)
    │
    └─ DirectoryNotFoundException.Init
           ├─ mBase.Message = Message
           └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Message ───────────┐
                   │
                   ├──▶ DirectoryNotFoundException.Init ──▶ 例外オブジェクト
                   │           │                                │
InnerException ────┘           ├─ mBase.Message設定             ├─ Message
                               └─ mBase.InnerException設定      ├─ HResult (固定)
                                                                ├─ ErrorNumber (76)
                                                                └─ InnerException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DirectoryNotFoundException.cls | `Source/CorLib/System.IO/DirectoryNotFoundException.cls` | ソース | 主要な例外クラス実装 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外共通機能のヘルパークラス |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | コンストラクタ関数群 |
| IOException.cls | `Source/CorLib/System.IO/IOException.cls` | ソース | 基底I/O例外クラス |
