# 機能設計書 109-PathTooLongException

## 概要

本ドキュメントは、VBCorLibライブラリにおける`PathTooLongException`クラスの機能設計を定義する。このクラスは、パスまたはファイル名がシステムの最大長を超えている場合にスローされる例外を表現する。

### 本機能の処理概要

**業務上の目的・背景**：Windowsオペレーティングシステムには、パス長の制限（MAX_PATH = 260文字）がある。PathTooLongExceptionは、この制限を超えるパスが指定された場合に発生し、ユーザーに対してパスを短くする必要があることを通知する。深くネストされたディレクトリ構造や長いファイル名を使用する際に遭遇する可能性がある。

**機能の利用シーン**：
- 260文字を超えるパスでファイル操作を行おうとした場合
- 深くネストされたディレクトリでファイルを作成しようとした場合
- 長いファイル名を含むパスでアクセスしようとした場合
- パス結合の結果が最大長を超えた場合

**主要な処理内容**：
1. 例外インスタンスの生成と初期化（メッセージ、内部例外を設定）
2. 例外情報のプロパティ提供（Message、HResult、ErrorNumber等）
3. 例外チェーンの追跡（GetBaseException）とシリアライズ対応
4. IObject、Exception、SystemException、IOExceptionインターフェースの実装

**関連システム・外部連携**：VBCorLibの例外階層において、IOException、SystemException、Exceptionインターフェースを実装し、.NET Frameworkの例外モデルとの互換性を提供する。

**権限による制御**：本クラスは権限制御なく、すべてのコードから利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面との直接的な関連なし |

## 機能種別

例外処理 / エラーハンドリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Message | String | Yes | エラーメッセージ | なし（空の場合はデフォルトメッセージ使用） |
| InnerException | Exception | No | 内部例外 | なし |

### 入力データソース

コンストラクタ`Cor.NewPathTooLongException`関数経由でのパラメータ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | String | エラーメッセージ |
| HResult | Long | COR_E_PATHTOOLONG定数値 |
| ErrorNumber | Long | vbBadNameOrNumber (52) |
| Source | String | 例外発生元の情報 |
| Data | IDictionary | ユーザー定義の追加情報 |
| InnerException | Exception | 内部例外オブジェクト |

### 出力先

例外オブジェクトとしてスロー、またはCatchブロックで捕捉

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し（NewPathTooLongException）
   └─ 新しいPathTooLongExceptionインスタンスを生成
2. Initメソッド実行
   └─ Message、InnerExceptionを設定
3. 例外スロー（Throw）
   └─ 例外がエラーハンドラに伝播
4. 例外捕捉（Catch）
   └─ 例外タイプを判定し、例外オブジェクトを取得
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[NewPathTooLongException呼び出し]
    B --> C[新しいインスタンス生成]
    C --> D[Initメソッド実行]
    D --> E[Message設定]
    E --> F[InnerException設定]
    F --> G[例外オブジェクト完成]
    G --> H[Throw実行]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-109-1 | デフォルトメッセージ | Messageが未指定の場合、IO_PathTooLongリソースからデフォルトメッセージを取得 | Message引数がvbNullStringの場合 |
| BR-109-2 | 固定ErrorNumber | ErrorNumberは常にvbBadNameOrNumber (52)を返却 | 常時 |
| BR-109-3 | 固定HResult | HResultは常にCOR_E_PATHTOOLONGを返却 | 常時 |
| BR-109-4 | MAX_PATH制限 | Windowsのパス最大長は260文字 | Windows環境 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（本クラスはデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 本クラス自体が例外クラスであり、内部でエラーは発生しない | - |

### リトライ仕様

リトライ不要（例外クラスであり、再試行の概念なし）

## トランザクション仕様

該当なし

## パフォーマンス要件

例外生成は即座に完了すること（ミリ秒単位）

## セキュリティ考慮事項

- Messageにフルパスが含まれる場合、機密情報（ユーザー名を含むパス等）の漏洩に注意

## 備考

- .NET FrameworkのSystem.IO.PathTooLongExceptionクラスとの互換性を意図した設計
- Persistable属性によりシリアライズ可能
- IOExceptionを継承（Implements）
- Windowsの260文字制限は、ドライブ文字、コロン、バックスラッシュ、NULターミネータを含む
- Windows 10以降では、レジストリ設定やマニフェストで長いパスを有効化できるが、VB6環境では通常適用されない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外クラスの継承階層とインターフェース実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | 例外の共通機能を提供するヘルパークラス |
| 1-2 | IOException.cls | `Source/CorLib/System.IO/IOException.cls` | 基底となるI/O例外クラス |

**読解のコツ**: PathTooLongExceptionはDirectoryNotFoundExceptionと同様、シンプルな例外クラスである。ソースコードのコメント（38-42行目）にMAX_PATH制限の説明がある。

#### Step 2: エントリーポイントを理解する

例外オブジェクトの生成起点となるコンストラクタ関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewPathTooLongException関数（465-467行目）が例外生成の起点 |

**主要処理フロー**:
1. **465行目**: 関数定義。Message（必須）、InnerException（任意）を受け取る
2. **466行目**: New PathTooLongExceptionでインスタンス生成
3. **467行目**: Initメソッドを呼び出し、各プロパティを初期化

#### Step 3: 例外クラスの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PathTooLongException.cls | `Source/CorLib/System.IO/PathTooLongException.cls` | 主要な例外クラス実装 |

**主要処理フロー**:
- **47-51行目**: Implements宣言。IObject、Exception、SystemException、IOExceptionを実装
- **55行目**: mBase As ExceptionBase - 共通機能をExceptionBaseに委譲
- **99-101行目**: HResultプロパティ。COR_E_PATHTOOLONG定数を返却
- **108-110行目**: ErrorNumberプロパティ。vbBadNameOrNumber (52)を返却
- **146-148行目**: Messageプロパティ。GetExceptionMessage関数でIO_PathTooLongリソースからメッセージを取得
- **221-224行目**: Initメソッド。Message、InnerExceptionを設定

### プログラム呼び出し階層図

```
Cor.NewPathTooLongException (Constructors.cls)
    │
    ├─ New PathTooLongException
    │      └─ Class_InitProperties
    │             └─ Cor.NewExceptionBase (ExceptionBase生成)
    │
    └─ PathTooLongException.Init
           ├─ mBase.Message = Message
           └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Message ───────────┐
                   │
                   ├──▶ PathTooLongException.Init ─────▶ 例外オブジェクト
                   │           │                                │
InnerException ────┘           ├─ mBase.Message設定             ├─ Message
                               └─ mBase.InnerException設定      ├─ HResult (固定)
                                                                ├─ ErrorNumber (52)
                                                                └─ InnerException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PathTooLongException.cls | `Source/CorLib/System.IO/PathTooLongException.cls` | ソース | 主要な例外クラス実装 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外共通機能のヘルパークラス |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | コンストラクタ関数群 |
| IOException.cls | `Source/CorLib/System.IO/IOException.cls` | ソース | 基底I/O例外クラス |
| Path.cls | `Source/CorLib/System.IO/Path.cls` | ソース | パス操作クラス（この例外をスローする可能性） |
