# 機能設計書 110-CryptographicException

## 概要

本ドキュメントは、VBCorLibライブラリにおける`CryptographicException`クラスの機能設計を定義する。このクラスは、暗号化操作中にエラーが発生した場合にスローされる例外を表現する。

### 本機能の処理概要

**業務上の目的・背景**：セキュアなアプリケーション開発において、暗号化・復号化・ハッシュ化などの暗号操作は不可欠である。CryptographicExceptionは、これらの操作中に発生するエラー（不正なキー、不正なパディング、暗号プロバイダーエラーなど）を包括的に表現し、セキュリティ関連の問題を明確に通知する。

**機能の利用シーン**：
- 暗号化キーが不正な場合
- 暗号化/復号化時にパディングエラーが発生した場合
- 暗号サービスプロバイダー（CSP）の初期化に失敗した場合
- ハッシュ計算中にエラーが発生した場合
- デジタル署名の検証に失敗した場合
- 乱数生成器でエラーが発生した場合

**主要な処理内容**：
1. 例外インスタンスの生成と初期化（メッセージ、内部例外を設定）
2. 例外情報のプロパティ提供（Message、HResult、ErrorNumber等）
3. 例外チェーンの追跡（GetBaseException）とシリアライズ対応
4. IObject、Exception、SystemExceptionインターフェースの実装

**関連システム・外部連携**：VBCorLibの例外階層において、SystemException、Exceptionインターフェースを実装し、.NET Frameworkの例外モデルとの互換性を提供する。System.Security.Cryptography名前空間のクラス群で使用される。

**権限による制御**：本クラスは権限制御なく、すべてのコードから利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面との直接的な関連なし |

## 機能種別

例外処理 / エラーハンドリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Message | String | Yes | エラーメッセージ | なし（空の場合はデフォルトメッセージ使用） |
| InnerException | Exception | No | 内部例外 | なし |

### 入力データソース

コンストラクタ`Cor.NewCryptographicException`関数経由でのパラメータ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | String | エラーメッセージ |
| HResult | Long | CORSEC_E_CRYPTO定数値 |
| ErrorNumber | Long | vbInvalidProcedureCall (5) |
| Source | String | 例外発生元の情報 |
| Data | IDictionary | ユーザー定義の追加情報 |
| InnerException | Exception | 内部例外オブジェクト |

### 出力先

例外オブジェクトとしてスロー、またはCatchブロックで捕捉

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し（NewCryptographicException）
   └─ 新しいCryptographicExceptionインスタンスを生成
2. Initメソッド実行
   └─ Message、InnerExceptionを設定
3. 例外スロー（Throw）
   └─ 例外がエラーハンドラに伝播
4. 例外捕捉（Catch）
   └─ 例外タイプを判定し、例外オブジェクトを取得
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[NewCryptographicException呼び出し]
    B --> C[新しいインスタンス生成]
    C --> D[Initメソッド実行]
    D --> E[Message設定]
    E --> F[InnerException設定]
    F --> G[例外オブジェクト完成]
    G --> H[Throw実行]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-110-1 | デフォルトメッセージ | Messageが未指定の場合、Arg_CryptographyExceptionリソースからデフォルトメッセージを取得 | Message引数がvbNullStringの場合 |
| BR-110-2 | 固定ErrorNumber | ErrorNumberは常にvbInvalidProcedureCall (5)を返却 | 常時 |
| BR-110-3 | 固定HResult | HResultは常にCORSEC_E_CRYPTOを返却 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（本クラスはデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 本クラス自体が例外クラスであり、内部でエラーは発生しない | - |

### リトライ仕様

リトライ不要（例外クラスであり、再試行の概念なし）

## トランザクション仕様

該当なし

## パフォーマンス要件

例外生成は即座に完了すること（ミリ秒単位）

## セキュリティ考慮事項

- Messageに暗号キーや機密データを含めないこと
- エラーメッセージから暗号化アルゴリズムの脆弱性が推測されないよう注意
- ログ出力時にセキュリティ情報の漏洩に注意

## 備考

- .NET FrameworkのSystem.Security.Cryptography.CryptographicExceptionクラスとの互換性を意図した設計
- Persistable属性によりシリアライズ可能
- System.Security.Cryptography名前空間に配置されている
- HResultとしてCORSEC_E_CRYPTO（セキュリティ関連の特別なHRESULT）を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外クラスの継承階層とインターフェース実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | 例外の共通機能を提供するヘルパークラス |

**読解のコツ**: CryptographicExceptionは暗号化操作専用の例外であり、他の例外クラスと同じ構造だが、HResultとして暗号関連の特別な値（CORSEC_E_CRYPTO）を使用している。

#### Step 2: エントリーポイントを理解する

例外オブジェクトの生成起点となるコンストラクタ関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewCryptographicException関数（1161-1163行目）が例外生成の起点 |

**主要処理フロー**:
1. **1161行目**: 関数定義。Message（必須）、InnerException（任意）を受け取る
2. **1162行目**: New CryptographicExceptionでインスタンス生成
3. **1163行目**: Initメソッドを呼び出し、各プロパティを初期化

#### Step 3: 例外クラスの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CryptographicException.cls | `Source/CorLib/System.Security.Cryptography/CryptographicException.cls` | 主要な例外クラス実装 |

**主要処理フロー**:
- **41-44行目**: Implements宣言。IObject、Exception、SystemExceptionを実装
- **50行目**: mBase As ExceptionBase - 共通機能をExceptionBaseに委譲
- **94-96行目**: HResultプロパティ。CORSEC_E_CRYPTO定数を返却
- **103-105行目**: ErrorNumberプロパティ。vbInvalidProcedureCall (5)を返却
- **141-143行目**: Messageプロパティ。GetExceptionMessage関数でArg_CryptographyExceptionリソースからメッセージを取得
- **216-219行目**: Initメソッド。Message、InnerExceptionを設定

### プログラム呼び出し階層図

```
Cor.NewCryptographicException (Constructors.cls)
    │
    ├─ New CryptographicException
    │      └─ Class_InitProperties
    │             └─ Cor.NewExceptionBase (ExceptionBase生成)
    │
    └─ CryptographicException.Init
           ├─ mBase.Message = Message
           └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Message ───────────┐
                   │
                   ├──▶ CryptographicException.Init ───▶ 例外オブジェクト
                   │           │                                │
InnerException ────┘           ├─ mBase.Message設定             ├─ Message
                               └─ mBase.InnerException設定      ├─ HResult (CORSEC_E_CRYPTO)
                                                                ├─ ErrorNumber (5)
                                                                └─ InnerException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CryptographicException.cls | `Source/CorLib/System.Security.Cryptography/CryptographicException.cls` | ソース | 主要な例外クラス実装 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外共通機能のヘルパークラス |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | コンストラクタ関数群 |
| CryptoAPI.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPI.cls` | ソース | 暗号APIラッパー（この例外を使用） |
| CryptoAPIHash.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPIHash.cls` | ソース | ハッシュクラス（この例外を使用） |
| CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` | ソース | 暗号変換クラス（この例外を使用） |
| RSACryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls` | ソース | RSA暗号クラス（この例外を使用） |
| DSACryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/DSACryptoServiceProvider.cls` | ソース | DSA署名クラス（この例外を使用） |
