# 機能設計書 2-CorString

## 概要

本ドキュメントは、VBCorLibライブラリにおける文字列操作機能（CorString）の設計を記述する。CorStringクラスは、VB6/VBAの文字列に対して.NET Frameworkの`System.String`クラスに相当する高度な書式設定・操作機能を提供する静的クラスである。

### 本機能の処理概要

CorStringクラスは、文字列の書式設定、比較、検索、分割、結合、トリミングなどの包括的なメソッド群を提供する。

**業務上の目的・背景**：VB6/VBAの標準的な文字列操作関数は機能が限られており、.NET Frameworkで提供されるような高度な文字列操作を行う際にはカスタムコードが必要となる。CorStringは.NET Frameworkのような高度な文字列操作機能をVB6/VBA環境で利用可能にし、国際化対応やカルチャに依存した文字列比較など、ビジネスアプリケーションに必要な機能を提供することを目的としている。

**機能の利用シーン**：テキスト処理を行う全ての場面で利用される。具体的には、ユーザー入力データのバリデーション・整形、レポート生成時の書式設定、CSV/ログファイルのパース処理、多言語対応アプリケーションでの文字列比較、データベースクエリの動的生成などの場面で活用される。

**主要な処理内容**：
1. 文字列の書式設定（Format、FormatEx、FormatArray、FormatArrayEx - .NET形式のプレースホルダー対応）
2. 文字列の比較（Compare、CompareEx、CompareOrdinal、CompareCultural - カルチャ対応）
3. 文字列の等価性判定（Equals）
4. 文字列の検索（IndexOfAny、LastIndexOfAny）
5. 文字列の分割・結合（Split、Join）
6. 文字列のトリミング（Trim、TrimStart、TrimEnd）
7. 文字列のパディング（PadLeft、PadRight）
8. 文字列の挿入・削除（Insert、Remove）
9. 文字列の開始・終了判定（StartsWith、EndsWith）
10. 文字列状態の判定（IsNull、IsNullOrWhiteSpace）
11. 文字配列変換（ToCharArray、CopyTo、CharAt）

**関連システム・外部連携**：外部システムとの連携はない。Windows APIの`CompareStringW`、`CompareStringOrdinal`等を使用してカルチャ依存の文字列比較を実現している。

**権限による制御**：権限による制御は行わない。全てのメソッドは同一の動作を行う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラスである |

## 機能種別

計算処理 / データ操作ユーティリティ / 文字列処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| S / StrA / StrB | String | Yes | 操作対象の文字列 | なし |
| FormatText | String | Yes | 書式文字列 | プレースホルダー形式 |
| Args | Variant() | Yes | 書式引数配列 | 配列型であること |
| Separator | String/Integer() | No | 分割・結合の区切り文字 | String または Integer配列 |
| TrimChars | String/Integer() | No | トリム対象文字 | String または Integer配列 |
| StartIndex | Long | No | 開始インデックス（0ベース） | 0以上、文字列長以下 |
| Length/Count | Long | No | 処理対象の文字数 | 0以上 |
| ComparisonType | StringComparison | No | 比較方法 | 列挙値 |
| Options | CompareOptions | No | 比較オプション | 列挙値 |
| Culture | CultureInfo | No | カルチャ情報 | CultureInfoオブジェクト |

### 入力データソース

呼び出し元からパラメータとして渡される文字列データ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 書式設定結果 | String | Format系メソッドの戻り値 |
| 比較結果 | Long | Compare系メソッドの戻り値（-1, 0, 1） |
| 等価判定結果 | Boolean | Equals、StartsWith、EndsWithの戻り値 |
| 検索結果インデックス | Long | IndexOfAny、LastIndexOfAnyの戻り値（見つからない場合は-1） |
| 分割結果配列 | String() | Splitの戻り値 |
| 結合結果 | String | Joinの戻り値 |
| トリム結果 | String | Trim系メソッドの戻り値 |
| 編集結果 | String | Insert、Remove、PadLeft、PadRightの戻り値 |
| 文字配列 | Integer() | ToCharArrayの戻り値 |
| 文字コード | Integer | CharAtの戻り値 |
| 状態判定結果 | Boolean | IsNull、IsNullOrWhiteSpaceの戻り値 |

### 出力先

呼び出し元への戻り値

## 処理フロー

### 処理シーケンス

```
1. パラメータ検証
   └─ インデックス・長さの範囲チェック
2. 比較タイプの判定（比較系メソッドの場合）
   └─ StringComparison/CompareOptionsに基づく処理分岐
3. 文字列処理の実行
   └─ メソッドに応じた処理（比較、検索、分割等）
4. 結果の返却
   └─ 戻り値の設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{パラメータ検証}
    B -->|無効| C[例外をスロー]
    B -->|有効| D{処理種別}
    D -->|比較| E[CompareHelper呼び出し]
    D -->|書式設定| F[StringBuilder.AppendFormat]
    D -->|分割| G[FindSeparatorIndexes]
    D -->|トリム| H[TrimCore]
    D -->|検索| I[IndexOfAnyCore]
    E --> J[結果返却]
    F --> J
    G --> K[Split配列生成]
    K --> J
    H --> J
    I --> J
    J --> L[終了]
    C --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 0ベースインデックス | 全てのインデックスは0ベース | 全てのメソッド |
| BR-02 | 検索失敗時の戻り値 | 検索に失敗した場合、-1を返す | IndexOfAny、LastIndexOfAny |
| BR-03 | カルチャ対応比較 | StringComparisonに基づいてカルチャ依存/非依存を切替 | Compare系メソッド |
| BR-04 | 空区切り時のホワイトスペース分割 | Separatorが空または省略時はホワイトスペースで分割 | Split |

### 計算ロジック

**比較結果の計算**
- StrA < StrB の場合: 負の値を返す
- StrA = StrB の場合: 0を返す
- StrA > StrB の場合: 正の値を返す

**StringComparison列挙値**
- CurrentCulture (0): 現在のカルチャで比較
- CurrentCultureIgnoreCase (1): 現在のカルチャで大文字小文字を無視して比較
- InvariantCulture (2): インバリアントカルチャで比較
- InvariantCultureIgnoreCase (3): インバリアントカルチャで大文字小文字を無視して比較
- Ordinal (4): 序数（バイナリ）比較
- OrdinalIgnoreCase (5): 大文字小文字を無視した序数比較
- BinaryCompare (100): VB標準のvbBinaryCompare
- TextCompare (101): VB標準のvbTextCompare

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本機能はデータベース操作を行わない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentNullException | 引数エラー | Args配列がNull | 有効な配列を渡す |
| ArgumentOutOfRangeException | 範囲エラー | インデックスまたは長さが範囲外 | 有効な範囲を指定 |
| ArgumentException | 引数エラー | 無効なComparisonType、無効なSeparator型 | 正しい列挙値/型を使用 |
| NotSupportedException | 非サポート | CompareExでTextCompare/BinaryCompare使用 | 他のComparisonTypeを使用 |

### リトライ仕様

リトライは行わない。エラー発生時は即座に例外をスロー。

## トランザクション仕様

本機能はトランザクション管理を行わない。文字列操作はメモリ上で直接実行される。

## パフォーマンス要件

- 文字列比較: CopyMemoryによる高速なメモリ比較
- 書式設定: StringBuilderを使用した効率的な文字列構築
- 分割処理: 事前にセパレータ位置を特定してから一括分割
- 内部配列の再利用: mString1/mString2等の静的配列による一時メモリ削減

## セキュリティ考慮事項

- 低レベルメモリ操作を行うため、StrPtrによるポインタ取得に依存
- 書式文字列インジェクションの可能性（呼び出し元の責任）

## 備考

- VB6の文字列はUnicode（UTF-16）で格納される
- Integer配列を使用して文字配列を表現（VB6にはChar型がないため）
- IFormatProviderインターフェースを使用してカスタム書式をサポート
- StringBuilderCacheを使用して書式設定のパフォーマンスを最適化

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 列挙型とデータ構造を理解する

比較オプションや分割オプションの列挙型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CorString.cls | `Source/CorLib/System/CorString.cls` | 57-66行目: StringComparison列挙型の定義 |
| 1-2 | CorString.cls | `Source/CorLib/System/CorString.cls` | 93-103行目: CompareOptions列挙型の定義 |
| 1-3 | CorString.cls | `Source/CorLib/System/CorString.cls` | 111-114行目: StringSplitOptions列挙型の定義 |
| 1-4 | CorString.cls | `Source/CorLib/System/CorString.cls` | 116-126行目: 内部変数（SafeArray構造体等）の定義 |

**読解のコツ**: StringComparison列挙型の各値がWindows APIのどの比較関数にマッピングされるかを理解することが重要。

#### Step 2: 基本メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CorString.cls | `Source/CorLib/System/CorString.cls` | 134-136行目: IsNull - StrPtrによるNull判定 |
| 2-2 | CorString.cls | `Source/CorLib/System/CorString.cls` | 144-164行目: IsNullOrWhiteSpace - ホワイトスペース判定 |
| 2-3 | CorString.cls | `Source/CorLib/System/CorString.cls` | 1265-1272行目: CharAt - 指定位置の文字取得 |

**主要処理フロー**:
1. **134-136行目**: IsNull - StrPtr(S) = vbNullPtrでNull判定
2. **144-164行目**: IsNullOrWhiteSpace - AllocCharsで文字配列に変換後、IsWhiteSpaceで各文字をチェック

#### Step 3: 書式設定処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CorString.cls | `Source/CorLib/System/CorString.cls` | 178-182行目: Format - ParamArrayからの引数受け取り |
| 3-2 | CorString.cls | `Source/CorLib/System/CorString.cls` | 1381-1389行目: FormatCore - StringBuilder使用 |

**主要処理フロー**:
- **180行目**: Helper.Swap4でParamArray引数を通常配列に変換
- **1386行目**: StringBuilderCache.Acquireでキャッシュからビルダーを取得
- **1387行目**: AppendFormatArrayExで書式設定

#### Step 4: 比較処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CorString.cls | `Source/CorLib/System/CorString.cls` | 1004-1013行目: Compare - StringComparisonに基づく分岐 |
| 4-2 | CorString.cls | `Source/CorLib/System/CorString.cls` | 959-972行目: Equals - 等価性判定 |
| 4-3 | CorString.cls | `Source/CorLib/System/CorString.cls` | 1186-1188行目: CompareOrdinal - 序数比較 |
| 4-4 | CorString.cls | `Source/CorLib/System/CorString.cls` | 1118-1120行目: CompareCultural - カルチャ依存比較 |

**主要処理フロー**:
- **1006-1009行目**: BinaryCompare/TextCompareの場合はVB標準StrComp使用
- **1011行目**: その他はCompareHelperを呼び出し

#### Step 5: 分割・結合処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | CorString.cls | `Source/CorLib/System/CorString.cls` | 674-717行目: Split - メインロジック |
| 5-2 | CorString.cls | `Source/CorLib/System/CorString.cls` | 719-749行目: FindSeparatorIndexes - セパレータ検出 |
| 5-3 | CorString.cls | `Source/CorLib/System/CorString.cls` | 852-880行目: FindWhitespaceSeparatorIndexes - 空白検出 |
| 5-4 | CorString.cls | `Source/CorLib/System/CorString.cls` | 364-390行目: Join - 結合処理 |

**主要処理フロー**:
- **690-702行目**: セパレータの型に応じて検索方法を分岐
- **705-712行目**: オプションに応じてSplitWithEmptiesまたはSplitWithoutEmptiesを呼び出し

#### Step 6: トリム・パディング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | CorString.cls | `Source/CorLib/System/CorString.cls` | 320-322行目: TrimStart - 先頭トリム |
| 6-2 | CorString.cls | `Source/CorLib/System/CorString.cls` | 334-336行目: TrimEnd - 末尾トリム |
| 6-3 | CorString.cls | `Source/CorLib/System/CorString.cls` | 348-350行目: Trim - 両端トリム |
| 6-4 | CorString.cls | `Source/CorLib/System/CorString.cls` | 280-288行目: PadLeft - 左パディング |
| 6-5 | CorString.cls | `Source/CorLib/System/CorString.cls` | 300-308行目: PadRight - 右パディング |

### プログラム呼び出し階層図

```
CorString (Public Methods)
    │
    ├─ Format / FormatEx / FormatArray / FormatArrayEx
    │      └─ FormatCore
    │             ├─ StringBuilderCache.Acquire
    │             ├─ StringBuilder.AppendFormatArrayEx
    │             └─ StringBuilderCache.GetStringAndRelease
    │
    ├─ Compare / CompareV
    │      ├─ StrComp (BinaryCompare/TextCompare)
    │      └─ CompareHelper
    │
    ├─ CompareEx
    │      ├─ ValidateAndGetLengths
    │      ├─ GetOffsetPointers
    │      └─ CompareHelper
    │
    ├─ CompareCultural / CompareCulturalEx
    │      └─ CompareCulturalHelper
    │
    ├─ CompareOrdinal / CompareOrdinalEx
    │      └─ CompareStringOrdinal (Windows API)
    │
    ├─ Equals
    │      ├─ EqualsOrdinal
    │      ├─ StrComp
    │      └─ CompareHelper
    │
    ├─ Split
    │      ├─ FindSeparatorIndexes
    │      │      ├─ FindStringSeparatorIndexes
    │      │      ├─ FindStringSeparatorsIndexes
    │      │      └─ FindCharSeparatorsIndexes
    │      ├─ FindWhitespaceSeparatorIndexes
    │      ├─ SplitWithEmpties
    │      └─ SplitWithoutEmpties
    │             ├─ CountSubstrings
    │             └─ CreateSubstrings
    │
    ├─ Join
    │      ├─ JoinCollection
    │      ├─ JoinStrings
    │      ├─ JoinVariants
    │      └─ JoinArray
    │
    ├─ Trim / TrimStart / TrimEnd
    │      └─ TrimCore
    │
    ├─ IndexOfAny / LastIndexOfAny
    │      └─ IndexOfAnyCore
    │             └─ AsChars
    │
    └─ StartsWith / EndsWith
           └─ CompareHelper
```

### データフロー図

```
[入力]                    [処理]                              [出力]

文字列(String) ─────────▶ パラメータ検証 ──────────────────▶ エラーまたは続行
                              │
                              ▼
                       [処理種別判定]
                              │
書式文字列+引数 ────────▶ FormatCore ────────────────────▶ 書式設定済み文字列
                              │
2つの文字列 ────────────▶ CompareHelper ─────────────────▶ 比較結果(Long)
                              │
文字列+セパレータ ──────▶ FindSeparatorIndexes ──────────▶ 分割配列(String())
                              │
文字列+トリム文字 ──────▶ TrimCore ──────────────────────▶ トリム済み文字列
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CorString.cls | `Source/CorLib/System/CorString.cls` | ソース | 文字列操作のメインクラス |
| StringBuilder.cls | `Source/CorLib/System.Text/StringBuilder.cls` | ソース | 可変長文字列ビルダー |
| StringBuilderCache.cls | `Source/CorLib/System.Text/StringBuilderCache.cls` | ソース | StringBuilderのキャッシュ |
| CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | ソース | カルチャ情報 |
| CompareInfo.cls | `Source/CorLib/System.Globalization/CompareInfo.cls` | ソース | 文字列比較情報 |
| Char.cls | `Source/CorLib/System/Char.cls` | ソース | 文字操作ヘルパー |
| modCorString.bas | `Source/CorLib/System/modCorString.bas` | ソース | 文字列操作ヘルパー関数 |
