# 機能設計書 34-File

## 概要

本ドキュメントは、VBCorLibライブラリにおけるFileクラスの機能設計について記述する。Fileクラスは、ファイルの作成、コピー、移動、削除、オープンなどの静的メソッドを提供するユーティリティクラスである。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーション開発において、ファイル操作は最も基本的かつ頻繁に必要となる処理である。Fileクラスは、.NET Frameworkと互換性のあるファイル操作APIを提供し、ファイルの存在確認、属性操作、タイムスタンプ管理、読み書き操作を簡潔なコードで実現可能にする。これにより、VB6/VBA環境でもモダンなファイル操作が可能となる。

**機能の利用シーン**：ファイルの作成・削除・コピー・移動、ファイル内容の読み書き、ファイル属性やタイムスタンプの取得・設定、テキストファイルの行単位処理、バイナリファイルの一括読み書きなど、ファイル操作が必要なすべての場面で利用される。

**主要な処理内容**：
1. ファイル存在確認（Exists）
2. ファイル作成・オープン（Create、OpenFile、OpenRead、OpenWrite、OpenText）
3. ファイルコピー・移動・削除（Copy、Move、Delete）
4. テキスト読み書き（ReadAllText、WriteAllText、ReadAllLines、WriteAllLines、ReadLines、AppendText、AppendAllText、AppendAllLines）
5. バイナリ読み書き（ReadAllBytes、WriteAllBytes）
6. ファイル属性操作（GetAttributes、SetAttributes）
7. タイムスタンプ操作（GetCreationTime、SetCreationTime、GetLastAccessTime、SetLastAccessTime、GetLastWriteTime、SetLastWriteTime）

**関連システム・外部連携**：FileStream、StreamReader、StreamWriter、Pathクラスと連携。Windows APIを直接呼び出してファイル操作を実行。

**権限による制御**：ファイルシステムのアクセス権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | Base64 Encoding | 主機能 | ReadAllBytes、WriteAllBytes、Exists、Delete |
| 6 | Real-Time Decryption | 補助機能 | OpenFile |
| 7 | File Encryption | 補助機能 | OpenFile |

## 機能種別

ファイル操作ユーティリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Path | String | Yes | 対象ファイルのパス | 空文字列の場合はArgumentException |
| SourceFileName | String | Yes | コピー元ファイルパス | 空文字列の場合はArgumentException |
| DestFileName | String | Yes | コピー先ファイルパス | 空文字列の場合はArgumentException |
| OverWrite | Boolean | No | 上書き許可フラグ（デフォルト: False） | - |
| Mode | FileMode | Yes | ファイルオープンモード | - |
| Access | FileAccess | No | アクセスモード | - |
| Share | FileShare | No | 共有モード（デフォルト: None） | - |
| BufferSize | Long | No | バッファサイズ（デフォルト: 4096） | - |
| Encoding | Encoding | No | テキストエンコーディング | Nothingの場合はUTF-8 |
| Contents | String/Variant | Yes | 書き込み内容 | - |

### 入力データソース

プログラムから直接渡されるファイルパスおよびデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FileStream | FileStream | Create、OpenFile、OpenRead、OpenWriteで返されるストリーム |
| StreamReader | StreamReader | OpenTextで返されるリーダー |
| StreamWriter | StreamWriter | AppendText、CreateTextで返されるライター |
| Boolean | Boolean | Existsで返される存在確認結果 |
| String | String | ReadAllTextで返されるファイル内容 |
| Byte() | Byte() | ReadAllBytesで返されるバイト配列 |
| String() | String() | ReadAllLinesで返される行配列 |
| IEnumerable | IEnumerable | ReadLinesで返される行イテレータ |
| FileAttributes | FileAttributes | GetAttributesで返される属性 |
| CorDateTime | CorDateTime | タイムスタンプ取得で返される日時 |

### 出力先

呼び出し元のプログラムに戻り値として返される、またはファイルシステム

## 処理フロー

### 処理シーケンス

```
1. パスのバリデーション
   └─ 空文字列チェック
   └─ フルパスへの変換（Path.GetFullPath）
2. ファイル操作実行
   └─ Windows API呼び出し
3. 結果の返却またはエラー処理
   └─ IOError.WinIOErrorでエラー変換
```

### フローチャート

```mermaid
flowchart TD
    A[メソッド呼び出し] --> B{パス検証}
    B -->|空文字列| C[ArgumentException]
    B -->|有効| D[Path.GetFullPath]
    D --> E[Windows API呼び出し]
    E --> F{成功?}
    F -->|Yes| G[結果を返す]
    F -->|No| H[IOError.WinIOError]
    H --> I[例外スロー]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 自己コピー防止 | 同一ファイルへのコピーは何もせず終了 | Copy実行時 |
| BR-002 | 上書き制御 | OverWrite=Falseの場合、既存ファイルへの上書き禁止 | Copy実行時 |
| BR-003 | ファイルサイズ制限 | ReadAllBytesは2GB以下のファイルのみ対応 | ReadAllBytes実行時 |
| BR-004 | デフォルトエンコーディング | テキスト操作時はUTF-8がデフォルト | 各テキストメソッド |
| BR-005 | 削除時の存在確認 | ファイルが存在しない場合はエラーとしない | Delete実行時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Argument_EmptyFileName | ArgumentException | ファイル名が空文字列 | 有効なファイル名を指定 |
| Argument_EmptyPath | ArgumentException | パスが空文字列 | 有効なパスを指定 |
| ERROR_FILE_NOT_FOUND | FileNotFoundException | ファイルが見つからない | ファイルの存在を確認 |
| ERROR_FILE_EXISTS | IOException | 上書き禁止で既存ファイルあり | OverWrite=Trueを指定 |
| IO_FileTooLong2GB | IOException | ファイルが2GBを超過 | 分割読み込みを使用 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

本機能はトランザクション管理を行わない。ファイル操作は即座にファイルシステムに反映される。

## パフォーマンス要件

- ReadAllBytes/WriteAllBytesはファイル全体をメモリに読み込むため、大きなファイルには注意
- ReadLinesは遅延読み込みを行い、大きなファイルでもメモリ効率が良い

## セキュリティ考慮事項

- ファイルシステムのアクセス権限に依存
- パストラバーサル攻撃に注意（Path.GetFullPathで正規化）
- 一時ファイルはGetTempFileNameで安全に作成

## 備考

- .NET FrameworkのSystem.IO.Fileクラスと高い互換性を持つ
- 静的クラスとして設計されており、インスタンス化不要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | File.cls | `Source/CorLib/System.IO/File.cls` | 38-42行目のクラスコメントで概要を確認 |

**読解のコツ**: Fileクラスは静的メソッドのみを持つユーティリティクラス。各メソッドは独立しており、共有状態は最小限。

#### Step 2: 基本操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | File.cls | `Source/CorLib/System.IO/File.cls` | 190-203行目のExists関数 |
| 2-2 | File.cls | `Source/CorLib/System.IO/File.cls` | 168-182行目のDelete関数 |
| 2-3 | File.cls | `Source/CorLib/System.IO/File.cls` | 111-138行目のCopy関数 |

**主要処理フロー**:
- **198行目**: Path.GetFullPathでパスを正規化
- **200-202行目**: GetFileDataでファイル情報取得、ディレクトリでないことを確認

#### Step 3: 読み書き操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | File.cls | `Source/CorLib/System.IO/File.cls` | 459-463行目のReadAllText関数 |
| 3-2 | File.cls | `Source/CorLib/System.IO/File.cls` | 471-490行目のReadAllBytes関数 |
| 3-3 | File.cls | `Source/CorLib/System.IO/File.cls` | 563-567行目のWriteAllText関数 |

**主要処理フロー**:
- **460-462行目**: StreamReaderを使用してファイル全体を読み込み
- **476-486行目**: FileStreamを使用してバイト配列に読み込み

### プログラム呼び出し階層図

```
File (静的クラス)
    │
    ├─ Exists
    │      └─ GetFileData (内部)
    │             └─ GetFileAttributesExW (Win API)
    │
    ├─ Copy
    │      ├─ Path.GetFullPath
    │      └─ CopyFileW (Win API)
    │
    ├─ Move
    │      ├─ Path.GetFullPath
    │      └─ MoveFileW (Win API)
    │
    ├─ Delete
    │      ├─ Path.GetFullPath
    │      └─ DeleteFileW (Win API)
    │
    ├─ Create / OpenFile / OpenRead / OpenWrite
    │      └─ NewFileStream
    │
    ├─ OpenText / CreateText / AppendText
    │      └─ NewStreamReader / NewStreamWriter
    │
    ├─ ReadAllText / ReadAllLines / ReadLines
    │      └─ NewStreamReader
    │
    ├─ WriteAllText / WriteAllLines
    │      └─ NewStreamWriter
    │
    ├─ ReadAllBytes
    │      └─ NewFileStream
    │
    ├─ WriteAllBytes
    │      └─ NewFileStream
    │
    ├─ GetAttributes / SetAttributes
    │      └─ GetFileAttributesW / SetFileAttributesW (Win API)
    │
    └─ Get/SetCreationTime, Get/SetLastAccessTime, Get/SetLastWriteTime
           └─ SetFileTime (Win API)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パス文字列 ─────────▶ Path.GetFullPath
                           │
                           ▼
                     Windows API
                           │
                           ▼
                     結果/ストリーム ─────────▶ 呼び出し元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| File.cls | `Source/CorLib/System.IO/File.cls` | ソース | Fileクラス本体 |
| Path.cls | `Source/CorLib/System.IO/Path.cls` | ソース | パス操作 |
| FileStream.cls | `Source/CorLib/System.IO/FileStream.cls` | ソース | ファイルストリーム |
| StreamReader.cls | `Source/CorLib/System.IO/StreamReader.cls` | ソース | テキスト読み込み |
| StreamWriter.cls | `Source/CorLib/System.IO/StreamWriter.cls` | ソース | テキスト書き込み |
| IOError.cls | `Source/CorLib/System.IO/IOError.cls` | ソース | エラー変換 |
| FileLineEnumerator.cls | `Source/CorLib/System.IO/FileLineEnumerator.cls` | ソース | 行イテレータ |
