# 機能設計書 35-Directory

## 概要

本ドキュメントは、VBCorLibライブラリにおけるDirectoryクラスの機能設計について記述する。Directoryクラスは、ディレクトリの作成、移動、削除、情報取得などの静的メソッドを提供するユーティリティクラスである。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーション開発において、ディレクトリ（フォルダ）操作は基本的かつ頻繁に必要となる処理である。Directoryクラスは、.NET Frameworkと互換性のあるディレクトリ操作APIを提供し、ディレクトリの存在確認、作成、削除、ファイル・サブディレクトリの一覧取得を簡潔なコードで実現可能にする。

**機能の利用シーン**：ディレクトリの作成・削除・移動、ディレクトリ内のファイル・サブディレクトリの一覧取得、カレントディレクトリの変更、ディレクトリ属性やタイムスタンプの取得・設定、論理ドライブ一覧の取得など、ディレクトリ操作が必要なすべての場面で利用される。

**主要な処理内容**：
1. ディレクトリ存在確認（Exists）
2. ディレクトリ作成（CreateDirectory）
3. ディレクトリ削除（Delete）- 再帰オプション対応
4. ディレクトリ移動（Move）
5. ファイル・ディレクトリ一覧取得（GetFiles、GetDirectories、GetFileSystemEntries）- 再帰検索対応
6. カレントディレクトリ操作（GetCurrentDirectory、SetCurrentDirectory）
7. 論理ドライブ一覧取得（GetLogicalDrives）
8. 親ディレクトリ取得（GetParent）
9. タイムスタンプ操作

**関連システム・外部連携**：DirectoryInfo、FileInfo、Pathクラスと連携。Windows APIを直接呼び出してディレクトリ操作を実行。

**権限による制御**：ファイルシステムのアクセス権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないライブラリクラスである |

## 機能種別

ディレクトリ操作ユーティリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Path | String | Yes | 対象ディレクトリのパス | 空文字列の場合はArgumentException |
| SourceDirName | String | Yes | 移動元ディレクトリパス | 空文字列の場合はArgumentException |
| DestDirName | String | Yes | 移動先ディレクトリパス | 空文字列の場合はArgumentException |
| Recursive | Boolean | No | 再帰削除フラグ（デフォルト: False） | - |
| SearchPattern | String | No | 検索パターン（デフォルト: "*"） | ".."を含む場合はArgumentException |
| SearchOption | SearchOption | No | 検索オプション（TopDirectoryOnly/AllDirectories） | - |

### 入力データソース

プログラムから直接渡されるディレクトリパス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DirectoryInfo | DirectoryInfo | CreateDirectory、GetParentで返されるディレクトリ情報 |
| Boolean | Boolean | Existsで返される存在確認結果 |
| String() | String() | GetFiles、GetDirectories、GetFileSystemEntries、GetLogicalDrivesで返される配列 |
| String | String | GetCurrentDirectory、GetDirectoryRootで返されるパス |
| CorDateTime | CorDateTime | タイムスタンプ取得で返される日時 |

### 出力先

呼び出し元のプログラムに戻り値として返される

## 処理フロー

### 処理シーケンス

```
1. パスのバリデーション
   └─ 空文字列チェック
   └─ フルパスへの変換
2. ディレクトリ操作実行
   └─ Windows API呼び出し
3. 結果の返却またはエラー処理
```

### フローチャート

```mermaid
flowchart TD
    A[メソッド呼び出し] --> B{パス検証}
    B -->|空文字列| C[ArgumentException]
    B -->|有効| D[Path.GetFullPath]
    D --> E[Windows API呼び出し]
    E --> F{成功?}
    F -->|Yes| G[結果を返す]
    F -->|No| H[IOError.WinIOError]
    H --> I[例外スロー]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 再帰削除 | Recursive=Trueの場合、中身も含めて削除 | Delete実行時 |
| BR-002 | 同一ルート制約 | 移動元と移動先は同じドライブルートである必要あり | Move実行時 |
| BR-003 | 同一パス禁止 | 移動元と移動先が同じパスの場合はエラー | Move実行時 |
| BR-004 | 末尾セパレータ除去 | パス末尾のディレクトリセパレータは除去 | CreateDirectory実行時 |
| BR-005 | 検索パターン検証 | ".."を含むパターンは禁止 | GetFiles等実行時 |

### 計算ロジック

**ディレクトリパス階層の作成**:
```
1. パスを階層ごとに分割
2. 存在しない最上位階層から順に作成
3. スタックを使って作成順序を管理
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Argument_EmptyPath | ArgumentException | パスが空文字列 | 有効なパスを指定 |
| Argument_EmptyFileName | ArgumentException | ファイル名が空 | 有効なファイル名を指定 |
| Arg_InvalidSearchPattern | ArgumentException | 不正な検索パターン | ".."を含まないパターンを使用 |
| IO_SourceDestMustBeDifferent | IOException | 移動元と移動先が同一 | 異なるパスを指定 |
| IO_SourceDestMustHaveSameRoot | IOException | ルートが異なる | 同じドライブを指定 |
| Arg_PathIsAVolume | ArgumentException | ルートボリュームを指定 | ボリューム以外を指定 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- GetFiles/GetDirectoriesでAllDirectoriesを指定した場合、大きなディレクトリ構造では時間がかかる可能性がある
- 再帰削除は対象ファイル数に比例して時間がかかる

## セキュリティ考慮事項

- ファイルシステムのアクセス権限に依存
- 再帰削除は注意して使用（システムディレクトリを誤って削除しないよう）
- シンボリックリンクのループに注意（AllDirectoriesオプション使用時）

## 備考

- .NET FrameworkのSystem.IO.Directoryクラスと高い互換性を持つ
- 静的クラスとして設計されており、インスタンス化不要
- SearchOption列挙体でAllDirectoriesを指定すると再帰検索

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 38-43行目のクラスコメントで概要を確認 |
| 1-2 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 61-64行目のSearchOption列挙体 |

**読解のコツ**: Directoryクラスは静的メソッドのみを持つユーティリティクラス。SearchOptionでサブディレクトリ検索の有無を制御。

#### Step 2: 基本操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 138-147行目のExists関数 |
| 2-2 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 74-86行目のCreateDirectory関数 |
| 2-3 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 157-200行目のDelete関数 |

**主要処理フロー**:
- **143-146行目**: GetFileDataで属性取得、DirectoryAttr判定
- **81-83行目**: GetDirectoryPathsToCreateで作成すべきパスのスタック取得
- **164-193行目**: 再帰フラグによる分岐と再帰削除処理

#### Step 3: 検索操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 303-305行目のGetDirectories関数 |
| 3-2 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 339-341行目のGetFiles関数 |
| 3-3 | Directory.cls | `Source/CorLib/System.IO/Directory.cls` | 540-589行目のGetFileSystemEntriesCore関数 |

**主要処理フロー**:
- **540-541行目**: 検索パターンの検証
- **550-576行目**: FindFirstFile/FindNextFileによるエントリ列挙
- **584-586行目**: サブフォルダの再帰処理

### プログラム呼び出し階層図

```
Directory (静的クラス)
    │
    ├─ Exists
    │      └─ File.GetFileData (内部)
    │
    ├─ CreateDirectory
    │      ├─ GetFullPath (内部)
    │      ├─ GetDirectoryPathsToCreate (内部)
    │      │      └─ Directory.Exists
    │      └─ CreateDirectoryPaths (内部)
    │             └─ CreateDirectoryW (Win API)
    │
    ├─ Delete
    │      ├─ Path.GetFullPath
    │      ├─ SafeFindFirstFile
    │      ├─ FindNextFileW (Win API)
    │      ├─ Delete (再帰呼び出し)
    │      ├─ DeleteFileW (Win API)
    │      └─ RemoveDirectoryW (Win API)
    │
    ├─ Move
    │      ├─ Path.GetFullPath
    │      ├─ Path.GetPathRoot
    │      └─ MoveFileW (Win API)
    │
    ├─ GetDirectories / GetFiles / GetFileSystemEntries
    │      └─ GetFileSystemEntriesCore (内部)
    │             ├─ SafeFindFirstFile
    │             ├─ FindNextFileW (Win API)
    │             └─ GetFileSystemEntriesCore (再帰)
    │
    ├─ GetLogicalDrives
    │      └─ CorType.GetLogicalDrives
    │
    ├─ GetCurrentDirectory
    │      └─ GetCurrentDirectoryW (Win API)
    │
    ├─ SetCurrentDirectory
    │      └─ SetCurrentDirectoryW (Win API)
    │
    └─ Get/SetCreationTime, Get/SetLastAccessTime, Get/SetLastWriteTime
           └─ SetFileTimeCore / OpenHandle
                  └─ SetFileTime (Win API)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パス文字列 ─────────▶ Path.GetFullPath
                           │
                           ▼
                     Windows API
                           │
                           ▼
                     結果/一覧 ─────────▶ 呼び出し元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Directory.cls | `Source/CorLib/System.IO/Directory.cls` | ソース | Directoryクラス本体 |
| DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | ソース | ディレクトリ情報クラス |
| Path.cls | `Source/CorLib/System.IO/Path.cls` | ソース | パス操作 |
| File.cls | `Source/CorLib/System.IO/File.cls` | ソース | GetFileDataで連携 |
| IOError.cls | `Source/CorLib/System.IO/IOError.cls` | ソース | エラー変換 |
| SafeFileHandle.cls | `Source/CorLib/Microsoft.Win32.SafeHandles/SafeFileHandle.cls` | ソース | ファイルハンドル管理 |
