# 機能設計書 37-DirectoryInfo

## 概要

本ドキュメントは、VBCorLibライブラリにおけるDirectoryInfoクラスの機能設計について記述する。DirectoryInfoクラスは、特定のディレクトリに関する情報の取得・操作を行うインスタンスクラスである。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーション開発において、特定のディレクトリに対して複数の操作を行う場面では、毎回パスを指定するよりもオブジェクトとして保持する方が便利である。DirectoryInfoクラスは、ディレクトリ情報をオブジェクトとしてカプセル化し、ディレクトリの存在確認、属性操作、タイムスタンプ管理、サブディレクトリやファイルの一覧取得を一貫したインターフェースで提供する。

**機能の利用シーン**：特定のディレクトリに対する複数の操作、ディレクトリ内のファイル・サブディレクトリの列挙、ディレクトリツリーの走査、ディレクトリのコピー・移動・削除など、オブジェクト指向的なディレクトリ操作が必要な場面で利用される。

**主要な処理内容**：
1. ディレクトリ情報取得（Attributes、Name、FullName、Extension）
2. タイムスタンプ操作（CreationTime、LastAccessTime、LastWriteTime）- ローカル/UTC両対応
3. 親ディレクトリ・ルート取得（Parent、Root）
4. ディレクトリ操作（Create、CreateSubdirectory、MoveTo、Delete）
5. 内容一覧取得（GetDirectories、GetFiles、GetFileSystemInfos）- 検索オプション対応
6. 情報リフレッシュ（Refresh）
7. シリアライズ対応

**関連システム・外部連携**：Directoryクラス、FileInfoクラス、Pathクラスと連携。FileSystemInfoインターフェースを実装。

**権限による制御**：ファイルシステムのアクセス権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないライブラリクラスである |

## 機能種別

ディレクトリ情報オブジェクト

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Path | String | Yes | 対象ディレクトリのパス | 有効なパスであること |
| DestDirName | String | Yes | 移動先パス | 有効なパスであること |
| sPath | String | Yes | 作成するサブディレクトリのパス | 有効なパスであること |
| SearchPattern | String | No | 検索パターン（デフォルト: "*"） | - |
| SearchOption | SearchOption | No | 検索オプション（デフォルト: TopDirectoryOnly） | - |
| Recursive | Boolean | No | 再帰削除フラグ（デフォルト: False） | - |
| Value | Variant | Yes | 属性・タイムスタンプ設定値 | CorDateTime型であること |

### 入力データソース

コンストラクタで指定されるディレクトリパス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Attributes | FileAttributes | ディレクトリ属性（ReadOnly、Hidden等） |
| Exists | Boolean | ディレクトリ存在確認結果 |
| Name | String | ディレクトリ名 |
| FullName | String | フルパス |
| Extension | String | 拡張子（ディレクトリの場合は空文字列） |
| Parent | DirectoryInfo | 親ディレクトリ情報 |
| Root | DirectoryInfo | ルートディレクトリ情報 |
| CreationTime | CorDateTime | 作成日時 |
| LastAccessTime | CorDateTime | 最終アクセス日時 |
| LastWriteTime | CorDateTime | 最終更新日時 |
| DirectoryInfo() | DirectoryInfo() | GetDirectoriesで返されるサブディレクトリ配列 |
| FileInfo() | FileInfo() | GetFilesで返されるファイル配列 |
| FileSystemInfo() | FileSystemInfo() | GetFileSystemInfosで返される配列 |
| DirectoryInfo | DirectoryInfo | CreateSubdirectoryで返される新規ディレクトリ情報 |

### 出力先

呼び出し元のプログラムに戻り値として返される

## 処理フロー

### 処理シーケンス

```
1. DirectoryInfo生成
   └─ パスをフルパスに変換して保持
2. プロパティアクセス
   └─ ダーティフラグをチェック
   └─ ダーティならRefreshを呼び出し
   └─ キャッシュされた値を返す
3. 書き込み操作（属性・タイムスタンプ設定）
   └─ Directory/Fileクラスを通じて設定
   └─ ダーティフラグをセット
4. ディレクトリ操作
   └─ Directoryクラスの対応メソッドを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[DirectoryInfo生成] --> B[パスをフルパスに変換]
    B --> C[プロパティアクセス]
    C --> D{ダーティ?}
    D -->|Yes| E[Refresh呼び出し]
    D -->|No| F[キャッシュ値を返す]
    E --> F
    F --> G{書き込み操作?}
    G -->|Yes| H[Directory.Set系メソッド呼び出し]
    G -->|No| I[終了]
    H --> J[ダーティフラグセット]
    J --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 遅延ロード | ディレクトリ情報はアクセス時に初めて取得 | プロパティ初回アクセス時 |
| BR-002 | ダーティフラグ管理 | 書き込み後は情報を再取得する必要あり | 書き込み操作後 |
| BR-003 | 拡張子は空 | ディレクトリのExtensionプロパティは常に空文字列 | Extension取得時 |
| BR-004 | 存在確認の遅延 | ディレクトリの存在は操作実行時まで確認されない | コンストラクタ呼び出し時 |
| BR-005 | MoveTo後のパス更新 | MoveToでパス情報も新しいパスに更新 | MoveTo実行時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Argument_DateRequired | ArgumentException | タイムスタンプにCorDateTime以外を指定 | CorDateTime型を使用 |
| ERROR_PATH_NOT_FOUND | DirectoryNotFoundException | ディレクトリが見つからない | パスを確認 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- ダーティフラグによりファイルシステムへのアクセスを最小化
- GetFiles/GetDirectoriesでAllDirectoriesを指定した場合は負荷に注意

## セキュリティ考慮事項

- ファイルシステムのアクセス権限に依存
- シリアライズ時にパス情報が保存される

## 備考

- .NET FrameworkのSystem.IO.DirectoryInfoクラスと高い互換性を持つ
- FileSystemInfoインターフェースを実装しているため多態的に利用可能
- シリアライズ（PropertyBag）に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 50-56行目のプライベート変数宣言を確認 |

**読解のコツ**: mPath（フルパス）、mOriginalPath（元のパス）、mIsDirty（ダーティフラグ）、mFileAttributes（属性キャッシュ）が主要な状態変数。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 556-559行目のInit関数でコンストラクタ処理を確認 |
| 2-2 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 552-554行目のClass_Initialize |

**主要処理フロー**:
1. **557-558行目**: パスを保持しフルパスに変換
2. **553行目**: MarkDirtyでダーティフラグをセット

#### Step 3: プロパティアクセスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 87-92行目のAttributesプロパティ |
| 3-2 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 327-344行目のRefreshメソッド |
| 3-3 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 64-69行目のNameプロパティ |

**主要処理フロー**:
- **88-90行目**: mIsDirtyチェックとRefresh呼び出し
- **331-333行目**: File.GetFileDataでエラーチェック
- **336-340行目**: 属性とタイムスタンプのキャッシュ

#### Step 4: 一覧取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 422-442行目のGetDirectoriesメソッド |
| 4-2 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 463-481行目のGetFilesメソッド |
| 4-3 | DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | 491-520行目のGetFileSystemInfosメソッド |

**主要処理フロー**:
- **426行目**: Directory.GetDirectoriesでパス配列取得
- **434-436行目**: 各パスからDirectoryInfoを生成

### プログラム呼び出し階層図

```
DirectoryInfo
    │
    ├─ Init (コンストラクタ)
    │      └─ Path.GetFullPath
    │
    ├─ Refresh
    │      └─ File.GetFileData
    │
    ├─ Attributes (Get)
    │      ├─ mIsDirty チェック
    │      └─ Refresh（必要時）
    │
    ├─ Attributes (Let)
    │      ├─ File.SetAttributes
    │      └─ MarkDirty
    │
    ├─ CreationTime / LastAccessTime / LastWriteTime
    │      ├─ mIsDirty チェック
    │      └─ Refresh（必要時）
    │
    ├─ Create
    │      └─ Directory.CreateDirectory
    │
    ├─ CreateSubdirectory
    │      ├─ Path.Combine
    │      └─ Directory.CreateDirectory
    │
    ├─ MoveTo
    │      └─ Directory.Move
    │
    ├─ Delete
    │      └─ Directory.Delete
    │
    ├─ GetDirectories
    │      ├─ Directory.GetDirectories
    │      └─ NewDirectoryInfo (各パス)
    │
    ├─ GetFiles
    │      ├─ Directory.GetFiles
    │      └─ NewFileInfo (各パス)
    │
    ├─ GetFileSystemInfos
    │      ├─ Directory.GetFiles
    │      ├─ Directory.GetDirectories
    │      └─ NewFileInfo / NewDirectoryInfo
    │
    ├─ Parent
    │      ├─ Path.GetDirectoryName
    │      └─ NewDirectoryInfo
    │
    └─ Root
           ├─ Path.GetPathRoot
           └─ NewDirectoryInfo
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ディレクトリパス ─────▶ Init
                           │
                           ▼
                     フルパスに変換
                           │
                           ▼
                     プロパティアクセス
                           │
                           ▼
                     必要ならRefresh
                           │
                           ▼
                     キャッシュ値 ─────────▶ プロパティ値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DirectoryInfo.cls | `Source/CorLib/System.IO/DirectoryInfo.cls` | ソース | DirectoryInfoクラス本体 |
| Directory.cls | `Source/CorLib/System.IO/Directory.cls` | ソース | 静的ディレクトリ操作 |
| FileInfo.cls | `Source/CorLib/System.IO/FileInfo.cls` | ソース | ファイル情報 |
| Path.cls | `Source/CorLib/System.IO/Path.cls` | ソース | パス操作 |
| File.cls | `Source/CorLib/System.IO/File.cls` | ソース | GetFileData連携 |
| FileSystemInfo.cls | `Source/CorLib/System.IO/FileSystemInfo.cls` | ソース | 実装インターフェース |
