# 機能設計書 49-RijndaelManaged

## 概要

本ドキュメントは、VBCorLibライブラリにおけるRijndael/AES対称暗号化機能「RijndaelManaged」クラスの機能設計について記述する。

### 本機能の処理概要

RijndaelManagedクラスは、Rijndael対称ブロック暗号アルゴリズムのマネージド実装を提供する。RijndaelはAES（Advanced Encryption Standard）の基礎となるアルゴリズムであり、可変のブロックサイズ（128/192/256ビット）とキーサイズ（128/192/256ビット）をサポートする。本実装はWindows CryptoAPIに依存せず、純粋なVB6コードで暗号化/復号化を実行する。

**業務上の目的・背景**：機密データの暗号化保護、ファイル暗号化、セキュアな通信データの保護など、高いセキュリティが必要な場面で使用。AESはNIST標準として世界中で広く採用されている。

**機能の利用シーン**：
- 機密ファイルの暗号化
- データベース内の機密情報の保護
- 通信データの暗号化
- パスワード保護されたドキュメントの作成
- セキュアなデータ交換

**主要な処理内容**：
1. 暗号化/復号化トランスフォーマの生成（CreateEncryptor/CreateDecryptor）
2. 複数のブロックサイズ/キーサイズの設定
3. 暗号モード（CBC/ECB/CFB）の設定
4. パディングモードの設定
5. ランダムなキー/IVの自動生成

**関連システム・外部連携**：ICryptoTransformインターフェースを通じてCryptoStreamと連携。

**権限による制御**：本機能には権限による制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面からの直接操作を持たない |

## 機能種別

データ変換処理 / 暗号化機能

## 入力仕様

### アルゴリズムパラメータ

| パラメータ名 | 型 | 必須 | 説明 | デフォルト値 |
|-------------|-----|-----|------|-------------|
| BlockSize | Long | No | ブロックサイズ（ビット） | 128 |
| KeySize | Long | No | キーサイズ（ビット） | 256 |
| Key | Byte() | No | 秘密鍵（未指定時は自動生成） | 自動生成 |
| IV | Byte() | No | 初期化ベクトル（未指定時は自動生成） | 自動生成 |
| Mode | CipherMode | No | 暗号モード | CBC |
| Padding | PaddingMode | No | パディングモード | PKCS7 |
| FeedbackSize | Long | No | フィードバックサイズ（ビット） | 128 |

### CreateEncryptor/CreateDecryptorパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|-----|------|
| RgbKey | Variant(Byte()) | No | 暗号化/復号化に使用する秘密鍵 |
| RgbIV | Variant(Byte()) | No | 暗号化/復号化に使用するIV |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CreateEncryptor戻り値 | ICryptoTransform | 暗号化トランスフォーマ（RijndaelManagedTransform） |
| CreateDecryptor戻り値 | ICryptoTransform | 復号化トランスフォーマ（RijndaelManagedTransform） |
| Key | Byte() | 現在の秘密鍵（未設定時は自動生成） |
| IV | Byte() | 現在のIV（未設定時は自動生成） |
| LegalBlockSizes | KeySizes() | 有効なブロックサイズ一覧 |
| LegalKeySizes | KeySizes() | 有効なキーサイズ一覧 |

### サポートする暗号パラメータ

```
ブロックサイズ: 128, 192, 256 ビット（64ビット刻み）
キーサイズ: 128, 192, 256 ビット（64ビット刻み）

暗号モード:
  - CBC (Cipher Block Chaining) - デフォルト
  - ECB (Electronic Codebook)
  - CFB (Cipher Feedback)
  ※ CTS, OFBはサポートしない

パディングモード:
  - PKCS7 - デフォルト
  - None
  - Zeros
  - ANSIX923
  - ISO10126
```

## 処理フロー

### 処理シーケンス

```
1. インスタンス生成
   └─ SymmetricAlgorithmBase初期化
   └─ LegalBlockSize/LegalKeySize設定（128-256ビット）
   └─ デフォルト値設定（BlockSize=128, KeySize=256）
2. パラメータ設定（オプション）
   └─ BlockSize/KeySize設定
   └─ Mode/Padding設定
   └─ Key/IV設定（省略時は自動生成）
3. トランスフォーマ生成
   ├─ CreateEncryptor: 暗号化用トランスフォーマ
   └─ CreateDecryptor: 復号化用トランスフォーマ
4. RijndaelManagedTransform.Init
   └─ ルックアップテーブル初期化
   └─ ラウンド数計算
   └─ 拡張鍵生成
   └─ IV初期化
5. データ変換
   └─ TransformBlock: ブロック単位の変換
   └─ TransformFinalBlock: 最終ブロックの変換（パディング処理）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[RijndaelManaged生成]
    B --> C{パラメータ設定}
    C --> D[BlockSize/KeySize設定]
    C --> E[Mode/Padding設定]
    C --> F[Key/IV設定]
    D --> G{トランスフォーマ生成}
    E --> G
    F --> G
    G -->|暗号化| H[CreateEncryptor]
    G -->|復号化| I[CreateDecryptor]
    H --> J[RijndaelManagedTransform.Init]
    I --> J
    J --> K[ルックアップテーブル初期化]
    K --> L[ラウンド数計算]
    L --> M[拡張鍵生成]
    M --> N{暗号モード}
    N -->|ECB| O[ECB処理]
    N -->|CBC| P[CBC処理]
    N -->|CFB| Q[CFB処理]
    O --> R[ブロック暗号化/復号化]
    P --> R
    Q --> R
    R --> S{全ブロック完了?}
    S -->|No| R
    S -->|Yes| T[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 可変ブロックサイズ | 128/192/256ビットのブロックサイズをサポート | 常時 |
| BR-002 | 可変キーサイズ | 128/192/256ビットのキーサイズをサポート | 常時 |
| BR-003 | ラウンド数決定 | キー/ブロックサイズに応じてラウンド数を決定（10/12/14回） | 暗号化/復号化時 |
| BR-004 | 自動生成 | Key/IVが未設定の場合、ランダムに自動生成 | 初回アクセス時 |
| BR-005 | パディング必須 | None/Zeros以外のパディングでは最終ブロックにパディング追加 | 暗号化時 |
| BR-006 | CFBモード | CFBモードではFeedbackSizeに基づいて処理 | CFBモード時 |
| BR-007 | 非サポートモード | CTS/OFBモードは例外をスロー | CreateEncryptor/CreateDecryptor時 |

### 計算ロジック

```
ラウンド数決定:
  Nk（キー列数） = KeySize / 32
  Nb（ブロック列数） = BlockSize / 32
  Nr（ラウンド数）:
    - Nk=8 または Nb=8 の場合: Nr = 14
    - Nk=6 または Nb=6 の場合: Nr = 12
    - それ以外: Nr = 10

拡張鍵サイズ:
  Nb * (Nr + 1) * 4 バイト
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CryptographicException | 無効なブロックサイズ | 128/192/256ビットを指定 |
| - | CryptographicException | 無効なキーサイズ | 128/192/256ビットを指定 |
| - | CryptographicException | 無効な暗号モード（CTS/OFB） | CBC/ECB/CFBを使用 |
| - | CryptographicException | 復号化データ長が不正 | 正しい暗号化データを使用 |
| - | CryptographicException | パディング不正（復号化時） | 正しいキー/IVを使用 |
| - | ArgumentException | RgbKeyとRgbIVの片方のみ指定 | 両方または両方とも省略 |
| - | ArgumentException | 無効なIVサイズ | BlockSize/8バイトのIVを指定 |

### リトライ仕様

暗号化/復号化処理であるため、リトライは不要。

## トランザクション仕様

本機能はトランザクション処理を行わない。

## パフォーマンス要件

- マネージド実装のため、CryptoAPI依存実装より若干低速
- ルックアップテーブルによる最適化で高速化
- 1MBデータの暗号化: 数十〜数百ミリ秒程度
- ブロックサイズ128ビットが最も高速

## セキュリティ考慮事項

- キーと IVは使用後にClearメソッドで消去することを推奨
- ECBモードは同一平文ブロックが同一暗号文になるため、セキュリティ上CBCの使用を推奨
- キーは十分なエントロピーを持つランダムデータを使用
- IVは暗号化ごとに異なる値を使用することを推奨
- AES-256（KeySize=256）が最も高いセキュリティを提供

## 備考

- .NET FrameworkのRijndaelManagedと高い互換性を持つ
- AES標準（FIPS 197）に準拠したRijndael実装
- Windows CryptoAPIに依存しないピュアVB6実装
- RijndaelManagedTransformが実際の暗号化/復号化を実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造とクラス定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RijndaelManaged.cls | `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` | クラス定義、定数（49-58行目） |

**読解のコツ**:
- 49-57行目: ブロックサイズ/キーサイズの定数定義
  - DEF_MINBLOCKSIZE/DEF_MAXBLOCKSIZE: 128-256ビット
  - DEF_MINKEYSIZE/DEF_MAXKEYSIZE: 128-256ビット
  - DEF_BLOCKSKIPSIZE/DEF_KEYSKIPSIZE: 64ビット刻み
- 59行目: mBase（SymmetricAlgorithmBase）への委譲

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RijndaelManaged.cls | `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` | 公開メソッド/プロパティ |

**主要処理フロー**:
1. **69-81行目**: BlockSizeプロパティ - ブロックサイズ取得/設定
2. **117-129行目**: KeySizeプロパティ - キーサイズ取得/設定
3. **146-157行目**: Modeプロパティ - 暗号モード取得/設定
4. **164-175行目**: Paddingプロパティ - パディングモード取得/設定
5. **183-196行目**: Keyプロパティ - 秘密鍵取得/設定
6. **211-223行目**: IVプロパティ - IV取得/設定
7. **260-262行目**: CreateEncryptor - 暗号化トランスフォーマ生成
8. **274-276行目**: CreateDecryptor - 復号化トランスフォーマ生成

#### Step 3: トランスフォーマ初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RijndaelManaged.cls | `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` | CreateCipher（317-323行目） |
| 3-2 | RijndaelManagedTransform.cls | `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` | Init（263-299行目） |

**主要処理フロー**:
- 317-323行目: CreateCipher - RijndaelManagedTransform生成・初期化
- 263-299行目: Init - ルックアップテーブル初期化、ラウンド数計算、拡張鍵生成

#### Step 4: 暗号化/復号化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RijndaelManagedTransform.cls | `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` | TransformBlock/TransformFinalBlock |

**主要処理フロー**:
- **163-172行目**: TransformBlock - ブロック変換
- **183-191行目**: TransformFinalBlock - 最終ブロック変換
- **501-511行目**: EncryptECB - ECBモード暗号化
- **517-535行目**: EncryptCBC - CBCモード暗号化
- **541-568行目**: EncryptCFB - CFBモード暗号化
- **645-675行目**: Encrypt128 - 128ビットブロック暗号化
- **758-786行目**: Decrypt128 - 128ビットブロック復号化
- **873-895行目**: CreateExpandedKey - 拡張鍵生成
- **897-905行目**: CalculateNumberOfRounds - ラウンド数計算

### プログラム呼び出し階層図

```
RijndaelManaged
    │
    ├─ CreateEncryptor(RgbKey, RgbIV)
    │      └─ CreateCipher(RgbKey, RgbIV, True)
    │             └─ RijndaelManagedTransform.Init()
    │                    ├─ InitLookupTables(): T0-T4テーブル初期化
    │                    ├─ CalculateNumberOfRounds(): Nr計算
    │                    ├─ CreateExpandedKey(): 拡張鍵生成
    │                    └─ Reset(): IV初期化
    │
    ├─ CreateDecryptor(RgbKey, RgbIV)
    │      └─ CreateCipher(RgbKey, RgbIV, False)
    │             └─ RijndaelManagedTransform.Init()
    │                    └─ CreateDecryptionKey(): 復号化用鍵生成
    │
    └─ SymmetricAlgorithmBase (mBase)
           ├─ GetKey(): 鍵取得（未設定時はGenerateKey）
           ├─ SetKey(): 鍵設定
           ├─ GetIV(): IV取得（未設定時はGenerateIV）
           ├─ SetIV(): IV設定
           ├─ GenerateKey(): ランダム鍵生成
           ├─ GenerateIV(): ランダムIV生成
           └─ ValidKeySize(): 鍵サイズ検証

RijndaelManagedTransform
    │
    ├─ TransformBlock(InputBuffer, InputOffset, InputCount, OutputBuffer, OutputOffset)
    │      ├─ EncryptBlock() / DecryptBlock()
    │      └─ EncryptECB/CBC/CFB() / DecryptECB/CBC/CFB()
    │             └─ Encrypt128/192/256() / Decrypt128/192/256()
    │
    └─ TransformFinalBlock(InputBuffer, InputOffset, InputCount)
           ├─ EncryptFinalBlock() / DecryptFinalBlock()
           ├─ PadBlock() / DepadBlock(): パディング処理
           └─ Reset(): 状態リセット
```

### データフロー図

```
[入力]                    [処理]                         [出力]

平文データ ─────────────▶ CreateEncryptor ─────────────▶ ICryptoTransform
  │                           │
  │                           └─ Init()
  │                                 ├─ ルックアップテーブル初期化
  │                                 ├─ 拡張鍵生成
  │                                 └─ IV初期化
  │
  └───────────────────────▶ TransformBlock ────────────▶ 暗号化データ
                               │
                               ├─ ECB: 各ブロック個別処理
                               ├─ CBC: XOR + ブロック暗号化
                               └─ CFB: IV暗号化 + XOR

暗号化データ ────────────▶ CreateDecryptor ─────────────▶ ICryptoTransform
  │                           │
  │                           └─ Init()
  │                                 └─ 復号化用拡張鍵生成
  │
  └───────────────────────▶ TransformBlock ────────────▶ 平文データ
                               │
                               └─ 各モードの逆変換
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RijndaelManaged.cls | `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` | ソース | メインクラス定義（566行） |
| RijndaelManagedTransform.cls | `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` | ソース | 暗号化/復号化トランスフォーマ（1038行） |
| SymmetricAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls` | ソース | 対称暗号基底クラス（470行） |
| Rijndael.cls | `Source/CorLib/System.Security.Cryptography/Rijndael.cls` | インターフェース | Rijndaelインターフェース |
| SymmetricAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithm.cls` | インターフェース | 対称暗号インターフェース |
| ICryptoTransform.cls | `Source/CorLib/System.Security.Cryptography/ICryptoTransform.cls` | インターフェース | 暗号変換インターフェース |
| RijndaelStatic.cls | `Source/CorLib/System.Security.Cryptography/RijndaelStatic.cls` | ソース | ルックアップテーブル（Te0-Te4, Td0-Td4等） |
| CryptoHelper.bas | `Source/CorLib/System.Security.Cryptography/CryptoHelper.bas` | モジュール | パディング処理、乱数生成 |
